/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.sound.sampled;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.sampled.AudioFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class AudioFormatJFrame
extends JFrame
implements ActionListener {
    private AudioFormat temp_format;
    private Container content_pane;
    private JPanel settings_panel;
    private JPanel button_panel;
    private ButtonGroup sampling_rate_rb_group = new ButtonGroup();
    private JRadioButton sr_8000_rb = new JRadioButton("8 kHz");
    private JRadioButton sr_11025_rb = new JRadioButton("11.025 kHz");
    private JRadioButton sr_16000_rb = new JRadioButton("16 kHz");
    private JRadioButton sr_22050_rb = new JRadioButton("22.05 kHz");
    private JRadioButton sr_44100_rb = new JRadioButton("44.1 kHz");
    private JRadioButton sr_other_rb = new JRadioButton("Other (kHz):");
    private JTextArea sr_text_area = new JTextArea("");
    private ButtonGroup bit_depth_rb_group = new ButtonGroup();
    private JRadioButton bd_8_rb = new JRadioButton("8 bit");
    private JRadioButton bd_16_rb = new JRadioButton("16 bit");
    private JRadioButton bd_other_rb = new JRadioButton("Other:");
    private JTextArea bd_text_area = new JTextArea("");
    private ButtonGroup channels_rb_group = new ButtonGroup();
    private JRadioButton chan_1_rb = new JRadioButton("Mono");
    private JRadioButton chan_2_rb = new JRadioButton("Stereo");
    private JRadioButton chan_other_rb = new JRadioButton("Other:");
    private JTextArea chan_text_area = new JTextArea("");
    private ButtonGroup signed_rb_group = new ButtonGroup();
    private JRadioButton signed_rb = new JRadioButton("Signed PCM");
    private JRadioButton unsigned_rb = new JRadioButton("Unsigned PCM");
    private ButtonGroup endian_rb_group = new ButtonGroup();
    private JRadioButton big_endian_rb = new JRadioButton("Big Endian");
    private JRadioButton little_endian_rb = new JRadioButton("Little Endian");
    private JButton low_quality_button;
    private JButton mid_quality_button;
    private JButton high_quality_button;
    private JButton cancel_button;
    private JButton ok_button;

    public AudioFormatJFrame() {
        this.sampling_rate_rb_group.add(this.sr_8000_rb);
        this.sampling_rate_rb_group.add(this.sr_11025_rb);
        this.sampling_rate_rb_group.add(this.sr_16000_rb);
        this.sampling_rate_rb_group.add(this.sr_22050_rb);
        this.sampling_rate_rb_group.add(this.sr_44100_rb);
        this.sampling_rate_rb_group.add(this.sr_other_rb);
        this.bit_depth_rb_group.add(this.bd_8_rb);
        this.bit_depth_rb_group.add(this.bd_16_rb);
        this.bit_depth_rb_group.add(this.bd_other_rb);
        this.channels_rb_group.add(this.chan_1_rb);
        this.channels_rb_group.add(this.chan_2_rb);
        this.channels_rb_group.add(this.chan_other_rb);
        this.signed_rb_group.add(this.signed_rb);
        this.signed_rb_group.add(this.unsigned_rb);
        this.endian_rb_group.add(this.big_endian_rb);
        this.endian_rb_group.add(this.little_endian_rb);
        this.low_quality_button = new JButton("Low Quality Settings");
        this.mid_quality_button = new JButton("Mid Quality Settings");
        this.high_quality_button = new JButton("High Quality Settings");
        this.cancel_button = new JButton("Cancel");
        this.ok_button = new JButton("OK");
        this.low_quality_button.addActionListener(this);
        this.mid_quality_button.addActionListener(this);
        this.high_quality_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        this.ok_button.addActionListener(this);
        this.setAudioFormat(AudioFormatJFrame.getStandardMidQualityRecordAudioFormat());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AudioFormatJFrame.this.cancel();
            }
        });
        this.setTitle("PCM Audio Format Selector");
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.content_pane = this.getContentPane();
        this.content_pane.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        this.settings_panel = new JPanel(new GridLayout(19, 2, horizontal_gap, vertical_gap));
        this.button_panel = new JPanel(new GridLayout(3, 2, horizontal_gap, vertical_gap));
        this.settings_panel.add(new JLabel("Sampling Rate:"));
        this.settings_panel.add(this.sr_8000_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_11025_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_16000_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_22050_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_44100_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_other_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.sr_text_area);
        this.settings_panel.add(new JLabel("Bit Depth:"));
        this.settings_panel.add(this.bd_8_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.bd_16_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.bd_other_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.bd_text_area);
        this.settings_panel.add(new JLabel("Channels:"));
        this.settings_panel.add(this.chan_1_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.chan_2_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.chan_other_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.chan_text_area);
        this.settings_panel.add(new JLabel("Signed Samples:"));
        this.settings_panel.add(this.signed_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.unsigned_rb);
        this.settings_panel.add(new JLabel("Byte Order:"));
        this.settings_panel.add(this.big_endian_rb);
        this.settings_panel.add(new JLabel(""));
        this.settings_panel.add(this.little_endian_rb);
        this.button_panel.add(this.low_quality_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.mid_quality_button);
        this.button_panel.add(this.cancel_button);
        this.button_panel.add(this.high_quality_button);
        this.button_panel.add(this.ok_button);
        this.content_pane.add((Component)this.settings_panel, "Center");
        this.content_pane.add((Component)this.button_panel, "South");
        this.pack();
    }

    public static AudioFormat getStandardLowQualityRecordAudioFormat() {
        return AudioFormatJFrame.defineAudioFormat(8000.0f, 8, 1, true, true);
    }

    public static AudioFormat getStandardMidQualityRecordAudioFormat() {
        return AudioFormatJFrame.defineAudioFormat(16000.0f, 16, 1, true, true);
    }

    public static AudioFormat getStandardHighQualityRecordAudioFormat() {
        return AudioFormatJFrame.defineAudioFormat(44100.0f, 16, 1, true, true);
    }

    public static AudioFormat defineAudioFormat(float sample_rate, int sample_size, int channels, boolean signed, boolean big_endian) {
        return new AudioFormat(sample_rate, sample_size, channels, signed, big_endian);
    }

    public void setAudioFormat(AudioFormat audio_format) {
        if (audio_format != null) {
            float sample_rate = audio_format.getSampleRate();
            if (sample_rate == 8000.0f) {
                this.sr_8000_rb.setSelected(true);
            } else if (sample_rate == 11025.0f) {
                this.sr_11025_rb.setSelected(true);
            } else if (sample_rate == 16000.0f) {
                this.sr_16000_rb.setSelected(true);
            } else if (sample_rate == 22050.0f) {
                this.sr_22050_rb.setSelected(true);
            } else if (sample_rate == 44100.0f) {
                this.sr_44100_rb.setSelected(true);
            } else {
                this.sr_other_rb.setSelected(true);
                this.sr_text_area.setText(new Float(sample_rate * 1000.0f).toString());
            }
            int bit_depth = audio_format.getSampleSizeInBits();
            if (bit_depth == 8) {
                this.bd_8_rb.setSelected(true);
            } else if (bit_depth == 16) {
                this.bd_16_rb.setSelected(true);
            } else {
                this.bd_other_rb.setSelected(true);
                this.bd_text_area.setText(new Integer(bit_depth).toString());
            }
            int channels = audio_format.getChannels();
            if (channels == 1) {
                this.chan_1_rb.setSelected(true);
            } else if (channels == 2) {
                this.chan_2_rb.setSelected(true);
            } else {
                this.chan_other_rb.setSelected(true);
                this.chan_text_area.setText(new Integer(bit_depth).toString());
            }
            AudioFormat.Encoding encoding = audio_format.getEncoding();
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                this.signed_rb.setSelected(true);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                this.unsigned_rb.setSelected(true);
            }
            boolean is_big_endian = audio_format.isBigEndian();
            if (is_big_endian) {
                this.big_endian_rb.setSelected(true);
            } else {
                this.little_endian_rb.setSelected(true);
            }
        }
    }

    public AudioFormat getAudioFormat(boolean allow_text_selections) throws Exception {
        if (!allow_text_selections) {
            if (this.sr_other_rb.isSelected()) {
                throw new Exception("Illegal sampling rate of " + this.sr_text_area.getText() + ".\n" + "Only sampling rates of 8, 11.025, 16, 22.05 and 44.1 kHz are\n" + "accepted under the current settings.");
            }
            if (this.bd_other_rb.isSelected()) {
                throw new Exception("Illegal bit depth of " + this.bd_text_area.getText() + ".\n" + "Only bit depths of 8 or 16 bits are accepted under the current settings.");
            }
            if (this.chan_other_rb.isSelected()) {
                throw new Exception("Illegal number of channels (" + this.chan_text_area.getText() + ").\n" + "Only 1 or 2 channels are accepted under the current settings.");
            }
        }
        float sample_rate = 8000.0f;
        if (this.sr_8000_rb.isSelected()) {
            sample_rate = 8000.0f;
        } else if (this.sr_11025_rb.isSelected()) {
            sample_rate = 11025.0f;
        } else if (this.sr_16000_rb.isSelected()) {
            sample_rate = 16000.0f;
        } else if (this.sr_22050_rb.isSelected()) {
            sample_rate = 22050.0f;
        } else if (this.sr_44100_rb.isSelected()) {
            sample_rate = 44100.0f;
        } else if (this.sr_other_rb.isSelected()) {
            sample_rate = Float.parseFloat(this.sr_text_area.getText());
        }
        int bit_depth = 8;
        if (this.bd_8_rb.isSelected()) {
            bit_depth = 8;
        } else if (this.bd_16_rb.isSelected()) {
            bit_depth = 16;
        } else if (this.bd_other_rb.isSelected()) {
            bit_depth = Integer.parseInt(this.bd_text_area.getText());
        }
        int channels = 1;
        if (this.chan_1_rb.isSelected()) {
            channels = 1;
        } else if (this.chan_2_rb.isSelected()) {
            channels = 2;
        } else if (this.chan_other_rb.isSelected()) {
            channels = Integer.parseInt(this.chan_text_area.getText());
        }
        boolean is_signed = true;
        if (this.signed_rb.isSelected()) {
            is_signed = true;
        } else if (this.unsigned_rb.isSelected()) {
            is_signed = false;
        }
        boolean is_big_endian = true;
        if (this.big_endian_rb.isSelected()) {
            is_big_endian = true;
        } else if (this.little_endian_rb.isSelected()) {
            is_big_endian = false;
        }
        return new AudioFormat(sample_rate, bit_depth, channels, is_signed, is_big_endian);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.low_quality_button)) {
            this.setAudioFormat(AudioFormatJFrame.getStandardLowQualityRecordAudioFormat());
        } else if (event.getSource().equals(this.mid_quality_button)) {
            this.setAudioFormat(AudioFormatJFrame.getStandardMidQualityRecordAudioFormat());
        } else if (event.getSource().equals(this.high_quality_button)) {
            this.setAudioFormat(AudioFormatJFrame.getStandardHighQualityRecordAudioFormat());
        } else if (event.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (event.getSource().equals(this.ok_button)) {
            this.setVisible(false);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        try {
            if (b) {
                this.temp_format = this.getAudioFormat(true);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(0);
        }
    }

    private void cancel() {
        this.setAudioFormat(this.temp_format);
        this.setVisible(false);
    }
}

