/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.staticlibraries;

import java.util.Arrays;

public class MathAndStatsMethods {
    public static double getPercentage(int value, int total) {
        return 100.0 * (double)value / (double)total;
    }

    public static double getAverage(double[] data) {
        if (data.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum / (double)data.length;
    }

    public static double getAverage(int[] data) {
        if (data.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += (double)data[i];
        }
        return sum / (double)data.length;
    }

    public static double getStandardDeviation(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double average = MathAndStatsMethods.getAverage(data);
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double diff = data[i] - average;
            sum += diff * diff;
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    public static double getStandardDeviation(int[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double average = MathAndStatsMethods.getAverage(data);
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double diff = (double)data[i] - average;
            sum += diff * diff;
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    public static long getFactorial(long n) throws Exception {
        if (n < 0L) {
            throw new Exception("Factorial input of " + n + " invalid: Must be 0 or greater.");
        }
        if (n > 20L) {
            throw new Exception("Factorial input of " + n + " invalid: Must be 20 or less.");
        }
        if (n == 0L) {
            return 1L;
        }
        return n * MathAndStatsMethods.getFactorial(n - 1L);
    }

    public static int getIndexOfSmallest(double[] values) {
        int min_index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < values[min_index])) continue;
            min_index = i;
        }
        return min_index;
    }

    public static int getIndexOfSmallest(int[] values) {
        int min_index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= values[min_index]) continue;
            min_index = i;
        }
        return min_index;
    }

    public static int getIndexOfMedian(double[] values) {
        double[] copy = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            copy[i] = values[i];
        }
        Arrays.sort(copy);
        int centre = copy.length / 2;
        double median = copy[centre];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != median) continue;
            return i;
        }
        return -1;
    }

    public static int getIndexOfLargest(float[] values) {
        int max_index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > values[max_index])) continue;
            max_index = i;
        }
        return max_index;
    }

    public static int getIndexOfLargest(double[] values) {
        int max_index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > values[max_index])) continue;
            max_index = i;
        }
        return max_index;
    }

    public static int getIndexOfLargest(int[] values) {
        int max_index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= values[max_index]) continue;
            max_index = i;
        }
        return max_index;
    }

    public static int[] removeRedundantEntries(int[] to_check) {
        boolean[] is_double = new boolean[to_check.length];
        for (int i = 0; i < is_double.length; ++i) {
            is_double[i] = false;
        }
        int doubles_found = 0;
        for (int i = 0; i < to_check.length - 1; ++i) {
            if (is_double[i]) continue;
            for (int j = i + 1; j < to_check.length; ++j) {
                if (to_check[j] != to_check[i]) continue;
                ++doubles_found;
                is_double[j] = true;
            }
        }
        if (doubles_found > 0) {
            int[] to_return = new int[to_check.length - doubles_found];
            int current = 0;
            for (int i = 0; i < to_check.length; ++i) {
                if (is_double[i]) continue;
                to_return[current] = to_check[i];
                ++current;
            }
            return to_return;
        }
        return to_check;
    }

    public static double calculateEuclideanDistance(double[] x, double[] y) throws Exception {
        if (x.length != y.length) {
            throw new Exception("The two given arrays have different sizes.");
        }
        double total = 0.0;
        for (int dim = 0; dim < x.length; ++dim) {
            total += Math.pow(x[dim] - y[dim], 2.0);
        }
        return Math.sqrt(total);
    }

    public static int generateRandomNumber(int max) {
        int random_number = (int)(2.147483647E9 * Math.random());
        return random_number % max;
    }

    public static int[] getRandomOrdering(int number_entries) {
        double[] random_values = new double[number_entries];
        for (int i = 0; i < random_values.length; ++i) {
            random_values[i] = Math.random();
        }
        int[] scrambled_values = new int[number_entries];
        for (int i = 0; i < scrambled_values.length; ++i) {
            int largest_index;
            scrambled_values[i] = largest_index = MathAndStatsMethods.getIndexOfLargest(random_values);
            random_values[largest_index] = -1.0;
        }
        return scrambled_values;
    }

    public static double getArraySum(double[] to_sum) {
        double sum = 0.0;
        for (int i = 0; i < to_sum.length; ++i) {
            sum += to_sum[i];
        }
        return sum;
    }

    public static double[] normalize(double[] to_normalize) {
        double[] normalized = new double[to_normalize.length];
        for (int i = 0; i < normalized.length; ++i) {
            normalized[i] = to_normalize[i];
        }
        double sum = MathAndStatsMethods.getArraySum(normalized);
        for (int i = 0; i < normalized.length; ++i) {
            normalized[i] = sum == 0.0 ? 0.0 : normalized[i] / sum;
        }
        return normalized;
    }

    public static double[][] normalize(double[][] to_normalize) {
        int j;
        int i;
        double[][] normalized = new double[to_normalize.length][];
        for (int i2 = 0; i2 < normalized.length; ++i2) {
            normalized[i2] = new double[to_normalize[i2].length];
            for (int j2 = 0; j2 < normalized[i2].length; ++j2) {
                normalized[i2][j2] = to_normalize[i2][j2];
            }
        }
        double[] totals = new double[normalized.length];
        for (i = 0; i < normalized.length; ++i) {
            totals[i] = 0.0;
            for (j = 0; j < normalized[i].length; ++j) {
                int n = i;
                totals[n] = totals[n] + normalized[i][j];
            }
        }
        for (i = 0; i < normalized.length; ++i) {
            for (j = 0; j < normalized[i].length; ++j) {
                normalized[i][j] = totals[i] == 0.0 ? 0.0 : normalized[i][j] / totals[i];
            }
        }
        return normalized;
    }

    public static double[][] normalizeEntirely(double[][] to_normalize) {
        double sum = 0.0;
        for (int i = 0; i < to_normalize.length; ++i) {
            for (int j = 0; j < to_normalize[i].length; ++j) {
                sum += to_normalize[i][j];
            }
        }
        double[][] normalized = new double[to_normalize.length][];
        for (int i = 0; i < to_normalize.length; ++i) {
            normalized[i] = new double[to_normalize[i].length];
            for (int j = 0; j < to_normalize[i].length; ++j) {
                normalized[i][j] = sum == 0.0 ? 0.0 : to_normalize[i][j] / sum;
            }
        }
        return normalized;
    }

    public static int pow(int a, int b) {
        int result = a;
        for (int i = 1; i < b; ++i) {
            result *= a;
        }
        return result;
    }

    public static double logBaseN(double x, double n) {
        return Math.log10(x) / Math.log10(n);
    }

    public static int ensureIsPowerOfN(int x, int n) {
        double log_value = MathAndStatsMethods.logBaseN(x, n);
        int log_int = (int)log_value;
        int valid_size = MathAndStatsMethods.pow(n, log_int);
        if (valid_size != x) {
            valid_size = MathAndStatsMethods.pow(n, log_int + 1);
        }
        return valid_size;
    }

    public static int getNumberPerumutations(int set_size, int permutation_size) throws Exception {
        if (permutation_size > set_size) {
            throw new Exception("Permutation set of " + permutation_size + " is larger than set size of " + set_size + ". Replacement is not permitted.");
        }
        long numerator = MathAndStatsMethods.getFactorial(set_size);
        long denominator = MathAndStatsMethods.getFactorial(set_size - permutation_size);
        return (int)(numerator / denominator);
    }

    public static boolean isFactorOrMultiple(int x, int y, int[] z) {
        boolean is_factor_or_multiple = false;
        if (y > x) {
            for (int i = 0; i < z.length; ++i) {
                if (x * z[i] != y) continue;
                is_factor_or_multiple = true;
                i = z.length + 1;
            }
        } else {
            for (int i = 0; i < z.length; ++i) {
                if (y * z[i] != x) continue;
                is_factor_or_multiple = true;
                i = z.length + 1;
            }
        }
        return is_factor_or_multiple;
    }
}

