/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.staticlibraries;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscellaneousMethods {
    public static String[] runCommand(String command, Runtime run_time, InputStreamReader[] error_stream_reader, int[] exit_code) throws Exception {
        Process process = run_time.exec(command);
        if (error_stream_reader != null && error_stream_reader.length == 1) {
            error_stream_reader[0] = new InputStreamReader(process.getErrorStream());
        }
        Vector<String> output = new Vector<String>();
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = input.readLine()) != null) {
            output.add(line);
        }
        int exit_value = process.waitFor();
        if (exit_code != null && exit_code.length == 1) {
            exit_code[0] = exit_value;
        }
        if (output.isEmpty()) {
            return null;
        }
        return output.toArray(new String[output.size()]);
    }

    public static HashMap<String, String> parseCommandLineParameters(String[] args, HashMap<String, Boolean> permitted_flags, String[] explanation_keys, String[] explanations, PrintStream print_stream) {
        try {
            if (args.length == 1 && args[0].equals("-help")) {
                print_stream = System.out;
                throw new Exception("");
            }
            if (args.length % 2 != 0) {
                throw new Exception("An odd number of command line parameters were provided. Only flag/value are pairs accepted.");
            }
            HashMap<String, String> parsed_args = new HashMap<String, String>();
            String current_flag = null;
            for (int i = 0; i < args.length; ++i) {
                if (i % 2 == 0) {
                    if (args[i].length() < 2) {
                        throw new Exception("There must be at least one flag and one value in the command line arguments.");
                    }
                    if (!args[i].startsWith("-")) {
                        throw new Exception("The \"" + args[i] + "\" flag does not start with a \"-\".");
                    }
                    if (!permitted_flags.containsKey(args[i])) {
                        throw new Exception("\"" + args[i] + "\" is not a recognized flag.");
                    }
                    if (parsed_args.containsKey(args[i])) {
                        throw new Exception("The flag \"" + args[i] + "\" appears more than once.");
                    }
                    current_flag = args[i];
                    continue;
                }
                parsed_args.put(current_flag, args[i]);
            }
            String[] flags_allowed = permitted_flags.keySet().toArray(new String[1]);
            for (int i = 0; i < flags_allowed.length; ++i) {
                if (!permitted_flags.get(flags_allowed[i]).booleanValue() || parsed_args.containsKey(flags_allowed[i])) continue;
                throw new Exception("The mandatory flag " + flags_allowed[i] + " is missing.");
            }
            return parsed_args;
        }
        catch (Exception e) {
            if (print_stream != null) {
                print_stream.println(e.getMessage());
                if (explanations != null && explanation_keys != null) {
                    int i;
                    int first_row_width = 0;
                    for (i = 0; i < explanation_keys.length; ++i) {
                        if (explanation_keys[i].length() <= first_row_width) continue;
                        first_row_width = explanation_keys[i].length();
                    }
                    first_row_width += 3;
                    print_stream.println("\nValid flags are:\n");
                    for (i = 0; i < explanation_keys.length; ++i) {
                        print_stream.print(explanation_keys[i]);
                        int number_spaces = first_row_width - explanation_keys[i].length();
                        for (int j = 0; j < number_spaces; ++j) {
                            print_stream.print(" ");
                        }
                        boolean required = permitted_flags.get(explanation_keys[i]);
                        if (required) {
                            print_stream.print("Required");
                        } else {
                            print_stream.print("Optional");
                        }
                        print_stream.print("   " + explanations[i] + "\n");
                    }
                    print_stream.print("\nThese flags must each be followed by their associated value.\n\n");
                }
            }
            System.exit(0);
            return null;
        }
    }
}

