/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.staticlibraries;

import java.text.Collator;
import javax.swing.tree.DefaultMutableTreeNode;

public class SortingMethods {
    public static DefaultMutableTreeNode sortTree(DefaultMutableTreeNode root_unsorted_tree) {
        int i;
        DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[root_unsorted_tree.getChildCount()];
        Collator string_comparer = Collator.getInstance();
        for (i = 0; i < root_unsorted_tree.getChildCount(); ++i) {
            children[i] = (DefaultMutableTreeNode)root_unsorted_tree.getChildAt(i);
        }
        for (i = 0; i < root_unsorted_tree.getChildCount(); ++i) {
            DefaultMutableTreeNode first = children[i];
            String first_name = (String)first.getUserObject();
            int first_indice = i;
            for (int j = i + 1; j < children.length; ++j) {
                String test_name = (String)children[j].getUserObject();
                if (string_comparer.compare(first_name, test_name) <= 0) continue;
                first_name = test_name;
                first_indice = j;
            }
            if (first_indice == i) continue;
            DefaultMutableTreeNode temp = children[i];
            children[i] = children[first_indice];
            children[first_indice] = temp;
        }
        for (i = 0; i < children.length; ++i) {
            if (children[i].isLeaf()) continue;
            children[i] = SortingMethods.sortTree(children[i]);
        }
        DefaultMutableTreeNode root_sorted_tree = new DefaultMutableTreeNode(root_unsorted_tree.getUserObject());
        for (int i2 = 0; i2 < children.length; ++i2) {
            root_sorted_tree.add(children[i2]);
        }
        return root_sorted_tree;
    }

    public static String[] sortArray(String[] original_strings) {
        int i;
        Collator string_comparer = Collator.getInstance();
        int[] sorted_ordering = new int[original_strings.length];
        boolean[] added_already = new boolean[original_strings.length];
        for (i = 0; i < original_strings.length - 1; ++i) {
            added_already[i] = false;
        }
        for (i = 0; i < original_strings.length; ++i) {
            String earliest_yet = null;
            int earliest_yet_index = -1;
            for (int j = 0; j < original_strings.length; ++j) {
                if (added_already[j]) continue;
                if (earliest_yet == null) {
                    earliest_yet = original_strings[j];
                    earliest_yet_index = j;
                    continue;
                }
                if (string_comparer.compare(earliest_yet, original_strings[j]) <= 0) continue;
                earliest_yet = original_strings[j];
                earliest_yet_index = j;
            }
            sorted_ordering[i] = earliest_yet_index;
            added_already[earliest_yet_index] = true;
        }
        String[] sorted = new String[original_strings.length];
        for (int i2 = 0; i2 < original_strings.length; ++i2) {
            sorted[i2] = original_strings[sorted_ordering[i2]];
        }
        return sorted;
    }

    public static String[][] sortTable(String[][] original_table, int column_to_sort_by, int[] sorted_ordering) {
        int i;
        Collator string_comparer = Collator.getInstance();
        boolean[] added_already = new boolean[original_table.length];
        for (i = 0; i < original_table.length - 1; ++i) {
            added_already[i] = false;
        }
        for (i = 0; i < original_table.length; ++i) {
            String earliest_yet = null;
            int earliest_yet_index = -1;
            for (int j = 0; j < original_table.length; ++j) {
                if (added_already[j]) continue;
                if (earliest_yet == null) {
                    earliest_yet = original_table[j][column_to_sort_by];
                    earliest_yet_index = j;
                    continue;
                }
                if (string_comparer.compare(earliest_yet, original_table[j][column_to_sort_by]) <= 0) continue;
                earliest_yet = original_table[j][column_to_sort_by];
                earliest_yet_index = j;
            }
            sorted_ordering[i] = earliest_yet_index;
            added_already[earliest_yet_index] = true;
        }
        String[][] sorted_table = new String[original_table.length][];
        for (int i2 = 0; i2 < original_table.length; ++i2) {
            sorted_table[i2] = original_table[sorted_ordering[i2]];
        }
        return sorted_table;
    }

    public static double[] sortDoubleArray(double[] to_sort) {
        int i;
        double[] sorted = new double[to_sort.length];
        for (i = 0; i < to_sort.length; ++i) {
            sorted[i] = to_sort[i];
        }
        for (i = 0; i < sorted.length; ++i) {
            double min = sorted[i];
            int min_index = i;
            for (int j = i; j < sorted.length; ++j) {
                if (!(sorted[j] < min)) continue;
                min_index = j;
                min = sorted[j];
            }
            double temp = sorted[i];
            sorted[i] = sorted[min_index];
            sorted[min_index] = temp;
        }
        return sorted;
    }

    public static int[] sortIntArray(int[] to_sort) {
        int i;
        int[] sorted = new int[to_sort.length];
        for (i = 0; i < to_sort.length; ++i) {
            sorted[i] = to_sort[i];
        }
        for (i = 0; i < sorted.length; ++i) {
            int min = sorted[i];
            int min_index = i;
            for (int j = i; j < sorted.length; ++j) {
                if (sorted[j] >= min) continue;
                min_index = j;
                min = sorted[j];
            }
            int temp = sorted[i];
            sorted[i] = sorted[min_index];
            sorted[min_index] = temp;
        }
        return sorted;
    }

    public static int[] getDoubleArraySortKey(double[] to_sort) {
        int[] key = new int[to_sort.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = -1;
        }
        int pos = 0;
        while (pos < key.length) {
            int lowest_index_yet = -1;
            double lowest_value_yet = 0.0;
            boolean found_one = false;
            for (int i = 0; i < to_sort.length; ++i) {
                if (key[i] != -1) continue;
                if (!found_one) {
                    lowest_index_yet = i;
                    lowest_value_yet = to_sort[i];
                    found_one = true;
                    continue;
                }
                if (!(to_sort[i] < lowest_value_yet)) continue;
                lowest_index_yet = i;
                lowest_value_yet = to_sort[i];
            }
            key[lowest_index_yet] = pos++;
        }
        return key;
    }
}

