/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.staticlibraries;

import java.io.File;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import mckay.utilities.staticlibraries.ArrayMethods;
import mckay.utilities.staticlibraries.MathAndStatsMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMethods {
    public static void printDoubleArray(String[][] test_strings, int number_tabs, String open_marker, String close_marker) {
        if (test_strings != null) {
            System.out.println("== " + test_strings.length + " OUTER ELEMENTS ==");
            for (int i = 0; i < test_strings.length; ++i) {
                StringMethods.printStringArrayContentsOnOneLine(test_strings[i], number_tabs, open_marker, close_marker);
            }
        } else {
            System.out.println("NULL");
        }
        System.out.println("");
    }

    public static void printStringArrayContentsOnOneLine(String[] test_strings, int number_tabs, String open_marker, String close_marker) {
        int i;
        for (i = 0; i < number_tabs; ++i) {
            System.out.print("\t");
        }
        if (test_strings == null) {
            System.out.println("NULL");
        } else {
            for (i = 0; i < test_strings.length; ++i) {
                System.out.print(open_marker + test_strings[i] + close_marker);
            }
        }
        System.out.println("");
    }

    public static void printStringArrayContents(String[] test_strings) {
        if (test_strings == null) {
            System.out.println("The given string array is null.");
        } else {
            System.out.println("The string array has " + test_strings.length + " entries:");
            for (int i = 0; i < test_strings.length; ++i) {
                System.out.println(i + ": >" + test_strings[i] + "<");
            }
        }
    }

    public static String[] breakIntoTokens(String input, String delimiter) {
        if (input == null || delimiter == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(input, delimiter);
        String[] tokens = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[count] = tokenizer.nextToken();
            ++count;
        }
        return tokens;
    }

    public static boolean isStringInArray(String test_string, String[] array_to_check) {
        for (int i = 0; i < array_to_check.length; ++i) {
            if (!test_string.equals(array_to_check[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllEntriesIdentical(String[] test_array) {
        if (test_array.length == 1) {
            return true;
        }
        String first = test_array[0];
        for (int i = 1; i < test_array.length; ++i) {
            if (test_array[i] == null) {
                if (first == null) continue;
                return false;
            }
            if (first == null) {
                return false;
            }
            if (first.equals(test_array[i])) continue;
            return false;
        }
        return true;
    }

    public static int getIndexOfString(String given_name, String[] possible_names) throws Exception {
        for (int i = 0; i < possible_names.length; ++i) {
            if (!given_name.equals(possible_names[i])) continue;
            return i;
        }
        throw new Exception("Unable to find " + given_name + ".");
    }

    public static int getIndexOfLongestString(String[] to_check) {
        int[] lengths = new int[to_check.length];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = to_check[i].length();
        }
        return MathAndStatsMethods.getIndexOfLargest(lengths);
    }

    public static int getLengthOfLongerString(String first, String second) {
        int second_length;
        if (first == null || second == null) {
            return -1;
        }
        int first_length = first.length();
        if (first_length > (second_length = second.length())) {
            return first_length;
        }
        return second_length;
    }

    public static int getLengthOfShorterString(String first, String second) {
        int second_length;
        if (first == null || second == null) {
            return -1;
        }
        int first_length = first.length();
        if (first_length < (second_length = second.length())) {
            return first_length;
        }
        return second_length;
    }

    public static String[] concatenateStringArrays(String[] array_1, String[] array_2) {
        int length_1 = array_1.length;
        int length_2 = array_2.length;
        String[] new_array = new String[length_1 + length_2];
        for (int i = 0; i < length_1; ++i) {
            new_array[i] = array_1[i];
        }
        for (int j = 0; j < length_2; ++j) {
            new_array[length_1 + j] = array_2[j];
        }
        return new_array;
    }

    public static boolean doStringArraysMatch(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < array2.length; ++j) {
                if (!array1[i].equals(array2[j])) continue;
                found = true;
                j = array2.length;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static String[] removeDoubles(String[] strings) {
        int i;
        Object[] editable_strings = new String[strings.length];
        for (i = 0; i < editable_strings.length; ++i) {
            editable_strings[i] = strings[i];
        }
        for (i = 0; i < editable_strings.length - 1; ++i) {
            for (int j = i + 1; j < editable_strings.length; ++j) {
                if (editable_strings[i] == null || editable_strings[j] == null || !((String)editable_strings[i]).equals(editable_strings[j])) continue;
                editable_strings[j] = null;
            }
        }
        Object[] cleaned_obj = ArrayMethods.removeNullEntriesFromArray(editable_strings);
        String[] cleaned_strings = new String[cleaned_obj.length];
        for (int i2 = 0; i2 < cleaned_strings.length; ++i2) {
            cleaned_strings[i2] = (String)cleaned_obj[i2];
        }
        return cleaned_strings;
    }

    public static String[] removeDuplicateEntries(String[] array_to_check) throws Exception {
        if (array_to_check == null) {
            throw new Exception("Cannot remove duplicate entries from empty array.");
        }
        if (array_to_check.length < 1) {
            throw new Exception("Cannot remove duplicate entries from empty array.");
        }
        LinkedList<String> unique_entries = new LinkedList<String>();
        for (int i = 0; i < array_to_check.length; ++i) {
            if (unique_entries.contains(array_to_check[i])) continue;
            unique_entries.add(array_to_check[i]);
        }
        return unique_entries.toArray(new String[1]);
    }

    public static int getNumberOccurencesOfSubString(String given_string, String substring) {
        if (given_string == null) {
            return 0;
        }
        if (given_string.equals("")) {
            return 0;
        }
        if (substring == null) {
            return 0;
        }
        if (substring.equals("")) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while (index < given_string.length() && index != -1) {
            if ((index = given_string.indexOf(substring, index)) == -1) continue;
            ++count;
            ++index;
        }
        return count;
    }

    public static String concatenateArrayOfStrings(String[] words) {
        StringBuffer concatenated = new StringBuffer();
        for (int i = 0; i < words.length; ++i) {
            concatenated.append(words[i]);
            if (i >= words.length - 1) continue;
            concatenated.append(", ");
        }
        return concatenated.toString();
    }

    public static String[] removeEmptyStringsFromArray(String[] array) {
        if (array == null) {
            return null;
        }
        LinkedList<String> not_empty = new LinkedList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || array[i].length() == 0) continue;
            not_empty.add(array[i]);
        }
        if (not_empty.size() == 0) {
            return null;
        }
        return not_empty.toArray(new String[not_empty.size()]);
    }

    public static int calculateLevenshteinDistance(String first_string, String second_string) {
        int i;
        if (first_string == null) {
            return -1;
        }
        if (second_string == null) {
            return -1;
        }
        char[] first_chars = first_string.toCharArray();
        char[] second_chars = second_string.toCharArray();
        int[][] distances = new int[first_chars.length + 1][second_chars.length + 1];
        for (i = 0; i <= first_chars.length; ++i) {
            distances[i][0] = i;
        }
        for (i = 0; i < second_chars.length + 1; ++i) {
            distances[0][i] = i;
        }
        for (i = 1; i <= first_chars.length; ++i) {
            for (int j = 1; j <= second_chars.length; ++j) {
                int cost = first_chars[i - 1] == second_chars[j - 1] ? 0 : 1;
                int a = distances[i - 1][j] + 1;
                int b = distances[i][j - 1] + 1;
                int c = distances[i - 1][j - 1] + cost;
                distances[i][j] = a;
                if (b < distances[i][j]) {
                    distances[i][j] = b;
                }
                if (c >= distances[i][j]) continue;
                distances[i][j] = c;
            }
        }
        return distances[first_chars.length][second_chars.length];
    }

    public static int[][] calculateLevenshteinDistances(String[] strings) {
        int[][] distances = new int[strings.length][strings.length];
        for (int i = 0; i < distances.length; ++i) {
            distances[i][i] = strings[i] == null ? -1 : 0;
            for (int j = 0; j < i; ++j) {
                distances[i][j] = StringMethods.calculateLevenshteinDistance(strings[i], strings[j]);
                distances[j][i] = distances[i][j];
            }
        }
        return distances;
    }

    public static void reportStringDifferences(String key, String first, String second, Vector<String[]> to_update) {
        boolean shold_update = false;
        if (first == null && second != null || first != null && second == null) {
            shold_update = true;
        } else if (first == null && second == null) {
            shold_update = false;
        } else if (!first.equals(second)) {
            shold_update = true;
        }
        if (shold_update) {
            String[] update = new String[]{key, first, second};
            to_update.add(update);
        }
    }

    public static String getBeginningOfString(String string_to_shorten, int number_characters) {
        String copy = new String(string_to_shorten);
        if (string_to_shorten.length() < number_characters) {
            int difference = number_characters - string_to_shorten.length();
            for (int i = 0; i < difference; ++i) {
                copy = copy + " ";
            }
            return copy;
        }
        if (string_to_shorten.length() > number_characters) {
            return string_to_shorten.substring(0, number_characters);
        }
        return copy;
    }

    public static String getBeginningOfStringWithHyphenFiller(String string_to_shorten, int number_characters) {
        String copy = new String(string_to_shorten);
        if (string_to_shorten.length() < number_characters) {
            int difference = number_characters - string_to_shorten.length();
            for (int i = 0; i < difference; ++i) {
                copy = i == 0 || i == 1 || i == difference - 2 || i == difference - 1 ? copy + " " : copy + "-";
            }
            return copy;
        }
        if (string_to_shorten.length() > number_characters) {
            return string_to_shorten.substring(0, number_characters);
        }
        return copy;
    }

    public static String nullifyStringIfEmpty(String given_string) {
        if (given_string == null) {
            return null;
        }
        if (given_string.matches("")) {
            return null;
        }
        return given_string;
    }

    public static String convertFilePathToFileName(String file_path) {
        return file_path.substring(file_path.lastIndexOf(File.separator) + 1, file_path.length());
    }

    public static String getDirectoryName(String file_path) throws Exception {
        int index_of_last_separator = file_path.lastIndexOf(File.separatorChar);
        if (index_of_last_separator == -1) {
            throw new Exception(file_path + " does not contain a valid directory separator.");
        }
        return new String(file_path.substring(0, file_path.lastIndexOf(File.separator)) + File.separator);
    }

    public static String removeExtension(String filename) {
        if (filename.length() < 5) {
            return null;
        }
        if (filename.charAt(filename.length() - 4) != '.') {
            if (filename.charAt(filename.length() - 5) == '.') {
                return filename.substring(0, filename.length() - 5);
            }
            if (filename.charAt(filename.length() - 3) == '.') {
                return filename.substring(0, filename.length() - 3);
            }
            return null;
        }
        return filename.substring(0, filename.length() - 4);
    }

    public static String getExtension(String filename) {
        if (filename.length() < 5) {
            return null;
        }
        if (filename.charAt(filename.length() - 4) != '.') {
            if (filename.charAt(filename.length() - 5) == '.') {
                return filename.substring(filename.length() - 5, filename.length());
            }
            if (filename.charAt(filename.length() - 3) == '.') {
                return filename.substring(filename.length() - 3, filename.length());
            }
            return null;
        }
        return filename.substring(filename.length() - 4, filename.length());
    }

    public static String replaceExtension(String filename, String new_extension) {
        String new_string = filename;
        if (StringMethods.getExtension(filename) != null) {
            new_string = StringMethods.removeExtension(filename);
        }
        return new_string + "." + new_extension;
    }

    public static String getRoundedDouble(double number_to_round, int decimal_places) {
        if (number_to_round == Double.NaN) {
            return new String("NaN");
        }
        if (number_to_round == Double.NEGATIVE_INFINITY) {
            return new String("-Infinity");
        }
        if (number_to_round == Double.POSITIVE_INFINITY) {
            return new String("Infinity");
        }
        String format_pattern = "#0.";
        for (int i = 0; i < decimal_places; ++i) {
            format_pattern = format_pattern + "#";
        }
        DecimalFormat formatter = new DecimalFormat(format_pattern);
        return formatter.format(number_to_round);
    }

    public static String getRoundedDoubleWithCommas(double number_to_round, int decimal_places) {
        if (number_to_round == Double.NaN) {
            return new String("NaN");
        }
        if (number_to_round == Double.NEGATIVE_INFINITY) {
            return new String("-Infinity");
        }
        if (number_to_round == Double.POSITIVE_INFINITY) {
            return new String("Infinity");
        }
        String format_pattern = "###,###.";
        for (int i = 0; i < decimal_places; ++i) {
            format_pattern = format_pattern + "#";
        }
        DecimalFormat formatter = new DecimalFormat(format_pattern);
        return formatter.format(number_to_round);
    }

    public static String getDoubleInScientificNotation(double number_to_round, int significant_digits) {
        if (number_to_round == Double.NaN) {
            return new String("NaN");
        }
        if (number_to_round == Double.NEGATIVE_INFINITY) {
            return new String("-Infinity");
        }
        if (number_to_round == Double.POSITIVE_INFINITY) {
            return new String("Infinity");
        }
        String format_pattern = "0.";
        for (int i = 0; i < significant_digits - 1; ++i) {
            format_pattern = format_pattern + "#";
        }
        format_pattern = format_pattern + "E0";
        DecimalFormat formatter = new DecimalFormat(format_pattern);
        return formatter.format(number_to_round);
    }

    public static String getNumberFormattedWithCommas(int number) {
        String format_pattern = "###,###";
        DecimalFormat formatter = new DecimalFormat(format_pattern);
        return formatter.format(number);
    }

    public static String getNumberFormattedWithCommas(long number) {
        String format_pattern = "###,###";
        DecimalFormat formatter = new DecimalFormat(format_pattern);
        return formatter.format(number);
    }

    public static boolean testIfStringIsAnInt(String test_string) {
        boolean is_int = true;
        try {
            int dummy = Integer.parseInt(test_string);
        }
        catch (NumberFormatException e) {
            is_int = false;
        }
        return is_int;
    }

    public static int getIntInLimits(String test_string, int min, int max) throws Exception {
        try {
            int number = Integer.parseInt(test_string);
            if (number < min) {
                throw new Exception(test_string + " is less than the acceptable minimum of " + min);
            }
            if (number > max) {
                throw new Exception(test_string + " is more than the acceptable maximum of " + max);
            }
            return number;
        }
        catch (NumberFormatException e) {
            throw new Exception(test_string + " is not an integer.");
        }
    }

    public static String URLEncodeWithNulls(String to_encode) throws Exception {
        if (to_encode == null) {
            return "";
        }
        return URLEncoder.encode(to_encode, "utf-8");
    }

    public static String URLDecodeNullCompatible(String to_encode) throws Exception {
        if (to_encode == null) {
            return null;
        }
        return URLDecoder.decode(to_encode, "utf-8");
    }

    public static byte[] passwordBasedEncrypt(String text_to_encrypt, String password) throws Exception {
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        int count = 20;
        PBEParameterSpec pbe_param_spec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory key_factory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbe_key = key_factory.generateSecret(pbeKeySpec);
        Cipher pbe_cipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbe_cipher.init(1, (Key)pbe_key, pbe_param_spec);
        return pbe_cipher.doFinal(text_to_encrypt.getBytes());
    }

    public static String passwordBasedDecrypt(byte[] encrypted_text, String password) throws Exception {
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        int count = 20;
        PBEParameterSpec pbe_param_spec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory key_factory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbe_key = key_factory.generateSecret(pbeKeySpec);
        Cipher pbe_cipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbe_cipher.init(2, (Key)pbe_key, pbe_param_spec);
        return new String(pbe_cipher.doFinal(encrypted_text));
    }
}

