/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.webservices;

import com.google.soap.search.GoogleSearch;
import com.google.soap.search.GoogleSearchFault;
import com.google.soap.search.GoogleSearchResult;
import com.google.soap.search.GoogleSearchResultElement;
import java.net.InetAddress;
import mckay.utilities.staticlibraries.StringMethods;
import mckay.utilities.webservices.NetworkSearch;

public class GoogleWebSearch
extends NetworkSearch {
    private GoogleSearch search_client = new GoogleSearch();

    public GoogleWebSearch(String google_license_key) {
        this.search_client.setKey(google_license_key);
    }

    public String getSeachServiceName() {
        return "Google SOAP";
    }

    public String getSearchServiceLimitations() {
        String limitations = "\nThe " + this.getSeachServiceName() + " web services have the following limitations in the context of all of the available search parameters.\n" + "<ul>\n" + "<li>There is no functionality for searching for similar but non-matching strings.\n" + "<li>There is no functionality for performing searches using a service located in a specific country.\n" + "<li>Searches can only be limited to one specific network site, not to multiple specified network sites. General network searches are permitted.\n" + "<li>There is a maximum of 10 words per query.\n" + "<li>Only up to 10 results may be returned per query.\n" + "<li>Only results up to the 1000th rank may be returned.\n" + "<li>Only up to 1000 queries may be performed per day. This quota refers to queries from all IP addresses combined.\n" + "</ul>\n";
        return limitations;
    }

    public String[][] getSearchResults(String[] search_strings, int start_index, int max_results, String[] number_hits, String[] query_used) throws Exception {
        String[][] formatted_search_results = null;
        String query = this.formatSearchString(search_strings);
        this.formatErrorMessage(null, query, max_results);
        try {
            int i;
            this.search_client = (GoogleSearch)this.prepareSearcher(this.search_client);
            this.search_client.setStartResult(start_index - 1);
            this.search_client.setMaxResults(max_results);
            this.search_client.setQueryString(query);
            GoogleSearchResult query_results = this.search_client.doSearch();
            GoogleSearchResultElement[] query_results_array = query_results.getResultElements();
            formatted_search_results = new String[query_results_array.length][3];
            for (i = 0; i < formatted_search_results.length; ++i) {
                formatted_search_results[i][0] = query_results_array[i].getTitle();
                formatted_search_results[i][1] = query_results_array[i].getURL();
                formatted_search_results[i][2] = query_results_array[i].getSnippet();
            }
            for (i = 0; i < formatted_search_results.length; ++i) {
                formatted_search_results[i][0] = formatted_search_results[i][0].replaceAll("<.*?>", "");
                formatted_search_results[i][2] = formatted_search_results[i][2].replaceAll("<.*?>", "");
            }
            if (number_hits != null) {
                number_hits[0] = new Integer(query_results.getEstimatedTotalResultsCount()).toString();
            }
            if (query_used != null) {
                query_used[0] = query;
            }
        }
        catch (Exception e) {
            this.formatErrorMessage(e, query, max_results);
        }
        return formatted_search_results;
    }

    public long getNumberHits(String[] search_strings, String[] query_used) throws Exception {
        String query = this.formatSearchString(search_strings);
        this.formatErrorMessage(null, query, 0);
        try {
            this.search_client = (GoogleSearch)this.prepareSearcher(this.search_client);
            this.search_client.setQueryString(query);
            GoogleSearchResult results = this.search_client.doSearch();
            long number_hits = results.getEstimatedTotalResultsCount();
            if (query_used != null) {
                query_used[0] = query;
            }
            return number_hits;
        }
        catch (Exception e) {
            this.formatErrorMessage(e, query, 0);
            return 0L;
        }
    }

    protected String formatSearchString(String[] search_strings) throws Exception {
        int i;
        if (search_strings == null) {
            throw new Exception("No search strings specified in query.");
        }
        for (int i2 = 0; i2 < search_strings.length; ++i2) {
            if (search_strings[i2] != null) continue;
            throw new Exception("One or more search terms is null.");
        }
        String formatted_query = "";
        for (i = 0; i < search_strings.length; ++i) {
            if (i != 0) {
                formatted_query = this.or_based_search ? formatted_query + " OR " : formatted_query + " ";
            }
            if (!this.literal_search) continue;
            if (!search_strings[i].startsWith("\"") && !search_strings[i].endsWith("\"")) {
                formatted_query = formatted_query + "\"" + search_strings[i] + "\"";
                continue;
            }
            if (this.or_based_search) {
                String[] words = StringMethods.breakIntoTokens(search_strings[i], " ");
                String to_add = words[0];
                if (words.length > 1) {
                    for (int j = 1; j < words.length; ++j) {
                        to_add = to_add + " OR " + words[j];
                    }
                }
                formatted_query = formatted_query + to_add;
                continue;
            }
            formatted_query = formatted_query + search_strings[i];
        }
        if (this.strings_to_exclude != null) {
            for (i = 0; i < this.strings_to_exclude.length; ++i) {
                formatted_query = formatted_query + " -\"" + this.strings_to_exclude[i] + "\"";
            }
        }
        if (this.specific_site != null) {
            formatted_query = formatted_query + " site:" + this.specific_site;
        }
        if (!this.limit_to_file_type.equals("No Limitations")) {
            formatted_query = formatted_query + " filetype:" + this.limit_to_file_type;
        }
        return formatted_query;
    }

    protected Object prepareSearcher(Object searcher) {
        String country_code;
        GoogleSearch this_searcher = (GoogleSearch)searcher;
        String language_code = this.getLanguageCode(this.limit_to_language);
        if (language_code != null) {
            this_searcher.setLanguageRestricts(language_code);
        }
        if ((country_code = this.getCountryCode(this.limit_to_country)) != null) {
            this_searcher.setRestrict(country_code);
        }
        this_searcher.setFilter(this.suppress_similar_hits);
        this_searcher.setSafeSearch(this.suppress_adult_content);
        return this_searcher;
    }

    protected void formatErrorMessage(Exception exception, String query, int max_results) throws Exception {
        if (exception == null) {
            if (max_results > 10) {
                throw new Exception("Service error when using " + this.getSeachServiceName() + ".\n\n" + "Requested a search with " + max_results + " results.\n" + "Google only allows up to 10.\n\n");
            }
        } else if (exception != null) {
            if (exception.toString().indexOf("quota") != -1) {
                throw new Exception("Service error when attempting to use " + this.getSeachServiceName() + ".\n\n" + "Daily search quota exceeded.\n" + "Google only allows 1000 queries per day per authorization key (irregardless of IP address).\n" + "You must wait for your quota to be cleared before you can perform more searches.\n\n");
            }
            if (exception.toString().indexOf("Invalid authorization key") != -1) {
                throw new Exception("Connection error when attempting to use " + this.getSeachServiceName() + ".\n\n" + "Invalid Google license key used.\n" + "Please correct this in the options.\n\n");
            }
            if (exception.toString().indexOf("Connection timed out") != -1) {
                throw new Exception("Service error when attempting to use " + this.getSeachServiceName() + ".\n\n" + "Timed out while trying to contact Google.\n" + "Service may be temporarily overloaded.\n" + "Please retry your search immediately.\n\n");
            }
            try {
                InetAddress address = InetAddress.getByName("www.google.com");
            }
            catch (Exception f) {
                throw new Exception("Unable to access the internet.\nPlease ensure that your computer is connected to the internet or other appropriate network.\n");
            }
            if (exception instanceof GoogleSearchFault) {
                throw new Exception("Search error when using " + this.getSeachServiceName() + ".\n\n" + exception.toString() + "\n\n" + "Query used: " + query + "\n\n");
            }
            throw new Exception("Search error when using " + this.getSeachServiceName() + ".\n\n" + exception.toString() + "\n\n" + "Query used: " + query + "\n\n");
        }
    }

    private String getLanguageCode(String language) {
        String return_value = null;
        if (language.equals("English")) {
            return_value = "lang_en";
        } else if (language.equals("French")) {
            return_value = "lang_fr";
        } else if (language.equals("Spanish")) {
            return_value = "lang_es";
        } else if (language.equals("Portuguese")) {
            return_value = "lang_pt";
        } else if (language.equals("German")) {
            return_value = "lang_de";
        } else if (language.equals("Chinese")) {
            return_value = "lang_zh-CN";
        } else if (language.equals("Japanese")) {
            return_value = "lang_ja";
        } else if (language.equals("Turkish")) {
            return_value = "lang_tr";
        } else if (language.equals("Arabic")) {
            return_value = "lang_ar";
        }
        return return_value;
    }

    private String getCountryCode(String country) {
        String return_value = null;
        if (country.equals("Canada")) {
            return_value = "countryCA";
        } else if (country.equals("U.S.A.")) {
            return_value = "countryUS";
        } else if (country.equals("U.K.")) {
            return_value = "countryUK";
        } else if (country.equals("France")) {
            return_value = "countryFR";
        } else if (country.equals("Spain")) {
            return_value = "countryES";
        } else if (country.equals("Germany")) {
            return_value = "countryDE";
        } else if (country.equals("Austria")) {
            return_value = "countryAT ";
        } else if (country.equals("Brazil")) {
            return_value = "countryBR ";
        } else if (country.equals("Japan")) {
            return_value = "countryJP";
        } else if (country.equals("China")) {
            return_value = "countryCN";
        } else if (country.equals("Turkey")) {
            return_value = "countryTR";
        }
        return return_value;
    }
}

