/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.webservices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import mckay.utilities.gui.progressbars.SimpleProgressBarDialog;
import mckay.utilities.webservices.GoogleWebSearch;
import mckay.utilities.webservices.NetworkSearch;
import mckay.utilities.webservices.YahooWebSearch;

public class NetworkSearchDialog
extends JFrame
implements ActionListener,
KeyListener {
    private JTextField first_search_string_field;
    private JTextField second_search_string_field;
    private JCheckBox literal_search_checkbox;
    private JCheckBox any_not_all_search_strings_checkbox;
    private JCheckBox include_hits_with_similar_search_strings_checkbox;
    private JTextField first_excluded_string_field;
    private JTextField second_excluded_string_field;
    private JTextField specific_domain_field;
    private JComboBox limit_to_language_combobox;
    private JComboBox limit_to_country_combobox;
    private JComboBox searching_from_region_combobox;
    private JComboBox limit_to_file_type_combobox;
    private JCheckBox suppress_similar_hits_checkbox;
    private JCheckBox suppress_adult_content_checkbox;
    private JComboBox max_results_combobox;
    private JComboBox left_web_service_combobox;
    private JComboBox right_web_service_combobox;
    private JEditorPane left_results_pane;
    private JEditorPane right_results_pane;
    private JButton left_back_button;
    private JButton left_next_button;
    private JButton right_back_button;
    private JButton right_next_button;
    private int current_left_start = 0;
    private int current_left_end = 0;
    private int current_right_start = 0;
    private int current_right_end = 0;
    private JButton begin_search_button;
    private String yahoo_application_id;
    private String google_license_key;
    private String[] included_web_services;

    public NetworkSearchDialog(String yahoo_application_id, String google_license_key) throws Exception {
        this.processWebServices(yahoo_application_id, google_license_key);
        this.initializeLayout();
        this.literal_search_checkbox.setSelected(true);
        this.any_not_all_search_strings_checkbox.setSelected(false);
        this.include_hits_with_similar_search_strings_checkbox.setSelected(false);
        this.limit_to_language_combobox.setSelectedIndex(0);
        this.limit_to_country_combobox.setSelectedIndex(0);
        this.searching_from_region_combobox.setSelectedIndex(0);
        this.limit_to_file_type_combobox.setSelectedIndex(0);
        this.suppress_similar_hits_checkbox.setSelected(false);
        this.suppress_adult_content_checkbox.setSelected(false);
        this.max_results_combobox.setSelectedIndex(9);
        int web_services_available = this.included_web_services.length - 1;
        this.left_web_service_combobox.setSelectedIndex(web_services_available);
        if (--web_services_available == 0) {
            this.right_web_service_combobox.setSelectedIndex(0);
        } else {
            this.right_web_service_combobox.setSelectedIndex(web_services_available);
        }
        this.setVisible(true);
    }

    public NetworkSearchDialog(String first_search_string, String second_search_string, boolean is_literal_search, boolean is_boolean_or, boolean include_similar_hits, String first_excluded_string, String second_excluded_string, String specific_domain, String specific_language, String specific_country, String search_origin, String specific_file_type, boolean suppress_similar_hits, boolean suppress_adult_content, int max_results, String yahoo_application_id, String google_license_key) throws Exception {
        this.processWebServices(yahoo_application_id, google_license_key);
        this.initializeLayout();
        this.first_search_string_field.setText(first_search_string);
        this.second_search_string_field.setText(second_search_string);
        this.literal_search_checkbox.setSelected(is_literal_search);
        this.any_not_all_search_strings_checkbox.setSelected(is_boolean_or);
        this.include_hits_with_similar_search_strings_checkbox.setSelected(include_similar_hits);
        this.first_excluded_string_field.setText(first_excluded_string);
        this.second_excluded_string_field.setText(second_excluded_string);
        this.specific_domain_field.setText(specific_domain);
        this.limit_to_language_combobox.setSelectedItem(specific_language);
        this.limit_to_country_combobox.setSelectedItem(specific_country);
        this.searching_from_region_combobox.setSelectedItem(search_origin);
        this.limit_to_file_type_combobox.setSelectedItem(specific_file_type);
        this.suppress_similar_hits_checkbox.setSelected(suppress_similar_hits);
        this.suppress_adult_content_checkbox.setSelected(suppress_adult_content);
        try {
            this.max_results_combobox.setSelectedIndex(max_results - 1);
        }
        catch (Exception e) {
            this.max_results_combobox.setSelectedIndex(0);
        }
        int web_services_available = this.included_web_services.length - 1;
        this.left_web_service_combobox.setSelectedIndex(web_services_available);
        if (--web_services_available == 0) {
            this.right_web_service_combobox.setSelectedIndex(0);
        } else {
            this.right_web_service_combobox.setSelectedIndex(web_services_available);
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.begin_search_button)) {
            this.current_left_start = 1;
            this.current_right_start = 1;
            this.current_left_end = 0;
            this.current_right_end = 0;
            this.performSearch(this.current_left_start, this.current_right_start);
        }
        if (event.getSource().equals(this.left_back_button)) {
            this.current_left_start -= ((Integer)this.max_results_combobox.getSelectedItem()).intValue();
            if (this.current_left_start < 1) {
                this.current_left_start = 1;
            }
            this.performSearch(this.current_left_start, 0);
        }
        if (event.getSource().equals(this.left_next_button)) {
            this.current_left_start = this.current_left_end + 1;
            this.performSearch(this.current_left_start, 0);
        }
        if (event.getSource().equals(this.right_back_button)) {
            this.current_right_start -= ((Integer)this.max_results_combobox.getSelectedItem()).intValue();
            if (this.current_right_start < 1) {
                this.current_right_start = 1;
            }
            this.performSearch(0, this.current_right_start);
        }
        if (event.getSource().equals(this.right_next_button)) {
            this.current_right_start = this.current_right_end + 1;
            this.performSearch(0, this.current_right_start);
        }
        if (event.getSource().equals(this.left_web_service_combobox)) {
            this.left_results_pane.setText("");
        }
        if (event.getSource().equals(this.right_web_service_combobox)) {
            this.right_results_pane.setText("");
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.current_left_start = 1;
            this.current_right_start = 1;
            this.current_left_end = 0;
            this.current_right_end = 0;
            this.performSearch(this.current_left_start, this.current_right_start);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void processWebServices(String yahoo_application_id, String google_license_key) throws Exception {
        if (yahoo_application_id == null && google_license_key == null) {
            throw new Exception("No web services specified.");
        }
        if (yahoo_application_id != null && yahoo_application_id.equals("")) {
            throw new Exception("No Yahoo Application ID code specified.");
        }
        if (google_license_key != null && google_license_key.equals("")) {
            throw new Exception("No Google License Key code specified.");
        }
        LinkedList<String> included_web_services_list = new LinkedList<String>();
        included_web_services_list.add("None");
        if (yahoo_application_id != null) {
            included_web_services_list.add("Yahoo");
        }
        if (google_license_key != null) {
            included_web_services_list.add("Google");
        }
        this.included_web_services = included_web_services_list.toArray(new String[1]);
        this.yahoo_application_id = yahoo_application_id;
        this.google_license_key = google_license_key;
    }

    private void initializeLayout() {
        int horizontal_gap = 4;
        int vertical_gap = 4;
        this.setTitle("Network Search");
        this.first_search_string_field = new JTextField();
        this.first_search_string_field.addKeyListener(this);
        JPanel first_search_string_panel = NetworkSearchDialog.getLabeledContainer("Search string 1:", this.first_search_string_field, horizontal_gap);
        this.second_search_string_field = new JTextField();
        this.second_search_string_field.addKeyListener(this);
        JPanel second_search_string_panel = NetworkSearchDialog.getLabeledContainer("Search string 2:", this.second_search_string_field, horizontal_gap);
        JPanel control_panel_1 = new JPanel(new GridLayout(1, 2, horizontal_gap, vertical_gap));
        control_panel_1.add(first_search_string_panel);
        control_panel_1.add(second_search_string_panel);
        this.literal_search_checkbox = new JCheckBox("Treat search strings literally");
        this.any_not_all_search_strings_checkbox = new JCheckBox("Perform search as OR instead of AND");
        this.include_hits_with_similar_search_strings_checkbox = new JCheckBox("Include non-matching similar hits");
        JPanel control_panel_2 = new JPanel(new GridLayout(1, 3, horizontal_gap, vertical_gap));
        control_panel_2.add(this.literal_search_checkbox);
        control_panel_2.add(this.any_not_all_search_strings_checkbox);
        control_panel_2.add(this.include_hits_with_similar_search_strings_checkbox);
        this.first_excluded_string_field = new JTextField();
        JPanel first_excluded_string_panel = NetworkSearchDialog.getLabeledContainer("Excluded string 1:", this.first_excluded_string_field, horizontal_gap);
        this.first_excluded_string_field.addKeyListener(this);
        this.second_excluded_string_field = new JTextField();
        JPanel second_excluded_string_panel = NetworkSearchDialog.getLabeledContainer("Excluded string 2:", this.second_excluded_string_field, horizontal_gap);
        this.second_excluded_string_field.addKeyListener(this);
        this.specific_domain_field = new JTextField();
        JPanel specific_site_panel = NetworkSearchDialog.getLabeledContainer("Limit to site:", this.specific_domain_field, horizontal_gap);
        this.specific_domain_field.addKeyListener(this);
        JPanel control_panel_3 = new JPanel(new GridLayout(1, 3, horizontal_gap, vertical_gap));
        control_panel_3.add(first_excluded_string_panel);
        control_panel_3.add(second_excluded_string_panel);
        control_panel_3.add(specific_site_panel);
        this.limit_to_language_combobox = new JComboBox<String>(NetworkSearch.included_languages);
        JPanel limit_to_language_panel = NetworkSearchDialog.getLabeledContainer("Limit to language:", this.limit_to_language_combobox, horizontal_gap);
        this.limit_to_country_combobox = new JComboBox<String>(NetworkSearch.included_countries);
        JPanel limit_to_country_panel = NetworkSearchDialog.getLabeledContainer("Limit to country:", this.limit_to_country_combobox, horizontal_gap);
        JPanel control_panel_4 = new JPanel(new GridLayout(1, 2, horizontal_gap, vertical_gap));
        control_panel_4.add(limit_to_language_panel);
        control_panel_4.add(limit_to_country_panel);
        this.limit_to_file_type_combobox = new JComboBox<String>(NetworkSearch.included_file_types);
        JPanel limit_to_file_type_panel = NetworkSearchDialog.getLabeledContainer("Limit to file type:", this.limit_to_file_type_combobox, horizontal_gap);
        this.searching_from_region_combobox = new JComboBox<String>(NetworkSearch.included_countries);
        JPanel searching_from_region_panel = NetworkSearchDialog.getLabeledContainer("Search from region:", this.searching_from_region_combobox, horizontal_gap);
        JPanel control_panel_5 = new JPanel(new GridLayout(1, 2, horizontal_gap, vertical_gap));
        control_panel_5.add(searching_from_region_panel);
        control_panel_5.add(limit_to_file_type_panel);
        this.suppress_similar_hits_checkbox = new JCheckBox("Suppress similar hits");
        this.suppress_adult_content_checkbox = new JCheckBox("Suppress adult content");
        Integer[] permitted_number_of_results = new Integer[100];
        for (int i = 0; i < permitted_number_of_results.length; ++i) {
            permitted_number_of_results[i] = new Integer(i + 1);
        }
        this.max_results_combobox = new JComboBox<Integer>(permitted_number_of_results);
        JPanel max_results_panel = NetworkSearchDialog.getLabeledContainer("Maximum results returned:", this.max_results_combobox, horizontal_gap);
        JPanel control_panel_6 = new JPanel(new GridLayout(1, 3, horizontal_gap, vertical_gap));
        control_panel_6.add(this.suppress_similar_hits_checkbox);
        control_panel_6.add(this.suppress_adult_content_checkbox);
        control_panel_6.add(max_results_panel);
        JPanel combined_control_panels = new JPanel(new GridLayout(6, 1, horizontal_gap, vertical_gap));
        combined_control_panels.add(control_panel_1);
        combined_control_panels.add(control_panel_2);
        combined_control_panels.add(control_panel_3);
        combined_control_panels.add(control_panel_4);
        combined_control_panels.add(control_panel_5);
        combined_control_panels.add(control_panel_6);
        this.left_web_service_combobox = new JComboBox<String>(this.included_web_services);
        this.left_web_service_combobox.addActionListener(this);
        JPanel left_web_service_panel = NetworkSearchDialog.getLabeledContainer("Service:", this.left_web_service_combobox, horizontal_gap);
        this.left_back_button = new JButton("<< Prev");
        this.left_back_button.addActionListener(this);
        this.left_back_button.setEnabled(false);
        this.left_next_button = new JButton("Next >>");
        this.left_next_button.addActionListener(this);
        this.left_next_button.setEnabled(false);
        this.right_web_service_combobox = new JComboBox<String>(this.included_web_services);
        this.right_web_service_combobox.addActionListener(this);
        JPanel right_web_service_panel = NetworkSearchDialog.getLabeledContainer("Service:", this.right_web_service_combobox, horizontal_gap);
        this.right_back_button = new JButton("<< Prev");
        this.right_back_button.addActionListener(this);
        this.right_back_button.setEnabled(false);
        this.right_next_button = new JButton("Next >>");
        this.right_next_button.addActionListener(this);
        this.right_next_button.setEnabled(false);
        JPanel left_chooser_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        left_chooser_panel.add((Component)this.left_back_button, "West");
        left_chooser_panel.add((Component)this.left_web_service_combobox, "Center");
        left_chooser_panel.add((Component)this.left_next_button, "East");
        JPanel right_chooser_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        right_chooser_panel.add((Component)this.right_back_button, "West");
        right_chooser_panel.add((Component)this.right_web_service_combobox, "Center");
        right_chooser_panel.add((Component)this.right_next_button, "East");
        JPanel results_chooser = new JPanel(new GridLayout(1, 2, horizontal_gap, vertical_gap));
        results_chooser.add(left_chooser_panel);
        results_chooser.add(right_chooser_panel);
        this.left_results_pane = new JEditorPane();
        this.left_results_pane.setContentType("text/html");
        this.left_results_pane.setEditable(false);
        this.right_results_pane = new JEditorPane();
        this.right_results_pane.setContentType("text/html");
        this.right_results_pane.setEditable(false);
        JScrollPane left_results_scroll_pane = new JScrollPane(this.left_results_pane, 22, 31);
        JScrollPane right_results_scroll_pane = new JScrollPane(this.right_results_pane, 22, 31);
        JPanel combined_results_panel = new JPanel(new GridLayout(1, 2, horizontal_gap, vertical_gap));
        combined_results_panel.add(left_results_scroll_pane);
        combined_results_panel.add(right_results_scroll_pane);
        JPanel results_chooser_and_results_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        results_chooser_and_results_panel.add((Component)results_chooser, "North");
        results_chooser_and_results_panel.add((Component)combined_results_panel, "Center");
        this.begin_search_button = new JButton("PERFORM SEARCH");
        this.begin_search_button.addActionListener(this);
        JPanel control_panel_border_panel_inner = new JPanel();
        JPanel control_panel_border_panel_outer = new JPanel();
        control_panel_border_panel_inner.add(combined_control_panels);
        control_panel_border_panel_outer.add(control_panel_border_panel_inner);
        combined_control_panels.setBorder(BorderFactory.createEmptyBorder(vertical_gap / 2, horizontal_gap / 2, vertical_gap / 2, horizontal_gap / 2));
        control_panel_border_panel_inner.setBorder(BorderFactory.createEtchedBorder());
        control_panel_border_panel_outer.setBorder(BorderFactory.createEmptyBorder(vertical_gap, 0, horizontal_gap / 2, 0));
        results_chooser_and_results_panel.setBorder(BorderFactory.createEmptyBorder(0, horizontal_gap, vertical_gap, horizontal_gap));
        this.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        this.add((Component)control_panel_border_panel_outer, "North");
        this.add((Component)results_chooser_and_results_panel, "Center");
        this.add((Component)this.begin_search_button, "South");
        int screen_height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.setBounds(0, 0, 775, (int)(0.9 * (double)screen_height));
        this.setDefaultCloseOperation(2);
    }

    private void performSearch(int left_start_rank, int right_start_rank) {
        int i;
        if (left_start_rank != 0) {
            this.left_results_pane.setText("");
        }
        if (right_start_rank != 0) {
            this.right_results_pane.setText("");
        }
        int number_tasks = 1;
        if (left_start_rank > 0) {
            ++number_tasks;
        }
        if (right_start_rank > 0) {
            ++number_tasks;
        }
        SimpleProgressBarDialog progress_bar = new SimpleProgressBarDialog(number_tasks, this);
        int[] start_ranks = new int[]{left_start_rank, right_start_rank};
        NetworkSearch[] searchers = new NetworkSearch[2];
        String[] service_names = new String[]{(String)this.left_web_service_combobox.getSelectedItem(), (String)this.right_web_service_combobox.getSelectedItem()};
        for (i = 0; i < searchers.length; ++i) {
            searchers[i] = null;
            if (start_ranks[i] == 0) continue;
            if (service_names[i].equals("Yahoo")) {
                searchers[i] = new YahooWebSearch(this.yahoo_application_id);
                continue;
            }
            if (!service_names[i].equals("Google")) continue;
            searchers[i] = new GoogleWebSearch(this.google_license_key);
        }
        for (i = 0; i < searchers.length; ++i) {
            try {
                if (searchers[i] == null) continue;
                searchers[i].setLiteralSearch(this.literal_search_checkbox.isSelected());
                searchers[i].setOrBasedSearch(this.any_not_all_search_strings_checkbox.isSelected());
                searchers[i].setIncludeSimilarButNonMatchingStrings(this.include_hits_with_similar_search_strings_checkbox.isSelected());
                searchers[i].setSuppressSimilarHits(this.suppress_similar_hits_checkbox.isSelected());
                searchers[i].setSuppressAdultContent(this.suppress_adult_content_checkbox.isSelected());
                int number_exlusions = 0;
                if (!this.first_excluded_string_field.getText().equals("")) {
                    ++number_exlusions;
                }
                if (!this.second_excluded_string_field.getText().equals("")) {
                    ++number_exlusions;
                }
                if (number_exlusions != 0) {
                    String[] exclusions = new String[number_exlusions];
                    int j = 0;
                    if (!this.first_excluded_string_field.getText().equals("")) {
                        exclusions[j] = this.first_excluded_string_field.getText();
                        ++j;
                    }
                    if (!this.second_excluded_string_field.getText().equals("")) {
                        exclusions[j] = this.second_excluded_string_field.getText();
                    }
                    searchers[i].setSearchStringsToExclude(exclusions);
                }
                if (!this.specific_domain_field.getText().equals("")) {
                    searchers[i].setSpecificSiteToSearch(this.specific_domain_field.getText());
                }
                searchers[i].setLanguageResultsMustBeIn((String)this.limit_to_language_combobox.getSelectedItem());
                searchers[i].setCountryResultsMustBeIn((String)this.limit_to_country_combobox.getSelectedItem());
                searchers[i].setRegionToSearchFrom((String)this.searching_from_region_combobox.getSelectedItem());
                searchers[i].setFileTypeResultsMustBelongTo((String)this.limit_to_file_type_combobox.getSelectedItem());
                continue;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), service_names[i] + " ERROR", 0);
            }
        }
        String[] search_strings = null;
        int number_search_strings = 0;
        if (!this.first_search_string_field.getText().equals("")) {
            ++number_search_strings;
        }
        if (!this.second_search_string_field.getText().equals("")) {
            ++number_search_strings;
        }
        if (number_search_strings != 0) {
            search_strings = new String[number_search_strings];
            int j = 0;
            if (!this.first_search_string_field.getText().equals("")) {
                search_strings[j] = this.first_search_string_field.getText();
                ++j;
            }
            if (!this.second_search_string_field.getText().equals("")) {
                search_strings[j] = this.second_search_string_field.getText();
            }
        }
        progress_bar.incrementStatus();
        int max_results = (Integer)this.max_results_combobox.getSelectedItem();
        JButton[] previous_buttons = new JButton[]{this.left_back_button, this.right_back_button};
        JButton[] next_buttons = new JButton[]{this.left_next_button, this.right_next_button};
        for (int i2 = 0; i2 < searchers.length; ++i2) {
            try {
                if (searchers[i2] != null) {
                    String[][] results = null;
                    String[] number_hits = new String[1];
                    String[] query_used = new String[1];
                    results = searchers[i2].getSearchResults(search_strings, start_ranks[i2], max_results, number_hits, query_used);
                    if (i2 == 0) {
                        this.left_results_pane.setText(searchers[i2].getHTMLFormattedSearchResults(results, start_ranks[i2], number_hits[0], query_used[0], searchers[i2].getSeachServiceName()));
                        this.left_results_pane.setCaretPosition(0);
                    } else if (i2 == 1) {
                        this.right_results_pane.setText(searchers[i2].getHTMLFormattedSearchResults(results, start_ranks[i2], number_hits[0], query_used[0], searchers[i2].getSeachServiceName()));
                        this.right_results_pane.setCaretPosition(0);
                    }
                    if (start_ranks[i2] == 1) {
                        previous_buttons[i2].setEnabled(false);
                    } else {
                        previous_buttons[i2].setEnabled(true);
                    }
                    boolean later_hits_exist = false;
                    int total_hits_found = Integer.parseInt(number_hits[0]);
                    int current_end_index = start_ranks[i2] + results.length - 1;
                    if (current_end_index < total_hits_found) {
                        later_hits_exist = true;
                    }
                    if (i2 == 0) {
                        this.current_left_end = current_end_index;
                        this.left_next_button.setEnabled(later_hits_exist);
                    }
                    if (i2 == 1) {
                        this.current_right_end = current_end_index;
                        this.right_next_button.setEnabled(later_hits_exist);
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage().equals("Unable to access the internet.") || e.getMessage().equals("No search strings specified in query.")) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                    for (int j = 0; j < previous_buttons.length; ++j) {
                        previous_buttons[j].setEnabled(false);
                        next_buttons[j].setEnabled(false);
                    }
                    i2 = searchers.length;
                    progress_bar.done();
                }
                JOptionPane.showMessageDialog(null, e.getMessage(), service_names[i2] + " ERROR", 0);
                previous_buttons[i2].setEnabled(false);
                next_buttons[i2].setEnabled(false);
            }
            progress_bar.incrementStatus();
        }
    }

    private static JPanel getLabeledContainer(String label_text, Container container, int gap) {
        JPanel panel = new JPanel(new BorderLayout(gap, gap));
        panel.add((Component)new JLabel(label_text), "West");
        panel.add((Component)container, "Center");
        return panel;
    }
}

