/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.webservices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.staticlibraries.StringMethods;

public class ProxyServerAccessor
extends JFrame
implements ActionListener {
    private String settings_save_path;
    private String test_url;
    private boolean save_settings = true;
    private String proxy_server = "";
    private String port = "80";
    private String username = "";
    private String password = "";
    private TextField proxy_server_field;
    private TextField port_field;
    private TextField username_field;
    private TextField password_field;
    private JCheckBox save_settings_checkbox;
    private JButton cancel_button;
    private JButton ok_button;

    public ProxyServerAccessor(String settings_save_path, String test_url) {
        try {
            boolean works;
            if (settings_save_path == null) {
                String home_directory = System.getProperty("user.home");
                String user_name = System.getProperty("user.name");
                String suffix = "_proxy_settings.cfg";
                String fs = System.getProperty("file.separator");
                settings_save_path = home_directory + fs + user_name + suffix;
            }
            if (test_url == null) {
                test_url = "http://www.google.com";
            }
            if (!(works = ProxyServerAccessor.isURLAccessible(test_url, null))) {
                this.settings_save_path = settings_save_path;
                this.test_url = test_url;
                try {
                    this.loadAndConfigureBasedOnSettingsFile();
                }
                catch (Exception e) {
                    this.initializeGUI();
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    public static boolean isURLAccessible(String test_url, Exception[] exception_store) {
        boolean accessible;
        block2: {
            accessible = false;
            try {
                URLConnection url_connection = new URL(test_url).openConnection();
                HttpURLConnection connection = (HttpURLConnection)url_connection;
                connection.setConnectTimeout(1500);
                connection.setReadTimeout(1500);
                connection.setInstanceFollowRedirects(true);
                connection.connect();
                connection.getContent();
                connection.disconnect();
                accessible = true;
            }
            catch (Exception e) {
                if (exception_store == null || exception_store.length == 1) break block2;
                exception_store[0] = e;
            }
        }
        return accessible;
    }

    public static void accessWebViaProxyServer(String proxy_server, String port, final String username, final String password) {
        System.setProperty("http.proxyHost", proxy_server);
        System.setProperty("http.proxyPort", port);
        if (!username.equals("") || !password.equals("")) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.cancel_button)) {
            this.done();
        } else if (event.getSource().equals(this.ok_button)) {
            try {
                this.configureProxy();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        }
    }

    private void loadAndConfigureBasedOnSettingsFile() throws Exception {
        File input_file = new File(this.settings_save_path);
        FileMethods.validateFile(input_file, true, false);
        byte[] encrypted_bytes = new byte[(int)input_file.length()];
        FileInputStream input_stream = new FileInputStream(input_file);
        input_stream.read(encrypted_bytes);
        input_stream.close();
        String key = System.getProperty("user.home");
        String decrypted_text = StringMethods.passwordBasedDecrypt(encrypted_bytes, key);
        String[] parsed_lines = StringMethods.breakIntoTokens(decrypted_text, "\n");
        this.proxy_server = parsed_lines[0];
        this.port = parsed_lines[1];
        this.username = parsed_lines[2];
        this.password = parsed_lines[3];
        ProxyServerAccessor.accessWebViaProxyServer(this.proxy_server, this.port, this.username, this.password);
        boolean works = ProxyServerAccessor.isURLAccessible(this.test_url, null);
        if (!works) {
            throw new Exception("Could not access " + this.test_url);
        }
    }

    private void saveSettingsFile() throws Exception {
        String nl = System.getProperty("line.separator");
        String data_to_save = this.proxy_server + nl + this.port + nl + this.username + nl + this.password + nl;
        String key = System.getProperty("user.home");
        byte[] encrypted = StringMethods.passwordBasedEncrypt(data_to_save, key);
        File save_file = FileMethods.getNewFileForWriting(this.settings_save_path, true);
        FileOutputStream writer = new FileOutputStream(save_file);
        writer.write(encrypted);
        writer.close();
        save_file.setReadable(false, false);
        save_file.setReadable(true, true);
    }

    private synchronized void initializeGUI() throws Exception {
        this.setTitle("Proxy Server Settings");
        int preferred_width = 350;
        int preferred_height = 20;
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProxyServerAccessor.this.done();
            }
        });
        this.proxy_server_field = new TextField();
        this.proxy_server_field.setEditable(true);
        this.proxy_server_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.port_field = new TextField();
        this.port_field.setEditable(true);
        this.port_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.username_field = new TextField();
        this.username_field.setEditable(true);
        this.username_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.password_field = new TextField();
        this.password_field.setEditable(true);
        this.password_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.password_field.setEchoChar('*');
        this.cancel_button = new JButton("Do Not Use Proxy");
        this.cancel_button.addActionListener(this);
        this.ok_button = new JButton("Enable Proxy Access");
        this.ok_button.addActionListener(this);
        this.save_settings_checkbox = new JCheckBox("Save these settings");
        this.save_settings_checkbox.addActionListener(this);
        this.setDefaultUIValues();
        Container content_pane = this.getContentPane();
        content_pane.setLayout(new GridLayout(6, 1, horizontal_gap, vertical_gap));
        JPanel proxy_server_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel port_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel username_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel password_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel field_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel button_panel = new JPanel(new GridLayout(1, 2, horizontal_gap, vertical_gap));
        proxy_server_panel.add((Component)new JLabel("Proxy server:"), "West");
        proxy_server_panel.add((Component)this.proxy_server_field, "East");
        content_pane.add(proxy_server_panel);
        port_panel.add((Component)new JLabel("Port:"), "West");
        port_panel.add((Component)this.port_field, "East");
        content_pane.add(port_panel);
        username_panel.add((Component)new JLabel("Username:"), "West");
        username_panel.add((Component)this.username_field, "East");
        content_pane.add(username_panel);
        password_panel.add((Component)new JLabel("Password:"), "West");
        password_panel.add((Component)this.password_field, "East");
        content_pane.add(password_panel);
        button_panel.add(this.cancel_button);
        button_panel.add(this.ok_button);
        content_pane.add(this.save_settings_checkbox);
        content_pane.add(button_panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.wait();
    }

    private void setDefaultUIValues() {
        this.proxy_server_field.setText(this.proxy_server);
        this.port_field.setText(this.port);
        this.username_field.setText(this.username);
        this.password_field.setText(this.password);
        this.save_settings_checkbox.setSelected(this.save_settings);
    }

    private void readUIFields() {
        if (this.proxy_server_field.getText().length() > 0) {
            this.proxy_server = this.proxy_server_field.getText();
        }
        if (this.port_field.getText().length() > 0) {
            this.port = this.port_field.getText();
        }
        if (this.username_field.getText().length() > 0) {
            this.username = this.username_field.getText();
        }
        if (this.password_field.getText().length() > 0) {
            this.password = this.password_field.getText();
        }
        this.save_settings = this.save_settings_checkbox.isSelected();
    }

    private void configureProxy() throws Exception {
        this.readUIFields();
        if (this.save_settings) {
            this.saveSettingsFile();
        }
        ProxyServerAccessor.accessWebViaProxyServer(this.proxy_server, this.port, this.username, this.password);
        boolean works = ProxyServerAccessor.isURLAccessible(this.test_url, null);
        if (!works) {
            JOptionPane.showMessageDialog(null, "Could not access the web with these settings.", "ERROR", 0);
        }
        if (works) {
            this.done();
        }
    }

    private synchronized void done() {
        this.notify();
        this.dispose();
    }
}

