/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import com.echonest.api.v4.Audio;
import com.echonest.api.v4.Biography;
import com.echonest.api.v4.Blog;
import com.echonest.api.v4.ENItem;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Image;
import com.echonest.api.v4.News;
import com.echonest.api.v4.PagedList;
import com.echonest.api.v4.PagedListInfo;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Review;
import com.echonest.api.v4.Term;
import com.echonest.api.v4.Video;
import com.echonest.api.v4.util.MQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artist
extends ENItem {
    private static final String PATH = "artist";
    private static final String TYPE = "artist";

    Artist(EchoNestAPI en, Map data) throws EchoNestException {
        super(en, "artist", "artist", data);
    }

    @Override
    public String getID() {
        if (this.data.containsKey("id")) {
            return (String)this.data.get("id");
        }
        return (String)this.data.get("thingID");
    }

    Artist(EchoNestAPI en, String id) throws EchoNestException {
        this(en, id, false);
    }

    Artist(EchoNestAPI en, String idOrName, boolean byName) throws EchoNestException {
        super(en, "artist", "artist", idOrName, byName);
    }

    public String getName() throws EchoNestException {
        return this.getString("name");
    }

    public double getHotttnesss() throws EchoNestException {
        this.fetchBucket("hotttnesss");
        return this.getDouble("hotttnesss");
    }

    public double getFamiliarity() throws EchoNestException {
        this.fetchBucket("familiarity");
        return this.getDouble("familiarity");
    }

    public String getForeignID(String idspace) throws EchoNestException {
        this.fetchBucket("id:" + idspace, idspace);
        return this.getString(idspace);
    }

    public List<Audio> getAudio() throws EchoNestException {
        String bucket = "audio";
        this.fetchBucket(bucket);
        return this.listToAudio((List)this.getObject(bucket));
    }

    public PagedList<Audio> getAudio(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/audio", "audio", start, count);
        return this.listToAudio(plist);
    }

    private List<Audio> listToAudio(List docs) {
        ArrayList<Audio> results = new ArrayList<Audio>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Audio audio = new Audio(map);
            results.add(audio);
            ++i;
        }
        return results;
    }

    private PagedList<Audio> listToAudio(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<Audio> results = new PagedList<Audio>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Audio audio = new Audio(map);
            results.add(audio);
            ++i;
        }
        return results;
    }

    public List<Biography> getBiographies() throws EchoNestException {
        String bucket = "biographies";
        this.fetchBucket(bucket);
        return this.listToBiography((List)this.getObject(bucket));
    }

    public PagedList<Biography> getBiographies(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/biographies", "biographies", start, count);
        return this.listToBiography(plist);
    }

    public PagedList<Biography> getBiographies(int start, int count, String license) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/biographies", "biographies", start, count, license);
        return this.listToBiography(plist);
    }

    public PagedList<Biography> getBiographies(int start, int count, List<String> licenses) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/biographies", "biographies", start, count, licenses);
        return this.listToBiography(plist);
    }

    private List<Biography> listToBiography(List docs) {
        ArrayList<Biography> results = new ArrayList<Biography>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Biography bio = new Biography(map);
            results.add(bio);
            ++i;
        }
        return results;
    }

    private PagedList<Biography> listToBiography(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<Biography> results = new PagedList<Biography>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Biography audio = new Biography(map);
            results.add(audio);
            ++i;
        }
        return results;
    }

    public List<Blog> getBlogs() throws EchoNestException {
        String bucket = "blogs";
        this.fetchBucket(bucket);
        return this.listToBlog((List)this.getObject(bucket));
    }

    public PagedList<Blog> getBlogs(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/blogs", "blogs", start, count);
        return this.listToBlog(plist);
    }

    private List<Blog> listToBlog(List docs) {
        ArrayList<Blog> results = new ArrayList<Blog>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Blog bio = new Blog(map);
            results.add(bio);
            ++i;
        }
        return results;
    }

    private PagedList<Blog> listToBlog(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<Blog> results = new PagedList<Blog>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Blog blog = new Blog(map);
            results.add(blog);
            ++i;
        }
        return results;
    }

    public List<Image> getImages() throws EchoNestException {
        String bucket = "images";
        this.fetchBucket(bucket);
        return this.listToImage((List)this.getObject(bucket));
    }

    public PagedList<Image> getImages(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/images", "images", start, count);
        return this.listToImage(plist);
    }

    public PagedList<Image> getImages(int start, int count, List<String> licenses) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/images", "images", start, count, licenses);
        return this.listToImage(plist);
    }

    public PagedList<Image> getImages(int start, int count, String license) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/images", "images", start, count, license);
        return this.listToImage(plist);
    }

    private List<Image> listToImage(List docs) {
        ArrayList<Image> results = new ArrayList<Image>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Image image = new Image(map);
            results.add(image);
            ++i;
        }
        return results;
    }

    private PagedList<Image> listToImage(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<Image> results = new PagedList<Image>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Image image = new Image(map);
            results.add(image);
            ++i;
        }
        return results;
    }

    public List<News> getNews() throws EchoNestException {
        String bucket = "news";
        this.fetchBucket(bucket);
        return this.listToNews((List)this.getObject(bucket));
    }

    public PagedList<News> getNews(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/news", "news", start, count);
        return this.listToNews(plist);
    }

    private List<News> listToNews(List docs) {
        ArrayList<News> results = new ArrayList<News>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            News news = new News(map);
            results.add(news);
            ++i;
        }
        return results;
    }

    private PagedList<News> listToNews(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<News> results = new PagedList<News>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            News news = new News(map);
            results.add(news);
            ++i;
        }
        return results;
    }

    public List<Review> getReviews() throws EchoNestException {
        String bucket = "reviews";
        this.fetchBucket(bucket);
        return this.listToReviews((List)this.getObject(bucket));
    }

    public PagedList<Review> getReviews(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/reviews", "reviews", start, count);
        return this.listToReviews(plist);
    }

    private List<Review> listToReviews(List docs) {
        ArrayList<Review> results = new ArrayList<Review>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Review review = new Review(map);
            results.add(review);
            ++i;
        }
        return results;
    }

    private PagedList<Review> listToReviews(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<Review> results = new PagedList<Review>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Review review = new Review(map);
            results.add(review);
            ++i;
        }
        return results;
    }

    public List<Video> getVideos() throws EchoNestException {
        String bucket = "video";
        this.fetchBucket(bucket);
        return this.listToVideos((List)this.getObject(bucket));
    }

    public PagedList<Video> getVideos(int start, int count) throws EchoNestException {
        PagedListInfo plist = this.en.getDocuments(this.getID(), "artist/video", "video", start, count);
        return this.listToVideos(plist);
    }

    private List<Video> listToVideos(List docs) {
        ArrayList<Video> results = new ArrayList<Video>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Video video = new Video(map);
            results.add(video);
            ++i;
        }
        return results;
    }

    private PagedList<Video> listToVideos(PagedListInfo plist) {
        List docs = plist.getDocs();
        PagedList<Video> results = new PagedList<Video>(plist.getStart(), plist.getTotal());
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            Video video = new Video(map);
            results.add(video);
            ++i;
        }
        return results;
    }

    public Map<String, String> getUrls() throws EchoNestException {
        this.fetchBucket("urls");
        Map map = (Map)this.getObject("urls");
        HashMap<String, String> results = new HashMap<String, String>();
        for (Object key : map.keySet()) {
            results.put((String)key, (String)map.get(key));
        }
        return results;
    }

    public List<Artist> getSimilar(int count) throws EchoNestException {
        List<Object> similars = null;
        if (this.data.containsKey("similar") && (similars = (List)this.data.get("similar")).size() < count) {
            similars = null;
        }
        if (similars == null) {
            Params p = new Params();
            p.add("id", this.getID());
            p.add("results", count);
            similars = this.en.getSimilarArtists(p);
            this.data.put("similar", similars);
        }
        if (similars.size() > count) {
            similars = similars.subList(0, count);
        }
        return similars;
    }

    public List<Term> getTerms() throws EchoNestException {
        String bucket = "terms";
        this.fetchBucket(bucket);
        return this.listToTerms((List)this.getObject(bucket));
    }

    private List<Term> listToTerms(List docs) {
        ArrayList<Term> terms = new ArrayList<Term>();
        int i = 0;
        while (i < docs.size()) {
            Map map = (Map)docs.get(i);
            MQuery mq = new MQuery(map);
            String tname = mq.getString("name");
            double frequency = mq.getDouble("frequency");
            double weight = mq.getDouble("weight");
            Term term = new Term(tname, weight, frequency);
            terms.add(term);
            ++i;
        }
        return terms;
    }
}

