/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import com.echonest.api.v4.ENItem;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Location;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.TrackAnalysis;
import com.echonest.api.v4.util.Commander;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Song
extends ENItem {
    private static final String PATH = "songs[0]";
    private Map<String, Track> trackMap = new HashMap<String, Track>();
    private TrackAnalysis analysis = null;

    Song(EchoNestAPI en, Map map) throws EchoNestException {
        super(en, "song", PATH, map);
    }

    public Song(EchoNestAPI en, String id) throws EchoNestException {
        super(en, "song", PATH, id);
    }

    public String toString() {
        return this.data.toString();
    }

    public String getTitle() {
        return this.getString("title");
    }

    public String getArtistName() {
        return this.getString("artist_name");
    }

    public String getArtistID() {
        return this.getString("artist_id");
    }

    public Location getArtistLocation() throws EchoNestException {
        this.fetchBucket("artist_location");
        Double latitude = this.getDouble("artist_location.latitude");
        Double longitude = this.getDouble("artist_location.longitude");
        String placeName = this.getString("artist_location.location");
        return new Location(latitude, longitude, placeName);
    }

    public double getSongHotttnesss() throws EchoNestException {
        this.fetchBucket("song_hotttnesss");
        return this.getDouble("song_hotttnesss");
    }

    public double getArtistHotttnesss() throws EchoNestException {
        this.fetchBucket("artist_hotttnesss");
        return this.getDouble("artist_hotttnesss");
    }

    public double getArtistFamiliarity() throws EchoNestException {
        this.fetchBucket("artist_familiarity");
        return this.getDouble("artist_familiarity");
    }

    public double getDuration() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getDouble("audio_summary.duration");
    }

    public double getLoudness() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getDouble("audio_summary.loudness");
    }

    public double getTempo() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getDouble("audio_summary.tempo");
    }

    public String getAnalysisURL() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getString("audio_summary.analysis_url");
    }

    public TrackAnalysis getAnalysis() throws EchoNestException {
        try {
            if (this.analysis == null) {
                Map analysisMap = Commander.fetchURLAsJSON(this.getAnalysisURL());
                this.analysis = new TrackAnalysis(analysisMap);
            }
        }
        catch (IOException e) {
            throw new EchoNestException(e);
        }
        return this.analysis;
    }

    public int getTimeSignature() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getInteger("audio_summary.time_signature");
    }

    public int getMode() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getInteger("audio_summary.mode");
    }

    public int getKey() throws EchoNestException {
        this.fetchBucket("audio_summary");
        return this.getInteger("audio_summary.key");
    }

    public Track getTrackOld(String idSpace) throws EchoNestException {
        Track track = this.trackMap.get(idSpace);
        if (track == null) {
            List tlist = (List)this.getObject("tracks");
            if (tlist == null) {
                String[] buckets = new String[]{"tracks", "id:" + idSpace};
                this.fetchBuckets(buckets, true);
                tlist = (List)this.getObject("tracks");
            }
            int i = 0;
            while (tlist != null && i < tlist.size()) {
                Map tmap = (Map)tlist.get(i);
                String tidSpace = (String)tmap.get("catalog");
                if (idSpace.equals(tidSpace)) {
                    track = new Track(this.en, tmap);
                    this.trackMap.put(idSpace, track);
                }
                ++i;
            }
        }
        return track;
    }

    public Track getTrack(String idSpace) throws EchoNestException {
        Track track = this.trackMap.get(idSpace);
        if (track == null) {
            List tlist = null;
            String[] buckets = new String[]{"tracks", "id:" + idSpace};
            this.fetchBuckets(buckets, true);
            tlist = (List)this.getObject("tracks");
            if (tlist != null) {
                for (Object item : tlist) {
                    String catalog = idSpace;
                    String trid = (String)item;
                    track = this.en.newTrackByID(trid);
                    this.trackMap.put(catalog, track);
                }
            }
        }
        return track;
    }

    public Track getTrackNew(String idSpace) throws EchoNestException {
        Track track = this.trackMap.get(idSpace);
        if (track == null) {
            Map map = (Map)this.getObject("tracks");
            if (map == null) {
                String[] buckets = new String[]{"tracks", "id:" + idSpace};
                this.fetchBuckets(buckets, true);
                map = (Map)this.getObject("tracks");
            }
            if (map != null) {
                for (Object key : map.keySet()) {
                    String catalog = (String)key;
                    String trid = (String)map.get(catalog);
                    track = this.en.newTrackByID(trid);
                    this.trackMap.put(catalog, track);
                }
            }
        }
        return track;
    }

    public void showAll() throws EchoNestException {
        String[] buckets = new String[]{"audio_summary", "song_hotttnesss", "artist_hotttnesss", "artist_familiarity", "artist_location"};
        this.fetchBuckets(buckets);
        System.out.println("Title      : " + this.getTitle());
        System.out.println("ID         : " + this.getID());
        System.out.println("Artist     : " + this.getArtistName());
        System.out.println("ArtistID   : " + this.getArtistID());
        System.out.println("Location   : " + this.getArtistLocation());
        System.out.println("Familiarity: " + this.getArtistFamiliarity());
        System.out.println("Hotttnesss : " + this.getArtistHotttnesss());
        System.out.println("Duration   : " + this.getDuration());
        System.out.println("Key        : " + this.getKey());
        System.out.println("Loudness   : " + this.getLoudness());
        System.out.println("SHotttnesss: " + this.getSongHotttnesss());
        System.out.println("Tempo      : " + this.getTempo());
        System.out.println("TimeSig    : " + this.getTimeSignature());
        System.out.println();
    }
}

