/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4;

import com.echonest.api.v4.Segment;
import com.echonest.api.v4.TimedEvent;
import com.echonest.api.v4.util.MQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackAnalysis {
    private Map map;
    private MQuery mq;

    TrackAnalysis(Map map) {
        this.map = map;
        this.mq = new MQuery(map);
    }

    public Map getMap() {
        return this.map;
    }

    public String toString() {
        return this.map.toString();
    }

    public Integer getNumSamples() {
        return this.mq.getInteger("track.num_samples");
    }

    public Double getDuration() {
        return this.mq.getDouble("track.duration");
    }

    public String getMD5() {
        return this.mq.getString("track.sample_md5");
    }

    public Double getSampleRate() {
        return this.mq.getDouble("track.analysis_sample_rate");
    }

    public Integer getNumChannels() {
        return this.mq.getInteger("track.analysis_channels");
    }

    public Double getEndOfFadeIn() {
        return this.mq.getDouble("track.end_of_fade_in");
    }

    public Double getStartOfFadeOut() {
        return this.mq.getDouble("track.start_of_fade_out");
    }

    public Double getLoudness() {
        return this.mq.getDouble("track.loudness");
    }

    public Double getTempo() {
        return this.mq.getDouble("track.tempo");
    }

    public Double getTempoConfidence() {
        return this.mq.getDouble("track.tempo_confidence");
    }

    public Integer getTimeSignature() {
        return this.mq.getInteger("track.time_signature");
    }

    public Double getTimeSignatureConfidence() {
        return this.mq.getDouble("track.time_signature_confidence");
    }

    public Integer getKey() {
        return this.mq.getInteger("track.key");
    }

    public Double getKeyConfidence() {
        return this.mq.getDouble("track.key_confidence");
    }

    public Integer getMode() {
        return this.mq.getInteger("track.mode");
    }

    public Double getModeConfidence() {
        return this.mq.getDouble("track.mode_confidence");
    }

    public List<TimedEvent> getSections() {
        ArrayList<TimedEvent> results = new ArrayList<TimedEvent>();
        List event = (List)this.mq.getObject("sections");
        int i = 0;
        while (i < event.size()) {
            results.add(new TimedEvent((Map)event.get(i)));
            ++i;
        }
        return results;
    }

    public List<TimedEvent> getBars() {
        ArrayList<TimedEvent> results = new ArrayList<TimedEvent>();
        List event = (List)this.mq.getObject("bars");
        int i = 0;
        while (i < event.size()) {
            results.add(new TimedEvent((Map)event.get(i)));
            ++i;
        }
        return results;
    }

    public List<TimedEvent> getBeats() {
        ArrayList<TimedEvent> results = new ArrayList<TimedEvent>();
        List event = (List)this.mq.getObject("beats");
        int i = 0;
        while (i < event.size()) {
            results.add(new TimedEvent((Map)event.get(i)));
            ++i;
        }
        return results;
    }

    public List<TimedEvent> getTatums() {
        ArrayList<TimedEvent> results = new ArrayList<TimedEvent>();
        List event = (List)this.mq.getObject("tatums");
        int i = 0;
        while (i < event.size()) {
            results.add(new TimedEvent((Map)event.get(i)));
            ++i;
        }
        return results;
    }

    public List<Segment> getSegments() {
        ArrayList<Segment> results = new ArrayList<Segment>();
        List event = (List)this.mq.getObject("segments");
        int i = 0;
        while (i < event.size()) {
            results.add(new Segment((Map)event.get(i)));
            ++i;
        }
        return results;
    }

    public void dump() {
        System.out.println("num samples : " + this.getNumSamples());
        System.out.println("sample md5  : " + this.getMD5());
        System.out.println("num channels: " + this.getNumChannels());
        System.out.println("duration    : " + this.getDuration());
        System.out.println(" Sections ");
        List<TimedEvent> sections = this.getSections();
        for (TimedEvent e : sections) {
            System.out.println(e);
        }
        System.out.println(" Bars ");
        List<TimedEvent> bars = this.getBars();
        for (TimedEvent e : bars) {
            System.out.println(e);
        }
        System.out.println(" Beats ");
        List<TimedEvent> beats = this.getBeats();
        for (TimedEvent e : beats) {
            System.out.println(e);
        }
        System.out.println(" Tatums ");
        List<TimedEvent> tatums = this.getTatums();
        for (TimedEvent e : tatums) {
            System.out.println(e);
        }
        System.out.println(" Segments ");
        List<Segment> segments = this.getSegments();
        for (Segment e : segments) {
            System.out.println(e);
        }
    }
}

