/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.tests;

import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.examples.SearchSongsExample;
import com.echonest.api.v4.util.Commander;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class APITests
extends TestCase {
    private Commander cmd;
    private String radiohead = "ARH6W4X1187B99274F";
    private String prefix = "music://id.echonest.com/~/AR/";
    private SearchSongsExample sse;

    @Before
    public void setUp() throws EchoNestException {
        this.cmd = new Commander("test");
        this.cmd.setTraceSends(true);
        this.cmd.setTraceRecvs(true);
        this.sse = new SearchSongsExample();
        Params stdParams = new Params();
        stdParams.add("api_key", "EHY4JJEGIOFA1RCJP");
        this.cmd.setStandardParams(stdParams);
    }

    @Test
    public void similarTest() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        this.cmd.sendCommand("artist/similar", params);
    }

    @Test
    public void similarTimingTest() throws EchoNestException {
        long start = System.currentTimeMillis();
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("results", 10);
        Map results = this.cmd.sendCommand("artist/similar", params);
        Map response = (Map)results.get("response");
        List artistList = (List)response.get("artists");
        int i = 0;
        while (i < artistList.size()) {
            Map artist = (Map)artistList.get(i);
            String id = (String)artist.get("id");
            Params p = new Params();
            p.add("id", id);
            this.cmd.sendCommand("artist/similar", p);
            ++i;
        }
        long delta = System.currentTimeMillis() - start;
        System.out.println("Delta is " + delta);
        APITests.assertTrue((delta < 15000L ? 1 : 0) != 0);
    }

    @Test(expected=EchoNestException.class)
    public void badArgCheck() throws EchoNestException {
        Params params = new Params();
        params.add("crap", "crapitycrap");
        this.cmd.sendCommand("artist/similar", params);
    }

    @Test
    public void longIDCheck() throws EchoNestException {
        Params params = new Params();
        params.add("id", String.valueOf(this.prefix) + this.radiohead);
        this.cmd.sendCommand("artist/similar", params);
    }

    @Test
    public void testBadApiKey() throws EchoNestException {
        Commander lcmd = new Commander("test");
        Params stdParams = new Params();
        stdParams.add("api_key", "CRAPPYKEY");
        lcmd.setStandardParams(stdParams);
        Params params = new Params();
        params.add("id", this.radiohead);
        try {
            lcmd.sendCommand("artist/similar", params, false);
            APITests.fail();
        }
        catch (EchoNestException e) {
            APITests.assertTrue((e.getCode() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDupIDsFail() throws EchoNestException {
        Params params = new Params();
        params.add("api_key", "XZTXVRO3VC3FBXS8C");
        params.add("id", this.radiohead);
        try {
            this.cmd.sendCommand("artist/similar", params, false);
            APITests.fail();
        }
        catch (EchoNestException e) {
            APITests.assertTrue((e.getCode() == 5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDupResultsFail() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("results", 10);
        params.add("results", 20);
        try {
            this.cmd.sendCommand("artist/similar", params, false);
            APITests.fail();
        }
        catch (EchoNestException e) {
            APITests.assertTrue((e.getCode() == 5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testResultsReturned() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("results", 10);
        Map results = this.cmd.sendCommand("artist/similar", params, false);
        Map response = (Map)results.get("response");
        List artist = (List)response.get("artists");
        APITests.assertTrue((artist.size() == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testResultsReturnedLarge() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("results", 100);
        Map results = this.cmd.sendCommand("artist/similar", params, false);
        Map response = (Map)results.get("response");
        List artist = (List)response.get("artists");
        APITests.assertTrue((artist.size() == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testResultsReturnedTooLarge() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("results", 1000);
        try {
            Map results = this.cmd.sendCommand("artist/similar", params, false);
            APITests.fail();
        }
        catch (EchoNestException e) {
            APITests.assertTrue((e.getCode() == 5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBadParameter() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("bad", 1000);
        try {
            Map results = this.cmd.sendCommand("artist/similar", params, false);
            APITests.fail();
        }
        catch (EchoNestException e) {
            APITests.assertTrue((e.getCode() == 5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testResultsNegative() throws EchoNestException {
        Params params = new Params();
        params.add("id", this.radiohead);
        params.add("results", -10);
        try {
            Map results = this.cmd.sendCommand("artist/similar", params, false);
            APITests.fail();
        }
        catch (EchoNestException e) {
            APITests.assertTrue((e.getCode() == 5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSearchSongs() throws EchoNestException {
        Params params = new Params();
        params.add("artist", "various");
        params.add("results", 100);
        Map results = this.cmd.sendCommand("song/search", params);
        Map response = (Map)results.get("response");
        List songList = (List)response.get("songs");
        int i = 0;
        while (i < songList.size()) {
            Map song = (Map)songList.get(i);
            System.out.printf("%s %s\n", song.get("artist_name"), song.get("title"));
            ++i;
        }
        System.out.printf("Size %d\n", songList.size());
    }

    @Test
    public void testSearchSongsParamResultsCheck() {
        this.pcheck("results", "-10", false);
        this.pcheck("results", "100", true);
        this.pcheck("results", "200", false);
    }

    @Test
    public void testSearchSongsParamMaxTempoCheck() {
        this.pcheck("max_tempo", "-10", false);
        this.pcheck("max_tempo", "100", true);
        this.pcheck("max_tempo", "600", false);
    }

    @Test
    public void testSearchSongsParamMinTempoCheck() {
        this.pcheck("min_tempo", "-10", false);
        this.pcheck("min_tempo", "100", true);
        this.pcheck("min_tempo", "600", false);
    }

    @Test
    public void testSearchSongsParamMaxDurationCheck() {
        this.pcheck("max_duration", "-10", false);
        this.pcheck("max_duration", "100", true);
        this.pcheck("max_duration", "3700", true);
    }

    @Test
    public void testSearchSongsParamModeCheck() {
        this.pcheck("mode", "1", true);
        this.pcheck("mode", "0", true);
        this.pcheck("mode", "2", false);
    }

    @Test
    public void searchSongsByTempoTest() throws EchoNestException {
        this.sse.searchSongsByTempo("weezer", 100);
    }

    private void pcheck(String name, String value, boolean shouldPass) {
        Params params = new Params();
        params.add("artist", "various");
        params.add(name, value);
        try {
            Map results = this.cmd.sendCommand("song/search", params);
            APITests.assertTrue((String)(String.valueOf(name) + "=" + value), (boolean)shouldPass);
        }
        catch (EchoNestException e) {
            APITests.assertTrue((String)(String.valueOf(name) + "=" + value), (!shouldPass ? 1 : 0) != 0);
        }
    }
}

