/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.tests;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.Biography;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.PagedList;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Song;
import com.echonest.api.v4.SongParams;
import com.echonest.api.v4.Term;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.TrackAnalysis;
import com.echonest.api.v4.WebDocument;
import com.echonest.api.v4.tests.TestHarness;
import com.echonest.api.v4.util.Shell;
import com.echonest.api.v4.util.ShellCommand;
import com.echonest.api.v4.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchonestDevShell {
    private Shell shell;
    private EchoNestAPI en;
    private TestHarness testHarness;
    private Map<String, Artist> artistCache = new HashMap<String, Artist>();
    private int displayCount = 15;
    private Set<Artist> done = new HashSet<Artist>();
    private List<Artist> todo = new ArrayList<Artist>();
    private Track currentTrack;

    public EchonestDevShell() throws EchoNestException {
        this.en = new EchoNestAPI();
        this.shell = new Shell();
        this.shell.setPrompt("nest% ");
        this.addEchoNestCommands();
    }

    public void go() {
        System.out.println("Welcome to The Echo Nest API Shell");
        System.out.println("   type 'help' ");
        this.shell.run();
    }

    public Shell getShell() {
        return this.shell;
    }

    private void addEchoNestCommands() {
        this.shell.add("enid", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    System.out.println(String.valueOf(artist.getName()) + " " + artist.getID());
                }
                return "";
            }

            public String getHelp() {
                return "gets the ENID for an arist";
            }
        });
        this.shell.add("search_artist", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                List<Artist> artists = EchonestDevShell.this.en.searchArtists(Shell.mash(args, 1));
                for (Artist artist : artists) {
                    System.out.println(String.valueOf(artist.getID()) + " " + artist.getName());
                }
                return "";
            }

            public String getHelp() {
                return "searches for artists exact match  ";
            }
        });
        this.shell.add("top_hottt", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                p.add("results", 100);
                List<Artist> artists = EchonestDevShell.this.en.topHotArtists(p);
                for (Artist artist : artists) {
                    System.out.println(String.valueOf(artist.getID()) + " " + artist.getName());
                }
                return "";
            }

            public String getHelp() {
                return "searches for artists exact match  ";
            }
        });
        this.shell.add("top_terms", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                int count = 100;
                if (args.length > 1) {
                    count = Integer.parseInt(args[1]);
                }
                List<Term> terms = EchonestDevShell.this.en.getTopTerms(count);
                for (Term term : terms) {
                    System.out.println(String.valueOf(term.getFrequency()) + " " + term.getName());
                }
                return "";
            }

            public String getHelp() {
                return "searches for artists exact match  ";
            }
        });
        this.shell.add("psearch_songs", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                EchonestDevShell.this.populateParams(p, args);
                List<Song> songs = EchonestDevShell.this.en.searchSongs(p);
                for (Song song : songs) {
                    System.out.println(song.toString());
                }
                return "";
            }

            public String getHelp() {
                return "searches for songs ";
            }
        });
        this.shell.add("track", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                if (args.length == 1 && EchonestDevShell.this.currentTrack != null) {
                    EchonestDevShell.this.dumpTrack(EchonestDevShell.this.currentTrack, false);
                } else {
                    int i = 1;
                    while (i < args.length) {
                        String id = args[i];
                        Track track = null;
                        track = id.startsWith("TR") ? EchonestDevShell.this.en.newTrackByID(id) : EchonestDevShell.this.en.newTrackByMD5(id);
                        EchonestDevShell.this.dumpTrack(track, false);
                        ++i;
                    }
                }
                return "";
            }

            public String getHelp() {
                return "dumps tracks by ID or MD5";
            }
        });
        this.shell.add("trackDetails", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                if (args.length == 1 && EchonestDevShell.this.currentTrack != null) {
                    EchonestDevShell.this.dumpTrack(EchonestDevShell.this.currentTrack, true);
                } else {
                    int i = 1;
                    while (i < args.length) {
                        String id = args[i];
                        Track track = null;
                        track = id.startsWith("TR") ? EchonestDevShell.this.en.newTrackByID(id) : EchonestDevShell.this.en.newTrackByMD5(id);
                        EchonestDevShell.this.dumpTrack(track, true);
                        ++i;
                    }
                }
                return "";
            }

            public String getHelp() {
                return "dumps tracks by ID or MD5";
            }
        });
        this.shell.add("psearch_artists", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                EchonestDevShell.this.populateParams(p, args);
                List<Artist> artists = EchonestDevShell.this.en.searchArtists(p);
                for (Artist artist : artists) {
                    System.out.println(artist.toString());
                }
                return "";
            }

            public String getHelp() {
                return "searches for artists (using params) ";
            }
        });
        this.shell.add("psimilar_songs", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                EchonestDevShell.this.populateParams(p, args);
                List<Song> songs = EchonestDevShell.this.en.similarSongs(p);
                for (Song song : songs) {
                    System.out.println(song.toString());
                }
                return "";
            }

            public String getHelp() {
                return "finds similar songs to the seed song ";
            }
        });
        this.shell.add("psimilar_artists", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                int i = 1;
                while (i < args.length) {
                    String arg = args[i];
                    String[] pv = arg.split("=");
                    if (pv.length == 2) {
                        p.add(pv[0], pv[1]);
                    } else {
                        System.out.println("Don't understand " + arg);
                    }
                    ++i;
                }
                List<Artist> artists = EchonestDevShell.this.en.getSimilarArtists(p);
                for (Artist artist : artists) {
                    System.out.println(artist.toString());
                }
                return "";
            }

            public String getHelp() {
                return "searches for artists (using params) ";
            }
        });
        this.shell.add("get_songs", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Params p = new Params();
                int i = 1;
                while (i < args.length) {
                    String arg = args[i];
                    String[] pv = arg.split("=");
                    if (pv.length == 2) {
                        p.add(pv[0], pv[1]);
                    } else {
                        System.out.println("Don't understand " + arg);
                    }
                    ++i;
                }
                List<Song> songs = EchonestDevShell.this.en.getSongs(p);
                for (Song song : songs) {
                    System.out.println(song.toString());
                }
                return "";
            }

            public String getHelp() {
                return "gets info for a song ";
            }
        });
        this.shell.add("hot_songs", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                boolean old_way = true;
                SongParams p = new SongParams();
                p.sortBy(SongParams.SORT_SONG_HOTTTNESSS, false);
                String description = Shell.mash(args, 1);
                if (old_way) {
                    p.addDescription(description);
                } else if (description.length() > 0) {
                    String[] fields;
                    String[] stringArray = fields = description.split(",");
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String f = stringArray[n2];
                        p.addDescription(f.trim());
                        ++n2;
                    }
                }
                List<Song> songs = EchonestDevShell.this.en.searchSongs(p);
                for (Song song : songs) {
                    System.out.println(song.toString());
                }
                return "";
            }

            public String getHelp() {
                return "show hot songs";
            }
        });
        this.shell.add("display_count", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                if (args.length == 2) {
                    EchonestDevShell.this.displayCount = Integer.parseInt(args[1]);
                } else {
                    System.out.println("Display count: " + EchonestDevShell.this.displayCount);
                }
                return "";
            }

            public String getHelp() {
                return "sets/gets the number of items to display";
            }
        });
        this.shell.add("get_similar", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    System.out.println("Similarity for " + artist.getName());
                    List<Artist> artists = artist.getSimilar(EchonestDevShell.this.displayCount);
                    for (Artist sartist : artists) {
                        System.out.printf("  %s\n", sartist.getName());
                    }
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "finds similar artists";
            }
        });
        this.shell.add("get_blogs", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("blogs", artist.getBlogs());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets blogs for an artist";
            }
        });
        this.shell.add("get_images", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("images", artist.getImages());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets images for an artist";
            }
        });
        this.shell.add("get_audio", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("audio", artist.getAudio());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets audio for an artist";
            }
        });
        this.shell.add("get_bio", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("audio", artist.getBiographies());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets bios for an artist";
            }
        });
        this.shell.add("get_urls", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    System.out.println("URLS for " + artist.getName());
                    Map<String, String> urlMap = artist.getUrls();
                    ArrayList<String> keys = new ArrayList<String>(urlMap.keySet());
                    Collections.sort(keys);
                    for (String key : keys) {
                        System.out.printf("%20s : %s\n", key, urlMap.get(key));
                    }
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets urls for an artist";
            }
        });
        this.shell.add("get_video", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("video", artist.getVideos());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets videos for an artist";
            }
        });
        this.shell.add("get_news", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("news", artist.getNews());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets news for an artist";
            }
        });
        this.shell.add("get_reviews", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    EchonestDevShell.this.dumpDocs("reviews", artist.getReviews());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets reviews for an artist";
            }
        });
        this.shell.add("get_terms", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    System.out.println("Terms for " + artist.getName());
                    List<Term> terms = artist.getTerms();
                    for (Term term : terms) {
                        System.out.printf("%.2f %s\n", term.getWeight(), term.getName());
                    }
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets terms for an artist";
            }
        });
        this.shell.add("get_fam", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    System.out.println("Familiarity for " + artist.getName() + " " + artist.getFamiliarity());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets familiarity for an artist";
            }
        });
        this.shell.add("get_hot", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                Artist artist = EchonestDevShell.this.getArtist(Shell.mash(args, 1));
                if (artist != null) {
                    System.out.println("Hotttnesss for " + artist.getName() + " " + artist.getHotttnesss());
                } else {
                    System.out.println("Can't find artist");
                }
                return "";
            }

            public String getHelp() {
                return "gets hotttnesss for an artist";
            }
        });
        this.shell.add("trackUpload", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                String url;
                String arg = url = "http://echonest-lap.s3.amazonaws.com/N/Nickelback/All The Right Reasons/11 Rockstar.mp3";
                if (args.length >= 2) {
                    arg = Shell.mash(args, 1);
                }
                try {
                    Track track;
                    if (arg.startsWith("http:")) {
                        track = EchonestDevShell.this.en.uploadTrack(new URL(arg), true);
                    } else {
                        System.out.println("md5 is " + Utilities.md5(arg));
                        track = EchonestDevShell.this.en.uploadTrack(new File(arg), true);
                    }
                    track.waitForAnalysis(30000L);
                    System.out.println("ID: " + track.getID() + " status " + (Object)((Object)track.getStatus()));
                    EchonestDevShell.this.currentTrack = track;
                }
                catch (IOException e) {
                    System.out.println("Trouble uploading");
                }
                return "";
            }

            public String getHelp() {
                return "uploads a track";
            }
        });
        this.shell.add("stats", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                EchonestDevShell.this.en.showStats();
                return "";
            }

            public String getHelp() {
                return "shows stats";
            }
        });
        this.shell.add("", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                int count = 100;
                String[] buckets = new String[]{"audio", "biographies", "blogs", "familiarity", "hotttnesss", "images", "news", "reviews", "urls", "video"};
                if (args.length >= 2) {
                    count = Integer.parseInt(args[1]);
                }
                if (EchonestDevShell.this.todo.size() == 0) {
                    Artist seed = EchonestDevShell.this.getArtist("The Beatles");
                    EchonestDevShell.this.todo.add(seed);
                }
                int i = 0;
                while (i < count) {
                    Artist next = null;
                    while (EchonestDevShell.this.todo.size() > 0 && next == null) {
                        next = (Artist)EchonestDevShell.this.todo.remove(0);
                        if (!EchonestDevShell.this.done.contains(next)) break;
                    }
                    if (next != null) {
                        EchonestDevShell.this.done.add(next);
                        next.fetchBuckets(buckets);
                        float score = EchonestDevShell.this.scoreArtist(next);
                        if (i % 20 == 0) {
                            System.out.printf("%5s %3s %3s %3s %3s %3s %3s %3s %3s %5s %5s %s\n", "score", "aud", "bio", "blg", "img", "nws", "rvs", "vid", "url", "hot", "fam", "");
                        }
                        System.out.printf("%5.1f %3d %3d %3d %3d %3d %3d %3d %3d %.3f %.3f %s\n", Float.valueOf(score), next.getAudio().size(), next.getBiographies().size(), next.getBlogs().size(), next.getImages().size(), next.getNews().size(), next.getReviews().size(), next.getVideos().size(), next.getUrls().size(), next.getHotttnesss(), next.getFamiliarity(), next.getName());
                        EchonestDevShell.this.todo.addAll(next.getSimilar(20));
                        Collections.shuffle(EchonestDevShell.this.todo);
                    }
                    ++i;
                }
                return "";
            }

            public String getHelp() {
                return "shows artist coverage";
            }
        });
        this.shell.add("mbidtest", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                int count = 100;
                if (args.length >= 2) {
                    count = Integer.parseInt(args[1]);
                }
                for (Artist artist : EchonestDevShell.this.en.topHotArtists(count)) {
                    String mbid = artist.getForeignID("musicbrainz");
                    if (mbid != null && mbid.length() > 0) {
                        Artist nArtist = EchonestDevShell.this.en.newArtistByID(mbid);
                        String status = "FAIL";
                        if (artist.equals(nArtist)) {
                            status = "GOOD";
                        }
                        System.out.printf("   %s %s %s %s %s\n", status, mbid, artist.getName(), nArtist.getForeignID("musicbrainz"), nArtist.getName());
                        continue;
                    }
                    System.out.printf("MISSING mbid for %s\n", artist.getName());
                }
                return "";
            }

            public String getHelp() {
                return "test mbids for popular artists";
            }
        });
        this.shell.add("scov", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                int count = 100;
                boolean showSims = false;
                if (args.length >= 2) {
                    count = Integer.parseInt(args[1]);
                }
                if (args.length >= 3) {
                    showSims = true;
                }
                if (EchonestDevShell.this.todo.size() == 0) {
                    Artist seed = EchonestDevShell.this.getArtist("The Beatles");
                    EchonestDevShell.this.todo.add(seed);
                }
                int i = 0;
                while (i < count) {
                    Artist next = null;
                    while (EchonestDevShell.this.todo.size() > 0 && next == null) {
                        next = (Artist)EchonestDevShell.this.todo.remove(0);
                        if (!EchonestDevShell.this.done.contains(next)) break;
                    }
                    if (next != null) {
                        EchonestDevShell.this.done.add(next);
                        System.out.printf("%s %s\n", next.getID(), next.getName());
                        List<Artist> sims = next.getSimilar(15);
                        if (showSims) {
                            for (Artist sim : sims) {
                                System.out.printf("    %s\n", sim.getName());
                            }
                        }
                        EchonestDevShell.this.todo.addAll(sims);
                        Collections.shuffle(EchonestDevShell.this.todo);
                    }
                    ++i;
                }
                return "";
            }

            public String getHelp() {
                return "shows artist similarity coverage";
            }
        });
        this.shell.add("wiki_bio_cov", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                List<Artist> artists = EchonestDevShell.this.en.topHotArtists(1000);
                int count = 0;
                int which = 0;
                for (Artist artist : artists) {
                    ++which;
                    PagedList<Biography> bios = artist.getBiographies(0, 100, "cc-by-sa");
                    if (bios.size() != 0) continue;
                    System.out.printf("%d %d %s\n", which, ++count, artist.getName());
                }
                System.out.println("Missing coverage count " + count);
                return "";
            }

            public String getHelp() {
                return "shows artist wiki bio coverage";
            }
        });
        this.shell.add("trace", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                if (args.length == 2) {
                    EchonestDevShell.this.en.setTraceSends(args[1].equals("true"));
                    EchonestDevShell.this.en.setTraceRecvs(args[1].equals("true"));
                } else {
                    System.out.println("Usage: trace true|false");
                }
                return "";
            }

            public String getHelp() {
                return "enables/disables trace";
            }
        });
        this.shell.add("traceSends", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                if (args.length == 2) {
                    EchonestDevShell.this.en.setTraceSends(args[1].equals("true"));
                } else {
                    System.out.println("Usage: traceSends true|false");
                }
                return "";
            }

            public String getHelp() {
                return "enables/disables trace sends";
            }
        });
        this.shell.add("traceRecvs", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                if (args.length == 2) {
                    EchonestDevShell.this.en.setTraceRecvs(args[1].equals("true"));
                } else {
                    System.out.println("Usage: traceRecvs true|false");
                }
                return "";
            }

            public String getHelp() {
                return "enables/disables trace recvs";
            }
        });
        this.shell.add("runTests", new ShellCommand(){

            public String execute(Shell ci, String[] args) throws Exception {
                String tests = "basic";
                int count = 100;
                if (args.length >= 2) {
                    count = Integer.parseInt(args[1]);
                }
                if (args.length >= 3) {
                    tests = args[2];
                }
                if (EchonestDevShell.this.testHarness == null) {
                    EchonestDevShell.this.testHarness = new TestHarness(EchonestDevShell.this.en);
                }
                EchonestDevShell.this.testHarness.runTests(tests, count);
                return "";
            }

            public String getHelp() {
                return "Usage: runTests  [count] [testset]";
            }
        });
    }

    private Artist getArtist(String name) throws EchoNestException {
        List<Artist> artists;
        Artist artist = null;
        artist = this.artistCache.get(name);
        if (artist == null && (artists = this.en.searchArtists(name)).size() > 0) {
            artist = artists.get(0);
            this.artistCache.put(name, artist);
        }
        return artist;
    }

    private void dumpDocs(String title, List<? extends WebDocument> list) {
        System.out.println(title);
        for (WebDocument webDocument : list) {
            webDocument.dump();
        }
        System.out.println("Total: " + list.size());
        System.out.println();
    }

    private void dumpTrack(Track track, boolean full) throws EchoNestException {
        if (track != null) {
            System.out.println(" ---- track ----");
            System.out.println("id      : " + track.getID());
            System.out.println("status  : " + (Object)((Object)track.getStatus()));
            System.out.println("analysis: " + track.getAnalysisURL());
            TrackAnalysis analysis = track.getAnalysis();
            if (full && analysis != null) {
                analysis.dump();
            }
        }
    }

    private float scoreArtist(Artist artist) throws EchoNestException {
        int sum = artist.getAudio().size() + artist.getBiographies().size() + artist.getBlogs().size() + artist.getNews().size() + artist.getReviews().size() + artist.getImages().size() + artist.getVideos().size() + artist.getUrls().size();
        return (float)sum * 100.0f / 120.0f;
    }

    private void populateParams(Params p, String[] args) {
        int i = 1;
        while (i < args.length) {
            String arg = args[i];
            String[] pv = arg.split("=");
            if (pv.length == 2) {
                String value = pv[1].replace('+', ' ');
                p.add(pv[0], value);
            } else {
                System.out.println("Don't understand " + arg);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            EchonestDevShell shell = new EchonestDevShell();
            shell.go();
        }
        catch (EchoNestException e) {
            System.err.println("Can't connect to the echonest");
        }
    }
}

