/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.api.v4.tests;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.EchoNestException;
import com.echonest.api.v4.Song;
import com.echonest.api.v4.SongParams;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.TrackAnalysis;
import com.echonest.api.v4.tests.Test;
import com.echonest.api.v4.tests.TestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TestHarness {
    private EchoNestAPI echoNest;
    private Map<String, List<Test>> testSets = new HashMap<String, List<Test>>();
    private boolean autoAdvance = true;
    private Artist curArtist = null;
    private HashSet<Artist> visited = new HashSet();
    private List<Artist> artistQueue = new ArrayList<Artist>();
    private boolean runSecondary = true;

    TestHarness(EchoNestAPI en) throws EchoNestException {
        this.echoNest = en;
        this.addBasicTests();
        this.addDetailedTests();
        this.seedQueue();
        this.advanceArtist();
    }

    private void addBasicTests() {
        String testSet = "basic";
        this.add(testSet, new Test(){

            public String getName() {
                return "audio";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getAudio();
                return true;
            }
        });
        if (this.runSecondary) {
            this.add(testSet, new Test(){

                public String getName() {
                    return "audio2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getAudio(2, 10);
                    return true;
                }
            });
            this.add(testSet, new Test(){

                public String getName() {
                    return "blogs2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getBlogs(2, 10);
                    return true;
                }
            });
            this.add(testSet, new Test(){

                public String getName() {
                    return "news2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getNews(2, 10);
                    return true;
                }
            });
            this.add(testSet, new Test(){

                public String getName() {
                    return "reviews2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getReviews(2, 10);
                    return true;
                }
            });
            this.add(testSet, new Test(){

                public String getName() {
                    return "bios2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getBiographies(2, 10);
                    return true;
                }
            });
            this.add(testSet, new Test(){

                public String getName() {
                    return "images2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getImages(2, 10);
                    return true;
                }
            });
            this.add(testSet, new Test(){

                public String getName() {
                    return "videos2";
                }

                public boolean go() throws Exception {
                    TestHarness.this.curArtist.getVideos(2, 10);
                    return true;
                }
            });
        }
        this.add(testSet, new Test(){

            public String getName() {
                return "blogs";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getBlogs();
                return true;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "familiarity";
            }

            public boolean go() throws Exception {
                return TestHarness.this.curArtist.getFamiliarity() >= 0.0 && TestHarness.this.curArtist.getFamiliarity() <= 1.0;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "hotttnesss";
            }

            public boolean go() throws Exception {
                return TestHarness.this.curArtist.getHotttnesss() >= 0.0 && TestHarness.this.curArtist.getHotttnesss() <= 1.0;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "search";
            }

            public boolean go() throws Exception {
                List<Artist> artists = TestHarness.this.echoNest.searchArtists(TestHarness.this.getArtistName());
                for (Artist artist : artists) {
                    if (!artist.equals(TestHarness.this.curArtist)) continue;
                    return true;
                }
                return false;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "news";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getNews();
                return true;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "reviews";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getReviews();
                return true;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "images";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getImages();
                return true;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "bios";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getBiographies();
                return true;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "musicbrainz id";
            }

            public boolean go() throws Exception {
                String mbid = TestHarness.this.curArtist.getForeignID("musicbrainz");
                Artist mbartist = TestHarness.this.echoNest.newArtistByID(mbid);
                return mbartist.equals(TestHarness.this.curArtist);
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "similar";
            }

            public boolean go() throws Exception {
                List<Artist> sims = TestHarness.this.curArtist.getSimilar(15);
                return sims.size() == 15;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "urls";
            }

            public boolean go() throws Exception {
                Map<String, String> urlMap = TestHarness.this.curArtist.getUrls();
                return urlMap.get("itunes_url") != null && urlMap.get("amazon_url") != null;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "videos";
            }

            public boolean go() throws Exception {
                TestHarness.this.curArtist.getVideos();
                return true;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "top_hottt_artists";
            }

            public boolean go() throws Exception {
                return TestHarness.this.echoNest.topHotArtists(100).size() == 100;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "search_songs";
            }

            public boolean go() throws Exception {
                SongParams p = new SongParams();
                p.setArtist("weezer");
                p.setMinTempo(100.0f);
                p.addIDSpace("paulify");
                return TestHarness.this.echoNest.searchSongs(p).size() > 1;
            }
        });
        this.add(testSet, new Test(){

            public String getName() {
                return "get_track_analysis";
            }

            public boolean go() throws Exception {
                SongParams p = new SongParams();
                p.setArtistID(TestHarness.this.curArtist.getID());
                p.setResults(1);
                p.addIDSpace("paulify");
                p.includeTracks();
                p.setLimit(true);
                List<Song> songs = TestHarness.this.echoNest.searchSongs(p);
                if (songs.size() > 0) {
                    Song song = songs.get(0);
                    Track track = song.getTrack("paulify");
                    TrackAnalysis analysis = track.getAnalysis();
                    return analysis.getDuration() > 0.0;
                }
                System.out.println(" no songs for " + TestHarness.this.curArtist.getName());
                return true;
            }
        });
    }

    void addDetailedTests() {
        String testSet = "details";
        this.add(testSet, new Test(){

            public String getName() {
                return "get_audio (all)";
            }

            public boolean go() throws Exception {
                return true;
            }
        });
    }

    public void runTests(String testName, int count) {
        int pass = 0;
        int fail = 0;
        List<Test> tests = this.testSets.get(testName);
        if (tests != null) {
            int i = 0;
            while (i < count) {
                for (Test test : tests) {
                    try {
                        System.out.print("    " + test.getName() + ": ");
                        if (test.go()) {
                            ++pass;
                            System.out.println("OK");
                            continue;
                        }
                        ++fail;
                        System.out.println("FAIL");
                    }
                    catch (Exception e) {
                        System.out.println("ERROR");
                    }
                }
                if (this.autoAdvance) {
                    this.advanceArtist();
                }
                if (i % 10 == 1) {
                    this.showStats();
                    System.out.printf("Test status:  Passed: %d,  Failed: %d\n", pass, fail);
                }
                ++i;
            }
        }
    }

    public void showStats() {
        this.echoNest.showStats();
    }

    private void add(String testSetName, Test test) {
        List<Test> testSet = this.testSets.get(testSetName);
        if (testSet == null) {
            testSet = new ArrayList<Test>();
            this.testSets.put(testSetName, testSet);
        }
        testSet.add(test);
    }

    private String getArtistName() throws EchoNestException {
        return this.curArtist.getName();
    }

    void seedQueue() throws EchoNestException {
        String[] seeds;
        String[] stringArray = seeds = new String[]{"Lady Gaga", "The Beatles", "Miles Davis", "Michael Jackson", "Led Zeppelin"};
        int n = seeds.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            List<Artist> artists = this.echoNest.searchArtists(name);
            this.artistQueue.addAll(artists);
            ++n2;
        }
        Collections.shuffle(this.artistQueue);
    }

    void advanceArtist() {
        try {
            do {
                this.curArtist = this.artistQueue.remove(0);
                this.log("Current artist is: " + this.curArtist.getName());
            } while (this.visited.contains(this.curArtist));
            this.visited.add(this.curArtist);
            List<Artist> similarArtists = this.curArtist.getSimilar(15);
            for (Artist sartist : similarArtists) {
                if (this.visited.contains(sartist)) continue;
                this.artistQueue.add(sartist);
            }
        }
        catch (EchoNestException e) {
            this.log("Advance Artist Error " + e.getMessage());
        }
    }

    void assertTrue(boolean condition, String message) throws TestException {
        if (!condition) {
            throw new TestException(message);
        }
    }

    void fail(String message) throws TestException {
        throw new TestException(message);
    }

    void log(String message) {
        System.out.println(message);
    }
}

