/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Event;
import net.roarsoftware.lastfm.Image;
import net.roarsoftware.lastfm.MusicEntry;
import net.roarsoftware.lastfm.PaginatedResult;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.lastfm.User;
import net.roarsoftware.util.StringUtilities;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artist
extends MusicEntry {
    private Collection<Artist> similar = new ArrayList<Artist>();
    private float similarityMatch;

    protected Artist(String name, String url) {
        super(name, url);
    }

    protected Artist(String name, String url, String mbid, int playcount, int listeners, boolean streamable) {
        super(name, url, mbid, playcount, listeners, streamable);
    }

    public float getSimilarityMatch() {
        return this.similarityMatch;
    }

    public Collection<Artist> getSimilar() {
        return this.similar;
    }

    public static Artist getInfo(String artistOrMbid, String apiKey) {
        return Artist.getInfo(artistOrMbid, Locale.getDefault(), apiKey);
    }

    public static Artist getInfo(String artistOrMbid, Locale locale, String apiKey) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(artistOrMbid)) {
            params.put("mbid", artistOrMbid);
        } else {
            params.put("artist", artistOrMbid);
        }
        if (locale != null && locale.getLanguage().length() != 0) {
            params.put("lang", locale.getLanguage());
        }
        if (!(result = Caller.getInstance().call("artist.getInfo", apiKey, params)).isSuccessful()) {
            return null;
        }
        DomElement artistElement = result.getContentElement();
        return Artist.artistFromElement(artistElement);
    }

    public static Collection<Artist> getSimilar(String artist, String apiKey) {
        return Artist.getSimilar(artist, 100, apiKey);
    }

    public static Collection<Artist> getSimilar(String artist, int limit, String apiKey) {
        Result result = Caller.getInstance().call("artist.getSimilar", apiKey, "artist", artist, "limit", String.valueOf(limit));
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Artist> artists = new ArrayList<Artist>();
        for (DomElement e : element.getChildren("artist")) {
            artists.add(Artist.artistFromElement(e));
        }
        return artists;
    }

    public static Collection<Artist> search(String name, String apiKey) {
        Result result = Caller.getInstance().call("artist.search", apiKey, "artist", name);
        Collection<DomElement> children = result.getContentElement().getChild("artistmatches").getChildren("artist");
        ArrayList<Artist> list = new ArrayList<Artist>(children.size());
        for (DomElement c : children) {
            list.add(Artist.artistFromElement(c));
        }
        return list;
    }

    public static Collection<Album> getTopAlbums(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopAlbums", apiKey, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        String artistName = element.getAttribute("artist");
        ArrayList<Album> albums = new ArrayList<Album>();
        for (DomElement e : element.getChildren("album")) {
            albums.add(Album.albumFromElement(e, artistName));
        }
        return albums;
    }

    public static Collection<User> getTopFans(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopFans", apiKey, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<User> users = new ArrayList<User>();
        for (DomElement domElement : element.getChildren("user")) {
            users.add(User.userFromElement(domElement));
        }
        return users;
    }

    public static Collection<String> getTopTags(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopTags", apiKey, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Collection<Track> getTopTracks(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getTopTracks", apiKey, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        String artistName = element.getAttribute("artist");
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement e : element.getChildren("track")) {
            tracks.add(Track.trackFromElement(e, artistName));
        }
        return tracks;
    }

    public static Result addTags(String artist, String tags, Session session) {
        return Caller.getInstance().call("artist.addTags", session, "artist", artist, "tags", tags);
    }

    public static Result removeTag(String artist, String tag, Session session) {
        return Caller.getInstance().call("artist.removeTag", session, "artist", artist, "tag", tag);
    }

    public static Result share(String artist, String recipients, String message, Session session) {
        return Caller.getInstance().call("artist.share", session, "artist", artist, "recipient", recipients, "message", message);
    }

    public static Collection<String> getTags(String artist, Session session) {
        Result result = Caller.getInstance().call("artist.getTags", session, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Collection<Event> getEvents(String artist, String apiKey) {
        Result result = Caller.getInstance().call("artist.getEvents", apiKey, "artist", artist);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Event> events = new ArrayList<Event>();
        for (DomElement domElement : element.getChildren("event")) {
            events.add(Event.eventFromElement(domElement));
        }
        return events;
    }

    public static PaginatedResult<Image> getImages(String artist, String apiKey) {
        return Artist.getImages(artist, 1, 50, apiKey);
    }

    public static PaginatedResult<Image> getImages(String artist, int page, int limit, String apiKey) {
        Result result = Caller.getInstance().call("artist.getImages", apiKey, "artist", artist, "page", String.valueOf(page), "limit", String.valueOf(limit));
        DomElement root = result.getContentElement();
        ArrayList<Image> images = new ArrayList<Image>(limit);
        for (DomElement element : root.getChildren("image")) {
            images.add(Image.imageFromElement(element));
        }
        return new PaginatedResult<Image>(Integer.parseInt(root.getAttribute("page")), Integer.parseInt(root.getAttribute("totalpages")), images);
    }

    public static Result shout(String artist, String message, Session session) {
        return Caller.getInstance().call("artist.shout", session, "artist", artist, "message", message);
    }

    static Artist artistFromElement(DomElement element) {
        DomElement similar;
        Artist artist = new Artist(null, null);
        MusicEntry.loadStandardInfo(artist, element);
        if (element.hasChild("match")) {
            artist.similarityMatch = Float.parseFloat(element.getChildText("match"));
        }
        if ((similar = element.getChild("similar")) != null) {
            Collection<DomElement> children = similar.getChildren("artist");
            for (DomElement child : children) {
                artist.similar.add(Artist.artistFromElement(child));
            }
        }
        return artist;
    }
}

