/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.PaginatedResult;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    private Library() {
    }

    public static PaginatedResult<Artist> getArtists(String user, String apiKey) {
        return Library.getArtists(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Artist> getArtists(String user, int page, String apiKey) {
        return Library.getArtists(user, page, 0, apiKey);
    }

    public static PaginatedResult<Artist> getArtists(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        Result result = Caller.getInstance().call("library.getArtists", apiKey, params);
        if (!result.isSuccessful()) {
            return new PaginatedResult<Artist>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Artist> artists = new ArrayList<Artist>();
        for (DomElement domElement : element.getChildren("artist")) {
            artists.add(Artist.artistFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalPages"));
        return new PaginatedResult<Artist>(currentPage, totalPages, artists);
    }

    public static Collection<Artist> getAllArtists(String user, String apiKey) {
        int total;
        ArrayList<Artist> artists = null;
        int page = 1;
        do {
            PaginatedResult<Artist> result = Library.getArtists(user, page, apiKey);
            total = result.getTotalPages();
            Collection<Artist> pageResults = result.getPageResults();
            if (artists == null) {
                artists = new ArrayList<Artist>(total * pageResults.size());
            }
            for (Artist artist : pageResults) {
                artists.add(artist);
            }
        } while (++page <= total);
        return artists;
    }

    public static PaginatedResult<Album> getAlbums(String user, String apiKey) {
        return Library.getAlbums(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Album> getAlbums(String user, int page, String apiKey) {
        return Library.getAlbums(user, page, 0, apiKey);
    }

    public static PaginatedResult<Album> getAlbums(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        Result result = Caller.getInstance().call("library.getAlbums", apiKey, params);
        if (!result.isSuccessful()) {
            return new PaginatedResult<Album>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Album> artists = new ArrayList<Album>();
        for (DomElement domElement : element.getChildren("album")) {
            artists.add(Album.albumFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalPages"));
        return new PaginatedResult<Album>(currentPage, totalPages, artists);
    }

    public static Collection<Album> getAllAlbums(String user, String apiKey) {
        int total;
        ArrayList<Album> albums = null;
        int page = 1;
        do {
            PaginatedResult<Album> result = Library.getAlbums(user, page, apiKey);
            total = result.getTotalPages();
            Collection<Album> pageResults = result.getPageResults();
            if (albums == null) {
                albums = new ArrayList<Album>(total * pageResults.size());
            }
            for (Album album : pageResults) {
                albums.add(album);
            }
        } while (++page <= total);
        return albums;
    }

    public static PaginatedResult<Track> getTracks(String user, String apiKey) {
        return Library.getTracks(user, 1, 0, apiKey);
    }

    public static PaginatedResult<Track> getTracks(String user, int page, String apiKey) {
        return Library.getTracks(user, page, 0, apiKey);
    }

    public static PaginatedResult<Track> getTracks(String user, int page, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        Result result = Caller.getInstance().call("library.getTracks", apiKey, params);
        if (!result.isSuccessful()) {
            return new PaginatedResult<Track>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement domElement : element.getChildren("track")) {
            tracks.add(Track.trackFromElement(domElement));
        }
        int currentPage = Integer.valueOf(element.getAttribute("page"));
        int totalPages = Integer.valueOf(element.getAttribute("totalPages"));
        return new PaginatedResult<Track>(currentPage, totalPages, tracks);
    }

    public static Collection<Track> getAllTracks(String user, String apiKey) {
        int total;
        ArrayList<Track> tracks = null;
        int page = 1;
        do {
            PaginatedResult<Track> result = Library.getTracks(user, page, apiKey);
            total = result.getTotalPages();
            Collection<Track> pageResults = result.getPageResults();
            if (tracks == null) {
                tracks = new ArrayList<Track>(total * pageResults.size());
            }
            for (Track track : pageResults) {
                tracks.add(track);
            }
        } while (++page <= total);
        return tracks;
    }

    public static Result addArtist(String artist, Session session) {
        return Caller.getInstance().call("library.addArtist", session, "artist", artist);
    }

    public static Result addAlbum(String artist, String album, Session session) {
        return Caller.getInstance().call("library.addAlbum", session, "artist", artist, "album", album);
    }

    public static Result addTrack(String artist, String track, Session session) {
        return Caller.getInstance().call("library.addTrack", session, "artist", artist, "track", track);
    }
}

