/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.ImageHolder;
import net.roarsoftware.lastfm.MusicEntry;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Session;
import net.roarsoftware.lastfm.Tag;
import net.roarsoftware.lastfm.User;
import net.roarsoftware.util.StringUtilities;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track
extends MusicEntry {
    public static final String ARTIST_PAGE = "artistpage";
    public static final String ALBUM_PAGE = "albumpage";
    public static final String TRACK_PAGE = "trackpage";
    protected String artist;
    protected String artistMbid;
    protected String album;
    protected String albumMbid;
    protected int position = -1;
    protected boolean fullTrackAvailable;
    protected boolean nowPlaying;
    protected Date playedWhen;
    protected int duration;
    protected String location;
    protected Map<String, String> lastFmExtensionInfos = new HashMap<String, String>();

    protected Track(String name, String url, String artist) {
        super(name, url);
        this.artist = artist;
    }

    protected Track(String name, String url, String mbid, int playcount, int listeners, boolean streamable, String artist, String artistMbid, boolean fullTrackAvailable, boolean nowPlaying) {
        super(name, url, mbid, playcount, listeners, streamable);
        this.artist = artist;
        this.artistMbid = artistMbid;
        this.fullTrackAvailable = fullTrackAvailable;
        this.nowPlaying = nowPlaying;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getArtistMbid() {
        return this.artistMbid;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumMbid() {
        return this.albumMbid;
    }

    public boolean isFullTrackAvailable() {
        return this.fullTrackAvailable;
    }

    public boolean isNowPlaying() {
        return this.nowPlaying;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLastFmInfo(String key) {
        return this.lastFmExtensionInfos.get(key);
    }

    public Date getPlayedWhen() {
        return this.playedWhen;
    }

    public int getPosition() {
        return this.position;
    }

    public static Collection<Track> search(String track, String apiKey) {
        return Track.search(null, track, 30, apiKey);
    }

    public static Collection<Track> search(String artist, String track, int limit, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("track", track);
        params.put("limit", String.valueOf(limit));
        if (artist != null) {
            params.put("artist", artist);
        }
        Result result = Caller.getInstance().call("track.search", apiKey, params);
        DomElement element = result.getContentElement();
        DomElement matches = element.getChild("trackmatches");
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement domElement : matches.getChildren("track")) {
            tracks.add(Track.trackFromElement(domElement));
        }
        return tracks;
    }

    public static List<Tag> getTopTags(String artist, String trackOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        Result result = Caller.getInstance().call("track.getTopTags", apiKey, params);
        DomElement element = result.getContentElement();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(Tag.tagFromElement(domElement));
        }
        return tags;
    }

    public static Collection<User> getTopFans(String artist, String trackOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        Result result = Caller.getInstance().call("track.getTopFans", apiKey, params);
        DomElement element = result.getContentElement();
        ArrayList<User> users = new ArrayList<User>();
        for (DomElement domElement : element.getChildren("user")) {
            users.add(User.userFromElement(domElement));
        }
        return users;
    }

    public static Result addTags(String artist, String track, String tags, Session session) {
        return Caller.getInstance().call("track.addTags", session, "artist", artist, "track", track, "tags", tags);
    }

    public static Result removeTag(String artist, String track, String tag, Session session) {
        return Caller.getInstance().call("track.removeTag", session, "artist", artist, "track", track, "tag", tag);
    }

    public static Result share(String artist, String track, String message, String recipient, Session session) {
        Map<String, String> params = StringUtilities.map("artist", artist, "track", track, "recipient", recipient);
        if (message != null) {
            params.put("message", message);
        }
        return Caller.getInstance().call("track.share", session, params);
    }

    public static Result love(String artist, String track, Session session) {
        return Caller.getInstance().call("track.love", session, "artist", artist, "track", track);
    }

    public static Result ban(String artist, String track, Session session) {
        return Caller.getInstance().call("track.ban", session, "artist", artist, "track", track);
    }

    public static Collection<Track> getSimilar(String artist, String track, String mbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (artist != null && track != null) {
            params.put("artist", artist);
            params.put("track", track);
        }
        if (mbid != null) {
            params.put("mbid", mbid);
        }
        Result result = Caller.getInstance().call("track.getSimilar", apiKey, params);
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (DomElement element : result.getContentElement().getChildren("track")) {
            tracks.add(Track.trackFromElement(element));
        }
        return tracks;
    }

    public static Collection<String> getTags(String artist, String track, Session session) {
        Result result = Caller.getInstance().call("track.getTags", session, "artist", artist, "track", track);
        DomElement element = result.getContentElement();
        ArrayList<String> tags = new ArrayList<String>();
        for (DomElement domElement : element.getChildren("tag")) {
            tags.add(domElement.getChildText("name"));
        }
        return tags;
    }

    public static Track getInfo(String artist, String trackOrMbid, String apiKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtilities.isMbid(trackOrMbid)) {
            params.put("mbid", trackOrMbid);
        } else {
            params.put("artist", artist);
            params.put("track", trackOrMbid);
        }
        Result result = Caller.getInstance().call("track.getInfo", apiKey, params);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement content = result.getContentElement();
        DomElement album = content.getChild("album");
        Track track = Track.trackFromElement(content);
        if (album != null) {
            String pos = album.getAttribute("position");
            if (pos != null && pos.length() != 0) {
                track.position = Integer.parseInt(pos);
            }
            track.album = album.getChildText("title");
            track.albumMbid = album.getChildText("mbid");
            ImageHolder.loadImages(track, album);
        }
        return track;
    }

    static Track trackFromElement(DomElement element, String artistName) {
        DomElement stream;
        DomElement artist;
        DomElement album;
        Track track = new Track(null, null, artistName);
        MusicEntry.loadStandardInfo(track, element);
        String nowPlayingAttr = element.getAttribute("nowplaying");
        if (nowPlayingAttr != null) {
            track.nowPlaying = Boolean.valueOf(nowPlayingAttr);
        }
        if (element.hasChild("duration")) {
            track.duration = Integer.parseInt(element.getChildText("duration")) / 1000;
        }
        if ((album = element.getChild("album")) != null) {
            track.album = album.getText();
            track.albumMbid = album.getAttribute("mbid");
        }
        if ((artist = element.getChild("artist")).getChild("name") != null) {
            track.artist = artist.getChildText("name");
            track.artistMbid = artist.getChildText("mbid");
        } else {
            if (artistName == null) {
                track.artist = artist.getText();
            }
            track.artistMbid = artist.getAttribute("mbid");
        }
        DomElement date = element.getChild("date");
        if (date != null) {
            String uts = date.getAttribute("uts");
            long utsTime = Long.parseLong(uts);
            track.playedWhen = new Date(utsTime * 1000L);
        }
        if ((stream = element.getChild("streamable")) != null) {
            String s = stream.getAttribute("fulltrack");
            track.fullTrackAvailable = s != null && Integer.parseInt(s) == 1;
        }
        return track;
    }

    public static Track trackFromElement(DomElement e) {
        return Track.trackFromElement(e, null);
    }
}

