/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Event;
import net.roarsoftware.lastfm.PaginatedResult;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.xml.DomElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Venue {
    private String name;
    private String url;
    private String city;
    private String country;
    private String street;
    private String postal;
    private float latitude;
    private float longitude;
    private String timezone;
    private String id;

    private Venue() {
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public String getName() {
        return this.name;
    }

    public String getPostal() {
        return this.postal;
    }

    public String getStreet() {
        return this.street;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public static Collection<Venue> search(String venue, String apiKey) {
        return Venue.search(venue, null, apiKey);
    }

    public static Collection<Venue> search(String venue, String country, String apiKey) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("venue", venue);
        if (country != null) {
            params.put("country", country);
        }
        if (!(result = Caller.getInstance().call("venue.search", apiKey, params)).isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement child = result.getContentElement().getChild("venuematches");
        Collection<DomElement> children = child.getChildren("venue");
        ArrayList<Venue> venues = new ArrayList<Venue>(children.size());
        for (DomElement element : children) {
            venues.add(Venue.venueFromElement(element));
        }
        return venues;
    }

    public static Collection<Event> getEvents(String venueId, String apiKey) {
        Result result = Caller.getInstance().call("venue.getEvents", apiKey, "venue", venueId);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        Collection<DomElement> children = result.getContentElement().getChildren("event");
        ArrayList<Event> events = new ArrayList<Event>(children.size());
        for (DomElement child : children) {
            events.add(Event.eventFromElement(child));
        }
        return events;
    }

    public static PaginatedResult<Event> getPastEvents(String venueId, String apiKey) {
        return Venue.getPastEvents(venueId, 1, apiKey);
    }

    public static PaginatedResult<Event> getPastEvents(String venueId, int page, String apiKey) {
        Result result = Caller.getInstance().call("venue.getPastEvents", apiKey, "venue", venueId, "page", String.valueOf(page));
        if (!result.isSuccessful()) {
            return new PaginatedResult<Event>(0, 0, Collections.emptyList());
        }
        DomElement element = result.getContentElement();
        Collection<DomElement> children = element.getChildren("event");
        ArrayList<Event> events = new ArrayList<Event>(children.size());
        for (DomElement child : children) {
            events.add(Event.eventFromElement(child));
        }
        int currentPage = Integer.parseInt(element.getAttribute("page"));
        int totalPages = Integer.parseInt(element.getAttribute("totalPages"));
        return new PaginatedResult<Event>(currentPage, totalPages, events);
    }

    static Venue venueFromElement(DomElement e) {
        Venue venue = new Venue();
        venue.id = e.getChildText("id");
        venue.name = e.getChildText("name");
        venue.url = e.getChildText("url");
        DomElement l = e.getChild("location");
        venue.city = l.getChildText("city");
        venue.country = l.getChildText("country");
        venue.street = l.getChildText("street");
        venue.postal = l.getChildText("postalcode");
        venue.timezone = l.getChildText("timezone");
        DomElement p = l.getChild("geo:point");
        if (p.getChildText("geo:lat").length() != 0) {
            venue.latitude = Float.parseFloat(p.getChildText("geo:lat"));
            venue.longitude = Float.parseFloat(p.getChildText("geo:long"));
        }
        return venue;
    }
}

