/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.roarsoftware.lastfm.cache.ExpirationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExpirationPolicy
implements ExpirationPolicy {
    protected static final long ONE_DAY = 86400000L;
    protected static final long ONE_WEEK = 604800000L;
    protected static final Set<String> ONE_WEEK_METHODS = new HashSet<String>();
    protected long cacheRecentWeeklyCharts = 604800000L;

    @Override
    public long getExpirationTime(String method, Map<String, String> params) {
        if ((method = method.toLowerCase()).contains("weekly")) {
            if (!method.contains("list")) {
                return params.containsKey("to") && params.containsKey("from") ? Long.MAX_VALUE : this.cacheRecentWeeklyCharts;
            }
            return this.cacheRecentWeeklyCharts;
        }
        return ONE_WEEK_METHODS.contains(method) ? 604800000L : -1L;
    }

    public void setCacheRecentWeeklyCharts(long cacheRecentWeeklyCharts) {
        this.cacheRecentWeeklyCharts = cacheRecentWeeklyCharts;
    }

    static {
        ONE_WEEK_METHODS.add("artist.getsimilar");
        ONE_WEEK_METHODS.add("tag.getsimilar");
        ONE_WEEK_METHODS.add("track.getsimilar");
        ONE_WEEK_METHODS.add("artist.gettopalbums");
        ONE_WEEK_METHODS.add("artist.gettoptracks");
        ONE_WEEK_METHODS.add("geo.gettopartists");
        ONE_WEEK_METHODS.add("geo.gettoptracks");
        ONE_WEEK_METHODS.add("tag.gettopalbums");
        ONE_WEEK_METHODS.add("tag.gettopartists");
        ONE_WEEK_METHODS.add("tag.gettoptags");
        ONE_WEEK_METHODS.add("tag.gettoptracks");
        ONE_WEEK_METHODS.add("user.gettopalbums");
        ONE_WEEK_METHODS.add("user.gettopartists");
        ONE_WEEK_METHODS.add("user.gettoptracks");
        ONE_WEEK_METHODS.add("user.gettoptags");
    }
}

