/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.cache;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.roarsoftware.lastfm.cache.Cache;

public class MemoryCache
extends Cache {
    private Map<String, String> data = new HashMap<String, String>();
    private Map<String, Long> expirations = new HashMap<String, Long>();

    public boolean contains(String cacheEntryName) {
        boolean contains = this.data.containsKey(cacheEntryName);
        System.out.println("MemoryCache.contains: " + cacheEntryName + " ? " + contains);
        return contains;
    }

    public InputStream load(String cacheEntryName) {
        System.out.println("MemoryCache.load: " + cacheEntryName);
        try {
            return new ByteArrayInputStream(this.data.get(cacheEntryName).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void remove(String cacheEntryName) {
        System.out.println("MemoryCache.remove: " + cacheEntryName);
        this.data.remove(cacheEntryName);
        this.expirations.remove(cacheEntryName);
    }

    public void store(String cacheEntryName, InputStream inputStream, long expirationDate) {
        System.out.println("MemoryCache.store: " + cacheEntryName + " Expires at: " + new Date(expirationDate));
        StringBuilder b = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String l;
            while ((l = r.readLine()) != null) {
                b.append(l);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.data.put(cacheEntryName, b.toString());
        this.expirations.put(cacheEntryName, expirationDate);
    }

    public boolean isExpired(String cacheEntryName) {
        boolean exp = this.expirations.get(cacheEntryName) < System.currentTimeMillis();
        System.out.println("MemoryCache.isExpired: " + cacheEntryName + " ? " + exp);
        return exp;
    }

    public void clear() {
        this.data.clear();
        this.expirations.clear();
    }
}

