/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.scrobble;

import net.roarsoftware.lastfm.scrobble.Rating;
import net.roarsoftware.lastfm.scrobble.Source;
import net.roarsoftware.util.StringUtilities;

public class SubmissionData {
    private String artist;
    private String track;
    private String album;
    private long startTime;
    private Source source;
    private Rating rating;
    private String recommendationKey;
    private int length;
    private int tracknumber;

    public SubmissionData(String artist, String track, String album, int length, int tracknumber, Source source, long startTime) {
        this(artist, track, album, length, tracknumber, source, null, startTime);
    }

    public SubmissionData(String artist, String track, String album, int length, int tracknumber, Source source, Rating rating, long startTime) {
        this.artist = artist;
        this.track = track;
        this.album = album;
        this.length = length;
        this.tracknumber = tracknumber;
        this.source = source;
        this.rating = rating;
        this.startTime = startTime;
    }

    public SubmissionData(String artist, String track, String album, int length, int tracknumber, Source source, Rating rating, long startTime, String recommendationKey) {
        this(artist, track, album, length, tracknumber, source, rating, startTime);
        this.recommendationKey = recommendationKey;
    }

    public SubmissionData(String s) {
        String[] parts = s.split("&", 9);
        this.artist = StringUtilities.decode(parts[0]);
        this.track = StringUtilities.decode(parts[1]);
        this.startTime = parts[2].length() == 0 ? 0L : Long.valueOf(parts[2]);
        this.source = Source.valueOf(parts[3]);
        this.recommendationKey = parts[4].length() == 0 ? null : parts[4];
        this.rating = parts[5].length() == 0 ? null : Rating.valueOf(parts[5]);
        this.length = parts[6].length() == 0 ? -1 : Integer.valueOf(parts[6]);
        this.album = parts[7].length() == 0 ? null : StringUtilities.decode(parts[7]);
        this.tracknumber = parts[8].length() == 0 ? -1 : Integer.valueOf(parts[8]);
    }

    public String toString() {
        String b = StringUtilities.encode(this.album != null ? this.album : "");
        String artist = StringUtilities.encode(this.artist);
        String track = StringUtilities.encode(this.track);
        String l = this.length == -1 ? "" : String.valueOf(this.length);
        String n = this.tracknumber == -1 ? "" : String.valueOf(this.tracknumber);
        String r = "";
        if (this.rating != null) {
            r = this.rating.name();
        }
        String rec = "";
        if (this.recommendationKey != null && this.source == Source.LAST_FM && this.recommendationKey.length() == 5) {
            rec = this.recommendationKey;
        }
        return String.format("%s&%s&%s&%s&%s&%s&%s&%s&%s", artist, track, this.startTime, this.source.name(), rec, r, l, b, n);
    }

    String toString(String sessionId, int index) {
        String b = StringUtilities.encode(this.album != null ? this.album : "");
        String artist = StringUtilities.encode(this.artist);
        String track = StringUtilities.encode(this.track);
        String l = this.length == -1 ? "" : String.valueOf(this.length);
        String n = this.tracknumber == -1 ? "" : String.valueOf(this.tracknumber);
        String r = "";
        if (this.rating != null) {
            r = this.rating.getCode();
        }
        String rec = "";
        if (this.recommendationKey != null && this.source == Source.LAST_FM && this.recommendationKey.length() == 5) {
            rec = this.recommendationKey;
        }
        return String.format("s=%s&a[%10$d]=%s&t[%10$d]=%s&i[%10$d]=%s&o[%10$d]=%s&r[%10$d]=%s&l[%10$d]=%s&b[%10$d]=%s&n[%10$d]=%s&m[%10$d]=", sessionId, artist, track, this.startTime, this.source.getCode() + rec, r, l, b, n, index);
    }
}

