/*
 * Decompiled with CFR 0.152.
 */
package gstests;

import java.util.List;
import org.greenstone.gsdl3.testing.GSTestingUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;

public class TestClass {
    private static final int NUMBER_OF_CLASSIFIERS = 4;
    private static final int NUMBER_OF_SEARCH_TYPES = 3;
    private static final int NUMBER_OF_SEARCH_INDEXES = 5;
    private static final int TITLE_CLASSIFIER_SIZE = 11;
    private static final int SUBJECT_CLASSIFIER_SIZE = 7;
    private static final int ORGANISATIONS_CLASSIFIER_SIZE = 5;
    private static final int HITS_PER_PAGE = 20;
    private static final int SNAILS_RESULT_COUNT = 58;
    private static final int SNAILS_OCCURENCE_COUNT = 398;
    private static final String COLLECTION_NAME = "Demo Collection";
    private static WebDriver _driver = new FirefoxDriver();

    @Before
    public void init() {
        _driver.get(System.getProperty("SERVERURL"));
    }

    @Test
    public void testHomePage() {
        Assert.assertNotNull((String)"The Demo Collection is not available", (Object)GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//div[@id='collectionLinks']/a[descendant::text()='Demo Collection']"));
    }

    @Test
    public void testDemoCollectionHomePage() {
        GSTestingUtil.loadCollectionByName((WebDriver)_driver, (String)COLLECTION_NAME);
        WebElement demoTitleElem = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//div[@id='titlearea']/h2");
        String title = demoTitleElem.getText();
        Assert.assertTrue((String)"The title is incorrect", (boolean)title.equals(COLLECTION_NAME));
        List classifierLinks = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//ul[@id='gs-nav']/li");
        Assert.assertEquals((String)("There should be 4 classifiers but there were " + classifierLinks.size()), (long)classifierLinks.size(), (long)4L);
        List searchTypes = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//div[@id='quicksearcharea']/ul/li");
        Assert.assertEquals((String)("There should be 3 search types but there were " + searchTypes.size()), (long)searchTypes.size(), (long)3L);
        List searchIndexes = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//div[@id='quicksearcharea']/form/span[@class='textselect']/select/option");
        Assert.assertEquals((String)("There should be 5 search indexes but there were " + searchIndexes.size()), (long)searchIndexes.size(), (long)5L);
    }

    @Test
    public void testTitleClassifier() {
        GSTestingUtil.loadCollectionByName((WebDriver)_driver, (String)COLLECTION_NAME);
        GSTestingUtil.loadClassifierByName((WebDriver)_driver, (String)"titles");
        List documents = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='classifiernodelist']/tbody/tr");
        Assert.assertEquals((String)("There should be 11 documents in the titles classifier but there were " + documents.size()), (long)documents.size(), (long)11L);
    }

    @Test
    public void testSubjectsClassifier() {
        GSTestingUtil.loadCollectionByName((WebDriver)_driver, (String)COLLECTION_NAME);
        GSTestingUtil.loadClassifierByName((WebDriver)_driver, (String)"subjects");
        List subjectElems = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='classifiernodelist']/tbody/tr");
        Assert.assertEquals((String)("There should be 7 documents in the subjects classifier but there were " + subjectElems.size()), (long)subjectElems.size(), (long)7L);
        List expandImages = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//img[@src='interfaces/default/images/expand.png']");
        WebElement randomSubject = (WebElement)expandImages.get((int)(Math.random() * 7.0));
        randomSubject.click();
        String sectionNumber = randomSubject.getAttribute("id").substring(6);
        GSTestingUtil.waitForXPath((WebDriver)_driver, (String)("//table[@id='div" + sectionNumber + "']"));
        Assert.assertNotNull((String)"The subjects classifier did not open correctly", (Object)GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)("//table[@id='div" + sectionNumber + "']")));
    }

    @Test
    public void testOrganisationsClassifier() {
        GSTestingUtil.loadCollectionByName((WebDriver)_driver, (String)COLLECTION_NAME);
        GSTestingUtil.loadClassifierByName((WebDriver)_driver, (String)"organisations");
        List orgElems = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='classifiernodelist']/tbody/tr");
        Assert.assertEquals((String)("There should be 5 documents in the organisations classifier but there were " + orgElems.size()), (long)orgElems.size(), (long)5L);
        List expandImages = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//img[@src='interfaces/default/images/expand.png']");
        WebElement randomOrganisation = (WebElement)expandImages.get((int)(Math.random() * 5.0));
        randomOrganisation.click();
        String sectionNumber = randomOrganisation.getAttribute("id").substring(6);
        GSTestingUtil.waitForXPath((WebDriver)_driver, (String)("//table[@id='div" + sectionNumber + "']"));
        Assert.assertNotNull((String)"The organisations classifier did not open correctly", (Object)GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)("//table[@id='div" + sectionNumber + "']")));
    }

    @Test
    public void testQuickSearch() {
        GSTestingUtil.loadCollectionByName((WebDriver)_driver, (String)COLLECTION_NAME);
        GSTestingUtil.performQuickSearch((WebDriver)_driver, (String)"snails", null);
        List results = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='resultsTable']/tbody/tr");
        Assert.assertEquals((String)("The number of results on the page should have been 20 but it was " + results.size()), (long)results.size(), (long)20L);
        WebElement termInfo = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//p[@class='termList']/span[@class='termInfo']");
        Assert.assertTrue((String)("The term information was incorrect, it should have been \"snails occurs 398 times in 58 sections\" but was \"" + termInfo.getText() + "\""), (boolean)termInfo.getText().equals("snails occurs 398 times in 58 sections"));
        WebElement searchStatus = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//td[@id='searchResultsStatusBar']");
        Assert.assertTrue((String)("The search status was incorrect, it should have been \"Displaying 1 to 20 of 58 sections\" but it was \"" + searchStatus.getText() + "\""), (boolean)searchStatus.getText().equals("Displaying 1 to 20 of 58 sections"));
        WebElement nextButton = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//td[@id='nextTD']/a");
        nextButton.click();
        searchStatus = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//td[@id='searchResultsStatusBar']");
        Assert.assertTrue((String)("The search status was incorrect, it should have been \"Displaying 21 to 40 of 58 sections\" but it was \"" + searchStatus.getText() + "\""), (boolean)searchStatus.getText().equals("Displaying 21 to 40 of 58 sections"));
        WebElement prevButton = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//td[@id='prevTD']/a");
        prevButton.click();
        String randomSearchTerm = GSTestingUtil.generateRandomString((int)20);
        GSTestingUtil.performQuickSearch((WebDriver)_driver, (String)randomSearchTerm, null);
        WebElement contentElem = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//div[@id='gs_content']");
        Assert.assertTrue((String)("No results should have been found for \"" + randomSearchTerm), (boolean)contentElem.getText().equals("No documents matched the query."));
    }

    @Test
    public void testLoginAndAdmin() {
        GSTestingUtil.loginAs((WebDriver)_driver, (String)"admin", (String)"admin");
        WebElement adminPagesLink = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//a[@href='library/admin/ListUsers']");
        adminPagesLink.click();
        WebElement userListTable = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//table[@id='userListTable']");
        Assert.assertNotNull((String)"Administrator failed to log in", (Object)userListTable);
        WebElement addNewUserButton = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//a[@href='library/admin/AddUser']");
        addNewUserButton.click();
        WebElement usernameBox = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//input[@name='s1.username']");
        WebElement passwordBox = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//input[@id='passwordOne']");
        WebElement repasswordBox = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//input[@id='passwordTwo']");
        WebElement emailBox = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//input[@name='s1.email']");
        WebElement groupsBox = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//input[@name='s1.groups']");
        WebElement commentBox = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//textarea[@name='s1.comment']");
        String randomUsername = GSTestingUtil.generateRandomString((int)8);
        String randomPassword = GSTestingUtil.generateRandomString((int)8);
        usernameBox.sendKeys(new CharSequence[]{randomUsername});
        passwordBox.sendKeys(new CharSequence[]{randomPassword});
        repasswordBox.sendKeys(new CharSequence[]{randomPassword});
        emailBox.sendKeys(new CharSequence[]{randomUsername + "@testusername.co.nz"});
        groupsBox.sendKeys(new CharSequence[]{"Test Group"});
        commentBox.sendKeys(new CharSequence[]{"A user added for testing purposes"});
        WebElement submitButton = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//input[@id='submitButton']");
        submitButton.click();
        List userRows = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='userListTable']/tbody/tr");
        boolean found = false;
        for (int i = 0; i < userRows.size(); ++i) {
            List columns = ((WebElement)userRows.get(i)).findElements(By.tagName((String)"td"));
            if (!((WebElement)columns.get(0)).getText().equals(randomUsername)) continue;
            found = true;
            Assert.assertTrue((String)"The new user enabled status was incorrect", (boolean)((WebElement)columns.get(1)).getText().equals("enabled"));
            Assert.assertTrue((String)"The new user group was incorrect", (boolean)((WebElement)columns.get(2)).getText().equals("TestGroup"));
            Assert.assertTrue((String)"The new user comment was incorrect", (boolean)((WebElement)columns.get(3)).getText().equals("A user added for testing purposes"));
            Assert.assertTrue((String)"The new user email was incorrect", (boolean)((WebElement)columns.get(4)).getText().equals(randomUsername + "@testusername.co.nz"));
        }
        Assert.assertTrue((String)"The new user was not found", (boolean)found);
        GSTestingUtil.logout((WebDriver)_driver);
        GSTestingUtil.loginAs((WebDriver)_driver, (String)randomUsername, (String)randomPassword);
        WebElement menuButton = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//li[@id='userMenuButton']/a");
        Assert.assertTrue((String)"The new user was not able to log in correctly", (boolean)menuButton.getText().equals(randomUsername));
        WebElement backToHomePageLink = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//div[@id='breadcrumbs']/a[1]");
        backToHomePageLink.click();
        GSTestingUtil.logout((WebDriver)_driver);
        GSTestingUtil.loginAs((WebDriver)_driver, (String)"admin", (String)"admin");
        addNewUserButton = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//a[@href='library/admin/ListUsers']");
        addNewUserButton.click();
        userRows = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='userListTable']/tbody/tr");
        for (int i = 0; i < userRows.size(); ++i) {
            List columns = ((WebElement)userRows.get(i)).findElements(By.tagName((String)"td"));
            if (!((WebElement)columns.get(0)).getText().equals(randomUsername)) continue;
            WebElement deleteLink = ((WebElement)columns.get(6)).findElement(By.xpath((String)".//input[@value='Delete']"));
            deleteLink.click();
            _driver.switchTo().alert().accept();
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        GSTestingUtil.logout((WebDriver)_driver);
    }

    @Test
    public void testDocumentView() {
        GSTestingUtil.loadCollectionByName((WebDriver)_driver, (String)COLLECTION_NAME);
        GSTestingUtil.loadClassifierByName((WebDriver)_driver, (String)"titles");
        List documents = GSTestingUtil.findElementsByXPath((WebDriver)_driver, (String)"//table[@id='classifiernodelist']/tbody/tr");
        WebElement randomRow = (WebElement)documents.get((int)(Math.random() * (double)documents.size()));
        WebElement link = randomRow.findElement(By.xpath((String)".//a"));
        link.click();
        WebElement coverImage = GSTestingUtil.findElementByXPath((WebDriver)_driver, (String)"//div[@id='coverImage']/img");
        Assert.assertTrue((String)"The cover image of the document did not load correctly", (boolean)GSTestingUtil.isImageLoaded((WebDriver)_driver, (WebElement)coverImage));
    }

    @AfterClass
    public static void destroy() {
        _driver.quit();
    }
}

