package org.hathitrust.lrl.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VolPageIdFreq 
{
	public VolPageIdFreq(String id, int freq)
	{
		// **** seq number is 1 higher than page number! ****
		// "id":"txu.059173012321469.page-000070" -> txu.059173012321469-seq-000071
		
		// Change from .page suffix to -seq-
		// increase the page number by 1 to get seq number
		
		Pattern pat = Pattern.compile("(\\.page-)(\\d+)");
		Matcher mat = pat.matcher(id);
		if (mat.find()) {
			// Strictly speaking could skip having (\\.page-) as a group, as not used
			// in replacement sequence
			String page_num_str = mat.group(2);
			int page_num = Integer.parseInt(page_num_str);
			int seq_num = page_num+1;
			String seq_num_str = String.format("%06d",seq_num);
			
			_id = mat.replaceFirst("-seq-"+seq_num_str);
		}
		else {
			_id = id;
		}
		
		_freq = freq;
	}
	
	protected String _id;
	protected int _freq;
	
	public String getID() { return _id; }
	
	public int getFreq() { return _freq; }
	
	public static void main(String[] args) 
	{
		String ex_page_id = "txu.059173012321469.page-000070";
		
		VolPageIdFreq ex_vol_page = new VolPageIdFreq(ex_page_id,10);
		
		System.out.println("*** ex_page_id = " + ex_page_id);
		System.out.println("*** ex_seq_id  = " + ex_vol_page.getID());
	}
}
