package org.hathitrust.lrl.vollevel;

import java.io.File;
import java.util.ArrayList;

import org.hathitrust.lrl.core.UtilIO;

public class DownloadMaoVolumes 
{
	public static boolean DEBUG = false;
	
	public static void main(String[] args) 
	{
		String maori_volmd_ids_filename = UtilIO.LRL_HOME + File.separator + "sorted-data-output" 
				+ File.separator + "maori-volume_metadata-ids.txt";
		
		System.out.println("Reading language_t:mao volume-level IDs from file: ");
		System.out.println("  " + maori_volmd_ids_filename);
		ArrayList<String> vol_ids = UtilIO.readLineBasedTextFile(maori_volmd_ids_filename);
		
		String output_dir_str = UtilIO.LRL_HOME + File.separator + "data-output" 
				+ File.separator + "volume-ef-json" ;
		File output_dir = new File(output_dir_str);
		
		if (!output_dir.exists()) {
			output_dir.mkdirs();
		}

		int num_vol_ids = vol_ids.size();
		int pcount = 0;
		
		for (String vol_id: vol_ids) {
			
			pcount++;
			
			System.out.println("Downloading: " + pcount + "/" + num_vol_ids);
			UtilIO.downloadEFJson(vol_id,output_dir_str);
			
			if ((DEBUG) && (pcount >= 3)) {
				System.out.flush();
				System.err.println("**** cutting Download EF JSON Volumes short");
				break;
			}
		}
		
		System.out.flush();
		System.err.println("Done!");	

	}

}
