package org.hathitrust.lrl.vollevel;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;

import org.hathitrust.lrl.core.EFJson;
import org.hathitrust.lrl.core.UtilIO;
import org.json.JSONObject;

public class VolumeEFJSONToText {

	public static void ConvertJsonFileToText(Path input_filename)
	{
		if (input_filename.toString().endsWith(".json")) {

			System.out.println("*** Processing filenane = " + input_filename);

			JSONObject json_page = UtilIO.readJSONFile(input_filename.toString());
			String page_text = EFJson.JsonVolumeToText(json_page);

			String output_filename = input_filename.toString().replace(".json",".txt");
			output_filename = output_filename.replace("volume-ef-json", "volume-ef-text");
			
			UtilIO.writeTextToFile(output_filename, page_text);
		}
		else {
			System.out.println("*** Skipping:" + input_filename);
		}

	}
	
	public static void main(String[] args) 
	{
		String data_output_dir_str = UtilIO.LRL_HOME + File.separator + "data-output";
		
		String volume_json_base_dir_str = data_output_dir_str + File.separator + "volume-ef-json";
		String volume_text_base_dir_str = data_output_dir_str + File.separator + "volume-ef-text";
		
		File volume_json_base_dir = new File(volume_json_base_dir_str);
		if (!volume_json_base_dir.exists()) {
			volume_json_base_dir.mkdir();
		}
		
		File volume_text_base_dir = new File(volume_text_base_dir_str);
		if (!volume_text_base_dir.exists()) {
			volume_text_base_dir.mkdir();
		}
		
		try {
			Files.walk(Paths.get(volume_json_base_dir_str))
			.filter(Files::isRegularFile)
			.forEach(item -> VolumeEFJSONToText.ConvertJsonFileToText(item) );

		}
		catch (Exception e) {
			e.printStackTrace();
		}

		System.out.flush();
		System.err.println("Done!");
	}

}
