/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.jmorphy2.Tag;
import java.util.List;

public class Grammeme {
    public final String key;
    public final String value;
    public final String parentValue;
    public final String russianValue;
    public final String description;
    private final Tag.Storage storage;

    public Grammeme(List<String> grammemeInfo, Tag.Storage storage) {
        this(grammemeInfo.get(0), grammemeInfo.get(1), grammemeInfo.get(2), grammemeInfo.get(3), storage);
    }

    public Grammeme(String value, String parentValue, String russianValue, String description, Tag.Storage storage) {
        this.key = value.toLowerCase();
        this.value = value;
        this.parentValue = this.stringOrNull(parentValue);
        this.russianValue = russianValue;
        this.description = description;
        this.storage = storage;
    }

    private String stringOrNull(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        return s;
    }

    public Grammeme getParent() {
        return this.storage.getGrammeme(this.parentValue);
    }

    public Grammeme getRoot() {
        Grammeme grammeme = this;
        Grammeme parentGrammeme = grammeme.getParent();
        if (parentGrammeme == null) {
            return null;
        }
        while (parentGrammeme != null) {
            grammeme = parentGrammeme;
            parentGrammeme = grammeme.getParent();
        }
        return grammeme;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.value.equals((String)obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((Grammeme)obj).value);
    }

    public String toString() {
        return this.value;
    }

    public String info() {
        return String.format("<%s, %s, %s, %s>", this.value, this.parentValue, this.russianValue, this.description);
    }
}

