/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.jmorphy2.Grammeme;
import company.evo.jmorphy2.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ParsedWord
implements Comparable {
    public static final float EPS = 1.0E-6f;
    public final String word;
    public final Tag tag;
    public final String normalForm;
    public final String foundWord;
    public final float score;

    public ParsedWord(String word, Tag tag, String normalForm, String foundWord, float score) {
        this.word = word;
        this.tag = tag;
        this.normalForm = normalForm;
        this.foundWord = foundWord;
        this.score = score;
    }

    public abstract ParsedWord rescore(float var1);

    public abstract List<ParsedWord> getLexeme();

    public List<ParsedWord> inflect(Collection<Grammeme> requiredGrammemes) {
        return this.inflect(requiredGrammemes, null);
    }

    public List<ParsedWord> inflect(Collection<Grammeme> requiredGrammemes, Collection<Grammeme> excludeGrammemes) {
        ArrayList<ParsedWord> paradigm = new ArrayList<ParsedWord>();
        for (ParsedWord p : this.getLexeme()) {
            if (!p.tag.containsAll(requiredGrammemes) || p.tag.containsAny(excludeGrammemes)) continue;
            paradigm.add(p);
        }
        return paradigm;
    }

    public String toString() {
        return String.format("<ParsedWord: \"%s\", \"%s\", \"%s\", \"%s\", %.6f>", this.word, this.tag, this.normalForm, this.foundWord, Float.valueOf(this.score));
    }

    public int compareTo(Object obj) {
        ParsedWord other = (ParsedWord)obj;
        if (this.score > other.score) {
            return 1;
        }
        if (this.score < other.score) {
            return -1;
        }
        return 0;
    }

    public Unique toUnique() {
        return new Unique(this.tag, this.normalForm);
    }

    public static class Unique {
        public final Tag tag;
        public final String normalForm;

        public Unique(Tag tag, String normalForm) {
            this.tag = tag;
            this.normalForm = normalForm;
        }

        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Unique other = (Unique)obj;
            return this.tag.equals(other.tag) && this.normalForm.equals(other.normalForm);
        }

        public int hashCode() {
            int h = 17;
            h = h * 37 + this.tag.hashCode();
            h = h * 37 + this.normalForm.hashCode();
            return h;
        }
    }
}

