/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.dawg.IntegerDAWG;
import company.evo.jmorphy2.FileLoader;
import company.evo.jmorphy2.Tag;
import java.io.IOException;
import java.io.InputStream;

public class ProbabilityEstimator {
    public static final String PROBABILITY_FILENAME = "p_t_given_w.intdawg";
    public static final String KEY_FORMAT = "%s:%s";
    public static final float MULTIPLIER = 1000000.0f;
    private IntegerDAWG dict;

    public ProbabilityEstimator(FileLoader loader) throws IOException {
        InputStream stream = loader.newStream(PROBABILITY_FILENAME);
        this.dict = new IntegerDAWG(stream);
        stream.close();
    }

    public float getProbability(String word, Tag tag) throws IOException {
        String key = String.format(KEY_FORMAT, word, tag);
        return (float)this.dict.get(key, Integer.valueOf(0)).intValue() / 1000000.0f;
    }
}

