/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import com.google.common.collect.Lists;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import company.evo.jmorphy2.units.RegexUnit;

public class LatinUnit
extends RegexUnit {
    private static final String LATIN_REGEX = "[\\p{IsLatin}\\d\\p{Punct}]+";

    public LatinUnit(Tag.Storage tagStorage, boolean terminate, float score) {
        super(tagStorage, LATIN_REGEX, "LATN", terminate, score);
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        public Builder(boolean terminate, float score) {
            super(terminate, score);
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) {
            tagStorage.newGrammeme(Lists.newArrayList((Object[])new String[]{"LATN", "", "\u041b\u0410\u0422", "\u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430"}));
            tagStorage.newTag("LATN");
            return new LatinUnit(tagStorage, this.terminate, this.score);
        }
    }
}

