/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import com.google.common.collect.Lists;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import company.evo.jmorphy2.units.RegexUnit;

public class PunctuationUnit
extends RegexUnit {
    private static final String PUNCTUATION_REGEX = "\\p{Punct}+";

    private PunctuationUnit(Tag.Storage tagStorage, boolean terminate, float score) {
        super(tagStorage, PUNCTUATION_REGEX, "PNCT", terminate, score);
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        public Builder(boolean terminate, float score) {
            super(terminate, score);
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) {
            tagStorage.newGrammeme(Lists.newArrayList((Object[])new String[]{"PNCT", "", "\u0417\u041f\u0420", "\u043f\u0443\u043d\u043a\u0442\u0443\u0430\u0446\u0438\u044f"}));
            tagStorage.newTag("PNCT");
            return new PunctuationUnit(tagStorage, this.terminate, this.score);
        }
    }
}

