/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.nlp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import company.evo.jmorphy2.nlp.Node;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class Rule {
    public final String leftStr;
    public final String rightStr;
    public final ImmutableSet<String> left;
    public final ImmutableList<NodeMatcher> right;
    public final int rightSize;
    public final float weight;
    private static Splitter grammemeSplitter = Splitter.on((String)",").trimResults(CharMatcher.anyOf((CharSequence)"@$!"));
    private static Splitter rhsSplitter = Splitter.on((String)" ").trimResults();
    private static CharMatcher wordMatcher = CharMatcher.anyOf((CharSequence)"'\"");

    public Rule(String left, String right, float weight) {
        this.leftStr = left;
        this.rightStr = right;
        this.left = this.parseLeft(left);
        this.right = this.parseRight(right);
        this.rightSize = this.right.size();
        this.weight = weight;
    }

    protected ImmutableSet<String> parseLeft(String left) {
        return ImmutableSet.copyOf((Iterable)grammemeSplitter.split((CharSequence)left));
    }

    protected ImmutableList<NodeMatcher> parseRight(String right) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String part : rhsSplitter.split((CharSequence)right)) {
            int flags = 0;
            if (part.startsWith("@")) {
                flags |= 1;
            }
            if (part.startsWith("$")) {
                flags |= 2;
            }
            if (part.startsWith("'") && part.endsWith("'") || part.startsWith("\"") && part.endsWith("\"")) {
                listBuilder.add((Object)new NodeMatcher(null, wordMatcher.trimFrom((CharSequence)part), flags));
                continue;
            }
            listBuilder.add((Object)new NodeMatcher((ImmutableSet<String>)ImmutableSet.copyOf((Iterable)grammemeSplitter.split((CharSequence)part)), null, flags));
        }
        return listBuilder.build();
    }

    public boolean match(List<Node> nodes) {
        int n = this.right.size();
        if (nodes.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (((NodeMatcher)this.right.get(i)).match(nodes.get(i))) continue;
            return false;
        }
        return true;
    }

    public ImmutableSet<String> commonGrammemeValues(List<Node> nodes, Set<String> allowedValues) {
        Sets.SetView values = null;
        int i = 0;
        for (Node node : nodes) {
            if ((((NodeMatcher)this.right.get((int)i)).flags & 1) != 0) {
                ++i;
                continue;
            }
            values = values == null ? node.grammemeValues : Sets.intersection(values, node.grammemeValues);
            ++i;
        }
        values = Sets.intersection(values, allowedValues);
        values = Sets.union((Set)values, this.left);
        return ImmutableSet.copyOf((Collection)values);
    }

    public String toString() {
        return String.format("%s -> %s [%s]", this.leftStr, this.rightStr, Float.valueOf(this.weight));
    }

    public static class NodeMatcher {
        public final ImmutableSet<String> grammemeValues;
        public final String word;
        public final int flags;
        public static final int NO_COMMONS = 1;
        public static final int NO_REDUCE = 2;

        public NodeMatcher(ImmutableSet<String> grammemeValues, String word, int flags) {
            this.grammemeValues = grammemeValues;
            this.word = word == null ? null : word.toLowerCase();
            this.flags = flags;
        }

        public boolean match(Node node) {
            if (this.grammemeValues != null && !node.grammemeValues.containsAll(this.grammemeValues)) {
                return false;
            }
            return this.word == null || this.word.equals(node.word.toLowerCase());
        }
    }
}

