/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.nlp;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import company.evo.jmorphy2.MorphAnalyzer;
import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.nlp.Node;
import company.evo.jmorphy2.nlp.Rule;
import company.evo.jmorphy2.nlp.Ruleset;
import company.evo.jmorphy2.nlp.Tagger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class SimpleTagger
extends Tagger {
    protected final Ruleset rules;
    private final int threshold;
    public static final int DEFAULT_THRESHOLD = 1000;
    public static final Ruleset defaultRules = new Ruleset();

    public SimpleTagger(MorphAnalyzer morph) {
        this(morph, defaultRules);
    }

    public SimpleTagger(MorphAnalyzer morph, Ruleset rules) {
        this(morph, rules, 1000);
    }

    public SimpleTagger(MorphAnalyzer morph, int threshold) {
        this(morph, defaultRules, threshold);
    }

    public SimpleTagger(MorphAnalyzer morph, Ruleset rules, int threshold) {
        super(morph);
        this.rules = rules;
        this.threshold = threshold;
    }

    @Override
    public List<Node.Top> tagAll(String[] tokens) throws IOException {
        ArrayList<Node.Top> results = new ArrayList<Node.Top>();
        if (tokens.length != 0) {
            this.tagAll(results, new LinkedList<Node>(), this.makeTokens(tokens));
            Collections.sort(results, Collections.reverseOrder(Node.scoreComparator()));
        }
        return results;
    }

    private Node reduce(Rule rule, ImmutableList<Node> nodes) {
        ImmutableList rNodes = nodes.subList(0, rule.rightSize);
        ArrayList<String> words = new ArrayList<String>();
        float score = 0.0f;
        for (Node node : rNodes) {
            words.add(node.word);
            score += node.score;
        }
        return new Node(rule.left, Joiner.on((String)" ").join(words), score);
    }

    private void tagAll(List<Node.Top> results, Deque<Node> nodesStack, ImmutableList<Node> nodes) throws IOException {
        List<Node> reducedNodes = new ArrayList<Object>();
        for (int count = 1; count <= this.rules.getMaxRightSize(); ++count) {
            for (Rule rule : this.rules.matchAll((List<Node>)nodes.subList(0, count))) {
                reducedNodes.add(this.reduce(rule, nodes));
            }
        }
        if (reducedNodes.isEmpty()) {
            Node tNode = (Node)nodes.get(0);
            List parseds = this.morph.parse(tNode.word);
            for (ParsedWord p : parseds) {
                reducedNodes.add(new Node((ImmutableSet<String>)ImmutableSet.copyOf((Collection)p.tag.getGrammemeValues()), p, p.score));
                if (!p.tag.contains("Fixd")) continue;
                break;
            }
        }
        if (reducedNodes.isEmpty()) {
            reducedNodes.add((Node)nodes.get(0));
        }
        if (!reducedNodes.isEmpty() && results.size() > this.threshold) {
            reducedNodes = reducedNodes.subList(0, 1);
        }
        for (Node node : reducedNodes) {
            nodesStack.addLast(node);
            int offset = node.hasChildren() ? node.getChildren().size() : 1;
            ImmutableList tail = nodes.subList(offset, nodes.size());
            if (tail.isEmpty()) {
                float score = 0.0f;
                for (Node n : nodesStack) {
                    score += n.score;
                }
                results.add(new Node.Top((ImmutableList<Node>)ImmutableList.copyOf(nodesStack), score));
            } else {
                this.tagAll(results, nodesStack, (ImmutableList<Node>)tail);
            }
            nodesStack.removeLast();
        }
    }

    @Override
    public Node.Top tag(String[] tokens) throws IOException {
        ImmutableList<Node> tokenNodes = this.makeTokens(tokens);
        float score = 0.0f;
        int tokensSize = tokenNodes.size();
        ImmutableList.Builder nodesBuilder = ImmutableList.builder();
        int i = 0;
        while (i < tokensSize) {
            Rule mRule = this.rules.match((List<Node>)tokenNodes);
            if (mRule != null) {
                nodesBuilder.add((Object)this.reduce(mRule, tokenNodes));
                score += mRule.weight;
                i += mRule.rightSize;
                continue;
            }
            Node tNode = (Node)tokenNodes.get(i);
            List parseds = this.morph.parse(tNode.word);
            if (!parseds.isEmpty()) {
                ParsedWord p = (ParsedWord)parseds.get(0);
                nodesBuilder.add((Object)new Node((ImmutableSet<String>)ImmutableSet.copyOf((Collection)p.tag.getGrammemeValues()), p, p.score));
                score += p.score;
            } else {
                nodesBuilder.add(tokenNodes.get(i));
            }
            ++i;
        }
        return new Node.Top((ImmutableList<Node>)nodesBuilder.build(), score);
    }

    private ImmutableList<Node> makeTokens(String[] words) {
        ImmutableList.Builder tokensBuilder = ImmutableList.builder();
        for (String w : words) {
            tokensBuilder.add((Object)new Node((ImmutableSet<String>)ImmutableSet.of((Object)"UNKN"), w, 1.0f));
        }
        return tokensBuilder.build();
    }

    static {
        defaultRules.add("CONJ", "'\u0430' | '\u0438' | '\u043d\u043e'");
        defaultRules.add("PREP", "'\u0431\u0435\u0437' | '\u0431\u0435\u0437\u043e' | '\u0432' | '\u0432\u043e' | '\u0434\u043b\u044f' | '\u0434\u043e' | '\u0437\u0430' | '\u0438\u0437' | '\u0438\u0437-\u0437\u0430' | '\u0438\u0437-\u043f\u043e\u0434' | '\u043a' | '\u043a\u043e' | '\u043c\u0435\u0436' | '\u043c\u0435\u0436\u0434\u0443' | '\u043d\u0430' | '\u043d\u0430\u0434' | '\u043e' | '\u043e\u0431' | '\u043e\u0442' | '\u043f\u0435\u0440\u0435\u0434' | '\u043f\u043e' | '\u043f\u0440\u0438' | '\u043f\u0440\u043e' | '\u0441' | '\u0441\u043e' | '\u0443' | '\u0447\u0435\u0440\u0435\u0437'");
    }
}

