/*
 * This is the lookup table used to compute x^(4/3) for Layer III
 * requantization. To maintain the best possible accuracy, the value is
 * stored as a normalized mantissa with exponent. The requantization
 * algorithm recombines these parts with appropriate scaling.
 */

/*
 * table for requantization
 *
 * rq_table[x].mantissa * 2^(rq_table[x].exponent) = x^(4/3)
 */
 
Mad.rq_table /* 8207 */ = [
  /*    0 */  [ 0.000000000,  0 ],
  /*    1 */  [ 0.250000000,  2 ],
  /*    2 */  [ 0.314980262,  3 ],
  /*    3 */  [ 0.270421794,  4 ],
  /*    4 */  [ 0.396850263,  4 ],
  /*    5 */  [ 0.267183742,  5 ],
  /*    6 */  [ 0.340710111,  5 ],
  /*    7 */  [ 0.418453696,  5 ],
  /*    8 */  [ 0.250000000,  6 ],
  /*    9 */  [ 0.292511788,  6 ],
  /*   10 */  [ 0.336630420,  6 ],
  /*   11 */  [ 0.382246578,  6 ],
  /*   12 */  [ 0.429267841,  6 ],
  /*   13 */  [ 0.477614858,  6 ],
  /*   14 */  [ 0.263609310,  7 ],
  /*   15 */  [ 0.289009227,  7 ],

  /*   16 */  [ 0.314980262,  7 ],
  /*   17 */  [ 0.341498336,  7 ],
  /*   18 */  [ 0.368541759,  7 ],
  /*   19 */  [ 0.396090870,  7 ],
  /*   20 */  [ 0.424127753,  7 ],
  /*   21 */  [ 0.452635998,  7 ],
  /*   22 */  [ 0.481600510,  7 ],
  /*   23 */  [ 0.255503674,  8 ],
  /*   24 */  [ 0.270421794,  8 ],
  /*   25 */  [ 0.285548607,  8 ],
  /*   26 */  [ 0.300878507,  8 ],
  /*   27 */  [ 0.316406250,  8 ],
  /*   28 */  [ 0.332126919,  8 ],
  /*   29 */  [ 0.348035890,  8 ],
  /*   30 */  [ 0.364128809,  8 ],
  /*   31 */  [ 0.380401563,  8 ],

  /*   32 */  [ 0.396850263,  8 ],
  /*   33 */  [ 0.413471222,  8 ],
  /*   34 */  [ 0.430260942,  8 ],
  /*   35 */  [ 0.447216097,  8 ],
  /*   36 */  [ 0.464333519,  8 ],
  /*   37 */  [ 0.481610189,  8 ],
  /*   38 */  [ 0.499043224,  8 ],
  /*   39 */  [ 0.258314934,  9 ],
  /*   40 */  [ 0.267183742,  9 ],
  /*   41 */  [ 0.276126771,  9 ],
  /*   42 */  [ 0.285142811,  9 ],
  /*   43 */  [ 0.294230696,  9 ],
  /*   44 */  [ 0.303389310,  9 ],
  /*   45 */  [ 0.312617576,  9 ],
  /*   46 */  [ 0.321914457,  9 ],
  /*   47 */  [ 0.331278957,  9 ],

  /*   48 */  [ 0.340710111,  9 ],
  /*   49 */  [ 0.350206992,  9 ],
  /*   50 */  [ 0.359768701,  9 ],
  /*   51 */  [ 0.369394372,  9 ],
  /*   52 */  [ 0.379083164,  9 ],
  /*   53 */  [ 0.388834268,  9 ],
  /*   54 */  [ 0.398646895,  9 ],
  /*   55 */  [ 0.408520284,  9 ],
  /*   56 */  [ 0.418453696,  9 ],
  /*   57 */  [ 0.428446415,  9 ],
  /*   58 */  [ 0.438497744,  9 ],
  /*   59 */  [ 0.448607009,  9 ],
  /*   60 */  [ 0.458773552,  9 ],
  /*   61 */  [ 0.468996735,  9 ],
  /*   62 */  [ 0.479275937,  9 ],
  /*   63 */  [ 0.489610555,  9 ],

  /*   64 */  [ 0.250000000, 10 ],
  /*   65 */  [ 0.255221850, 10 ],
  /*   66 */  [ 0.260470548, 10 ],
  /*   67 */  [ 0.265745823, 10 ],
  /*   68 */  [ 0.271047409, 10 ],
  /*   69 */  [ 0.276375048, 10 ],
  /*   70 */  [ 0.281728487, 10 ],
  /*   71 */  [ 0.287107481, 10 ],
  /*   72 */  [ 0.292511788, 10 ],
  /*   73 */  [ 0.297941173, 10 ],
  /*   74 */  [ 0.303395408, 10 ],
  /*   75 */  [ 0.308874267, 10 ],
  /*   76 */  [ 0.314377532, 10 ],
  /*   77 */  [ 0.319904987, 10 ],
  /*   78 */  [ 0.325456423, 10 ],
  /*   79 */  [ 0.331031635, 10 ],

  /*   80 */  [ 0.336630420, 10 ],
  /*   81 */  [ 0.342252584, 10 ],
  /*   82 */  [ 0.347897931, 10 ],
  /*   83 */  [ 0.353566275, 10 ],
  /*   84 */  [ 0.359257429, 10 ],
  /*   85 */  [ 0.364971213, 10 ],
  /*   86 */  [ 0.370707448, 10 ],
  /*   87 */  [ 0.376465960, 10 ],
  /*   88 */  [ 0.382246578, 10 ],
  /*   89 */  [ 0.388049134, 10 ],
  /*   90 */  [ 0.393873464, 10 ],
  /*   91 */  [ 0.399719406, 10 ],
  /*   92 */  [ 0.405586801, 10 ],
  /*   93 */  [ 0.411475493, 10 ],
  /*   94 */  [ 0.417385331, 10 ],
  /*   95 */  [ 0.423316162, 10 ],

  /*   96 */  [ 0.429267841, 10 ],
  /*   97 */  [ 0.435240221, 10 ],
  /*   98 */  [ 0.441233161, 10 ],
  /*   99 */  [ 0.447246519, 10 ],
  /*  100 */  [ 0.453280160, 10 ],
  /*  101 */  [ 0.459333946, 10 ],
  /*  102 */  [ 0.465407744, 10 ],
  /*  103 */  [ 0.471501425, 10 ],
  /*  104 */  [ 0.477614858, 10 ],
  /*  105 */  [ 0.483747918, 10 ],
  /*  106 */  [ 0.489900479, 10 ],
  /*  107 */  [ 0.496072418, 10 ],
  /*  108 */  [ 0.251131807, 11 ],
  /*  109 */  [ 0.254236974, 11 ],
  /*  110 */  [ 0.257351652, 11 ],
  /*  111 */  [ 0.260475783, 11 ],

  /*  112 */  [ 0.263609310, 11 ],
  /*  113 */  [ 0.266752177, 11 ],
  /*  114 */  [ 0.269904329, 11 ],
  /*  115 */  [ 0.273065710, 11 ],
  /*  116 */  [ 0.276236269, 11 ],
  /*  117 */  [ 0.279415952, 11 ],
  /*  118 */  [ 0.282604707, 11 ],
  /*  119 */  [ 0.285802482, 11 ],
  /*  120 */  [ 0.289009227, 11 ],
  /*  121 */  [ 0.292224893, 11 ],
  /*  122 */  [ 0.295449429, 11 ],
  /*  123 */  [ 0.298682788, 11 ],
  /*  124 */  [ 0.301924921, 11 ],
  /*  125 */  [ 0.305175781, 11 ],
  /*  126 */  [ 0.308435322, 11 ],
  /*  127 */  [ 0.311703498, 11 ],

  /*  128 */  [ 0.314980262, 11 ],
  /*  129 */  [ 0.318265572, 11 ],
  /*  130 */  [ 0.321559381, 11 ],
  /*  131 */  [ 0.324861647, 11 ],
  /*  132 */  [ 0.328172327, 11 ],
  /*  133 */  [ 0.331491377, 11 ],
  /*  134 */  [ 0.334818756, 11 ],
  /*  135 */  [ 0.338154423, 11 ],
  /*  136 */  [ 0.341498336, 11 ],
  /*  137 */  [ 0.344850455, 11 ],
  /*  138 */  [ 0.348210741, 11 ],
  /*  139 */  [ 0.351579152, 11 ],
  /*  140 */  [ 0.354955651, 11 ],
  /*  141 */  [ 0.358340200, 11 ],
  /*  142 */  [ 0.361732758, 11 ],
  /*  143 */  [ 0.365133291, 11 ],

  /*  144 */  [ 0.368541759, 11 ],
  /*  145 */  [ 0.371958126, 11 ],
  /*  146 */  [ 0.375382356, 11 ],
  /*  147 */  [ 0.378814413, 11 ],
  /*  148 */  [ 0.382254261, 11 ],
  /*  149 */  [ 0.385701865, 11 ],
  /*  150 */  [ 0.389157191, 11 ],
  /*  151 */  [ 0.392620204, 11 ],
  /*  152 */  [ 0.396090870, 11 ],
  /*  153 */  [ 0.399569155, 11 ],
  /*  154 */  [ 0.403055027, 11 ],
  /*  155 */  [ 0.406548452, 11 ],
  /*  156 */  [ 0.410049398, 11 ],
  /*  157 */  [ 0.413557833, 11 ],
  /*  158 */  [ 0.417073724, 11 ],
  /*  159 */  [ 0.420597041, 11 ],

  /*  160 */  [ 0.424127753, 11 ],
  /*  161 */  [ 0.427665827, 11 ],
  /*  162 */  [ 0.431211234, 11 ],
  /*  163 */  [ 0.434763944, 11 ],
  /*  164 */  [ 0.438323927, 11 ],
  /*  165 */  [ 0.441891153, 11 ],
  /*  166 */  [ 0.445465593, 11 ],
  /*  167 */  [ 0.449047217, 11 ],
  /*  168 */  [ 0.452635998, 11 ],
  /*  169 */  [ 0.456231906, 11 ],
  /*  170 */  [ 0.459834914, 11 ],
  /*  171 */  [ 0.463444993, 11 ],
  /*  172 */  [ 0.467062117, 11 ],
  /*  173 */  [ 0.470686258, 11 ],
  /*  174 */  [ 0.474317388, 11 ],
  /*  175 */  [ 0.477955481, 11 ],

  /*  176 */  [ 0.481600510, 11 ],
  /*  177 */  [ 0.485252449, 11 ],
  /*  178 */  [ 0.488911273, 11 ],
  /*  179 */  [ 0.492576954, 11 ],
  /*  180 */  [ 0.496249468, 11 ],
  /*  181 */  [ 0.499928790, 11 ],
  /*  182 */  [ 0.251807447, 12 ],
  /*  183 */  [ 0.253653877, 12 ],
  /*  184 */  [ 0.255503674, 12 ],
  /*  185 */  [ 0.257356825, 12 ],
  /*  186 */  [ 0.259213318, 12 ],
  /*  187 */  [ 0.261073141, 12 ],
  /*  188 */  [ 0.262936282, 12 ],
  /*  189 */  [ 0.264802730, 12 ],
  /*  190 */  [ 0.266672472, 12 ],
  /*  191 */  [ 0.268545497, 12 ],

  /*  192 */  [ 0.270421794, 12 ],
  /*  193 */  [ 0.272301352, 12 ],
  /*  194 */  [ 0.274184158, 12 ],
  /*  195 */  [ 0.276070203, 12 ],
  /*  196 */  [ 0.277959474, 12 ],
  /*  197 */  [ 0.279851960, 12 ],
  /*  198 */  [ 0.281747652, 12 ],
  /*  199 */  [ 0.283646538, 12 ],
  /*  200 */  [ 0.285548607, 12 ],
  /*  201 */  [ 0.287453849, 12 ],
  /*  202 */  [ 0.289362253, 12 ],
  /*  203 */  [ 0.291273810, 12 ],
  /*  204 */  [ 0.293188507, 12 ],
  /*  205 */  [ 0.295106336, 12 ],
  /*  206 */  [ 0.297027285, 12 ],
  /*  207 */  [ 0.298951346, 12 ],

  /*  208 */  [ 0.300878507, 12 ],
  /*  209 */  [ 0.302808759, 12 ],
  /*  210 */  [ 0.304742092, 12 ],
  /*  211 */  [ 0.306678497, 12 ],
  /*  212 */  [ 0.308617963, 12 ],
  /*  213 */  [ 0.310560480, 12 ],
  /*  214 */  [ 0.312506041, 12 ],
  /*  215 */  [ 0.314454634, 12 ],
  /*  216 */  [ 0.316406250, 12 ],
  /*  217 */  [ 0.318360880, 12 ],
  /*  218 */  [ 0.320318516, 12 ],
  /*  219 */  [ 0.322279147, 12 ],
  /*  220 */  [ 0.324242764, 12 ],
  /*  221 */  [ 0.326209359, 12 ],
  /*  222 */  [ 0.328178922, 12 ],
  /*  223 */  [ 0.330151445, 12 ],

  /*  224 */  [ 0.332126919, 12 ],
  /*  225 */  [ 0.334105334, 12 ],
  /*  226 */  [ 0.336086683, 12 ],
  /*  227 */  [ 0.338070956, 12 ],
  /*  228 */  [ 0.340058145, 12 ],
  /*  229 */  [ 0.342048241, 12 ],
  /*  230 */  [ 0.344041237, 12 ],
  /*  231 */  [ 0.346037122, 12 ],
  /*  232 */  [ 0.348035890, 12 ],
  /*  233 */  [ 0.350037532, 12 ],
  /*  234 */  [ 0.352042040, 12 ],
  /*  235 */  [ 0.354049405, 12 ],
  /*  236 */  [ 0.356059619, 12 ],
  /*  237 */  [ 0.358072674, 12 ],
  /*  238 */  [ 0.360088563, 12 ],
  /*  239 */  [ 0.362107278, 12 ],

  /*  240 */  [ 0.364128809, 12 ],
  /*  241 */  [ 0.366153151, 12 ],
  /*  242 */  [ 0.368180294, 12 ],
  /*  243 */  [ 0.370210231, 12 ],
  /*  244 */  [ 0.372242955, 12 ],
  /*  245 */  [ 0.374278458, 12 ],
  /*  246 */  [ 0.376316732, 12 ],
  /*  247 */  [ 0.378357769, 12 ],
  /*  248 */  [ 0.380401563, 12 ],
  /*  249 */  [ 0.382448106, 12 ],
  /*  250 */  [ 0.384497391, 12 ],
  /*  251 */  [ 0.386549409, 12 ],
  /*  252 */  [ 0.388604155, 12 ],
  /*  253 */  [ 0.390661620, 12 ],
  /*  254 */  [ 0.392721798, 12 ],
  /*  255 */  [ 0.394784681, 12 ],

  /*  256 */  [ 0.396850263, 12 ],
  /*  257 */  [ 0.398918536, 12 ],
  /*  258 */  [ 0.400989493, 12 ],
  /*  259 */  [ 0.403063128, 12 ],
  /*  260 */  [ 0.405139433, 12 ],
  /*  261 */  [ 0.407218402, 12 ],
  /*  262 */  [ 0.409300027, 12 ],
  /*  263 */  [ 0.411384303, 12 ],
  /*  264 */  [ 0.413471222, 12 ],
  /*  265 */  [ 0.415560778, 12 ],
  /*  266 */  [ 0.417652964, 12 ],
  /*  267 */  [ 0.419747773, 12 ],
  /*  268 */  [ 0.421845199, 12 ],
  /*  269 */  [ 0.423945235, 12 ],
  /*  270 */  [ 0.426047876, 12 ],
  /*  271 */  [ 0.428153114, 12 ],

  /*  272 */  [ 0.430260942, 12 ],
  /*  273 */  [ 0.432371356, 12 ],
  /*  274 */  [ 0.434484348, 12 ],
  /*  275 */  [ 0.436599912, 12 ],
  /*  276 */  [ 0.438718042, 12 ],
  /*  277 */  [ 0.440838732, 12 ],
  /*  278 */  [ 0.442961975, 12 ],
  /*  279 */  [ 0.445087765, 12 ],
  /*  280 */  [ 0.447216097, 12 ],
  /*  281 */  [ 0.449346964, 12 ],
  /*  282 */  [ 0.451480360, 12 ],
  /*  283 */  [ 0.453616280, 12 ],
  /*  284 */  [ 0.455754717, 12 ],
  /*  285 */  [ 0.457895665, 12 ],
  /*  286 */  [ 0.460039119, 12 ],
  /*  287 */  [ 0.462185072, 12 ],

  /*  288 */  [ 0.464333519, 12 ],
  /*  289 */  [ 0.466484455, 12 ],
  /*  290 */  [ 0.468637872, 12 ],
  /*  291 */  [ 0.470793767, 12 ],
  /*  292 */  [ 0.472952132, 12 ],
  /*  293 */  [ 0.475112962, 12 ],
  /*  294 */  [ 0.477276252, 12 ],
  /*  295 */  [ 0.479441997, 12 ],
  /*  296 */  [ 0.481610189, 12 ],
  /*  297 */  [ 0.483780825, 12 ],
  /*  298 */  [ 0.485953899, 12 ],
  /*  299 */  [ 0.488129404, 12 ],
  /*  300 */  [ 0.490307336, 12 ],
  /*  301 */  [ 0.492487690, 12 ],
  /*  302 */  [ 0.494670459, 12 ],
  /*  303 */  [ 0.496855639, 12 ],

  /*  304 */  [ 0.499043224, 12 ],
  /*  305 */  [ 0.250616605, 13 ],
  /*  306 */  [ 0.251712795, 13 ],
  /*  307 */  [ 0.252810180, 13 ],
  /*  308 */  [ 0.253908756, 13 ],
  /*  309 */  [ 0.255008523, 13 ],
  /*  310 */  [ 0.256109476, 13 ],
  /*  311 */  [ 0.257211614, 13 ],
  /*  312 */  [ 0.258314934, 13 ],
  /*  313 */  [ 0.259419433, 13 ],
  /*  314 */  [ 0.260525110, 13 ],
  /*  315 */  [ 0.261631960, 13 ],
  /*  316 */  [ 0.262739982, 13 ],
  /*  317 */  [ 0.263849174, 13 ],
  /*  318 */  [ 0.264959533, 13 ],
  /*  319 */  [ 0.266071056, 13 ],

  /*  320 */  [ 0.267183742, 13 ],
  /*  321 */  [ 0.268297587, 13 ],
  /*  322 */  [ 0.269412589, 13 ],
  /*  323 */  [ 0.270528746, 13 ],
  /*  324 */  [ 0.271646056, 13 ],
  /*  325 */  [ 0.272764515, 13 ],
  /*  326 */  [ 0.273884123, 13 ],
  /*  327 */  [ 0.275004875, 13 ],
  /*  328 */  [ 0.276126771, 13 ],
  /*  329 */  [ 0.277249808, 13 ],
  /*  330 */  [ 0.278373983, 13 ],
  /*  331 */  [ 0.279499294, 13 ],
  /*  332 */  [ 0.280625739, 13 ],
  /*  333 */  [ 0.281753315, 13 ],
  /*  334 */  [ 0.282882021, 13 ],
  /*  335 */  [ 0.284011853, 13 ],

  /*  336 */  [ 0.285142811, 13 ],
  /*  337 */  [ 0.286274891, 13 ],
  /*  338 */  [ 0.287408091, 13 ],
  /*  339 */  [ 0.288542409, 13 ],
  /*  340 */  [ 0.289677844, 13 ],
  /*  341 */  [ 0.290814392, 13 ],
  /*  342 */  [ 0.291952051, 13 ],
  /*  343 */  [ 0.293090820, 13 ],
  /*  344 */  [ 0.294230696, 13 ],
  /*  345 */  [ 0.295371678, 13 ],
  /*  346 */  [ 0.296513762, 13 ],
  /*  347 */  [ 0.297656947, 13 ],
  /*  348 */  [ 0.298801231, 13 ],
  /*  349 */  [ 0.299946611, 13 ],
  /*  350 */  [ 0.301093085, 13 ],
  /*  351 */  [ 0.302240653, 13 ],

  /*  352 */  [ 0.303389310, 13 ],
  /*  353 */  [ 0.304539056, 13 ],
  /*  354 */  [ 0.305689888, 13 ],
  /*  355 */  [ 0.306841804, 13 ],
  /*  356 */  [ 0.307994802, 13 ],
  /*  357 */  [ 0.309148880, 13 ],
  /*  358 */  [ 0.310304037, 13 ],
  /*  359 */  [ 0.311460269, 13 ],
  /*  360 */  [ 0.312617576, 13 ],
  /*  361 */  [ 0.313775954, 13 ],
  /*  362 */  [ 0.314935403, 13 ],
  /*  363 */  [ 0.316095920, 13 ],
  /*  364 */  [ 0.317257503, 13 ],
  /*  365 */  [ 0.318420150, 13 ],
  /*  366 */  [ 0.319583859, 13 ],
  /*  367 */  [ 0.320748629, 13 ],

  /*  368 */  [ 0.321914457, 13 ],
  /*  369 */  [ 0.323081342, 13 ],
  /*  370 */  [ 0.324249281, 13 ],
  /*  371 */  [ 0.325418273, 13 ],
  /*  372 */  [ 0.326588316, 13 ],
  /*  373 */  [ 0.327759407, 13 ],
  /*  374 */  [ 0.328931546, 13 ],
  /*  375 */  [ 0.330104730, 13 ],
  /*  376 */  [ 0.331278957, 13 ],
  /*  377 */  [ 0.332454225, 13 ],
  /*  378 */  [ 0.333630533, 13 ],
  /*  379 */  [ 0.334807879, 13 ],
  /*  380 */  [ 0.335986261, 13 ],
  /*  381 */  [ 0.337165677, 13 ],
  /*  382 */  [ 0.338346125, 13 ],
  /*  383 */  [ 0.339527604, 13 ],

  /*  384 */  [ 0.340710111, 13 ],
  /*  385 */  [ 0.341893646, 13 ],
  /*  386 */  [ 0.343078205, 13 ],
  /*  387 */  [ 0.344263788, 13 ],
  /*  388 */  [ 0.345450393, 13 ],
  /*  389 */  [ 0.346638017, 13 ],
  /*  390 */  [ 0.347826659, 13 ],
  /*  391 */  [ 0.349016318, 13 ],
  /*  392 */  [ 0.350206992, 13 ],
  /*  393 */  [ 0.351398678, 13 ],
  /*  394 */  [ 0.352591376, 13 ],
  /*  395 */  [ 0.353785083, 13 ],
  /*  396 */  [ 0.354979798, 13 ],
  /*  397 */  [ 0.356175519, 13 ],
  /*  398 */  [ 0.357372244, 13 ],
  /*  399 */  [ 0.358569972, 13 ],

  /*  400 */  [ 0.359768701, 13 ],
  /*  401 */  [ 0.360968429, 13 ],
  /*  402 */  [ 0.362169156, 13 ],
  /*  403 */  [ 0.363370878, 13 ],
  /*  404 */  [ 0.364573594, 13 ],
  /*  405 */  [ 0.365777304, 13 ],
  /*  406 */  [ 0.366982004, 13 ],
  /*  407 */  [ 0.368187694, 13 ],
  /*  408 */  [ 0.369394372, 13 ],
  /*  409 */  [ 0.370602036, 13 ],
  /*  410 */  [ 0.371810684, 13 ],
  /*  411 */  [ 0.373020316, 13 ],
  /*  412 */  [ 0.374230929, 13 ],
  /*  413 */  [ 0.375442522, 13 ],
  /*  414 */  [ 0.376655093, 13 ],
  /*  415 */  [ 0.377868641, 13 ],

  /*  416 */  [ 0.379083164, 13 ],
  /*  417 */  [ 0.380298661, 13 ],
  /*  418 */  [ 0.381515130, 13 ],
  /*  419 */  [ 0.382732569, 13 ],
  /*  420 */  [ 0.383950977, 13 ],
  /*  421 */  [ 0.385170352, 13 ],
  /*  422 */  [ 0.386390694, 13 ],
  /*  423 */  [ 0.387611999, 13 ],
  /*  424 */  [ 0.388834268, 13 ],
  /*  425 */  [ 0.390057497, 13 ],
  /*  426 */  [ 0.391281687, 13 ],
  /*  427 */  [ 0.392506834, 13 ],
  /*  428 */  [ 0.393732939, 13 ],
  /*  429 */  [ 0.394959999, 13 ],
  /*  430 */  [ 0.396188012, 13 ],
  /*  431 */  [ 0.397416978, 13 ],

  /*  432 */  [ 0.398646895, 13 ],
  /*  433 */  [ 0.399877761, 13 ],
  /*  434 */  [ 0.401109575, 13 ],
  /*  435 */  [ 0.402342335, 13 ],
  /*  436 */  [ 0.403576041, 13 ],
  /*  437 */  [ 0.404810690, 13 ],
  /*  438 */  [ 0.406046281, 13 ],
  /*  439 */  [ 0.407282813, 13 ],
  /*  440 */  [ 0.408520284, 13 ],
  /*  441 */  [ 0.409758693, 13 ],
  /*  442 */  [ 0.410998038, 13 ],
  /*  443 */  [ 0.412238319, 13 ],
  /*  444 */  [ 0.413479532, 13 ],
  /*  445 */  [ 0.414721679, 13 ],
  /*  446 */  [ 0.415964756, 13 ],
  /*  447 */  [ 0.417208762, 13 ],

  /*  448 */  [ 0.418453696, 13 ],
  /*  449 */  [ 0.419699557, 13 ],
  /*  450 */  [ 0.420946343, 13 ],
  /*  451 */  [ 0.422194054, 13 ],
  /*  452 */  [ 0.423442686, 13 ],
  /*  453 */  [ 0.424692240, 13 ],
  /*  454 */  [ 0.425942714, 13 ],
  /*  455 */  [ 0.427194106, 13 ],
  /*  456 */  [ 0.428446415, 13 ],
  /*  457 */  [ 0.429699640, 13 ],
  /*  458 */  [ 0.430953779, 13 ],
  /*  459 */  [ 0.432208832, 13 ],
  /*  460 */  [ 0.433464796, 13 ],
  /*  461 */  [ 0.434721671, 13 ],
  /*  462 */  [ 0.435979455, 13 ],
  /*  463 */  [ 0.437238146, 13 ],

  /*  464 */  [ 0.438497744, 13 ],
  /*  465 */  [ 0.439758248, 13 ],
  /*  466 */  [ 0.441019655, 13 ],
  /*  467 */  [ 0.442281965, 13 ],
  /*  468 */  [ 0.443545176, 13 ],
  /*  469 */  [ 0.444809288, 13 ],
  /*  470 */  [ 0.446074298, 13 ],
  /*  471 */  [ 0.447340205, 13 ],
  /*  472 */  [ 0.448607009, 13 ],
  /*  473 */  [ 0.449874708, 13 ],
  /*  474 */  [ 0.451143300, 13 ],
  /*  475 */  [ 0.452412785, 13 ],
  /*  476 */  [ 0.453683161, 13 ],
  /*  477 */  [ 0.454954427, 13 ],
  /*  478 */  [ 0.456226581, 13 ],
  /*  479 */  [ 0.457499623, 13 ],

  /*  480 */  [ 0.458773552, 13 ],
  /*  481 */  [ 0.460048365, 13 ],
  /*  482 */  [ 0.461324062, 13 ],
  /*  483 */  [ 0.462600642, 13 ],
  /*  484 */  [ 0.463878102, 13 ],
  /*  485 */  [ 0.465156443, 13 ],
  /*  486 */  [ 0.466435663, 13 ],
  /*  487 */  [ 0.467715761, 13 ],
  /*  488 */  [ 0.468996735, 13 ],
  /*  489 */  [ 0.470278584, 13 ],
  /*  490 */  [ 0.471561307, 13 ],
  /*  491 */  [ 0.472844904, 13 ],
  /*  492 */  [ 0.474129372, 13 ],
  /*  493 */  [ 0.475414710, 13 ],
  /*  494 */  [ 0.476700918, 13 ],
  /*  495 */  [ 0.477987994, 13 ],

  /*  496 */  [ 0.479275937, 13 ],
  /*  497 */  [ 0.480564746, 13 ],
  /*  498 */  [ 0.481854420, 13 ],
  /*  499 */  [ 0.483144957, 13 ],
  /*  500 */  [ 0.484436356, 13 ],
  /*  501 */  [ 0.485728617, 13 ],
  /*  502 */  [ 0.487021738, 13 ],
  /*  503 */  [ 0.488315717, 13 ],
  /*  504 */  [ 0.489610555, 13 ],
  /*  505 */  [ 0.490906249, 13 ],
  /*  506 */  [ 0.492202799, 13 ],
  /*  507 */  [ 0.493500203, 13 ],
  /*  508 */  [ 0.494798460, 13 ],
  /*  509 */  [ 0.496097570, 13 ],
  /*  510 */  [ 0.497397530, 13 ],
  /*  511 */  [ 0.498698341, 13 ],

  /*  512 */  [ 0.250000000, 14 ],
  /*  513 */  [ 0.250651254, 14 ],
  /*  514 */  [ 0.251302930, 14 ],
  /*  515 */  [ 0.251955030, 14 ],
  /*  516 */  [ 0.252607552, 14 ],
  /*  517 */  [ 0.253260495, 14 ],
  /*  518 */  [ 0.253913860, 14 ],
  /*  519 */  [ 0.254567645, 14 ],
  /*  520 */  [ 0.255221850, 14 ],
  /*  521 */  [ 0.255876475, 14 ],
  /*  522 */  [ 0.256531518, 14 ],
  /*  523 */  [ 0.257186980, 14 ],
  /*  524 */  [ 0.257842860, 14 ],
  /*  525 */  [ 0.258499157, 14 ],
  /*  526 */  [ 0.259155872, 14 ],
  /*  527 */  [ 0.259813002, 14 ],

  /*  528 */  [ 0.260470548, 14 ],
  /*  529 */  [ 0.261128510, 14 ],
  /*  530 */  [ 0.261786886, 14 ],
  /*  531 */  [ 0.262445676, 14 ],
  /*  532 */  [ 0.263104880, 14 ],
  /*  533 */  [ 0.263764497, 14 ],
  /*  534 */  [ 0.264424527, 14 ],
  /*  535 */  [ 0.265084969, 14 ],
  /*  536 */  [ 0.265745823, 14 ],
  /*  537 */  [ 0.266407088, 14 ],
  /*  538 */  [ 0.267068763, 14 ],
  /*  539 */  [ 0.267730848, 14 ],
  /*  540 */  [ 0.268393343, 14 ],
  /*  541 */  [ 0.269056248, 14 ],
  /*  542 */  [ 0.269719560, 14 ],
  /*  543 */  [ 0.270383281, 14 ],

  /*  544 */  [ 0.271047409, 14 ],
  /*  545 */  [ 0.271711944, 14 ],
  /*  546 */  [ 0.272376886, 14 ],
  /*  547 */  [ 0.273042234, 14 ],
  /*  548 */  [ 0.273707988, 14 ],
  /*  549 */  [ 0.274374147, 14 ],
  /*  550 */  [ 0.275040710, 14 ],
  /*  551 */  [ 0.275707677, 14 ],
  /*  552 */  [ 0.276375048, 14 ],
  /*  553 */  [ 0.277042822, 14 ],
  /*  554 */  [ 0.277710999, 14 ],
  /*  555 */  [ 0.278379578, 14 ],
  /*  556 */  [ 0.279048558, 14 ],
  /*  557 */  [ 0.279717940, 14 ],
  /*  558 */  [ 0.280387722, 14 ],
  /*  559 */  [ 0.281057905, 14 ],

  /*  560 */  [ 0.281728487, 14 ],
  /*  561 */  [ 0.282399469, 14 ],
  /*  562 */  [ 0.283070849, 14 ],
  /*  563 */  [ 0.283742628, 14 ],
  /*  564 */  [ 0.284414805, 14 ],
  /*  565 */  [ 0.285087379, 14 ],
  /*  566 */  [ 0.285760350, 14 ],
  /*  567 */  [ 0.286433717, 14 ],
  /*  568 */  [ 0.287107481, 14 ],
  /*  569 */  [ 0.287781640, 14 ],
  /*  570 */  [ 0.288456194, 14 ],
  /*  571 */  [ 0.289131142, 14 ],
  /*  572 */  [ 0.289806485, 14 ],
  /*  573 */  [ 0.290482221, 14 ],
  /*  574 */  [ 0.291158351, 14 ],
  /*  575 */  [ 0.291834873, 14 ],

  /*  576 */  [ 0.292511788, 14 ],
  /*  577 */  [ 0.293189094, 14 ],
  /*  578 */  [ 0.293866792, 14 ],
  /*  579 */  [ 0.294544881, 14 ],
  /*  580 */  [ 0.295223360, 14 ],
  /*  581 */  [ 0.295902229, 14 ],
  /*  582 */  [ 0.296581488, 14 ],
  /*  583 */  [ 0.297261136, 14 ],
  /*  584 */  [ 0.297941173, 14 ],
  /*  585 */  [ 0.298621598, 14 ],
  /*  586 */  [ 0.299302411, 14 ],
  /*  587 */  [ 0.299983611, 14 ],
  /*  588 */  [ 0.300665198, 14 ],
  /*  589 */  [ 0.301347172, 14 ],
  /*  590 */  [ 0.302029532, 14 ],
  /*  591 */  [ 0.302712277, 14 ],

  /*  592 */  [ 0.303395408, 14 ],
  /*  593 */  [ 0.304078923, 14 ],
  /*  594 */  [ 0.304762823, 14 ],
  /*  595 */  [ 0.305447106, 14 ],
  /*  596 */  [ 0.306131773, 14 ],
  /*  597 */  [ 0.306816823, 14 ],
  /*  598 */  [ 0.307502256, 14 ],
  /*  599 */  [ 0.308188071, 14 ],
  /*  600 */  [ 0.308874267, 14 ],
  /*  601 */  [ 0.309560845, 14 ],
  /*  602 */  [ 0.310247804, 14 ],
  /*  603 */  [ 0.310935143, 14 ],
  /*  604 */  [ 0.311622862, 14 ],
  /*  605 */  [ 0.312310961, 14 ],
  /*  606 */  [ 0.312999439, 14 ],
  /*  607 */  [ 0.313688296, 14 ],

  /*  608 */  [ 0.314377532, 14 ],
  /*  609 */  [ 0.315067145, 14 ],
  /*  610 */  [ 0.315757136, 14 ],
  /*  611 */  [ 0.316447504, 14 ],
  /*  612 */  [ 0.317138249, 14 ],
  /*  613 */  [ 0.317829370, 14 ],
  /*  614 */  [ 0.318520867, 14 ],
  /*  615 */  [ 0.319212739, 14 ],
  /*  616 */  [ 0.319904987, 14 ],
  /*  617 */  [ 0.320597609, 14 ],
  /*  618 */  [ 0.321290606, 14 ],
  /*  619 */  [ 0.321983976, 14 ],
  /*  620 */  [ 0.322677720, 14 ],
  /*  621 */  [ 0.323371837, 14 ],
  /*  622 */  [ 0.324066327, 14 ],
  /*  623 */  [ 0.324761189, 14 ],

  /*  624 */  [ 0.325456423, 14 ],
  /*  625 */  [ 0.326152028, 14 ],
  /*  626 */  [ 0.326848005, 14 ],
  /*  627 */  [ 0.327544352, 14 ],
  /*  628 */  [ 0.328241070, 14 ],
  /*  629 */  [ 0.328938157, 14 ],
  /*  630 */  [ 0.329635614, 14 ],
  /*  631 */  [ 0.330333440, 14 ],
  /*  632 */  [ 0.331031635, 14 ],
  /*  633 */  [ 0.331730198, 14 ],
  /*  634 */  [ 0.332429129, 14 ],
  /*  635 */  [ 0.333128427, 14 ],
  /*  636 */  [ 0.333828093, 14 ],
  /*  637 */  [ 0.334528126, 14 ],
  /*  638 */  [ 0.335228525, 14 ],
  /*  639 */  [ 0.335929290, 14 ],

  /*  640 */  [ 0.336630420, 14 ],
  /*  641 */  [ 0.337331916, 14 ],
  /*  642 */  [ 0.338033777, 14 ],
  /*  643 */  [ 0.338736002, 14 ],
  /*  644 */  [ 0.339438592, 14 ],
  /*  645 */  [ 0.340141545, 14 ],
  /*  646 */  [ 0.340844862, 14 ],
  /*  647 */  [ 0.341548541, 14 ],
  /*  648 */  [ 0.342252584, 14 ],
  /*  649 */  [ 0.342956988, 14 ],
  /*  650 */  [ 0.343661754, 14 ],
  /*  651 */  [ 0.344366882, 14 ],
  /*  652 */  [ 0.345072371, 14 ],
  /*  653 */  [ 0.345778221, 14 ],
  /*  654 */  [ 0.346484431, 14 ],
  /*  655 */  [ 0.347191002, 14 ],

  /*  656 */  [ 0.347897931, 14 ],
  /*  657 */  [ 0.348605221, 14 ],
  /*  658 */  [ 0.349312869, 14 ],
  /*  659 */  [ 0.350020876, 14 ],
  /*  660 */  [ 0.350729240, 14 ],
  /*  661 */  [ 0.351437963, 14 ],
  /*  662 */  [ 0.352147044, 14 ],
  /*  663 */  [ 0.352856481, 14 ],
  /*  664 */  [ 0.353566275, 14 ],
  /*  665 */  [ 0.354276426, 14 ],
  /*  666 */  [ 0.354986932, 14 ],
  /*  667 */  [ 0.355697795, 14 ],
  /*  668 */  [ 0.356409012, 14 ],
  /*  669 */  [ 0.357120585, 14 ],
  /*  670 */  [ 0.357832512, 14 ],
  /*  671 */  [ 0.358544794, 14 ],

  /*  672 */  [ 0.359257429, 14 ],
  /*  673 */  [ 0.359970419, 14 ],
  /*  674 */  [ 0.360683761, 14 ],
  /*  675 */  [ 0.361397456, 14 ],
  /*  676 */  [ 0.362111504, 14 ],
  /*  677 */  [ 0.362825904, 14 ],
  /*  678 */  [ 0.363540655, 14 ],
  /*  679 */  [ 0.364255759, 14 ],
  /*  680 */  [ 0.364971213, 14 ],
  /*  681 */  [ 0.365687018, 14 ],
  /*  682 */  [ 0.366403174, 14 ],
  /*  683 */  [ 0.367119680, 14 ],
  /*  684 */  [ 0.367836535, 14 ],
  /*  685 */  [ 0.368553740, 14 ],
  /*  686 */  [ 0.369271294, 14 ],
  /*  687 */  [ 0.369989197, 14 ],

  /*  688 */  [ 0.370707448, 14 ],
  /*  689 */  [ 0.371426047, 14 ],
  /*  690 */  [ 0.372144994, 14 ],
  /*  691 */  [ 0.372864289, 14 ],
  /*  692 */  [ 0.373583930, 14 ],
  /*  693 */  [ 0.374303918, 14 ],
  /*  694 */  [ 0.375024253, 14 ],
  /*  695 */  [ 0.375744934, 14 ],
  /*  696 */  [ 0.376465960, 14 ],
  /*  697 */  [ 0.377187332, 14 ],
  /*  698 */  [ 0.377909049, 14 ],
  /*  699 */  [ 0.378631110, 14 ],
  /*  700 */  [ 0.379353516, 14 ],
  /*  701 */  [ 0.380076266, 14 ],
  /*  702 */  [ 0.380799360, 14 ],
  /*  703 */  [ 0.381522798, 14 ],

  /*  704 */  [ 0.382246578, 14 ],
  /*  705 */  [ 0.382970701, 14 ],
  /*  706 */  [ 0.383695167, 14 ],
  /*  707 */  [ 0.384419975, 14 ],
  /*  708 */  [ 0.385145124, 14 ],
  /*  709 */  [ 0.385870615, 14 ],
  /*  710 */  [ 0.386596448, 14 ],
  /*  711 */  [ 0.387322621, 14 ],
  /*  712 */  [ 0.388049134, 14 ],
  /*  713 */  [ 0.388775988, 14 ],
  /*  714 */  [ 0.389503182, 14 ],
  /*  715 */  [ 0.390230715, 14 ],
  /*  716 */  [ 0.390958588, 14 ],
  /*  717 */  [ 0.391686799, 14 ],
  /*  718 */  [ 0.392415349, 14 ],
  /*  719 */  [ 0.393144238, 14 ],

  /*  720 */  [ 0.393873464, 14 ],
  /*  721 */  [ 0.394603028, 14 ],
  /*  722 */  [ 0.395332930, 14 ],
  /*  723 */  [ 0.396063168, 14 ],
  /*  724 */  [ 0.396793743, 14 ],
  /*  725 */  [ 0.397524655, 14 ],
  /*  726 */  [ 0.398255903, 14 ],
  /*  727 */  [ 0.398987487, 14 ],
  /*  728 */  [ 0.399719406, 14 ],
  /*  729 */  [ 0.400451660, 14 ],
  /*  730 */  [ 0.401184249, 14 ],
  /*  731 */  [ 0.401917173, 14 ],
  /*  732 */  [ 0.402650431, 14 ],
  /*  733 */  [ 0.403384024, 14 ],
  /*  734 */  [ 0.404117949, 14 ],
  /*  735 */  [ 0.404852209, 14 ],

  /*  736 */  [ 0.405586801, 14 ],
  /*  737 */  [ 0.406321726, 14 ],
  /*  738 */  [ 0.407056983, 14 ],
  /*  739 */  [ 0.407792573, 14 ],
  /*  740 */  [ 0.408528495, 14 ],
  /*  741 */  [ 0.409264748, 14 ],
  /*  742 */  [ 0.410001332, 14 ],
  /*  743 */  [ 0.410738247, 14 ],
  /*  744 */  [ 0.411475493, 14 ],
  /*  745 */  [ 0.412213070, 14 ],
  /*  746 */  [ 0.412950976, 14 ],
  /*  747 */  [ 0.413689213, 14 ],
  /*  748 */  [ 0.414427779, 14 ],
  /*  749 */  [ 0.415166674, 14 ],
  /*  750 */  [ 0.415905897, 14 ],
  /*  751 */  [ 0.416645450, 14 ],

  /*  752 */  [ 0.417385331, 14 ],
  /*  753 */  [ 0.418125540, 14 ],
  /*  754 */  [ 0.418866076, 14 ],
  /*  755 */  [ 0.419606940, 14 ],
  /*  756 */  [ 0.420348132, 14 ],
  /*  757 */  [ 0.421089650, 14 ],
  /*  758 */  [ 0.421831494, 14 ],
  /*  759 */  [ 0.422573665, 14 ],
  /*  760 */  [ 0.423316162, 14 ],
  /*  761 */  [ 0.424058985, 14 ],
  /*  762 */  [ 0.424802133, 14 ],
  /*  763 */  [ 0.425545607, 14 ],
  /*  764 */  [ 0.426289405, 14 ],
  /*  765 */  [ 0.427033528, 14 ],
  /*  766 */  [ 0.427777975, 14 ],
  /*  767 */  [ 0.428522746, 14 ],

  /*  768 */  [ 0.429267841, 14 ],
  /*  769 */  [ 0.430013259, 14 ],
  /*  770 */  [ 0.430759001, 14 ],
  /*  771 */  [ 0.431505065, 14 ],
  /*  772 */  [ 0.432251452, 14 ],
  /*  773 */  [ 0.432998162, 14 ],
  /*  774 */  [ 0.433745193, 14 ],
  /*  775 */  [ 0.434492546, 14 ],
  /*  776 */  [ 0.435240221, 14 ],
  /*  777 */  [ 0.435988217, 14 ],
  /*  778 */  [ 0.436736534, 14 ],
  /*  779 */  [ 0.437485172, 14 ],
  /*  780 */  [ 0.438234130, 14 ],
  /*  781 */  [ 0.438983408, 14 ],
  /*  782 */  [ 0.439733006, 14 ],
  /*  783 */  [ 0.440482924, 14 ],

  /*  784 */  [ 0.441233161, 14 ],
  /*  785 */  [ 0.441983717, 14 ],
  /*  786 */  [ 0.442734592, 14 ],
  /*  787 */  [ 0.443485785, 14 ],
  /*  788 */  [ 0.444237296, 14 ],
  /*  789 */  [ 0.444989126, 14 ],
  /*  790 */  [ 0.445741273, 14 ],
  /*  791 */  [ 0.446493738, 14 ],
  /*  792 */  [ 0.447246519, 14 ],
  /*  793 */  [ 0.447999618, 14 ],
  /*  794 */  [ 0.448753033, 14 ],
  /*  795 */  [ 0.449506765, 14 ],
  /*  796 */  [ 0.450260813, 14 ],
  /*  797 */  [ 0.451015176, 14 ],
  /*  798 */  [ 0.451769856, 14 ],
  /*  799 */  [ 0.452524850, 14 ],

  /*  800 */  [ 0.453280160, 14 ],
  /*  801 */  [ 0.454035784, 14 ],
  /*  802 */  [ 0.454791723, 14 ],
  /*  803 */  [ 0.455547976, 14 ],
  /*  804 */  [ 0.456304543, 14 ],
  /*  805 */  [ 0.457061423, 14 ],
  /*  806 */  [ 0.457818618, 14 ],
  /*  807 */  [ 0.458576125, 14 ],
  /*  808 */  [ 0.459333946, 14 ],
  /*  809 */  [ 0.460092079, 14 ],
  /*  810 */  [ 0.460850524, 14 ],
  /*  811 */  [ 0.461609282, 14 ],
  /*  812 */  [ 0.462368352, 14 ],
  /*  813 */  [ 0.463127733, 14 ],
  /*  814 */  [ 0.463887426, 14 ],
  /*  815 */  [ 0.464647430, 14 ],

  /*  816 */  [ 0.465407744, 14 ],
  /*  817 */  [ 0.466168370, 14 ],
  /*  818 */  [ 0.466929306, 14 ],
  /*  819 */  [ 0.467690552, 14 ],
  /*  820 */  [ 0.468452108, 14 ],
  /*  821 */  [ 0.469213973, 14 ],
  /*  822 */  [ 0.469976148, 14 ],
  /*  823 */  [ 0.470738632, 14 ],
  /*  824 */  [ 0.471501425, 14 ],
  /*  825 */  [ 0.472264527, 14 ],
  /*  826 */  [ 0.473027937, 14 ],
  /*  827 */  [ 0.473791655, 14 ],
  /*  828 */  [ 0.474555681, 14 ],
  /*  829 */  [ 0.475320014, 14 ],
  /*  830 */  [ 0.476084655, 14 ],
  /*  831 */  [ 0.476849603, 14 ],

  /*  832 */  [ 0.477614858, 14 ],
  /*  833 */  [ 0.478380420, 14 ],
  /*  834 */  [ 0.479146288, 14 ],
  /*  835 */  [ 0.479912463, 14 ],
  /*  836 */  [ 0.480678943, 14 ],
  /*  837 */  [ 0.481445729, 14 ],
  /*  838 */  [ 0.482212820, 14 ],
  /*  839 */  [ 0.482980216, 14 ],
  /*  840 */  [ 0.483747918, 14 ],
  /*  841 */  [ 0.484515924, 14 ],
  /*  842 */  [ 0.485284235, 14 ],
  /*  843 */  [ 0.486052849, 14 ],
  /*  844 */  [ 0.486821768, 14 ],
  /*  845 */  [ 0.487590991, 14 ],
  /*  846 */  [ 0.488360517, 14 ],
  /*  847 */  [ 0.489130346, 14 ],

  /*  848 */  [ 0.489900479, 14 ],
  /*  849 */  [ 0.490670914, 14 ],
  /*  850 */  [ 0.491441651, 14 ],
  /*  851 */  [ 0.492212691, 14 ],
  /*  852 */  [ 0.492984033, 14 ],
  /*  853 */  [ 0.493755677, 14 ],
  /*  854 */  [ 0.494527623, 14 ],
  /*  855 */  [ 0.495299870, 14 ],
  /*  856 */  [ 0.496072418, 14 ],
  /*  857 */  [ 0.496845266, 14 ],
  /*  858 */  [ 0.497618416, 14 ],
  /*  859 */  [ 0.498391866, 14 ],
  /*  860 */  [ 0.499165616, 14 ],
  /*  861 */  [ 0.499939666, 14 ],
  /*  862 */  [ 0.250357008, 15 ],
  /*  863 */  [ 0.250744333, 15 ],

  /*  864 */  [ 0.251131807, 15 ],
  /*  865 */  [ 0.251519431, 15 ],
  /*  866 */  [ 0.251907204, 15 ],
  /*  867 */  [ 0.252295127, 15 ],
  /*  868 */  [ 0.252683198, 15 ],
  /*  869 */  [ 0.253071419, 15 ],
  /*  870 */  [ 0.253459789, 15 ],
  /*  871 */  [ 0.253848307, 15 ],
  /*  872 */  [ 0.254236974, 15 ],
  /*  873 */  [ 0.254625790, 15 ],
  /*  874 */  [ 0.255014755, 15 ],
  /*  875 */  [ 0.255403867, 15 ],
  /*  876 */  [ 0.255793128, 15 ],
  /*  877 */  [ 0.256182537, 15 ],
  /*  878 */  [ 0.256572095, 15 ],
  /*  879 */  [ 0.256961800, 15 ],

  /*  880 */  [ 0.257351652, 15 ],
  /*  881 */  [ 0.257741653, 15 ],
  /*  882 */  [ 0.258131801, 15 ],
  /*  883 */  [ 0.258522097, 15 ],
  /*  884 */  [ 0.258912540, 15 ],
  /*  885 */  [ 0.259303130, 15 ],
  /*  886 */  [ 0.259693868, 15 ],
  /*  887 */  [ 0.260084752, 15 ],
  /*  888 */  [ 0.260475783, 15 ],
  /*  889 */  [ 0.260866961, 15 ],
  /*  890 */  [ 0.261258286, 15 ],
  /*  891 */  [ 0.261649758, 15 ],
  /*  892 */  [ 0.262041376, 15 ],
  /*  893 */  [ 0.262433140, 15 ],
  /*  894 */  [ 0.262825051, 15 ],
  /*  895 */  [ 0.263217107, 15 ],

  /*  896 */  [ 0.263609310, 15 ],
  /*  897 */  [ 0.264001659, 15 ],
  /*  898 */  [ 0.264394153, 15 ],
  /*  899 */  [ 0.264786794, 15 ],
  /*  900 */  [ 0.265179580, 15 ],
  /*  901 */  [ 0.265572511, 15 ],
  /*  902 */  [ 0.265965588, 15 ],
  /*  903 */  [ 0.266358810, 15 ],
  /*  904 */  [ 0.266752177, 15 ],
  /*  905 */  [ 0.267145689, 15 ],
  /*  906 */  [ 0.267539347, 15 ],
  /*  907 */  [ 0.267933149, 15 ],
  /*  908 */  [ 0.268327096, 15 ],
  /*  909 */  [ 0.268721187, 15 ],
  /*  910 */  [ 0.269115423, 15 ],
  /*  911 */  [ 0.269509804, 15 ],

  /*  912 */  [ 0.269904329, 15 ],
  /*  913 */  [ 0.270298998, 15 ],
  /*  914 */  [ 0.270693811, 15 ],
  /*  915 */  [ 0.271088768, 15 ],
  /*  916 */  [ 0.271483869, 15 ],
  /*  917 */  [ 0.271879114, 15 ],
  /*  918 */  [ 0.272274503, 15 ],
  /*  919 */  [ 0.272670035, 15 ],
  /*  920 */  [ 0.273065710, 15 ],
  /*  921 */  [ 0.273461530, 15 ],
  /*  922 */  [ 0.273857492, 15 ],
  /*  923 */  [ 0.274253597, 15 ],
  /*  924 */  [ 0.274649846, 15 ],
  /*  925 */  [ 0.275046238, 15 ],
  /*  926 */  [ 0.275442772, 15 ],
  /*  927 */  [ 0.275839449, 15 ],

  /*  928 */  [ 0.276236269, 15 ],
  /*  929 */  [ 0.276633232, 15 ],
  /*  930 */  [ 0.277030337, 15 ],
  /*  931 */  [ 0.277427584, 15 ],
  /*  932 */  [ 0.277824973, 15 ],
  /*  933 */  [ 0.278222505, 15 ],
  /*  934 */  [ 0.278620179, 15 ],
  /*  935 */  [ 0.279017995, 15 ],
  /*  936 */  [ 0.279415952, 15 ],
  /*  937 */  [ 0.279814051, 15 ],
  /*  938 */  [ 0.280212292, 15 ],
  /*  939 */  [ 0.280610675, 15 ],
  /*  940 */  [ 0.281009199, 15 ],
  /*  941 */  [ 0.281407864, 15 ],
  /*  942 */  [ 0.281806670, 15 ],
  /*  943 */  [ 0.282205618, 15 ],

  /*  944 */  [ 0.282604707, 15 ],
  /*  945 */  [ 0.283003936, 15 ],
  /*  946 */  [ 0.283403307, 15 ],
  /*  947 */  [ 0.283802818, 15 ],
  /*  948 */  [ 0.284202470, 15 ],
  /*  949 */  [ 0.284602263, 15 ],
  /*  950 */  [ 0.285002195, 15 ],
  /*  951 */  [ 0.285402269, 15 ],
  /*  952 */  [ 0.285802482, 15 ],
  /*  953 */  [ 0.286202836, 15 ],
  /*  954 */  [ 0.286603329, 15 ],
  /*  955 */  [ 0.287003963, 15 ],
  /*  956 */  [ 0.287404737, 15 ],
  /*  957 */  [ 0.287805650, 15 ],
  /*  958 */  [ 0.288206703, 15 ],
  /*  959 */  [ 0.288607895, 15 ],

  /*  960 */  [ 0.289009227, 15 ],
  /*  961 */  [ 0.289410699, 15 ],
  /*  962 */  [ 0.289812309, 15 ],
  /*  963 */  [ 0.290214059, 15 ],
  /*  964 */  [ 0.290615948, 15 ],
  /*  965 */  [ 0.291017976, 15 ],
  /*  966 */  [ 0.291420143, 15 ],
  /*  967 */  [ 0.291822449, 15 ],
  /*  968 */  [ 0.292224893, 15 ],
  /*  969 */  [ 0.292627476, 15 ],
  /*  970 */  [ 0.293030197, 15 ],
  /*  971 */  [ 0.293433057, 15 ],
  /*  972 */  [ 0.293836055, 15 ],
  /*  973 */  [ 0.294239192, 15 ],
  /*  974 */  [ 0.294642466, 15 ],
  /*  975 */  [ 0.295045879, 15 ],

  /*  976 */  [ 0.295449429, 15 ],
  /*  977 */  [ 0.295853118, 15 ],
  /*  978 */  [ 0.296256944, 15 ],
  /*  979 */  [ 0.296660907, 15 ],
  /*  980 */  [ 0.297065009, 15 ],
  /*  981 */  [ 0.297469248, 15 ],
  /*  982 */  [ 0.297873624, 15 ],
  /*  983 */  [ 0.298278137, 15 ],
  /*  984 */  [ 0.298682788, 15 ],
  /*  985 */  [ 0.299087576, 15 ],
  /*  986 */  [ 0.299492500, 15 ],
  /*  987 */  [ 0.299897562, 15 ],
  /*  988 */  [ 0.300302761, 15 ],
  /*  989 */  [ 0.300708096, 15 ],
  /*  990 */  [ 0.301113568, 15 ],
  /*  991 */  [ 0.301519176, 15 ],

  /*  992 */  [ 0.301924921, 15 ],
  /*  993 */  [ 0.302330802, 15 ],
  /*  994 */  [ 0.302736820, 15 ],
  /*  995 */  [ 0.303142973, 15 ],
  /*  996 */  [ 0.303549263, 15 ],
  /*  997 */  [ 0.303955689, 15 ],
  /*  998 */  [ 0.304362251, 15 ],
  /*  999 */  [ 0.304768948, 15 ],
  /* 1000 */  [ 0.305175781, 15 ],
  /* 1001 */  [ 0.305582750, 15 ],
  /* 1002 */  [ 0.305989854, 15 ],
  /* 1003 */  [ 0.306397094, 15 ],
  /* 1004 */  [ 0.306804470, 15 ],
  /* 1005 */  [ 0.307211980, 15 ],
  /* 1006 */  [ 0.307619626, 15 ],
  /* 1007 */  [ 0.308027406, 15 ],

  /* 1008 */  [ 0.308435322, 15 ],
  /* 1009 */  [ 0.308843373, 15 ],
  /* 1010 */  [ 0.309251558, 15 ],
  /* 1011 */  [ 0.309659879, 15 ],
  /* 1012 */  [ 0.310068333, 15 ],
  /* 1013 */  [ 0.310476923, 15 ],
  /* 1014 */  [ 0.310885647, 15 ],
  /* 1015 */  [ 0.311294505, 15 ],
  /* 1016 */  [ 0.311703498, 15 ],
  /* 1017 */  [ 0.312112625, 15 ],
  /* 1018 */  [ 0.312521885, 15 ],
  /* 1019 */  [ 0.312931280, 15 ],
  /* 1020 */  [ 0.313340809, 15 ],
  /* 1021 */  [ 0.313750472, 15 ],
  /* 1022 */  [ 0.314160269, 15 ],
  /* 1023 */  [ 0.314570199, 15 ],

  /* 1024 */  [ 0.314980262, 15 ],
  /* 1025 */  [ 0.315390460, 15 ],
  /* 1026 */  [ 0.315800790, 15 ],
  /* 1027 */  [ 0.316211255, 15 ],
  /* 1028 */  [ 0.316621852, 15 ],
  /* 1029 */  [ 0.317032582, 15 ],
  /* 1030 */  [ 0.317443446, 15 ],
  /* 1031 */  [ 0.317854442, 15 ],
  /* 1032 */  [ 0.318265572, 15 ],
  /* 1033 */  [ 0.318676834, 15 ],
  /* 1034 */  [ 0.319088229, 15 ],
  /* 1035 */  [ 0.319499756, 15 ],
  /* 1036 */  [ 0.319911417, 15 ],
  /* 1037 */  [ 0.320323209, 15 ],
  /* 1038 */  [ 0.320735134, 15 ],
  /* 1039 */  [ 0.321147192, 15 ],

  /* 1040 */  [ 0.321559381, 15 ],
  /* 1041 */  [ 0.321971703, 15 ],
  /* 1042 */  [ 0.322384156, 15 ],
  /* 1043 */  [ 0.322796742, 15 ],
  /* 1044 */  [ 0.323209460, 15 ],
  /* 1045 */  [ 0.323622309, 15 ],
  /* 1046 */  [ 0.324035290, 15 ],
  /* 1047 */  [ 0.324448403, 15 ],
  /* 1048 */  [ 0.324861647, 15 ],
  /* 1049 */  [ 0.325275023, 15 ],
  /* 1050 */  [ 0.325688530, 15 ],
  /* 1051 */  [ 0.326102168, 15 ],
  /* 1052 */  [ 0.326515938, 15 ],
  /* 1053 */  [ 0.326929839, 15 ],
  /* 1054 */  [ 0.327343870, 15 ],
  /* 1055 */  [ 0.327758033, 15 ],

  /* 1056 */  [ 0.328172327, 15 ],
  /* 1057 */  [ 0.328586751, 15 ],
  /* 1058 */  [ 0.329001306, 15 ],
  /* 1059 */  [ 0.329415992, 15 ],
  /* 1060 */  [ 0.329830808, 15 ],
  /* 1061 */  [ 0.330245755, 15 ],
  /* 1062 */  [ 0.330660832, 15 ],
  /* 1063 */  [ 0.331076039, 15 ],
  /* 1064 */  [ 0.331491377, 15 ],
  /* 1065 */  [ 0.331906845, 15 ],
  /* 1066 */  [ 0.332322443, 15 ],
  /* 1067 */  [ 0.332738170, 15 ],
  /* 1068 */  [ 0.333154028, 15 ],
  /* 1069 */  [ 0.333570016, 15 ],
  /* 1070 */  [ 0.333986133, 15 ],
  /* 1071 */  [ 0.334402380, 15 ],

  /* 1072 */  [ 0.334818756, 15 ],
  /* 1073 */  [ 0.335235262, 15 ],
  /* 1074 */  [ 0.335651898, 15 ],
  /* 1075 */  [ 0.336068662, 15 ],
  /* 1076 */  [ 0.336485556, 15 ],
  /* 1077 */  [ 0.336902579, 15 ],
  /* 1078 */  [ 0.337319732, 15 ],
  /* 1079 */  [ 0.337737013, 15 ],
  /* 1080 */  [ 0.338154423, 15 ],
  /* 1081 */  [ 0.338571962, 15 ],
  /* 1082 */  [ 0.338989630, 15 ],
  /* 1083 */  [ 0.339407426, 15 ],
  /* 1084 */  [ 0.339825351, 15 ],
  /* 1085 */  [ 0.340243405, 15 ],
  /* 1086 */  [ 0.340661587, 15 ],
  /* 1087 */  [ 0.341079898, 15 ],

  /* 1088 */  [ 0.341498336, 15 ],
  /* 1089 */  [ 0.341916903, 15 ],
  /* 1090 */  [ 0.342335598, 15 ],
  /* 1091 */  [ 0.342754421, 15 ],
  /* 1092 */  [ 0.343173373, 15 ],
  /* 1093 */  [ 0.343592452, 15 ],
  /* 1094 */  [ 0.344011659, 15 ],
  /* 1095 */  [ 0.344430993, 15 ],
  /* 1096 */  [ 0.344850455, 15 ],
  /* 1097 */  [ 0.345270045, 15 ],
  /* 1098 */  [ 0.345689763, 15 ],
  /* 1099 */  [ 0.346109608, 15 ],
  /* 1100 */  [ 0.346529580, 15 ],
  /* 1101 */  [ 0.346949679, 15 ],
  /* 1102 */  [ 0.347369906, 15 ],
  /* 1103 */  [ 0.347790260, 15 ],

  /* 1104 */  [ 0.348210741, 15 ],
  /* 1105 */  [ 0.348631348, 15 ],
  /* 1106 */  [ 0.349052083, 15 ],
  /* 1107 */  [ 0.349472945, 15 ],
  /* 1108 */  [ 0.349893933, 15 ],
  /* 1109 */  [ 0.350315048, 15 ],
  /* 1110 */  [ 0.350736290, 15 ],
  /* 1111 */  [ 0.351157658, 15 ],
  /* 1112 */  [ 0.351579152, 15 ],
  /* 1113 */  [ 0.352000773, 15 ],
  /* 1114 */  [ 0.352422520, 15 ],
  /* 1115 */  [ 0.352844394, 15 ],
  /* 1116 */  [ 0.353266393, 15 ],
  /* 1117 */  [ 0.353688519, 15 ],
  /* 1118 */  [ 0.354110771, 15 ],
  /* 1119 */  [ 0.354533148, 15 ],

  /* 1120 */  [ 0.354955651, 15 ],
  /* 1121 */  [ 0.355378281, 15 ],
  /* 1122 */  [ 0.355801035, 15 ],
  /* 1123 */  [ 0.356223916, 15 ],
  /* 1124 */  [ 0.356646922, 15 ],
  /* 1125 */  [ 0.357070053, 15 ],
  /* 1126 */  [ 0.357493310, 15 ],
  /* 1127 */  [ 0.357916692, 15 ],
  /* 1128 */  [ 0.358340200, 15 ],
  /* 1129 */  [ 0.358763832, 15 ],
  /* 1130 */  [ 0.359187590, 15 ],
  /* 1131 */  [ 0.359611472, 15 ],
  /* 1132 */  [ 0.360035480, 15 ],
  /* 1133 */  [ 0.360459613, 15 ],
  /* 1134 */  [ 0.360883870, 15 ],
  /* 1135 */  [ 0.361308252, 15 ],

  /* 1136 */  [ 0.361732758, 15 ],
  /* 1137 */  [ 0.362157390, 15 ],
  /* 1138 */  [ 0.362582145, 15 ],
  /* 1139 */  [ 0.363007026, 15 ],
  /* 1140 */  [ 0.363432030, 15 ],
  /* 1141 */  [ 0.363857159, 15 ],
  /* 1142 */  [ 0.364282412, 15 ],
  /* 1143 */  [ 0.364707789, 15 ],
  /* 1144 */  [ 0.365133291, 15 ],
  /* 1145 */  [ 0.365558916, 15 ],
  /* 1146 */  [ 0.365984665, 15 ],
  /* 1147 */  [ 0.366410538, 15 ],
  /* 1148 */  [ 0.366836535, 15 ],
  /* 1149 */  [ 0.367262655, 15 ],
  /* 1150 */  [ 0.367688900, 15 ],
  /* 1151 */  [ 0.368115267, 15 ],

  /* 1152 */  [ 0.368541759, 15 ],
  /* 1153 */  [ 0.368968373, 15 ],
  /* 1154 */  [ 0.369395111, 15 ],
  /* 1155 */  [ 0.369821973, 15 ],
  /* 1156 */  [ 0.370248957, 15 ],
  /* 1157 */  [ 0.370676065, 15 ],
  /* 1158 */  [ 0.371103295, 15 ],
  /* 1159 */  [ 0.371530649, 15 ],
  /* 1160 */  [ 0.371958126, 15 ],
  /* 1161 */  [ 0.372385725, 15 ],
  /* 1162 */  [ 0.372813448, 15 ],
  /* 1163 */  [ 0.373241292, 15 ],
  /* 1164 */  [ 0.373669260, 15 ],
  /* 1165 */  [ 0.374097350, 15 ],
  /* 1166 */  [ 0.374525563, 15 ],
  /* 1167 */  [ 0.374953898, 15 ],

  /* 1168 */  [ 0.375382356, 15 ],
  /* 1169 */  [ 0.375810936, 15 ],
  /* 1170 */  [ 0.376239638, 15 ],
  /* 1171 */  [ 0.376668462, 15 ],
  /* 1172 */  [ 0.377097408, 15 ],
  /* 1173 */  [ 0.377526476, 15 ],
  /* 1174 */  [ 0.377955667, 15 ],
  /* 1175 */  [ 0.378384979, 15 ],
  /* 1176 */  [ 0.378814413, 15 ],
  /* 1177 */  [ 0.379243968, 15 ],
  /* 1178 */  [ 0.379673646, 15 ],
  /* 1179 */  [ 0.380103444, 15 ],
  /* 1180 */  [ 0.380533365, 15 ],
  /* 1181 */  [ 0.380963407, 15 ],
  /* 1182 */  [ 0.381393570, 15 ],
  /* 1183 */  [ 0.381823855, 15 ],

  /* 1184 */  [ 0.382254261, 15 ],
  /* 1185 */  [ 0.382684788, 15 ],
  /* 1186 */  [ 0.383115436, 15 ],
  /* 1187 */  [ 0.383546205, 15 ],
  /* 1188 */  [ 0.383977096, 15 ],
  /* 1189 */  [ 0.384408107, 15 ],
  /* 1190 */  [ 0.384839239, 15 ],
  /* 1191 */  [ 0.385270492, 15 ],
  /* 1192 */  [ 0.385701865, 15 ],
  /* 1193 */  [ 0.386133359, 15 ],
  /* 1194 */  [ 0.386564974, 15 ],
  /* 1195 */  [ 0.386996709, 15 ],
  /* 1196 */  [ 0.387428565, 15 ],
  /* 1197 */  [ 0.387860541, 15 ],
  /* 1198 */  [ 0.388292637, 15 ],
  /* 1199 */  [ 0.388724854, 15 ],

  /* 1200 */  [ 0.389157191, 15 ],
  /* 1201 */  [ 0.389589648, 15 ],
  /* 1202 */  [ 0.390022225, 15 ],
  /* 1203 */  [ 0.390454922, 15 ],
  /* 1204 */  [ 0.390887739, 15 ],
  /* 1205 */  [ 0.391320675, 15 ],
  /* 1206 */  [ 0.391753732, 15 ],
  /* 1207 */  [ 0.392186908, 15 ],
  /* 1208 */  [ 0.392620204, 15 ],
  /* 1209 */  [ 0.393053619, 15 ],
  /* 1210 */  [ 0.393487154, 15 ],
  /* 1211 */  [ 0.393920808, 15 ],
  /* 1212 */  [ 0.394354582, 15 ],
  /* 1213 */  [ 0.394788475, 15 ],
  /* 1214 */  [ 0.395222488, 15 ],
  /* 1215 */  [ 0.395656619, 15 ],

  /* 1216 */  [ 0.396090870, 15 ],
  /* 1217 */  [ 0.396525239, 15 ],
  /* 1218 */  [ 0.396959728, 15 ],
  /* 1219 */  [ 0.397394336, 15 ],
  /* 1220 */  [ 0.397829062, 15 ],
  /* 1221 */  [ 0.398263907, 15 ],
  /* 1222 */  [ 0.398698871, 15 ],
  /* 1223 */  [ 0.399133954, 15 ],
  /* 1224 */  [ 0.399569155, 15 ],
  /* 1225 */  [ 0.400004475, 15 ],
  /* 1226 */  [ 0.400439913, 15 ],
  /* 1227 */  [ 0.400875470, 15 ],
  /* 1228 */  [ 0.401311145, 15 ],
  /* 1229 */  [ 0.401746938, 15 ],
  /* 1230 */  [ 0.402182850, 15 ],
  /* 1231 */  [ 0.402618879, 15 ],

  /* 1232 */  [ 0.403055027, 15 ],
  /* 1233 */  [ 0.403491293, 15 ],
  /* 1234 */  [ 0.403927676, 15 ],
  /* 1235 */  [ 0.404364178, 15 ],
  /* 1236 */  [ 0.404800797, 15 ],
  /* 1237 */  [ 0.405237535, 15 ],
  /* 1238 */  [ 0.405674390, 15 ],
  /* 1239 */  [ 0.406111362, 15 ],
  /* 1240 */  [ 0.406548452, 15 ],
  /* 1241 */  [ 0.406985660, 15 ],
  /* 1242 */  [ 0.407422985, 15 ],
  /* 1243 */  [ 0.407860427, 15 ],
  /* 1244 */  [ 0.408297987, 15 ],
  /* 1245 */  [ 0.408735664, 15 ],
  /* 1246 */  [ 0.409173458, 15 ],
  /* 1247 */  [ 0.409611370, 15 ],

  /* 1248 */  [ 0.410049398, 15 ],
  /* 1249 */  [ 0.410487544, 15 ],
  /* 1250 */  [ 0.410925806, 15 ],
  /* 1251 */  [ 0.411364185, 15 ],
  /* 1252 */  [ 0.411802681, 15 ],
  /* 1253 */  [ 0.412241294, 15 ],
  /* 1254 */  [ 0.412680024, 15 ],
  /* 1255 */  [ 0.413118870, 15 ],
  /* 1256 */  [ 0.413557833, 15 ],
  /* 1257 */  [ 0.413996912, 15 ],
  /* 1258 */  [ 0.414436108, 15 ],
  /* 1259 */  [ 0.414875420, 15 ],
  /* 1260 */  [ 0.415314849, 15 ],
  /* 1261 */  [ 0.415754393, 15 ],
  /* 1262 */  [ 0.416194054, 15 ],
  /* 1263 */  [ 0.416633831, 15 ],

  /* 1264 */  [ 0.417073724, 15 ],
  /* 1265 */  [ 0.417513734, 15 ],
  /* 1266 */  [ 0.417953859, 15 ],
  /* 1267 */  [ 0.418394100, 15 ],
  /* 1268 */  [ 0.418834457, 15 ],
  /* 1269 */  [ 0.419274929, 15 ],
  /* 1270 */  [ 0.419715518, 15 ],
  /* 1271 */  [ 0.420156222, 15 ],
  /* 1272 */  [ 0.420597041, 15 ],
  /* 1273 */  [ 0.421037977, 15 ],
  /* 1274 */  [ 0.421479027, 15 ],
  /* 1275 */  [ 0.421920193, 15 ],
  /* 1276 */  [ 0.422361475, 15 ],
  /* 1277 */  [ 0.422802871, 15 ],
  /* 1278 */  [ 0.423244383, 15 ],
  /* 1279 */  [ 0.423686010, 15 ],

  /* 1280 */  [ 0.424127753, 15 ],
  /* 1281 */  [ 0.424569610, 15 ],
  /* 1282 */  [ 0.425011582, 15 ],
  /* 1283 */  [ 0.425453669, 15 ],
  /* 1284 */  [ 0.425895871, 15 ],
  /* 1285 */  [ 0.426338188, 15 ],
  /* 1286 */  [ 0.426780620, 15 ],
  /* 1287 */  [ 0.427223166, 15 ],
  /* 1288 */  [ 0.427665827, 15 ],
  /* 1289 */  [ 0.428108603, 15 ],
  /* 1290 */  [ 0.428551493, 15 ],
  /* 1291 */  [ 0.428994497, 15 ],
  /* 1292 */  [ 0.429437616, 15 ],
  /* 1293 */  [ 0.429880849, 15 ],
  /* 1294 */  [ 0.430324197, 15 ],
  /* 1295 */  [ 0.430767659, 15 ],

  /* 1296 */  [ 0.431211234, 15 ],
  /* 1297 */  [ 0.431654924, 15 ],
  /* 1298 */  [ 0.432098728, 15 ],
  /* 1299 */  [ 0.432542647, 15 ],
  /* 1300 */  [ 0.432986678, 15 ],
  /* 1301 */  [ 0.433430824, 15 ],
  /* 1302 */  [ 0.433875084, 15 ],
  /* 1303 */  [ 0.434319457, 15 ],
  /* 1304 */  [ 0.434763944, 15 ],
  /* 1305 */  [ 0.435208545, 15 ],
  /* 1306 */  [ 0.435653259, 15 ],
  /* 1307 */  [ 0.436098087, 15 ],
  /* 1308 */  [ 0.436543029, 15 ],
  /* 1309 */  [ 0.436988083, 15 ],
  /* 1310 */  [ 0.437433251, 15 ],
  /* 1311 */  [ 0.437878533, 15 ],

  /* 1312 */  [ 0.438323927, 15 ],
  /* 1313 */  [ 0.438769435, 15 ],
  /* 1314 */  [ 0.439215056, 15 ],
  /* 1315 */  [ 0.439660790, 15 ],
  /* 1316 */  [ 0.440106636, 15 ],
  /* 1317 */  [ 0.440552596, 15 ],
  /* 1318 */  [ 0.440998669, 15 ],
  /* 1319 */  [ 0.441444855, 15 ],
  /* 1320 */  [ 0.441891153, 15 ],
  /* 1321 */  [ 0.442337564, 15 ],
  /* 1322 */  [ 0.442784088, 15 ],
  /* 1323 */  [ 0.443230724, 15 ],
  /* 1324 */  [ 0.443677473, 15 ],
  /* 1325 */  [ 0.444124334, 15 ],
  /* 1326 */  [ 0.444571308, 15 ],
  /* 1327 */  [ 0.445018394, 15 ],

  /* 1328 */  [ 0.445465593, 15 ],
  /* 1329 */  [ 0.445912903, 15 ],
  /* 1330 */  [ 0.446360326, 15 ],
  /* 1331 */  [ 0.446807861, 15 ],
  /* 1332 */  [ 0.447255509, 15 ],
  /* 1333 */  [ 0.447703268, 15 ],
  /* 1334 */  [ 0.448151139, 15 ],
  /* 1335 */  [ 0.448599122, 15 ],
  /* 1336 */  [ 0.449047217, 15 ],
  /* 1337 */  [ 0.449495424, 15 ],
  /* 1338 */  [ 0.449943742, 15 ],
  /* 1339 */  [ 0.450392173, 15 ],
  /* 1340 */  [ 0.450840715, 15 ],
  /* 1341 */  [ 0.451289368, 15 ],
  /* 1342 */  [ 0.451738133, 15 ],
  /* 1343 */  [ 0.452187010, 15 ],

  /* 1344 */  [ 0.452635998, 15 ],
  /* 1345 */  [ 0.453085097, 15 ],
  /* 1346 */  [ 0.453534308, 15 ],
  /* 1347 */  [ 0.453983630, 15 ],
  /* 1348 */  [ 0.454433063, 15 ],
  /* 1349 */  [ 0.454882607, 15 ],
  /* 1350 */  [ 0.455332262, 15 ],
  /* 1351 */  [ 0.455782029, 15 ],
  /* 1352 */  [ 0.456231906, 15 ],
  /* 1353 */  [ 0.456681894, 15 ],
  /* 1354 */  [ 0.457131993, 15 ],
  /* 1355 */  [ 0.457582203, 15 ],
  /* 1356 */  [ 0.458032524, 15 ],
  /* 1357 */  [ 0.458482956, 15 ],
  /* 1358 */  [ 0.458933498, 15 ],
  /* 1359 */  [ 0.459384151, 15 ],

  /* 1360 */  [ 0.459834914, 15 ],
  /* 1361 */  [ 0.460285788, 15 ],
  /* 1362 */  [ 0.460736772, 15 ],
  /* 1363 */  [ 0.461187867, 15 ],
  /* 1364 */  [ 0.461639071, 15 ],
  /* 1365 */  [ 0.462090387, 15 ],
  /* 1366 */  [ 0.462541812, 15 ],
  /* 1367 */  [ 0.462993348, 15 ],
  /* 1368 */  [ 0.463444993, 15 ],
  /* 1369 */  [ 0.463896749, 15 ],
  /* 1370 */  [ 0.464348615, 15 ],
  /* 1371 */  [ 0.464800591, 15 ],
  /* 1372 */  [ 0.465252676, 15 ],
  /* 1373 */  [ 0.465704872, 15 ],
  /* 1374 */  [ 0.466157177, 15 ],
  /* 1375 */  [ 0.466609592, 15 ],

  /* 1376 */  [ 0.467062117, 15 ],
  /* 1377 */  [ 0.467514751, 15 ],
  /* 1378 */  [ 0.467967495, 15 ],
  /* 1379 */  [ 0.468420349, 15 ],
  /* 1380 */  [ 0.468873312, 15 ],
  /* 1381 */  [ 0.469326384, 15 ],
  /* 1382 */  [ 0.469779566, 15 ],
  /* 1383 */  [ 0.470232857, 15 ],
  /* 1384 */  [ 0.470686258, 15 ],
  /* 1385 */  [ 0.471139767, 15 ],
  /* 1386 */  [ 0.471593386, 15 ],
  /* 1387 */  [ 0.472047114, 15 ],
  /* 1388 */  [ 0.472500951, 15 ],
  /* 1389 */  [ 0.472954896, 15 ],
  /* 1390 */  [ 0.473408951, 15 ],
  /* 1391 */  [ 0.473863115, 15 ],

  /* 1392 */  [ 0.474317388, 15 ],
  /* 1393 */  [ 0.474771769, 15 ],
  /* 1394 */  [ 0.475226259, 15 ],
  /* 1395 */  [ 0.475680858, 15 ],
  /* 1396 */  [ 0.476135565, 15 ],
  /* 1397 */  [ 0.476590381, 15 ],
  /* 1398 */  [ 0.477045306, 15 ],
  /* 1399 */  [ 0.477500339, 15 ],
  /* 1400 */  [ 0.477955481, 15 ],
  /* 1401 */  [ 0.478410731, 15 ],
  /* 1402 */  [ 0.478866089, 15 ],
  /* 1403 */  [ 0.479321555, 15 ],
  /* 1404 */  [ 0.479777130, 15 ],
  /* 1405 */  [ 0.480232813, 15 ],
  /* 1406 */  [ 0.480688604, 15 ],
  /* 1407 */  [ 0.481144503, 15 ],

  /* 1408 */  [ 0.481600510, 15 ],
  /* 1409 */  [ 0.482056625, 15 ],
  /* 1410 */  [ 0.482512848, 15 ],
  /* 1411 */  [ 0.482969179, 15 ],
  /* 1412 */  [ 0.483425618, 15 ],
  /* 1413 */  [ 0.483882164, 15 ],
  /* 1414 */  [ 0.484338818, 15 ],
  /* 1415 */  [ 0.484795580, 15 ],
  /* 1416 */  [ 0.485252449, 15 ],
  /* 1417 */  [ 0.485709426, 15 ],
  /* 1418 */  [ 0.486166511, 15 ],
  /* 1419 */  [ 0.486623703, 15 ],
  /* 1420 */  [ 0.487081002, 15 ],
  /* 1421 */  [ 0.487538409, 15 ],
  /* 1422 */  [ 0.487995923, 15 ],
  /* 1423 */  [ 0.488453544, 15 ],

  /* 1424 */  [ 0.488911273, 15 ],
  /* 1425 */  [ 0.489369108, 15 ],
  /* 1426 */  [ 0.489827051, 15 ],
  /* 1427 */  [ 0.490285101, 15 ],
  /* 1428 */  [ 0.490743258, 15 ],
  /* 1429 */  [ 0.491201522, 15 ],
  /* 1430 */  [ 0.491659892, 15 ],
  /* 1431 */  [ 0.492118370, 15 ],
  /* 1432 */  [ 0.492576954, 15 ],
  /* 1433 */  [ 0.493035645, 15 ],
  /* 1434 */  [ 0.493494443, 15 ],
  /* 1435 */  [ 0.493953348, 15 ],
  /* 1436 */  [ 0.494412359, 15 ],
  /* 1437 */  [ 0.494871476, 15 ],
  /* 1438 */  [ 0.495330701, 15 ],
  /* 1439 */  [ 0.495790031, 15 ],

  /* 1440 */  [ 0.496249468, 15 ],
  /* 1441 */  [ 0.496709012, 15 ],
  /* 1442 */  [ 0.497168662, 15 ],
  /* 1443 */  [ 0.497628418, 15 ],
  /* 1444 */  [ 0.498088280, 15 ],
  /* 1445 */  [ 0.498548248, 15 ],
  /* 1446 */  [ 0.499008323, 15 ],
  /* 1447 */  [ 0.499468503, 15 ],
  /* 1448 */  [ 0.499928790, 15 ],
  /* 1449 */  [ 0.250194591, 16 ],
  /* 1450 */  [ 0.250424840, 16 ],
  /* 1451 */  [ 0.250655143, 16 ],
  /* 1452 */  [ 0.250885498, 16 ],
  /* 1453 */  [ 0.251115906, 16 ],
  /* 1454 */  [ 0.251346367, 16 ],
  /* 1455 */  [ 0.251576880, 16 ],

  /* 1456 */  [ 0.251807447, 16 ],
  /* 1457 */  [ 0.252038066, 16 ],
  /* 1458 */  [ 0.252268738, 16 ],
  /* 1459 */  [ 0.252499463, 16 ],
  /* 1460 */  [ 0.252730240, 16 ],
  /* 1461 */  [ 0.252961071, 16 ],
  /* 1462 */  [ 0.253191953, 16 ],
  /* 1463 */  [ 0.253422889, 16 ],
  /* 1464 */  [ 0.253653877, 16 ],
  /* 1465 */  [ 0.253884918, 16 ],
  /* 1466 */  [ 0.254116011, 16 ],
  /* 1467 */  [ 0.254347157, 16 ],
  /* 1468 */  [ 0.254578356, 16 ],
  /* 1469 */  [ 0.254809606, 16 ],
  /* 1470 */  [ 0.255040910, 16 ],
  /* 1471 */  [ 0.255272266, 16 ],

  /* 1472 */  [ 0.255503674, 16 ],
  /* 1473 */  [ 0.255735135, 16 ],
  /* 1474 */  [ 0.255966648, 16 ],
  /* 1475 */  [ 0.256198213, 16 ],
  /* 1476 */  [ 0.256429831, 16 ],
  /* 1477 */  [ 0.256661501, 16 ],
  /* 1478 */  [ 0.256893223, 16 ],
  /* 1479 */  [ 0.257124998, 16 ],
  /* 1480 */  [ 0.257356825, 16 ],
  /* 1481 */  [ 0.257588704, 16 ],
  /* 1482 */  [ 0.257820635, 16 ],
  /* 1483 */  [ 0.258052619, 16 ],
  /* 1484 */  [ 0.258284654, 16 ],
  /* 1485 */  [ 0.258516742, 16 ],
  /* 1486 */  [ 0.258748882, 16 ],
  /* 1487 */  [ 0.258981074, 16 ],

  /* 1488 */  [ 0.259213318, 16 ],
  /* 1489 */  [ 0.259445614, 16 ],
  /* 1490 */  [ 0.259677962, 16 ],
  /* 1491 */  [ 0.259910362, 16 ],
  /* 1492 */  [ 0.260142814, 16 ],
  /* 1493 */  [ 0.260375318, 16 ],
  /* 1494 */  [ 0.260607874, 16 ],
  /* 1495 */  [ 0.260840481, 16 ],
  /* 1496 */  [ 0.261073141, 16 ],
  /* 1497 */  [ 0.261305852, 16 ],
  /* 1498 */  [ 0.261538616, 16 ],
  /* 1499 */  [ 0.261771431, 16 ],
  /* 1500 */  [ 0.262004297, 16 ],
  /* 1501 */  [ 0.262237216, 16 ],
  /* 1502 */  [ 0.262470186, 16 ],
  /* 1503 */  [ 0.262703208, 16 ],

  /* 1504 */  [ 0.262936282, 16 ],
  /* 1505 */  [ 0.263169407, 16 ],
  /* 1506 */  [ 0.263402584, 16 ],
  /* 1507 */  [ 0.263635813, 16 ],
  /* 1508 */  [ 0.263869093, 16 ],
  /* 1509 */  [ 0.264102425, 16 ],
  /* 1510 */  [ 0.264335808, 16 ],
  /* 1511 */  [ 0.264569243, 16 ],
  /* 1512 */  [ 0.264802730, 16 ],
  /* 1513 */  [ 0.265036267, 16 ],
  /* 1514 */  [ 0.265269857, 16 ],
  /* 1515 */  [ 0.265503498, 16 ],
  /* 1516 */  [ 0.265737190, 16 ],
  /* 1517 */  [ 0.265970933, 16 ],
  /* 1518 */  [ 0.266204728, 16 ],
  /* 1519 */  [ 0.266438574, 16 ],

  /* 1520 */  [ 0.266672472, 16 ],
  /* 1521 */  [ 0.266906421, 16 ],
  /* 1522 */  [ 0.267140421, 16 ],
  /* 1523 */  [ 0.267374472, 16 ],
  /* 1524 */  [ 0.267608575, 16 ],
  /* 1525 */  [ 0.267842729, 16 ],
  /* 1526 */  [ 0.268076934, 16 ],
  /* 1527 */  [ 0.268311190, 16 ],
  /* 1528 */  [ 0.268545497, 16 ],
  /* 1529 */  [ 0.268779856, 16 ],
  /* 1530 */  [ 0.269014265, 16 ],
  /* 1531 */  [ 0.269248726, 16 ],
  /* 1532 */  [ 0.269483238, 16 ],
  /* 1533 */  [ 0.269717800, 16 ],
  /* 1534 */  [ 0.269952414, 16 ],
  /* 1535 */  [ 0.270187079, 16 ],

  /* 1536 */  [ 0.270421794, 16 ],
  /* 1537 */  [ 0.270656561, 16 ],
  /* 1538 */  [ 0.270891379, 16 ],
  /* 1539 */  [ 0.271126247, 16 ],
  /* 1540 */  [ 0.271361166, 16 ],
  /* 1541 */  [ 0.271596136, 16 ],
  /* 1542 */  [ 0.271831157, 16 ],
  /* 1543 */  [ 0.272066229, 16 ],
  /* 1544 */  [ 0.272301352, 16 ],
  /* 1545 */  [ 0.272536525, 16 ],
  /* 1546 */  [ 0.272771749, 16 ],
  /* 1547 */  [ 0.273007024, 16 ],
  /* 1548 */  [ 0.273242350, 16 ],
  /* 1549 */  [ 0.273477726, 16 ],
  /* 1550 */  [ 0.273713153, 16 ],
  /* 1551 */  [ 0.273948630, 16 ],

  /* 1552 */  [ 0.274184158, 16 ],
  /* 1553 */  [ 0.274419737, 16 ],
  /* 1554 */  [ 0.274655366, 16 ],
  /* 1555 */  [ 0.274891046, 16 ],
  /* 1556 */  [ 0.275126776, 16 ],
  /* 1557 */  [ 0.275362557, 16 ],
  /* 1558 */  [ 0.275598389, 16 ],
  /* 1559 */  [ 0.275834270, 16 ],
  /* 1560 */  [ 0.276070203, 16 ],
  /* 1561 */  [ 0.276306185, 16 ],
  /* 1562 */  [ 0.276542218, 16 ],
  /* 1563 */  [ 0.276778302, 16 ],
  /* 1564 */  [ 0.277014435, 16 ],
  /* 1565 */  [ 0.277250619, 16 ],
  /* 1566 */  [ 0.277486854, 16 ],
  /* 1567 */  [ 0.277723139, 16 ],

  /* 1568 */  [ 0.277959474, 16 ],
  /* 1569 */  [ 0.278195859, 16 ],
  /* 1570 */  [ 0.278432294, 16 ],
  /* 1571 */  [ 0.278668780, 16 ],
  /* 1572 */  [ 0.278905316, 16 ],
  /* 1573 */  [ 0.279141902, 16 ],
  /* 1574 */  [ 0.279378538, 16 ],
  /* 1575 */  [ 0.279615224, 16 ],
  /* 1576 */  [ 0.279851960, 16 ],
  /* 1577 */  [ 0.280088747, 16 ],
  /* 1578 */  [ 0.280325583, 16 ],
  /* 1579 */  [ 0.280562470, 16 ],
  /* 1580 */  [ 0.280799406, 16 ],
  /* 1581 */  [ 0.281036393, 16 ],
  /* 1582 */  [ 0.281273429, 16 ],
  /* 1583 */  [ 0.281510516, 16 ],

  /* 1584 */  [ 0.281747652, 16 ],
  /* 1585 */  [ 0.281984838, 16 ],
  /* 1586 */  [ 0.282222075, 16 ],
  /* 1587 */  [ 0.282459361, 16 ],
  /* 1588 */  [ 0.282696697, 16 ],
  /* 1589 */  [ 0.282934082, 16 ],
  /* 1590 */  [ 0.283171518, 16 ],
  /* 1591 */  [ 0.283409003, 16 ],
  /* 1592 */  [ 0.283646538, 16 ],
  /* 1593 */  [ 0.283884123, 16 ],
  /* 1594 */  [ 0.284121757, 16 ],
  /* 1595 */  [ 0.284359441, 16 ],
  /* 1596 */  [ 0.284597175, 16 ],
  /* 1597 */  [ 0.284834959, 16 ],
  /* 1598 */  [ 0.285072792, 16 ],
  /* 1599 */  [ 0.285310675, 16 ],

  /* 1600 */  [ 0.285548607, 16 ],
  /* 1601 */  [ 0.285786589, 16 ],
  /* 1602 */  [ 0.286024621, 16 ],
  /* 1603 */  [ 0.286262702, 16 ],
  /* 1604 */  [ 0.286500832, 16 ],
  /* 1605 */  [ 0.286739012, 16 ],
  /* 1606 */  [ 0.286977242, 16 ],
  /* 1607 */  [ 0.287215521, 16 ],
  /* 1608 */  [ 0.287453849, 16 ],
  /* 1609 */  [ 0.287692227, 16 ],
  /* 1610 */  [ 0.287930654, 16 ],
  /* 1611 */  [ 0.288169131, 16 ],
  /* 1612 */  [ 0.288407657, 16 ],
  /* 1613 */  [ 0.288646232, 16 ],
  /* 1614 */  [ 0.288884857, 16 ],
  /* 1615 */  [ 0.289123530, 16 ],

  /* 1616 */  [ 0.289362253, 16 ],
  /* 1617 */  [ 0.289601026, 16 ],
  /* 1618 */  [ 0.289839847, 16 ],
  /* 1619 */  [ 0.290078718, 16 ],
  /* 1620 */  [ 0.290317638, 16 ],
  /* 1621 */  [ 0.290556607, 16 ],
  /* 1622 */  [ 0.290795626, 16 ],
  /* 1623 */  [ 0.291034693, 16 ],
  /* 1624 */  [ 0.291273810, 16 ],
  /* 1625 */  [ 0.291512975, 16 ],
  /* 1626 */  [ 0.291752190, 16 ],
  /* 1627 */  [ 0.291991453, 16 ],
  /* 1628 */  [ 0.292230766, 16 ],
  /* 1629 */  [ 0.292470128, 16 ],
  /* 1630 */  [ 0.292709539, 16 ],
  /* 1631 */  [ 0.292948998, 16 ],

  /* 1632 */  [ 0.293188507, 16 ],
  /* 1633 */  [ 0.293428065, 16 ],
  /* 1634 */  [ 0.293667671, 16 ],
  /* 1635 */  [ 0.293907326, 16 ],
  /* 1636 */  [ 0.294147031, 16 ],
  /* 1637 */  [ 0.294386784, 16 ],
  /* 1638 */  [ 0.294626585, 16 ],
  /* 1639 */  [ 0.294866436, 16 ],
  /* 1640 */  [ 0.295106336, 16 ],
  /* 1641 */  [ 0.295346284, 16 ],
  /* 1642 */  [ 0.295586281, 16 ],
  /* 1643 */  [ 0.295826327, 16 ],
  /* 1644 */  [ 0.296066421, 16 ],
  /* 1645 */  [ 0.296306564, 16 ],
  /* 1646 */  [ 0.296546756, 16 ],
  /* 1647 */  [ 0.296786996, 16 ],

  /* 1648 */  [ 0.297027285, 16 ],
  /* 1649 */  [ 0.297267623, 16 ],
  /* 1650 */  [ 0.297508009, 16 ],
  /* 1651 */  [ 0.297748444, 16 ],
  /* 1652 */  [ 0.297988927, 16 ],
  /* 1653 */  [ 0.298229459, 16 ],
  /* 1654 */  [ 0.298470039, 16 ],
  /* 1655 */  [ 0.298710668, 16 ],
  /* 1656 */  [ 0.298951346, 16 ],
  /* 1657 */  [ 0.299192071, 16 ],
  /* 1658 */  [ 0.299432846, 16 ],
  /* 1659 */  [ 0.299673668, 16 ],
  /* 1660 */  [ 0.299914539, 16 ],
  /* 1661 */  [ 0.300155459, 16 ],
  /* 1662 */  [ 0.300396426, 16 ],
  /* 1663 */  [ 0.300637443, 16 ],

  /* 1664 */  [ 0.300878507, 16 ],
  /* 1665 */  [ 0.301119620, 16 ],
  /* 1666 */  [ 0.301360781, 16 ],
  /* 1667 */  [ 0.301601990, 16 ],
  /* 1668 */  [ 0.301843247, 16 ],
  /* 1669 */  [ 0.302084553, 16 ],
  /* 1670 */  [ 0.302325907, 16 ],
  /* 1671 */  [ 0.302567309, 16 ],
  /* 1672 */  [ 0.302808759, 16 ],
  /* 1673 */  [ 0.303050257, 16 ],
  /* 1674 */  [ 0.303291804, 16 ],
  /* 1675 */  [ 0.303533399, 16 ],
  /* 1676 */  [ 0.303775041, 16 ],
  /* 1677 */  [ 0.304016732, 16 ],
  /* 1678 */  [ 0.304258471, 16 ],
  /* 1679 */  [ 0.304500257, 16 ],

  /* 1680 */  [ 0.304742092, 16 ],
  /* 1681 */  [ 0.304983975, 16 ],
  /* 1682 */  [ 0.305225906, 16 ],
  /* 1683 */  [ 0.305467885, 16 ],
  /* 1684 */  [ 0.305709911, 16 ],
  /* 1685 */  [ 0.305951986, 16 ],
  /* 1686 */  [ 0.306194108, 16 ],
  /* 1687 */  [ 0.306436279, 16 ],
  /* 1688 */  [ 0.306678497, 16 ],
  /* 1689 */  [ 0.306920763, 16 ],
  /* 1690 */  [ 0.307163077, 16 ],
  /* 1691 */  [ 0.307405438, 16 ],
  /* 1692 */  [ 0.307647848, 16 ],
  /* 1693 */  [ 0.307890305, 16 ],
  /* 1694 */  [ 0.308132810, 16 ],
  /* 1695 */  [ 0.308375362, 16 ],

  /* 1696 */  [ 0.308617963, 16 ],
  /* 1697 */  [ 0.308860611, 16 ],
  /* 1698 */  [ 0.309103306, 16 ],
  /* 1699 */  [ 0.309346050, 16 ],
  /* 1700 */  [ 0.309588841, 16 ],
  /* 1701 */  [ 0.309831679, 16 ],
  /* 1702 */  [ 0.310074565, 16 ],
  /* 1703 */  [ 0.310317499, 16 ],
  /* 1704 */  [ 0.310560480, 16 ],
  /* 1705 */  [ 0.310803509, 16 ],
  /* 1706 */  [ 0.311046586, 16 ],
  /* 1707 */  [ 0.311289710, 16 ],
  /* 1708 */  [ 0.311532881, 16 ],
  /* 1709 */  [ 0.311776100, 16 ],
  /* 1710 */  [ 0.312019366, 16 ],
  /* 1711 */  [ 0.312262680, 16 ],

  /* 1712 */  [ 0.312506041, 16 ],
  /* 1713 */  [ 0.312749449, 16 ],
  /* 1714 */  [ 0.312992905, 16 ],
  /* 1715 */  [ 0.313236408, 16 ],
  /* 1716 */  [ 0.313479959, 16 ],
  /* 1717 */  [ 0.313723556, 16 ],
  /* 1718 */  [ 0.313967202, 16 ],
  /* 1719 */  [ 0.314210894, 16 ],
  /* 1720 */  [ 0.314454634, 16 ],
  /* 1721 */  [ 0.314698420, 16 ],
  /* 1722 */  [ 0.314942255, 16 ],
  /* 1723 */  [ 0.315186136, 16 ],
  /* 1724 */  [ 0.315430064, 16 ],
  /* 1725 */  [ 0.315674040, 16 ],
  /* 1726 */  [ 0.315918063, 16 ],
  /* 1727 */  [ 0.316162133, 16 ],

  /* 1728 */  [ 0.316406250, 16 ],
  /* 1729 */  [ 0.316650414, 16 ],
  /* 1730 */  [ 0.316894625, 16 ],
  /* 1731 */  [ 0.317138884, 16 ],
  /* 1732 */  [ 0.317383189, 16 ],
  /* 1733 */  [ 0.317627541, 16 ],
  /* 1734 */  [ 0.317871941, 16 ],
  /* 1735 */  [ 0.318116387, 16 ],
  /* 1736 */  [ 0.318360880, 16 ],
  /* 1737 */  [ 0.318605421, 16 ],
  /* 1738 */  [ 0.318850008, 16 ],
  /* 1739 */  [ 0.319094642, 16 ],
  /* 1740 */  [ 0.319339323, 16 ],
  /* 1741 */  [ 0.319584051, 16 ],
  /* 1742 */  [ 0.319828826, 16 ],
  /* 1743 */  [ 0.320073647, 16 ],

  /* 1744 */  [ 0.320318516, 16 ],
  /* 1745 */  [ 0.320563431, 16 ],
  /* 1746 */  [ 0.320808393, 16 ],
  /* 1747 */  [ 0.321053402, 16 ],
  /* 1748 */  [ 0.321298457, 16 ],
  /* 1749 */  [ 0.321543560, 16 ],
  /* 1750 */  [ 0.321788709, 16 ],
  /* 1751 */  [ 0.322033904, 16 ],
  /* 1752 */  [ 0.322279147, 16 ],
  /* 1753 */  [ 0.322524436, 16 ],
  /* 1754 */  [ 0.322769771, 16 ],
  /* 1755 */  [ 0.323015154, 16 ],
  /* 1756 */  [ 0.323260583, 16 ],
  /* 1757 */  [ 0.323506058, 16 ],
  /* 1758 */  [ 0.323751580, 16 ],
  /* 1759 */  [ 0.323997149, 16 ],

  /* 1760 */  [ 0.324242764, 16 ],
  /* 1761 */  [ 0.324488426, 16 ],
  /* 1762 */  [ 0.324734134, 16 ],
  /* 1763 */  [ 0.324979889, 16 ],
  /* 1764 */  [ 0.325225690, 16 ],
  /* 1765 */  [ 0.325471538, 16 ],
  /* 1766 */  [ 0.325717432, 16 ],
  /* 1767 */  [ 0.325963372, 16 ],
  /* 1768 */  [ 0.326209359, 16 ],
  /* 1769 */  [ 0.326455392, 16 ],
  /* 1770 */  [ 0.326701472, 16 ],
  /* 1771 */  [ 0.326947598, 16 ],
  /* 1772 */  [ 0.327193770, 16 ],
  /* 1773 */  [ 0.327439989, 16 ],
  /* 1774 */  [ 0.327686254, 16 ],
  /* 1775 */  [ 0.327932565, 16 ],

  /* 1776 */  [ 0.328178922, 16 ],
  /* 1777 */  [ 0.328425326, 16 ],
  /* 1778 */  [ 0.328671776, 16 ],
  /* 1779 */  [ 0.328918272, 16 ],
  /* 1780 */  [ 0.329164814, 16 ],
  /* 1781 */  [ 0.329411403, 16 ],
  /* 1782 */  [ 0.329658038, 16 ],
  /* 1783 */  [ 0.329904718, 16 ],
  /* 1784 */  [ 0.330151445, 16 ],
  /* 1785 */  [ 0.330398218, 16 ],
  /* 1786 */  [ 0.330645037, 16 ],
  /* 1787 */  [ 0.330891903, 16 ],
  /* 1788 */  [ 0.331138814, 16 ],
  /* 1789 */  [ 0.331385771, 16 ],
  /* 1790 */  [ 0.331632774, 16 ],
  /* 1791 */  [ 0.331879824, 16 ],

  /* 1792 */  [ 0.332126919, 16 ],
  /* 1793 */  [ 0.332374060, 16 ],
  /* 1794 */  [ 0.332621247, 16 ],
  /* 1795 */  [ 0.332868480, 16 ],
  /* 1796 */  [ 0.333115759, 16 ],
  /* 1797 */  [ 0.333363084, 16 ],
  /* 1798 */  [ 0.333610455, 16 ],
  /* 1799 */  [ 0.333857872, 16 ],
  /* 1800 */  [ 0.334105334, 16 ],
  /* 1801 */  [ 0.334352843, 16 ],
  /* 1802 */  [ 0.334600397, 16 ],
  /* 1803 */  [ 0.334847997, 16 ],
  /* 1804 */  [ 0.335095642, 16 ],
  /* 1805 */  [ 0.335343334, 16 ],
  /* 1806 */  [ 0.335591071, 16 ],
  /* 1807 */  [ 0.335838854, 16 ],

  /* 1808 */  [ 0.336086683, 16 ],
  /* 1809 */  [ 0.336334557, 16 ],
  /* 1810 */  [ 0.336582477, 16 ],
  /* 1811 */  [ 0.336830443, 16 ],
  /* 1812 */  [ 0.337078454, 16 ],
  /* 1813 */  [ 0.337326511, 16 ],
  /* 1814 */  [ 0.337574614, 16 ],
  /* 1815 */  [ 0.337822762, 16 ],
  /* 1816 */  [ 0.338070956, 16 ],
  /* 1817 */  [ 0.338319195, 16 ],
  /* 1818 */  [ 0.338567480, 16 ],
  /* 1819 */  [ 0.338815811, 16 ],
  /* 1820 */  [ 0.339064186, 16 ],
  /* 1821 */  [ 0.339312608, 16 ],
  /* 1822 */  [ 0.339561075, 16 ],
  /* 1823 */  [ 0.339809587, 16 ],

  /* 1824 */  [ 0.340058145, 16 ],
  /* 1825 */  [ 0.340306748, 16 ],
  /* 1826 */  [ 0.340555397, 16 ],
  /* 1827 */  [ 0.340804091, 16 ],
  /* 1828 */  [ 0.341052830, 16 ],
  /* 1829 */  [ 0.341301615, 16 ],
  /* 1830 */  [ 0.341550445, 16 ],
  /* 1831 */  [ 0.341799321, 16 ],
  /* 1832 */  [ 0.342048241, 16 ],
  /* 1833 */  [ 0.342297207, 16 ],
  /* 1834 */  [ 0.342546219, 16 ],
  /* 1835 */  [ 0.342795275, 16 ],
  /* 1836 */  [ 0.343044377, 16 ],
  /* 1837 */  [ 0.343293524, 16 ],
  /* 1838 */  [ 0.343542717, 16 ],
  /* 1839 */  [ 0.343791954, 16 ],

  /* 1840 */  [ 0.344041237, 16 ],
  /* 1841 */  [ 0.344290564, 16 ],
  /* 1842 */  [ 0.344539937, 16 ],
  /* 1843 */  [ 0.344789356, 16 ],
  /* 1844 */  [ 0.345038819, 16 ],
  /* 1845 */  [ 0.345288327, 16 ],
  /* 1846 */  [ 0.345537880, 16 ],
  /* 1847 */  [ 0.345787479, 16 ],
  /* 1848 */  [ 0.346037122, 16 ],
  /* 1849 */  [ 0.346286811, 16 ],
  /* 1850 */  [ 0.346536545, 16 ],
  /* 1851 */  [ 0.346786323, 16 ],
  /* 1852 */  [ 0.347036147, 16 ],
  /* 1853 */  [ 0.347286015, 16 ],
  /* 1854 */  [ 0.347535929, 16 ],
  /* 1855 */  [ 0.347785887, 16 ],

  /* 1856 */  [ 0.348035890, 16 ],
  /* 1857 */  [ 0.348285939, 16 ],
  /* 1858 */  [ 0.348536032, 16 ],
  /* 1859 */  [ 0.348786170, 16 ],
  /* 1860 */  [ 0.349036353, 16 ],
  /* 1861 */  [ 0.349286580, 16 ],
  /* 1862 */  [ 0.349536853, 16 ],
  /* 1863 */  [ 0.349787170, 16 ],
  /* 1864 */  [ 0.350037532, 16 ],
  /* 1865 */  [ 0.350287939, 16 ],
  /* 1866 */  [ 0.350538391, 16 ],
  /* 1867 */  [ 0.350788887, 16 ],
  /* 1868 */  [ 0.351039428, 16 ],
  /* 1869 */  [ 0.351290014, 16 ],
  /* 1870 */  [ 0.351540645, 16 ],
  /* 1871 */  [ 0.351791320, 16 ],

  /* 1872 */  [ 0.352042040, 16 ],
  /* 1873 */  [ 0.352292804, 16 ],
  /* 1874 */  [ 0.352543613, 16 ],
  /* 1875 */  [ 0.352794467, 16 ],
  /* 1876 */  [ 0.353045365, 16 ],
  /* 1877 */  [ 0.353296308, 16 ],
  /* 1878 */  [ 0.353547296, 16 ],
  /* 1879 */  [ 0.353798328, 16 ],
  /* 1880 */  [ 0.354049405, 16 ],
  /* 1881 */  [ 0.354300526, 16 ],
  /* 1882 */  [ 0.354551691, 16 ],
  /* 1883 */  [ 0.354802901, 16 ],
  /* 1884 */  [ 0.355054156, 16 ],
  /* 1885 */  [ 0.355305455, 16 ],
  /* 1886 */  [ 0.355556799, 16 ],
  /* 1887 */  [ 0.355808187, 16 ],

  /* 1888 */  [ 0.356059619, 16 ],
  /* 1889 */  [ 0.356311096, 16 ],
  /* 1890 */  [ 0.356562617, 16 ],
  /* 1891 */  [ 0.356814182, 16 ],
  /* 1892 */  [ 0.357065792, 16 ],
  /* 1893 */  [ 0.357317446, 16 ],
  /* 1894 */  [ 0.357569145, 16 ],
  /* 1895 */  [ 0.357820887, 16 ],
  /* 1896 */  [ 0.358072674, 16 ],
  /* 1897 */  [ 0.358324506, 16 ],
  /* 1898 */  [ 0.358576381, 16 ],
  /* 1899 */  [ 0.358828301, 16 ],
  /* 1900 */  [ 0.359080265, 16 ],
  /* 1901 */  [ 0.359332273, 16 ],
  /* 1902 */  [ 0.359584326, 16 ],
  /* 1903 */  [ 0.359836423, 16 ],

  /* 1904 */  [ 0.360088563, 16 ],
  /* 1905 */  [ 0.360340748, 16 ],
  /* 1906 */  [ 0.360592977, 16 ],
  /* 1907 */  [ 0.360845251, 16 ],
  /* 1908 */  [ 0.361097568, 16 ],
  /* 1909 */  [ 0.361349929, 16 ],
  /* 1910 */  [ 0.361602335, 16 ],
  /* 1911 */  [ 0.361854784, 16 ],
  /* 1912 */  [ 0.362107278, 16 ],
  /* 1913 */  [ 0.362359815, 16 ],
  /* 1914 */  [ 0.362612397, 16 ],
  /* 1915 */  [ 0.362865022, 16 ],
  /* 1916 */  [ 0.363117692, 16 ],
  /* 1917 */  [ 0.363370405, 16 ],
  /* 1918 */  [ 0.363623163, 16 ],
  /* 1919 */  [ 0.363875964, 16 ],

  /* 1920 */  [ 0.364128809, 16 ],
  /* 1921 */  [ 0.364381698, 16 ],
  /* 1922 */  [ 0.364634632, 16 ],
  /* 1923 */  [ 0.364887608, 16 ],
  /* 1924 */  [ 0.365140629, 16 ],
  /* 1925 */  [ 0.365393694, 16 ],
  /* 1926 */  [ 0.365646802, 16 ],
  /* 1927 */  [ 0.365899955, 16 ],
  /* 1928 */  [ 0.366153151, 16 ],
  /* 1929 */  [ 0.366406390, 16 ],
  /* 1930 */  [ 0.366659674, 16 ],
  /* 1931 */  [ 0.366913001, 16 ],
  /* 1932 */  [ 0.367166372, 16 ],
  /* 1933 */  [ 0.367419787, 16 ],
  /* 1934 */  [ 0.367673246, 16 ],
  /* 1935 */  [ 0.367926748, 16 ],

  /* 1936 */  [ 0.368180294, 16 ],
  /* 1937 */  [ 0.368433883, 16 ],
  /* 1938 */  [ 0.368687517, 16 ],
  /* 1939 */  [ 0.368941193, 16 ],
  /* 1940 */  [ 0.369194914, 16 ],
  /* 1941 */  [ 0.369448678, 16 ],
  /* 1942 */  [ 0.369702485, 16 ],
  /* 1943 */  [ 0.369956336, 16 ],
  /* 1944 */  [ 0.370210231, 16 ],
  /* 1945 */  [ 0.370464169, 16 ],
  /* 1946 */  [ 0.370718151, 16 ],
  /* 1947 */  [ 0.370972177, 16 ],
  /* 1948 */  [ 0.371226245, 16 ],
  /* 1949 */  [ 0.371480358, 16 ],
  /* 1950 */  [ 0.371734513, 16 ],
  /* 1951 */  [ 0.371988712, 16 ],

  /* 1952 */  [ 0.372242955, 16 ],
  /* 1953 */  [ 0.372497241, 16 ],
  /* 1954 */  [ 0.372751570, 16 ],
  /* 1955 */  [ 0.373005943, 16 ],
  /* 1956 */  [ 0.373260359, 16 ],
  /* 1957 */  [ 0.373514819, 16 ],
  /* 1958 */  [ 0.373769322, 16 ],
  /* 1959 */  [ 0.374023868, 16 ],
  /* 1960 */  [ 0.374278458, 16 ],
  /* 1961 */  [ 0.374533091, 16 ],
  /* 1962 */  [ 0.374787767, 16 ],
  /* 1963 */  [ 0.375042486, 16 ],
  /* 1964 */  [ 0.375297249, 16 ],
  /* 1965 */  [ 0.375552055, 16 ],
  /* 1966 */  [ 0.375806904, 16 ],
  /* 1967 */  [ 0.376061796, 16 ],

  /* 1968 */  [ 0.376316732, 16 ],
  /* 1969 */  [ 0.376571710, 16 ],
  /* 1970 */  [ 0.376826732, 16 ],
  /* 1971 */  [ 0.377081797, 16 ],
  /* 1972 */  [ 0.377336905, 16 ],
  /* 1973 */  [ 0.377592057, 16 ],
  /* 1974 */  [ 0.377847251, 16 ],
  /* 1975 */  [ 0.378102489, 16 ],
  /* 1976 */  [ 0.378357769, 16 ],
  /* 1977 */  [ 0.378613093, 16 ],
  /* 1978 */  [ 0.378868460, 16 ],
  /* 1979 */  [ 0.379123870, 16 ],
  /* 1980 */  [ 0.379379322, 16 ],
  /* 1981 */  [ 0.379634818, 16 ],
  /* 1982 */  [ 0.379890357, 16 ],
  /* 1983 */  [ 0.380145939, 16 ],

  /* 1984 */  [ 0.380401563, 16 ],
  /* 1985 */  [ 0.380657231, 16 ],
  /* 1986 */  [ 0.380912942, 16 ],
  /* 1987 */  [ 0.381168695, 16 ],
  /* 1988 */  [ 0.381424492, 16 ],
  /* 1989 */  [ 0.381680331, 16 ],
  /* 1990 */  [ 0.381936213, 16 ],
  /* 1991 */  [ 0.382192138, 16 ],
  /* 1992 */  [ 0.382448106, 16 ],
  /* 1993 */  [ 0.382704117, 16 ],
  /* 1994 */  [ 0.382960171, 16 ],
  /* 1995 */  [ 0.383216267, 16 ],
  /* 1996 */  [ 0.383472406, 16 ],
  /* 1997 */  [ 0.383728588, 16 ],
  /* 1998 */  [ 0.383984813, 16 ],
  /* 1999 */  [ 0.384241080, 16 ],

  /* 2000 */  [ 0.384497391, 16 ],
  /* 2001 */  [ 0.384753744, 16 ],
  /* 2002 */  [ 0.385010139, 16 ],
  /* 2003 */  [ 0.385266578, 16 ],
  /* 2004 */  [ 0.385523059, 16 ],
  /* 2005 */  [ 0.385779582, 16 ],
  /* 2006 */  [ 0.386036149, 16 ],
  /* 2007 */  [ 0.386292758, 16 ],
  /* 2008 */  [ 0.386549409, 16 ],
  /* 2009 */  [ 0.386806104, 16 ],
  /* 2010 */  [ 0.387062840, 16 ],
  /* 2011 */  [ 0.387319620, 16 ],
  /* 2012 */  [ 0.387576442, 16 ],
  /* 2013 */  [ 0.387833306, 16 ],
  /* 2014 */  [ 0.388090213, 16 ],
  /* 2015 */  [ 0.388347163, 16 ],

  /* 2016 */  [ 0.388604155, 16 ],
  /* 2017 */  [ 0.388861190, 16 ],
  /* 2018 */  [ 0.389118267, 16 ],
  /* 2019 */  [ 0.389375386, 16 ],
  /* 2020 */  [ 0.389632548, 16 ],
  /* 2021 */  [ 0.389889752, 16 ],
  /* 2022 */  [ 0.390146999, 16 ],
  /* 2023 */  [ 0.390404289, 16 ],
  /* 2024 */  [ 0.390661620, 16 ],
  /* 2025 */  [ 0.390918994, 16 ],
  /* 2026 */  [ 0.391176411, 16 ],
  /* 2027 */  [ 0.391433869, 16 ],
  /* 2028 */  [ 0.391691371, 16 ],
  /* 2029 */  [ 0.391948914, 16 ],
  /* 2030 */  [ 0.392206500, 16 ],
  /* 2031 */  [ 0.392464128, 16 ],

  /* 2032 */  [ 0.392721798, 16 ],
  /* 2033 */  [ 0.392979511, 16 ],
  /* 2034 */  [ 0.393237266, 16 ],
  /* 2035 */  [ 0.393495063, 16 ],
  /* 2036 */  [ 0.393752902, 16 ],
  /* 2037 */  [ 0.394010784, 16 ],
  /* 2038 */  [ 0.394268707, 16 ],
  /* 2039 */  [ 0.394526673, 16 ],
  /* 2040 */  [ 0.394784681, 16 ],
  /* 2041 */  [ 0.395042732, 16 ],
  /* 2042 */  [ 0.395300824, 16 ],
  /* 2043 */  [ 0.395558959, 16 ],
  /* 2044 */  [ 0.395817135, 16 ],
  /* 2045 */  [ 0.396075354, 16 ],
  /* 2046 */  [ 0.396333615, 16 ],
  /* 2047 */  [ 0.396591918, 16 ],

  /* 2048 */  [ 0.396850263, 16 ],
  /* 2049 */  [ 0.397108650, 16 ],
  /* 2050 */  [ 0.397367079, 16 ],
  /* 2051 */  [ 0.397625550, 16 ],
  /* 2052 */  [ 0.397884063, 16 ],
  /* 2053 */  [ 0.398142619, 16 ],
  /* 2054 */  [ 0.398401216, 16 ],
  /* 2055 */  [ 0.398659855, 16 ],
  /* 2056 */  [ 0.398918536, 16 ],
  /* 2057 */  [ 0.399177259, 16 ],
  /* 2058 */  [ 0.399436024, 16 ],
  /* 2059 */  [ 0.399694831, 16 ],
  /* 2060 */  [ 0.399953679, 16 ],
  /* 2061 */  [ 0.400212570, 16 ],
  /* 2062 */  [ 0.400471503, 16 ],
  /* 2063 */  [ 0.400730477, 16 ],

  /* 2064 */  [ 0.400989493, 16 ],
  /* 2065 */  [ 0.401248551, 16 ],
  /* 2066 */  [ 0.401507651, 16 ],
  /* 2067 */  [ 0.401766793, 16 ],
  /* 2068 */  [ 0.402025976, 16 ],
  /* 2069 */  [ 0.402285202, 16 ],
  /* 2070 */  [ 0.402544469, 16 ],
  /* 2071 */  [ 0.402803777, 16 ],
  /* 2072 */  [ 0.403063128, 16 ],
  /* 2073 */  [ 0.403322520, 16 ],
  /* 2074 */  [ 0.403581954, 16 ],
  /* 2075 */  [ 0.403841430, 16 ],
  /* 2076 */  [ 0.404100947, 16 ],
  /* 2077 */  [ 0.404360506, 16 ],
  /* 2078 */  [ 0.404620107, 16 ],
  /* 2079 */  [ 0.404879749, 16 ],

  /* 2080 */  [ 0.405139433, 16 ],
  /* 2081 */  [ 0.405399159, 16 ],
  /* 2082 */  [ 0.405658926, 16 ],
  /* 2083 */  [ 0.405918735, 16 ],
  /* 2084 */  [ 0.406178585, 16 ],
  /* 2085 */  [ 0.406438477, 16 ],
  /* 2086 */  [ 0.406698410, 16 ],
  /* 2087 */  [ 0.406958385, 16 ],
  /* 2088 */  [ 0.407218402, 16 ],
  /* 2089 */  [ 0.407478460, 16 ],
  /* 2090 */  [ 0.407738559, 16 ],
  /* 2091 */  [ 0.407998700, 16 ],
  /* 2092 */  [ 0.408258883, 16 ],
  /* 2093 */  [ 0.408519107, 16 ],
  /* 2094 */  [ 0.408779372, 16 ],
  /* 2095 */  [ 0.409039679, 16 ],

  /* 2096 */  [ 0.409300027, 16 ],
  /* 2097 */  [ 0.409560417, 16 ],
  /* 2098 */  [ 0.409820848, 16 ],
  /* 2099 */  [ 0.410081321, 16 ],
  /* 2100 */  [ 0.410341834, 16 ],
  /* 2101 */  [ 0.410602390, 16 ],
  /* 2102 */  [ 0.410862986, 16 ],
  /* 2103 */  [ 0.411123624, 16 ],
  /* 2104 */  [ 0.411384303, 16 ],
  /* 2105 */  [ 0.411645024, 16 ],
  /* 2106 */  [ 0.411905785, 16 ],
  /* 2107 */  [ 0.412166588, 16 ],
  /* 2108 */  [ 0.412427433, 16 ],
  /* 2109 */  [ 0.412688318, 16 ],
  /* 2110 */  [ 0.412949245, 16 ],
  /* 2111 */  [ 0.413210213, 16 ],

  /* 2112 */  [ 0.413471222, 16 ],
  /* 2113 */  [ 0.413732273, 16 ],
  /* 2114 */  [ 0.413993364, 16 ],
  /* 2115 */  [ 0.414254497, 16 ],
  /* 2116 */  [ 0.414515671, 16 ],
  /* 2117 */  [ 0.414776886, 16 ],
  /* 2118 */  [ 0.415038142, 16 ],
  /* 2119 */  [ 0.415299440, 16 ],
  /* 2120 */  [ 0.415560778, 16 ],
  /* 2121 */  [ 0.415822157, 16 ],
  /* 2122 */  [ 0.416083578, 16 ],
  /* 2123 */  [ 0.416345040, 16 ],
  /* 2124 */  [ 0.416606542, 16 ],
  /* 2125 */  [ 0.416868086, 16 ],
  /* 2126 */  [ 0.417129671, 16 ],
  /* 2127 */  [ 0.417391297, 16 ],

  /* 2128 */  [ 0.417652964, 16 ],
  /* 2129 */  [ 0.417914672, 16 ],
  /* 2130 */  [ 0.418176420, 16 ],
  /* 2131 */  [ 0.418438210, 16 ],
  /* 2132 */  [ 0.418700041, 16 ],
  /* 2133 */  [ 0.418961912, 16 ],
  /* 2134 */  [ 0.419223825, 16 ],
  /* 2135 */  [ 0.419485778, 16 ],
  /* 2136 */  [ 0.419747773, 16 ],
  /* 2137 */  [ 0.420009808, 16 ],
  /* 2138 */  [ 0.420271884, 16 ],
  /* 2139 */  [ 0.420534001, 16 ],
  /* 2140 */  [ 0.420796159, 16 ],
  /* 2141 */  [ 0.421058358, 16 ],
  /* 2142 */  [ 0.421320597, 16 ],
  /* 2143 */  [ 0.421582878, 16 ],

  /* 2144 */  [ 0.421845199, 16 ],
  /* 2145 */  [ 0.422107561, 16 ],
  /* 2146 */  [ 0.422369964, 16 ],
  /* 2147 */  [ 0.422632407, 16 ],
  /* 2148 */  [ 0.422894891, 16 ],
  /* 2149 */  [ 0.423157416, 16 ],
  /* 2150 */  [ 0.423419982, 16 ],
  /* 2151 */  [ 0.423682588, 16 ],
  /* 2152 */  [ 0.423945235, 16 ],
  /* 2153 */  [ 0.424207923, 16 ],
  /* 2154 */  [ 0.424470652, 16 ],
  /* 2155 */  [ 0.424733421, 16 ],
  /* 2156 */  [ 0.424996230, 16 ],
  /* 2157 */  [ 0.425259081, 16 ],
  /* 2158 */  [ 0.425521972, 16 ],
  /* 2159 */  [ 0.425784903, 16 ],

  /* 2160 */  [ 0.426047876, 16 ],
  /* 2161 */  [ 0.426310889, 16 ],
  /* 2162 */  [ 0.426573942, 16 ],
  /* 2163 */  [ 0.426837036, 16 ],
  /* 2164 */  [ 0.427100170, 16 ],
  /* 2165 */  [ 0.427363345, 16 ],
  /* 2166 */  [ 0.427626561, 16 ],
  /* 2167 */  [ 0.427889817, 16 ],
  /* 2168 */  [ 0.428153114, 16 ],
  /* 2169 */  [ 0.428416451, 16 ],
  /* 2170 */  [ 0.428679828, 16 ],
  /* 2171 */  [ 0.428943246, 16 ],
  /* 2172 */  [ 0.429206704, 16 ],
  /* 2173 */  [ 0.429470203, 16 ],
  /* 2174 */  [ 0.429733743, 16 ],
  /* 2175 */  [ 0.429997322, 16 ],

  /* 2176 */  [ 0.430260942, 16 ],
  /* 2177 */  [ 0.430524603, 16 ],
  /* 2178 */  [ 0.430788304, 16 ],
  /* 2179 */  [ 0.431052045, 16 ],
  /* 2180 */  [ 0.431315826, 16 ],
  /* 2181 */  [ 0.431579648, 16 ],
  /* 2182 */  [ 0.431843511, 16 ],
  /* 2183 */  [ 0.432107413, 16 ],
  /* 2184 */  [ 0.432371356, 16 ],
  /* 2185 */  [ 0.432635339, 16 ],
  /* 2186 */  [ 0.432899362, 16 ],
  /* 2187 */  [ 0.433163426, 16 ],
  /* 2188 */  [ 0.433427530, 16 ],
  /* 2189 */  [ 0.433691674, 16 ],
  /* 2190 */  [ 0.433955859, 16 ],
  /* 2191 */  [ 0.434220083, 16 ],

  /* 2192 */  [ 0.434484348, 16 ],
  /* 2193 */  [ 0.434748653, 16 ],
  /* 2194 */  [ 0.435012998, 16 ],
  /* 2195 */  [ 0.435277383, 16 ],
  /* 2196 */  [ 0.435541809, 16 ],
  /* 2197 */  [ 0.435806274, 16 ],
  /* 2198 */  [ 0.436070780, 16 ],
  /* 2199 */  [ 0.436335326, 16 ],
  /* 2200 */  [ 0.436599912, 16 ],
  /* 2201 */  [ 0.436864538, 16 ],
  /* 2202 */  [ 0.437129204, 16 ],
  /* 2203 */  [ 0.437393910, 16 ],
  /* 2204 */  [ 0.437658657, 16 ],
  /* 2205 */  [ 0.437923443, 16 ],
  /* 2206 */  [ 0.438188269, 16 ],
  /* 2207 */  [ 0.438453136, 16 ],

  /* 2208 */  [ 0.438718042, 16 ],
  /* 2209 */  [ 0.438982988, 16 ],
  /* 2210 */  [ 0.439247975, 16 ],
  /* 2211 */  [ 0.439513001, 16 ],
  /* 2212 */  [ 0.439778067, 16 ],
  /* 2213 */  [ 0.440043173, 16 ],
  /* 2214 */  [ 0.440308320, 16 ],
  /* 2215 */  [ 0.440573506, 16 ],
  /* 2216 */  [ 0.440838732, 16 ],
  /* 2217 */  [ 0.441103997, 16 ],
  /* 2218 */  [ 0.441369303, 16 ],
  /* 2219 */  [ 0.441634649, 16 ],
  /* 2220 */  [ 0.441900034, 16 ],
  /* 2221 */  [ 0.442165460, 16 ],
  /* 2222 */  [ 0.442430925, 16 ],
  /* 2223 */  [ 0.442696430, 16 ],

  /* 2224 */  [ 0.442961975, 16 ],
  /* 2225 */  [ 0.443227559, 16 ],
  /* 2226 */  [ 0.443493184, 16 ],
  /* 2227 */  [ 0.443758848, 16 ],
  /* 2228 */  [ 0.444024552, 16 ],
  /* 2229 */  [ 0.444290296, 16 ],
  /* 2230 */  [ 0.444556079, 16 ],
  /* 2231 */  [ 0.444821902, 16 ],
  /* 2232 */  [ 0.445087765, 16 ],
  /* 2233 */  [ 0.445353668, 16 ],
  /* 2234 */  [ 0.445619610, 16 ],
  /* 2235 */  [ 0.445885592, 16 ],
  /* 2236 */  [ 0.446151614, 16 ],
  /* 2237 */  [ 0.446417675, 16 ],
  /* 2238 */  [ 0.446683776, 16 ],
  /* 2239 */  [ 0.446949917, 16 ],

  /* 2240 */  [ 0.447216097, 16 ],
  /* 2241 */  [ 0.447482317, 16 ],
  /* 2242 */  [ 0.447748576, 16 ],
  /* 2243 */  [ 0.448014875, 16 ],
  /* 2244 */  [ 0.448281214, 16 ],
  /* 2245 */  [ 0.448547592, 16 ],
  /* 2246 */  [ 0.448814010, 16 ],
  /* 2247 */  [ 0.449080467, 16 ],
  /* 2248 */  [ 0.449346964, 16 ],
  /* 2249 */  [ 0.449613501, 16 ],
  /* 2250 */  [ 0.449880076, 16 ],
  /* 2251 */  [ 0.450146692, 16 ],
  /* 2252 */  [ 0.450413347, 16 ],
  /* 2253 */  [ 0.450680041, 16 ],
  /* 2254 */  [ 0.450946775, 16 ],
  /* 2255 */  [ 0.451213548, 16 ],

  /* 2256 */  [ 0.451480360, 16 ],
  /* 2257 */  [ 0.451747213, 16 ],
  /* 2258 */  [ 0.452014104, 16 ],
  /* 2259 */  [ 0.452281035, 16 ],
  /* 2260 */  [ 0.452548005, 16 ],
  /* 2261 */  [ 0.452815015, 16 ],
  /* 2262 */  [ 0.453082064, 16 ],
  /* 2263 */  [ 0.453349152, 16 ],
  /* 2264 */  [ 0.453616280, 16 ],
  /* 2265 */  [ 0.453883447, 16 ],
  /* 2266 */  [ 0.454150653, 16 ],
  /* 2267 */  [ 0.454417899, 16 ],
  /* 2268 */  [ 0.454685184, 16 ],
  /* 2269 */  [ 0.454952508, 16 ],
  /* 2270 */  [ 0.455219872, 16 ],
  /* 2271 */  [ 0.455487275, 16 ],

  /* 2272 */  [ 0.455754717, 16 ],
  /* 2273 */  [ 0.456022198, 16 ],
  /* 2274 */  [ 0.456289719, 16 ],
  /* 2275 */  [ 0.456557278, 16 ],
  /* 2276 */  [ 0.456824877, 16 ],
  /* 2277 */  [ 0.457092516, 16 ],
  /* 2278 */  [ 0.457360193, 16 ],
  /* 2279 */  [ 0.457627909, 16 ],
  /* 2280 */  [ 0.457895665, 16 ],
  /* 2281 */  [ 0.458163460, 16 ],
  /* 2282 */  [ 0.458431294, 16 ],
  /* 2283 */  [ 0.458699167, 16 ],
  /* 2284 */  [ 0.458967079, 16 ],
  /* 2285 */  [ 0.459235030, 16 ],
  /* 2286 */  [ 0.459503021, 16 ],
  /* 2287 */  [ 0.459771050, 16 ],

  /* 2288 */  [ 0.460039119, 16 ],
  /* 2289 */  [ 0.460307226, 16 ],
  /* 2290 */  [ 0.460575373, 16 ],
  /* 2291 */  [ 0.460843559, 16 ],
  /* 2292 */  [ 0.461111783, 16 ],
  /* 2293 */  [ 0.461380047, 16 ],
  /* 2294 */  [ 0.461648350, 16 ],
  /* 2295 */  [ 0.461916691, 16 ],
  /* 2296 */  [ 0.462185072, 16 ],
  /* 2297 */  [ 0.462453492, 16 ],
  /* 2298 */  [ 0.462721950, 16 ],
  /* 2299 */  [ 0.462990448, 16 ],
  /* 2300 */  [ 0.463258984, 16 ],
  /* 2301 */  [ 0.463527560, 16 ],
  /* 2302 */  [ 0.463796174, 16 ],
  /* 2303 */  [ 0.464064827, 16 ],

  /* 2304 */  [ 0.464333519, 16 ],
  /* 2305 */  [ 0.464602250, 16 ],
  /* 2306 */  [ 0.464871020, 16 ],
  /* 2307 */  [ 0.465139829, 16 ],
  /* 2308 */  [ 0.465408676, 16 ],
  /* 2309 */  [ 0.465677563, 16 ],
  /* 2310 */  [ 0.465946488, 16 ],
  /* 2311 */  [ 0.466215452, 16 ],
  /* 2312 */  [ 0.466484455, 16 ],
  /* 2313 */  [ 0.466753496, 16 ],
  /* 2314 */  [ 0.467022577, 16 ],
  /* 2315 */  [ 0.467291696, 16 ],
  /* 2316 */  [ 0.467560854, 16 ],
  /* 2317 */  [ 0.467830050, 16 ],
  /* 2318 */  [ 0.468099285, 16 ],
  /* 2319 */  [ 0.468368560, 16 ],

  /* 2320 */  [ 0.468637872, 16 ],
  /* 2321 */  [ 0.468907224, 16 ],
  /* 2322 */  [ 0.469176614, 16 ],
  /* 2323 */  [ 0.469446043, 16 ],
  /* 2324 */  [ 0.469715510, 16 ],
  /* 2325 */  [ 0.469985016, 16 ],
  /* 2326 */  [ 0.470254561, 16 ],
  /* 2327 */  [ 0.470524145, 16 ],
  /* 2328 */  [ 0.470793767, 16 ],
  /* 2329 */  [ 0.471063427, 16 ],
  /* 2330 */  [ 0.471333126, 16 ],
  /* 2331 */  [ 0.471602864, 16 ],
  /* 2332 */  [ 0.471872641, 16 ],
  /* 2333 */  [ 0.472142456, 16 ],
  /* 2334 */  [ 0.472412309, 16 ],
  /* 2335 */  [ 0.472682201, 16 ],

  /* 2336 */  [ 0.472952132, 16 ],
  /* 2337 */  [ 0.473222101, 16 ],
  /* 2338 */  [ 0.473492108, 16 ],
  /* 2339 */  [ 0.473762155, 16 ],
  /* 2340 */  [ 0.474032239, 16 ],
  /* 2341 */  [ 0.474302362, 16 ],
  /* 2342 */  [ 0.474572524, 16 ],
  /* 2343 */  [ 0.474842724, 16 ],
  /* 2344 */  [ 0.475112962, 16 ],
  /* 2345 */  [ 0.475383239, 16 ],
  /* 2346 */  [ 0.475653554, 16 ],
  /* 2347 */  [ 0.475923908, 16 ],
  /* 2348 */  [ 0.476194300, 16 ],
  /* 2349 */  [ 0.476464731, 16 ],
  /* 2350 */  [ 0.476735200, 16 ],
  /* 2351 */  [ 0.477005707, 16 ],

  /* 2352 */  [ 0.477276252, 16 ],
  /* 2353 */  [ 0.477546836, 16 ],
  /* 2354 */  [ 0.477817459, 16 ],
  /* 2355 */  [ 0.478088119, 16 ],
  /* 2356 */  [ 0.478358818, 16 ],
  /* 2357 */  [ 0.478629555, 16 ],
  /* 2358 */  [ 0.478900331, 16 ],
  /* 2359 */  [ 0.479171145, 16 ],
  /* 2360 */  [ 0.479441997, 16 ],
  /* 2361 */  [ 0.479712887, 16 ],
  /* 2362 */  [ 0.479983816, 16 ],
  /* 2363 */  [ 0.480254782, 16 ],
  /* 2364 */  [ 0.480525787, 16 ],
  /* 2365 */  [ 0.480796831, 16 ],
  /* 2366 */  [ 0.481067912, 16 ],
  /* 2367 */  [ 0.481339032, 16 ],

  /* 2368 */  [ 0.481610189, 16 ],
  /* 2369 */  [ 0.481881385, 16 ],
  /* 2370 */  [ 0.482152620, 16 ],
  /* 2371 */  [ 0.482423892, 16 ],
  /* 2372 */  [ 0.482695202, 16 ],
  /* 2373 */  [ 0.482966551, 16 ],
  /* 2374 */  [ 0.483237938, 16 ],
  /* 2375 */  [ 0.483509362, 16 ],
  /* 2376 */  [ 0.483780825, 16 ],
  /* 2377 */  [ 0.484052326, 16 ],
  /* 2378 */  [ 0.484323865, 16 ],
  /* 2379 */  [ 0.484595443, 16 ],
  /* 2380 */  [ 0.484867058, 16 ],
  /* 2381 */  [ 0.485138711, 16 ],
  /* 2382 */  [ 0.485410402, 16 ],
  /* 2383 */  [ 0.485682131, 16 ],

  /* 2384 */  [ 0.485953899, 16 ],
  /* 2385 */  [ 0.486225704, 16 ],
  /* 2386 */  [ 0.486497547, 16 ],
  /* 2387 */  [ 0.486769429, 16 ],
  /* 2388 */  [ 0.487041348, 16 ],
  /* 2389 */  [ 0.487313305, 16 ],
  /* 2390 */  [ 0.487585300, 16 ],
  /* 2391 */  [ 0.487857333, 16 ],
  /* 2392 */  [ 0.488129404, 16 ],
  /* 2393 */  [ 0.488401513, 16 ],
  /* 2394 */  [ 0.488673660, 16 ],
  /* 2395 */  [ 0.488945845, 16 ],
  /* 2396 */  [ 0.489218067, 16 ],
  /* 2397 */  [ 0.489490328, 16 ],
  /* 2398 */  [ 0.489762626, 16 ],
  /* 2399 */  [ 0.490034962, 16 ],

  /* 2400 */  [ 0.490307336, 16 ],
  /* 2401 */  [ 0.490579748, 16 ],
  /* 2402 */  [ 0.490852198, 16 ],
  /* 2403 */  [ 0.491124686, 16 ],
  /* 2404 */  [ 0.491397211, 16 ],
  /* 2405 */  [ 0.491669774, 16 ],
  /* 2406 */  [ 0.491942375, 16 ],
  /* 2407 */  [ 0.492215014, 16 ],
  /* 2408 */  [ 0.492487690, 16 ],
  /* 2409 */  [ 0.492760404, 16 ],
  /* 2410 */  [ 0.493033156, 16 ],
  /* 2411 */  [ 0.493305946, 16 ],
  /* 2412 */  [ 0.493578773, 16 ],
  /* 2413 */  [ 0.493851638, 16 ],
  /* 2414 */  [ 0.494124541, 16 ],
  /* 2415 */  [ 0.494397481, 16 ],

  /* 2416 */  [ 0.494670459, 16 ],
  /* 2417 */  [ 0.494943475, 16 ],
  /* 2418 */  [ 0.495216529, 16 ],
  /* 2419 */  [ 0.495489620, 16 ],
  /* 2420 */  [ 0.495762748, 16 ],
  /* 2421 */  [ 0.496035915, 16 ],
  /* 2422 */  [ 0.496309119, 16 ],
  /* 2423 */  [ 0.496582360, 16 ],
  /* 2424 */  [ 0.496855639, 16 ],
  /* 2425 */  [ 0.497128956, 16 ],
  /* 2426 */  [ 0.497402310, 16 ],
  /* 2427 */  [ 0.497675702, 16 ],
  /* 2428 */  [ 0.497949132, 16 ],
  /* 2429 */  [ 0.498222598, 16 ],
  /* 2430 */  [ 0.498496103, 16 ],
  /* 2431 */  [ 0.498769645, 16 ],

  /* 2432 */  [ 0.499043224, 16 ],
  /* 2433 */  [ 0.499316841, 16 ],
  /* 2434 */  [ 0.499590496, 16 ],
  /* 2435 */  [ 0.499864188, 16 ],
  /* 2436 */  [ 0.250068959, 17 ],
  /* 2437 */  [ 0.250205842, 17 ],
  /* 2438 */  [ 0.250342744, 17 ],
  /* 2439 */  [ 0.250479665, 17 ],
  /* 2440 */  [ 0.250616605, 17 ],
  /* 2441 */  [ 0.250753563, 17 ],
  /* 2442 */  [ 0.250890540, 17 ],
  /* 2443 */  [ 0.251027536, 17 ],
  /* 2444 */  [ 0.251164550, 17 ],
  /* 2445 */  [ 0.251301583, 17 ],
  /* 2446 */  [ 0.251438635, 17 ],
  /* 2447 */  [ 0.251575706, 17 ],

  /* 2448 */  [ 0.251712795, 17 ],
  /* 2449 */  [ 0.251849903, 17 ],
  /* 2450 */  [ 0.251987029, 17 ],
  /* 2451 */  [ 0.252124174, 17 ],
  /* 2452 */  [ 0.252261338, 17 ],
  /* 2453 */  [ 0.252398520, 17 ],
  /* 2454 */  [ 0.252535721, 17 ],
  /* 2455 */  [ 0.252672941, 17 ],
  /* 2456 */  [ 0.252810180, 17 ],
  /* 2457 */  [ 0.252947436, 17 ],
  /* 2458 */  [ 0.253084712, 17 ],
  /* 2459 */  [ 0.253222006, 17 ],
  /* 2460 */  [ 0.253359319, 17 ],
  /* 2461 */  [ 0.253496651, 17 ],
  /* 2462 */  [ 0.253634001, 17 ],
  /* 2463 */  [ 0.253771369, 17 ],

  /* 2464 */  [ 0.253908756, 17 ],
  /* 2465 */  [ 0.254046162, 17 ],
  /* 2466 */  [ 0.254183587, 17 ],
  /* 2467 */  [ 0.254321030, 17 ],
  /* 2468 */  [ 0.254458491, 17 ],
  /* 2469 */  [ 0.254595971, 17 ],
  /* 2470 */  [ 0.254733470, 17 ],
  /* 2471 */  [ 0.254870987, 17 ],
  /* 2472 */  [ 0.255008523, 17 ],
  /* 2473 */  [ 0.255146077, 17 ],
  /* 2474 */  [ 0.255283650, 17 ],
  /* 2475 */  [ 0.255421241, 17 ],
  /* 2476 */  [ 0.255558851, 17 ],
  /* 2477 */  [ 0.255696480, 17 ],
  /* 2478 */  [ 0.255834127, 17 ],
  /* 2479 */  [ 0.255971792, 17 ],

  /* 2480 */  [ 0.256109476, 17 ],
  /* 2481 */  [ 0.256247179, 17 ],
  /* 2482 */  [ 0.256384900, 17 ],
  /* 2483 */  [ 0.256522639, 17 ],
  /* 2484 */  [ 0.256660397, 17 ],
  /* 2485 */  [ 0.256798174, 17 ],
  /* 2486 */  [ 0.256935969, 17 ],
  /* 2487 */  [ 0.257073782, 17 ],
  /* 2488 */  [ 0.257211614, 17 ],
  /* 2489 */  [ 0.257349465, 17 ],
  /* 2490 */  [ 0.257487334, 17 ],
  /* 2491 */  [ 0.257625221, 17 ],
  /* 2492 */  [ 0.257763127, 17 ],
  /* 2493 */  [ 0.257901051, 17 ],
  /* 2494 */  [ 0.258038994, 17 ],
  /* 2495 */  [ 0.258176955, 17 ],

  /* 2496 */  [ 0.258314934, 17 ],
  /* 2497 */  [ 0.258452932, 17 ],
  /* 2498 */  [ 0.258590948, 17 ],
  /* 2499 */  [ 0.258728983, 17 ],
  /* 2500 */  [ 0.258867036, 17 ],
  /* 2501 */  [ 0.259005108, 17 ],
  /* 2502 */  [ 0.259143198, 17 ],
  /* 2503 */  [ 0.259281307, 17 ],
  /* 2504 */  [ 0.259419433, 17 ],
  /* 2505 */  [ 0.259557579, 17 ],
  /* 2506 */  [ 0.259695742, 17 ],
  /* 2507 */  [ 0.259833924, 17 ],
  /* 2508 */  [ 0.259972124, 17 ],
  /* 2509 */  [ 0.260110343, 17 ],
  /* 2510 */  [ 0.260248580, 17 ],
  /* 2511 */  [ 0.260386836, 17 ],

  /* 2512 */  [ 0.260525110, 17 ],
  /* 2513 */  [ 0.260663402, 17 ],
  /* 2514 */  [ 0.260801712, 17 ],
  /* 2515 */  [ 0.260940041, 17 ],
  /* 2516 */  [ 0.261078388, 17 ],
  /* 2517 */  [ 0.261216754, 17 ],
  /* 2518 */  [ 0.261355137, 17 ],
  /* 2519 */  [ 0.261493540, 17 ],
  /* 2520 */  [ 0.261631960, 17 ],
  /* 2521 */  [ 0.261770399, 17 ],
  /* 2522 */  [ 0.261908856, 17 ],
  /* 2523 */  [ 0.262047331, 17 ],
  /* 2524 */  [ 0.262185825, 17 ],
  /* 2525 */  [ 0.262324337, 17 ],
  /* 2526 */  [ 0.262462867, 17 ],
  /* 2527 */  [ 0.262601416, 17 ],

  /* 2528 */  [ 0.262739982, 17 ],
  /* 2529 */  [ 0.262878568, 17 ],
  /* 2530 */  [ 0.263017171, 17 ],
  /* 2531 */  [ 0.263155792, 17 ],
  /* 2532 */  [ 0.263294432, 17 ],
  /* 2533 */  [ 0.263433090, 17 ],
  /* 2534 */  [ 0.263571767, 17 ],
  /* 2535 */  [ 0.263710461, 17 ],
  /* 2536 */  [ 0.263849174, 17 ],
  /* 2537 */  [ 0.263987905, 17 ],
  /* 2538 */  [ 0.264126655, 17 ],
  /* 2539 */  [ 0.264265422, 17 ],
  /* 2540 */  [ 0.264404208, 17 ],
  /* 2541 */  [ 0.264543012, 17 ],
  /* 2542 */  [ 0.264681834, 17 ],
  /* 2543 */  [ 0.264820674, 17 ],

  /* 2544 */  [ 0.264959533, 17 ],
  /* 2545 */  [ 0.265098410, 17 ],
  /* 2546 */  [ 0.265237305, 17 ],
  /* 2547 */  [ 0.265376218, 17 ],
  /* 2548 */  [ 0.265515149, 17 ],
  /* 2549 */  [ 0.265654099, 17 ],
  /* 2550 */  [ 0.265793066, 17 ],
  /* 2551 */  [ 0.265932052, 17 ],
  /* 2552 */  [ 0.266071056, 17 ],
  /* 2553 */  [ 0.266210078, 17 ],
  /* 2554 */  [ 0.266349119, 17 ],
  /* 2555 */  [ 0.266488177, 17 ],
  /* 2556 */  [ 0.266627254, 17 ],
  /* 2557 */  [ 0.266766349, 17 ],
  /* 2558 */  [ 0.266905462, 17 ],
  /* 2559 */  [ 0.267044593, 17 ],

  /* 2560 */  [ 0.267183742, 17 ],
  /* 2561 */  [ 0.267322909, 17 ],
  /* 2562 */  [ 0.267462094, 17 ],
  /* 2563 */  [ 0.267601298, 17 ],
  /* 2564 */  [ 0.267740519, 17 ],
  /* 2565 */  [ 0.267879759, 17 ],
  /* 2566 */  [ 0.268019017, 17 ],
  /* 2567 */  [ 0.268158293, 17 ],
  /* 2568 */  [ 0.268297587, 17 ],
  /* 2569 */  [ 0.268436899, 17 ],
  /* 2570 */  [ 0.268576229, 17 ],
  /* 2571 */  [ 0.268715577, 17 ],
  /* 2572 */  [ 0.268854943, 17 ],
  /* 2573 */  [ 0.268994328, 17 ],
  /* 2574 */  [ 0.269133730, 17 ],
  /* 2575 */  [ 0.269273150, 17 ],

  /* 2576 */  [ 0.269412589, 17 ],
  /* 2577 */  [ 0.269552045, 17 ],
  /* 2578 */  [ 0.269691520, 17 ],
  /* 2579 */  [ 0.269831013, 17 ],
  /* 2580 */  [ 0.269970523, 17 ],
  /* 2581 */  [ 0.270110052, 17 ],
  /* 2582 */  [ 0.270249599, 17 ],
  /* 2583 */  [ 0.270389163, 17 ],
  /* 2584 */  [ 0.270528746, 17 ],
  /* 2585 */  [ 0.270668347, 17 ],
  /* 2586 */  [ 0.270807965, 17 ],
  /* 2587 */  [ 0.270947602, 17 ],
  /* 2588 */  [ 0.271087257, 17 ],
  /* 2589 */  [ 0.271226930, 17 ],
  /* 2590 */  [ 0.271366620, 17 ],
  /* 2591 */  [ 0.271506329, 17 ],

  /* 2592 */  [ 0.271646056, 17 ],
  /* 2593 */  [ 0.271785800, 17 ],
  /* 2594 */  [ 0.271925563, 17 ],
  /* 2595 */  [ 0.272065343, 17 ],
  /* 2596 */  [ 0.272205142, 17 ],
  /* 2597 */  [ 0.272344958, 17 ],
  /* 2598 */  [ 0.272484793, 17 ],
  /* 2599 */  [ 0.272624645, 17 ],
  /* 2600 */  [ 0.272764515, 17 ],
  /* 2601 */  [ 0.272904403, 17 ],
  /* 2602 */  [ 0.273044310, 17 ],
  /* 2603 */  [ 0.273184234, 17 ],
  /* 2604 */  [ 0.273324176, 17 ],
  /* 2605 */  [ 0.273464136, 17 ],
  /* 2606 */  [ 0.273604113, 17 ],
  /* 2607 */  [ 0.273744109, 17 ],

  /* 2608 */  [ 0.273884123, 17 ],
  /* 2609 */  [ 0.274024154, 17 ],
  /* 2610 */  [ 0.274164204, 17 ],
  /* 2611 */  [ 0.274304271, 17 ],
  /* 2612 */  [ 0.274444356, 17 ],
  /* 2613 */  [ 0.274584459, 17 ],
  /* 2614 */  [ 0.274724580, 17 ],
  /* 2615 */  [ 0.274864719, 17 ],
  /* 2616 */  [ 0.275004875, 17 ],
  /* 2617 */  [ 0.275145050, 17 ],
  /* 2618 */  [ 0.275285242, 17 ],
  /* 2619 */  [ 0.275425452, 17 ],
  /* 2620 */  [ 0.275565681, 17 ],
  /* 2621 */  [ 0.275705926, 17 ],
  /* 2622 */  [ 0.275846190, 17 ],
  /* 2623 */  [ 0.275986472, 17 ],

  /* 2624 */  [ 0.276126771, 17 ],
  /* 2625 */  [ 0.276267088, 17 ],
  /* 2626 */  [ 0.276407423, 17 ],
  /* 2627 */  [ 0.276547776, 17 ],
  /* 2628 */  [ 0.276688147, 17 ],
  /* 2629 */  [ 0.276828535, 17 ],
  /* 2630 */  [ 0.276968942, 17 ],
  /* 2631 */  [ 0.277109366, 17 ],
  /* 2632 */  [ 0.277249808, 17 ],
  /* 2633 */  [ 0.277390267, 17 ],
  /* 2634 */  [ 0.277530745, 17 ],
  /* 2635 */  [ 0.277671240, 17 ],
  /* 2636 */  [ 0.277811753, 17 ],
  /* 2637 */  [ 0.277952284, 17 ],
  /* 2638 */  [ 0.278092832, 17 ],
  /* 2639 */  [ 0.278233399, 17 ],

  /* 2640 */  [ 0.278373983, 17 ],
  /* 2641 */  [ 0.278514584, 17 ],
  /* 2642 */  [ 0.278655204, 17 ],
  /* 2643 */  [ 0.278795841, 17 ],
  /* 2644 */  [ 0.278936496, 17 ],
  /* 2645 */  [ 0.279077169, 17 ],
  /* 2646 */  [ 0.279217860, 17 ],
  /* 2647 */  [ 0.279358568, 17 ],
  /* 2648 */  [ 0.279499294, 17 ],
  /* 2649 */  [ 0.279640037, 17 ],
  /* 2650 */  [ 0.279780799, 17 ],
  /* 2651 */  [ 0.279921578, 17 ],
  /* 2652 */  [ 0.280062375, 17 ],
  /* 2653 */  [ 0.280203189, 17 ],
  /* 2654 */  [ 0.280344021, 17 ],
  /* 2655 */  [ 0.280484871, 17 ],

  /* 2656 */  [ 0.280625739, 17 ],
  /* 2657 */  [ 0.280766624, 17 ],
  /* 2658 */  [ 0.280907527, 17 ],
  /* 2659 */  [ 0.281048447, 17 ],
  /* 2660 */  [ 0.281189385, 17 ],
  /* 2661 */  [ 0.281330341, 17 ],
  /* 2662 */  [ 0.281471315, 17 ],
  /* 2663 */  [ 0.281612306, 17 ],
  /* 2664 */  [ 0.281753315, 17 ],
  /* 2665 */  [ 0.281894341, 17 ],
  /* 2666 */  [ 0.282035386, 17 ],
  /* 2667 */  [ 0.282176447, 17 ],
  /* 2668 */  [ 0.282317527, 17 ],
  /* 2669 */  [ 0.282458624, 17 ],
  /* 2670 */  [ 0.282599738, 17 ],
  /* 2671 */  [ 0.282740871, 17 ],

  /* 2672 */  [ 0.282882021, 17 ],
  /* 2673 */  [ 0.283023188, 17 ],
  /* 2674 */  [ 0.283164373, 17 ],
  /* 2675 */  [ 0.283305576, 17 ],
  /* 2676 */  [ 0.283446796, 17 ],
  /* 2677 */  [ 0.283588034, 17 ],
  /* 2678 */  [ 0.283729290, 17 ],
  /* 2679 */  [ 0.283870563, 17 ],
  /* 2680 */  [ 0.284011853, 17 ],
  /* 2681 */  [ 0.284153161, 17 ],
  /* 2682 */  [ 0.284294487, 17 ],
  /* 2683 */  [ 0.284435831, 17 ],
  /* 2684 */  [ 0.284577192, 17 ],
  /* 2685 */  [ 0.284718570, 17 ],
  /* 2686 */  [ 0.284859966, 17 ],
  /* 2687 */  [ 0.285001380, 17 ],

  /* 2688 */  [ 0.285142811, 17 ],
  /* 2689 */  [ 0.285284259, 17 ],
  /* 2690 */  [ 0.285425726, 17 ],
  /* 2691 */  [ 0.285567209, 17 ],
  /* 2692 */  [ 0.285708711, 17 ],
  /* 2693 */  [ 0.285850229, 17 ],
  /* 2694 */  [ 0.285991766, 17 ],
  /* 2695 */  [ 0.286133319, 17 ],
  /* 2696 */  [ 0.286274891, 17 ],
  /* 2697 */  [ 0.286416480, 17 ],
  /* 2698 */  [ 0.286558086, 17 ],
  /* 2699 */  [ 0.286699710, 17 ],
  /* 2700 */  [ 0.286841351, 17 ],
  /* 2701 */  [ 0.286983010, 17 ],
  /* 2702 */  [ 0.287124686, 17 ],
  /* 2703 */  [ 0.287266380, 17 ],

  /* 2704 */  [ 0.287408091, 17 ],
  /* 2705 */  [ 0.287549820, 17 ],
  /* 2706 */  [ 0.287691566, 17 ],
  /* 2707 */  [ 0.287833330, 17 ],
  /* 2708 */  [ 0.287975111, 17 ],
  /* 2709 */  [ 0.288116909, 17 ],
  /* 2710 */  [ 0.288258725, 17 ],
  /* 2711 */  [ 0.288400559, 17 ],
  /* 2712 */  [ 0.288542409, 17 ],
  /* 2713 */  [ 0.288684278, 17 ],
  /* 2714 */  [ 0.288826163, 17 ],
  /* 2715 */  [ 0.288968067, 17 ],
  /* 2716 */  [ 0.289109987, 17 ],
  /* 2717 */  [ 0.289251925, 17 ],
  /* 2718 */  [ 0.289393881, 17 ],
  /* 2719 */  [ 0.289535854, 17 ],

  /* 2720 */  [ 0.289677844, 17 ],
  /* 2721 */  [ 0.289819851, 17 ],
  /* 2722 */  [ 0.289961876, 17 ],
  /* 2723 */  [ 0.290103919, 17 ],
  /* 2724 */  [ 0.290245979, 17 ],
  /* 2725 */  [ 0.290388056, 17 ],
  /* 2726 */  [ 0.290530150, 17 ],
  /* 2727 */  [ 0.290672262, 17 ],
  /* 2728 */  [ 0.290814392, 17 ],
  /* 2729 */  [ 0.290956538, 17 ],
  /* 2730 */  [ 0.291098703, 17 ],
  /* 2731 */  [ 0.291240884, 17 ],
  /* 2732 */  [ 0.291383083, 17 ],
  /* 2733 */  [ 0.291525299, 17 ],
  /* 2734 */  [ 0.291667532, 17 ],
  /* 2735 */  [ 0.291809783, 17 ],

  /* 2736 */  [ 0.291952051, 17 ],
  /* 2737 */  [ 0.292094337, 17 ],
  /* 2738 */  [ 0.292236640, 17 ],
  /* 2739 */  [ 0.292378960, 17 ],
  /* 2740 */  [ 0.292521297, 17 ],
  /* 2741 */  [ 0.292663652, 17 ],
  /* 2742 */  [ 0.292806024, 17 ],
  /* 2743 */  [ 0.292948414, 17 ],
  /* 2744 */  [ 0.293090820, 17 ],
  /* 2745 */  [ 0.293233244, 17 ],
  /* 2746 */  [ 0.293375686, 17 ],
  /* 2747 */  [ 0.293518144, 17 ],
  /* 2748 */  [ 0.293660620, 17 ],
  /* 2749 */  [ 0.293803113, 17 ],
  /* 2750 */  [ 0.293945624, 17 ],
  /* 2751 */  [ 0.294088151, 17 ],

  /* 2752 */  [ 0.294230696, 17 ],
  /* 2753 */  [ 0.294373259, 17 ],
  /* 2754 */  [ 0.294515838, 17 ],
  /* 2755 */  [ 0.294658435, 17 ],
  /* 2756 */  [ 0.294801049, 17 ],
  /* 2757 */  [ 0.294943680, 17 ],
  /* 2758 */  [ 0.295086329, 17 ],
  /* 2759 */  [ 0.295228995, 17 ],
  /* 2760 */  [ 0.295371678, 17 ],
  /* 2761 */  [ 0.295514378, 17 ],
  /* 2762 */  [ 0.295657095, 17 ],
  /* 2763 */  [ 0.295799830, 17 ],
  /* 2764 */  [ 0.295942582, 17 ],
  /* 2765 */  [ 0.296085351, 17 ],
  /* 2766 */  [ 0.296228138, 17 ],
  /* 2767 */  [ 0.296370941, 17 ],

  /* 2768 */  [ 0.296513762, 17 ],
  /* 2769 */  [ 0.296656600, 17 ],
  /* 2770 */  [ 0.296799455, 17 ],
  /* 2771 */  [ 0.296942327, 17 ],
  /* 2772 */  [ 0.297085217, 17 ],
  /* 2773 */  [ 0.297228124, 17 ],
  /* 2774 */  [ 0.297371048, 17 ],
  /* 2775 */  [ 0.297513989, 17 ],
  /* 2776 */  [ 0.297656947, 17 ],
  /* 2777 */  [ 0.297799922, 17 ],
  /* 2778 */  [ 0.297942915, 17 ],
  /* 2779 */  [ 0.298085925, 17 ],
  /* 2780 */  [ 0.298228951, 17 ],
  /* 2781 */  [ 0.298371996, 17 ],
  /* 2782 */  [ 0.298515057, 17 ],
  /* 2783 */  [ 0.298658135, 17 ],

  /* 2784 */  [ 0.298801231, 17 ],
  /* 2785 */  [ 0.298944343, 17 ],
  /* 2786 */  [ 0.299087473, 17 ],
  /* 2787 */  [ 0.299230620, 17 ],
  /* 2788 */  [ 0.299373784, 17 ],
  /* 2789 */  [ 0.299516965, 17 ],
  /* 2790 */  [ 0.299660163, 17 ],
  /* 2791 */  [ 0.299803378, 17 ],
  /* 2792 */  [ 0.299946611, 17 ],
  /* 2793 */  [ 0.300089860, 17 ],
  /* 2794 */  [ 0.300233127, 17 ],
  /* 2795 */  [ 0.300376411, 17 ],
  /* 2796 */  [ 0.300519711, 17 ],
  /* 2797 */  [ 0.300663029, 17 ],
  /* 2798 */  [ 0.300806364, 17 ],
  /* 2799 */  [ 0.300949716, 17 ],

  /* 2800 */  [ 0.301093085, 17 ],
  /* 2801 */  [ 0.301236472, 17 ],
  /* 2802 */  [ 0.301379875, 17 ],
  /* 2803 */  [ 0.301523295, 17 ],
  /* 2804 */  [ 0.301666733, 17 ],
  /* 2805 */  [ 0.301810187, 17 ],
  /* 2806 */  [ 0.301953659, 17 ],
  /* 2807 */  [ 0.302097147, 17 ],
  /* 2808 */  [ 0.302240653, 17 ],
  /* 2809 */  [ 0.302384175, 17 ],
  /* 2810 */  [ 0.302527715, 17 ],
  /* 2811 */  [ 0.302671271, 17 ],
  /* 2812 */  [ 0.302814845, 17 ],
  /* 2813 */  [ 0.302958436, 17 ],
  /* 2814 */  [ 0.303102044, 17 ],
  /* 2815 */  [ 0.303245668, 17 ],

  /* 2816 */  [ 0.303389310, 17 ],
  /* 2817 */  [ 0.303532969, 17 ],
  /* 2818 */  [ 0.303676645, 17 ],
  /* 2819 */  [ 0.303820337, 17 ],
  /* 2820 */  [ 0.303964047, 17 ],
  /* 2821 */  [ 0.304107774, 17 ],
  /* 2822 */  [ 0.304251517, 17 ],
  /* 2823 */  [ 0.304395278, 17 ],
  /* 2824 */  [ 0.304539056, 17 ],
  /* 2825 */  [ 0.304682850, 17 ],
  /* 2826 */  [ 0.304826662, 17 ],
  /* 2827 */  [ 0.304970491, 17 ],
  /* 2828 */  [ 0.305114336, 17 ],
  /* 2829 */  [ 0.305258199, 17 ],
  /* 2830 */  [ 0.305402078, 17 ],
  /* 2831 */  [ 0.305545974, 17 ],

  /* 2832 */  [ 0.305689888, 17 ],
  /* 2833 */  [ 0.305833818, 17 ],
  /* 2834 */  [ 0.305977765, 17 ],
  /* 2835 */  [ 0.306121729, 17 ],
  /* 2836 */  [ 0.306265710, 17 ],
  /* 2837 */  [ 0.306409708, 17 ],
  /* 2838 */  [ 0.306553723, 17 ],
  /* 2839 */  [ 0.306697755, 17 ],
  /* 2840 */  [ 0.306841804, 17 ],
  /* 2841 */  [ 0.306985869, 17 ],
  /* 2842 */  [ 0.307129952, 17 ],
  /* 2843 */  [ 0.307274051, 17 ],
  /* 2844 */  [ 0.307418168, 17 ],
  /* 2845 */  [ 0.307562301, 17 ],
  /* 2846 */  [ 0.307706451, 17 ],
  /* 2847 */  [ 0.307850618, 17 ],

  /* 2848 */  [ 0.307994802, 17 ],
  /* 2849 */  [ 0.308139003, 17 ],
  /* 2850 */  [ 0.308283220, 17 ],
  /* 2851 */  [ 0.308427455, 17 ],
  /* 2852 */  [ 0.308571706, 17 ],
  /* 2853 */  [ 0.308715974, 17 ],
  /* 2854 */  [ 0.308860260, 17 ],
  /* 2855 */  [ 0.309004561, 17 ],
  /* 2856 */  [ 0.309148880, 17 ],
  /* 2857 */  [ 0.309293216, 17 ],
  /* 2858 */  [ 0.309437568, 17 ],
  /* 2859 */  [ 0.309581938, 17 ],
  /* 2860 */  [ 0.309726324, 17 ],
  /* 2861 */  [ 0.309870727, 17 ],
  /* 2862 */  [ 0.310015147, 17 ],
  /* 2863 */  [ 0.310159583, 17 ],

  /* 2864 */  [ 0.310304037, 17 ],
  /* 2865 */  [ 0.310448507, 17 ],
  /* 2866 */  [ 0.310592994, 17 ],
  /* 2867 */  [ 0.310737498, 17 ],
  /* 2868 */  [ 0.310882018, 17 ],
  /* 2869 */  [ 0.311026556, 17 ],
  /* 2870 */  [ 0.311171110, 17 ],
  /* 2871 */  [ 0.311315681, 17 ],
  /* 2872 */  [ 0.311460269, 17 ],
  /* 2873 */  [ 0.311604874, 17 ],
  /* 2874 */  [ 0.311749495, 17 ],
  /* 2875 */  [ 0.311894133, 17 ],
  /* 2876 */  [ 0.312038788, 17 ],
  /* 2877 */  [ 0.312183460, 17 ],
  /* 2878 */  [ 0.312328148, 17 ],
  /* 2879 */  [ 0.312472854, 17 ],

  /* 2880 */  [ 0.312617576, 17 ],
  /* 2881 */  [ 0.312762314, 17 ],
  /* 2882 */  [ 0.312907070, 17 ],
  /* 2883 */  [ 0.313051842, 17 ],
  /* 2884 */  [ 0.313196631, 17 ],
  /* 2885 */  [ 0.313341437, 17 ],
  /* 2886 */  [ 0.313486259, 17 ],
  /* 2887 */  [ 0.313631098, 17 ],
  /* 2888 */  [ 0.313775954, 17 ],
  /* 2889 */  [ 0.313920827, 17 ],
  /* 2890 */  [ 0.314065716, 17 ],
  /* 2891 */  [ 0.314210622, 17 ],
  /* 2892 */  [ 0.314355545, 17 ],
  /* 2893 */  [ 0.314500484, 17 ],
  /* 2894 */  [ 0.314645440, 17 ],
  /* 2895 */  [ 0.314790413, 17 ],

  /* 2896 */  [ 0.314935403, 17 ],
  /* 2897 */  [ 0.315080409, 17 ],
  /* 2898 */  [ 0.315225432, 17 ],
  /* 2899 */  [ 0.315370472, 17 ],
  /* 2900 */  [ 0.315515528, 17 ],
  /* 2901 */  [ 0.315660601, 17 ],
  /* 2902 */  [ 0.315805690, 17 ],
  /* 2903 */  [ 0.315950797, 17 ],
  /* 2904 */  [ 0.316095920, 17 ],
  /* 2905 */  [ 0.316241059, 17 ],
  /* 2906 */  [ 0.316386216, 17 ],
  /* 2907 */  [ 0.316531388, 17 ],
  /* 2908 */  [ 0.316676578, 17 ],
  /* 2909 */  [ 0.316821784, 17 ],
  /* 2910 */  [ 0.316967007, 17 ],
  /* 2911 */  [ 0.317112247, 17 ],

  /* 2912 */  [ 0.317257503, 17 ],
  /* 2913 */  [ 0.317402775, 17 ],
  /* 2914 */  [ 0.317548065, 17 ],
  /* 2915 */  [ 0.317693371, 17 ],
  /* 2916 */  [ 0.317838693, 17 ],
  /* 2917 */  [ 0.317984033, 17 ],
  /* 2918 */  [ 0.318129388, 17 ],
  /* 2919 */  [ 0.318274761, 17 ],
  /* 2920 */  [ 0.318420150, 17 ],
  /* 2921 */  [ 0.318565555, 17 ],
  /* 2922 */  [ 0.318710978, 17 ],
  /* 2923 */  [ 0.318856416, 17 ],
  /* 2924 */  [ 0.319001872, 17 ],
  /* 2925 */  [ 0.319147344, 17 ],
  /* 2926 */  [ 0.319292832, 17 ],
  /* 2927 */  [ 0.319438338, 17 ],

  /* 2928 */  [ 0.319583859, 17 ],
  /* 2929 */  [ 0.319729398, 17 ],
  /* 2930 */  [ 0.319874952, 17 ],
  /* 2931 */  [ 0.320020524, 17 ],
  /* 2932 */  [ 0.320166112, 17 ],
  /* 2933 */  [ 0.320311716, 17 ],
  /* 2934 */  [ 0.320457337, 17 ],
  /* 2935 */  [ 0.320602975, 17 ],
  /* 2936 */  [ 0.320748629, 17 ],
  /* 2937 */  [ 0.320894300, 17 ],
  /* 2938 */  [ 0.321039987, 17 ],
  /* 2939 */  [ 0.321185691, 17 ],
  /* 2940 */  [ 0.321331411, 17 ],
  /* 2941 */  [ 0.321477148, 17 ],
  /* 2942 */  [ 0.321622901, 17 ],
  /* 2943 */  [ 0.321768671, 17 ],

  /* 2944 */  [ 0.321914457, 17 ],
  /* 2945 */  [ 0.322060260, 17 ],
  /* 2946 */  [ 0.322206079, 17 ],
  /* 2947 */  [ 0.322351915, 17 ],
  /* 2948 */  [ 0.322497768, 17 ],
  /* 2949 */  [ 0.322643636, 17 ],
  /* 2950 */  [ 0.322789522, 17 ],
  /* 2951 */  [ 0.322935424, 17 ],
  /* 2952 */  [ 0.323081342, 17 ],
  /* 2953 */  [ 0.323227277, 17 ],
  /* 2954 */  [ 0.323373228, 17 ],
  /* 2955 */  [ 0.323519196, 17 ],
  /* 2956 */  [ 0.323665180, 17 ],
  /* 2957 */  [ 0.323811180, 17 ],
  /* 2958 */  [ 0.323957197, 17 ],
  /* 2959 */  [ 0.324103231, 17 ],

  /* 2960 */  [ 0.324249281, 17 ],
  /* 2961 */  [ 0.324395347, 17 ],
  /* 2962 */  [ 0.324541430, 17 ],
  /* 2963 */  [ 0.324687530, 17 ],
  /* 2964 */  [ 0.324833646, 17 ],
  /* 2965 */  [ 0.324979778, 17 ],
  /* 2966 */  [ 0.325125926, 17 ],
  /* 2967 */  [ 0.325272091, 17 ],
  /* 2968 */  [ 0.325418273, 17 ],
  /* 2969 */  [ 0.325564471, 17 ],
  /* 2970 */  [ 0.325710685, 17 ],
  /* 2971 */  [ 0.325856916, 17 ],
  /* 2972 */  [ 0.326003163, 17 ],
  /* 2973 */  [ 0.326149427, 17 ],
  /* 2974 */  [ 0.326295707, 17 ],
  /* 2975 */  [ 0.326442003, 17 ],

  /* 2976 */  [ 0.326588316, 17 ],
  /* 2977 */  [ 0.326734645, 17 ],
  /* 2978 */  [ 0.326880990, 17 ],
  /* 2979 */  [ 0.327027352, 17 ],
  /* 2980 */  [ 0.327173730, 17 ],
  /* 2981 */  [ 0.327320125, 17 ],
  /* 2982 */  [ 0.327466536, 17 ],
  /* 2983 */  [ 0.327612963, 17 ],
  /* 2984 */  [ 0.327759407, 17 ],
  /* 2985 */  [ 0.327905867, 17 ],
  /* 2986 */  [ 0.328052344, 17 ],
  /* 2987 */  [ 0.328198837, 17 ],
  /* 2988 */  [ 0.328345346, 17 ],
  /* 2989 */  [ 0.328491871, 17 ],
  /* 2990 */  [ 0.328638413, 17 ],
  /* 2991 */  [ 0.328784971, 17 ],

  /* 2992 */  [ 0.328931546, 17 ],
  /* 2993 */  [ 0.329078137, 17 ],
  /* 2994 */  [ 0.329224744, 17 ],
  /* 2995 */  [ 0.329371367, 17 ],
  /* 2996 */  [ 0.329518007, 17 ],
  /* 2997 */  [ 0.329664663, 17 ],
  /* 2998 */  [ 0.329811336, 17 ],
  /* 2999 */  [ 0.329958024, 17 ],
  /* 3000 */  [ 0.330104730, 17 ],
  /* 3001 */  [ 0.330251451, 17 ],
  /* 3002 */  [ 0.330398189, 17 ],
  /* 3003 */  [ 0.330544943, 17 ],
  /* 3004 */  [ 0.330691713, 17 ],
  /* 3005 */  [ 0.330838499, 17 ],
  /* 3006 */  [ 0.330985302, 17 ],
  /* 3007 */  [ 0.331132121, 17 ],

  /* 3008 */  [ 0.331278957, 17 ],
  /* 3009 */  [ 0.331425808, 17 ],
  /* 3010 */  [ 0.331572676, 17 ],
  /* 3011 */  [ 0.331719560, 17 ],
  /* 3012 */  [ 0.331866461, 17 ],
  /* 3013 */  [ 0.332013377, 17 ],
  /* 3014 */  [ 0.332160310, 17 ],
  /* 3015 */  [ 0.332307260, 17 ],
  /* 3016 */  [ 0.332454225, 17 ],
  /* 3017 */  [ 0.332601207, 17 ],
  /* 3018 */  [ 0.332748205, 17 ],
  /* 3019 */  [ 0.332895219, 17 ],
  /* 3020 */  [ 0.333042249, 17 ],
  /* 3021 */  [ 0.333189296, 17 ],
  /* 3022 */  [ 0.333336359, 17 ],
  /* 3023 */  [ 0.333483438, 17 ],

  /* 3024 */  [ 0.333630533, 17 ],
  /* 3025 */  [ 0.333777645, 17 ],
  /* 3026 */  [ 0.333924772, 17 ],
  /* 3027 */  [ 0.334071916, 17 ],
  /* 3028 */  [ 0.334219076, 17 ],
  /* 3029 */  [ 0.334366253, 17 ],
  /* 3030 */  [ 0.334513445, 17 ],
  /* 3031 */  [ 0.334660654, 17 ],
  /* 3032 */  [ 0.334807879, 17 ],
  /* 3033 */  [ 0.334955120, 17 ],
  /* 3034 */  [ 0.335102377, 17 ],
  /* 3035 */  [ 0.335249651, 17 ],
  /* 3036 */  [ 0.335396941, 17 ],
  /* 3037 */  [ 0.335544246, 17 ],
  /* 3038 */  [ 0.335691568, 17 ],
  /* 3039 */  [ 0.335838906, 17 ],

  /* 3040 */  [ 0.335986261, 17 ],
  /* 3041 */  [ 0.336133631, 17 ],
  /* 3042 */  [ 0.336281018, 17 ],
  /* 3043 */  [ 0.336428421, 17 ],
  /* 3044 */  [ 0.336575840, 17 ],
  /* 3045 */  [ 0.336723275, 17 ],
  /* 3046 */  [ 0.336870726, 17 ],
  /* 3047 */  [ 0.337018193, 17 ],
  /* 3048 */  [ 0.337165677, 17 ],
  /* 3049 */  [ 0.337313176, 17 ],
  /* 3050 */  [ 0.337460692, 17 ],
  /* 3051 */  [ 0.337608224, 17 ],
  /* 3052 */  [ 0.337755772, 17 ],
  /* 3053 */  [ 0.337903336, 17 ],
  /* 3054 */  [ 0.338050916, 17 ],
  /* 3055 */  [ 0.338198513, 17 ],

  /* 3056 */  [ 0.338346125, 17 ],
  /* 3057 */  [ 0.338493753, 17 ],
  /* 3058 */  [ 0.338641398, 17 ],
  /* 3059 */  [ 0.338789059, 17 ],
  /* 3060 */  [ 0.338936736, 17 ],
  /* 3061 */  [ 0.339084429, 17 ],
  /* 3062 */  [ 0.339232138, 17 ],
  /* 3063 */  [ 0.339379863, 17 ],
  /* 3064 */  [ 0.339527604, 17 ],
  /* 3065 */  [ 0.339675361, 17 ],
  /* 3066 */  [ 0.339823134, 17 ],
  /* 3067 */  [ 0.339970924, 17 ],
  /* 3068 */  [ 0.340118729, 17 ],
  /* 3069 */  [ 0.340266550, 17 ],
  /* 3070 */  [ 0.340414388, 17 ],
  /* 3071 */  [ 0.340562242, 17 ],

  /* 3072 */  [ 0.340710111, 17 ],
  /* 3073 */  [ 0.340857997, 17 ],
  /* 3074 */  [ 0.341005899, 17 ],
  /* 3075 */  [ 0.341153816, 17 ],
  /* 3076 */  [ 0.341301750, 17 ],
  /* 3077 */  [ 0.341449700, 17 ],
  /* 3078 */  [ 0.341597666, 17 ],
  /* 3079 */  [ 0.341745648, 17 ],
  /* 3080 */  [ 0.341893646, 17 ],
  /* 3081 */  [ 0.342041659, 17 ],
  /* 3082 */  [ 0.342189689, 17 ],
  /* 3083 */  [ 0.342337735, 17 ],
  /* 3084 */  [ 0.342485797, 17 ],
  /* 3085 */  [ 0.342633875, 17 ],
  /* 3086 */  [ 0.342781969, 17 ],
  /* 3087 */  [ 0.342930079, 17 ],

  /* 3088 */  [ 0.343078205, 17 ],
  /* 3089 */  [ 0.343226347, 17 ],
  /* 3090 */  [ 0.343374505, 17 ],
  /* 3091 */  [ 0.343522679, 17 ],
  /* 3092 */  [ 0.343670869, 17 ],
  /* 3093 */  [ 0.343819075, 17 ],
  /* 3094 */  [ 0.343967296, 17 ],
  /* 3095 */  [ 0.344115534, 17 ],
  /* 3096 */  [ 0.344263788, 17 ],
  /* 3097 */  [ 0.344412058, 17 ],
  /* 3098 */  [ 0.344560343, 17 ],
  /* 3099 */  [ 0.344708645, 17 ],
  /* 3100 */  [ 0.344856963, 17 ],
  /* 3101 */  [ 0.345005296, 17 ],
  /* 3102 */  [ 0.345153646, 17 ],
  /* 3103 */  [ 0.345302011, 17 ],

  /* 3104 */  [ 0.345450393, 17 ],
  /* 3105 */  [ 0.345598790, 17 ],
  /* 3106 */  [ 0.345747203, 17 ],
  /* 3107 */  [ 0.345895632, 17 ],
  /* 3108 */  [ 0.346044077, 17 ],
  /* 3109 */  [ 0.346192538, 17 ],
  /* 3110 */  [ 0.346341015, 17 ],
  /* 3111 */  [ 0.346489508, 17 ],
  /* 3112 */  [ 0.346638017, 17 ],
  /* 3113 */  [ 0.346786542, 17 ],
  /* 3114 */  [ 0.346935082, 17 ],
  /* 3115 */  [ 0.347083639, 17 ],
  /* 3116 */  [ 0.347232211, 17 ],
  /* 3117 */  [ 0.347380799, 17 ],
  /* 3118 */  [ 0.347529403, 17 ],
  /* 3119 */  [ 0.347678023, 17 ],

  /* 3120 */  [ 0.347826659, 17 ],
  /* 3121 */  [ 0.347975311, 17 ],
  /* 3122 */  [ 0.348123979, 17 ],
  /* 3123 */  [ 0.348272662, 17 ],
  /* 3124 */  [ 0.348421362, 17 ],
  /* 3125 */  [ 0.348570077, 17 ],
  /* 3126 */  [ 0.348718808, 17 ],
  /* 3127 */  [ 0.348867555, 17 ],
  /* 3128 */  [ 0.349016318, 17 ],
  /* 3129 */  [ 0.349165097, 17 ],
  /* 3130 */  [ 0.349313892, 17 ],
  /* 3131 */  [ 0.349462702, 17 ],
  /* 3132 */  [ 0.349611528, 17 ],
  /* 3133 */  [ 0.349760370, 17 ],
  /* 3134 */  [ 0.349909228, 17 ],
  /* 3135 */  [ 0.350058102, 17 ],

  /* 3136 */  [ 0.350206992, 17 ],
  /* 3137 */  [ 0.350355897, 17 ],
  /* 3138 */  [ 0.350504818, 17 ],
  /* 3139 */  [ 0.350653756, 17 ],
  /* 3140 */  [ 0.350802708, 17 ],
  /* 3141 */  [ 0.350951677, 17 ],
  /* 3142 */  [ 0.351100662, 17 ],
  /* 3143 */  [ 0.351249662, 17 ],
  /* 3144 */  [ 0.351398678, 17 ],
  /* 3145 */  [ 0.351547710, 17 ],
  /* 3146 */  [ 0.351696758, 17 ],
  /* 3147 */  [ 0.351845821, 17 ],
  /* 3148 */  [ 0.351994901, 17 ],
  /* 3149 */  [ 0.352143996, 17 ],
  /* 3150 */  [ 0.352293107, 17 ],
  /* 3151 */  [ 0.352442233, 17 ],

  /* 3152 */  [ 0.352591376, 17 ],
  /* 3153 */  [ 0.352740534, 17 ],
  /* 3154 */  [ 0.352889708, 17 ],
  /* 3155 */  [ 0.353038898, 17 ],
  /* 3156 */  [ 0.353188103, 17 ],
  /* 3157 */  [ 0.353337325, 17 ],
  /* 3158 */  [ 0.353486562, 17 ],
  /* 3159 */  [ 0.353635814, 17 ],
  /* 3160 */  [ 0.353785083, 17 ],
  /* 3161 */  [ 0.353934367, 17 ],
  /* 3162 */  [ 0.354083667, 17 ],
  /* 3163 */  [ 0.354232983, 17 ],
  /* 3164 */  [ 0.354382314, 17 ],
  /* 3165 */  [ 0.354531662, 17 ],
  /* 3166 */  [ 0.354681025, 17 ],
  /* 3167 */  [ 0.354830403, 17 ],

  /* 3168 */  [ 0.354979798, 17 ],
  /* 3169 */  [ 0.355129208, 17 ],
  /* 3170 */  [ 0.355278634, 17 ],
  /* 3171 */  [ 0.355428075, 17 ],
  /* 3172 */  [ 0.355577533, 17 ],
  /* 3173 */  [ 0.355727006, 17 ],
  /* 3174 */  [ 0.355876494, 17 ],
  /* 3175 */  [ 0.356025999, 17 ],
  /* 3176 */  [ 0.356175519, 17 ],
  /* 3177 */  [ 0.356325054, 17 ],
  /* 3178 */  [ 0.356474606, 17 ],
  /* 3179 */  [ 0.356624173, 17 ],
  /* 3180 */  [ 0.356773756, 17 ],
  /* 3181 */  [ 0.356923354, 17 ],
  /* 3182 */  [ 0.357072969, 17 ],
  /* 3183 */  [ 0.357222598, 17 ],

  /* 3184 */  [ 0.357372244, 17 ],
  /* 3185 */  [ 0.357521905, 17 ],
  /* 3186 */  [ 0.357671582, 17 ],
  /* 3187 */  [ 0.357821275, 17 ],
  /* 3188 */  [ 0.357970983, 17 ],
  /* 3189 */  [ 0.358120707, 17 ],
  /* 3190 */  [ 0.358270446, 17 ],
  /* 3191 */  [ 0.358420201, 17 ],
  /* 3192 */  [ 0.358569972, 17 ],
  /* 3193 */  [ 0.358719758, 17 ],
  /* 3194 */  [ 0.358869560, 17 ],
  /* 3195 */  [ 0.359019378, 17 ],
  /* 3196 */  [ 0.359169211, 17 ],
  /* 3197 */  [ 0.359319060, 17 ],
  /* 3198 */  [ 0.359468925, 17 ],
  /* 3199 */  [ 0.359618805, 17 ],

  /* 3200 */  [ 0.359768701, 17 ],
  /* 3201 */  [ 0.359918612, 17 ],
  /* 3202 */  [ 0.360068540, 17 ],
  /* 3203 */  [ 0.360218482, 17 ],
  /* 3204 */  [ 0.360368440, 17 ],
  /* 3205 */  [ 0.360518414, 17 ],
  /* 3206 */  [ 0.360668404, 17 ],
  /* 3207 */  [ 0.360818409, 17 ],
  /* 3208 */  [ 0.360968429, 17 ],
  /* 3209 */  [ 0.361118466, 17 ],
  /* 3210 */  [ 0.361268517, 17 ],
  /* 3211 */  [ 0.361418585, 17 ],
  /* 3212 */  [ 0.361568668, 17 ],
  /* 3213 */  [ 0.361718766, 17 ],
  /* 3214 */  [ 0.361868881, 17 ],
  /* 3215 */  [ 0.362019010, 17 ],

  /* 3216 */  [ 0.362169156, 17 ],
  /* 3217 */  [ 0.362319316, 17 ],
  /* 3218 */  [ 0.362469493, 17 ],
  /* 3219 */  [ 0.362619685, 17 ],
  /* 3220 */  [ 0.362769892, 17 ],
  /* 3221 */  [ 0.362920115, 17 ],
  /* 3222 */  [ 0.363070354, 17 ],
  /* 3223 */  [ 0.363220608, 17 ],
  /* 3224 */  [ 0.363370878, 17 ],
  /* 3225 */  [ 0.363521163, 17 ],
  /* 3226 */  [ 0.363671464, 17 ],
  /* 3227 */  [ 0.363821780, 17 ],
  /* 3228 */  [ 0.363972112, 17 ],
  /* 3229 */  [ 0.364122459, 17 ],
  /* 3230 */  [ 0.364272822, 17 ],
  /* 3231 */  [ 0.364423200, 17 ],

  /* 3232 */  [ 0.364573594, 17 ],
  /* 3233 */  [ 0.364724004, 17 ],
  /* 3234 */  [ 0.364874429, 17 ],
  /* 3235 */  [ 0.365024869, 17 ],
  /* 3236 */  [ 0.365175325, 17 ],
  /* 3237 */  [ 0.365325796, 17 ],
  /* 3238 */  [ 0.365476283, 17 ],
  /* 3239 */  [ 0.365626786, 17 ],
  /* 3240 */  [ 0.365777304, 17 ],
  /* 3241 */  [ 0.365927837, 17 ],
  /* 3242 */  [ 0.366078386, 17 ],
  /* 3243 */  [ 0.366228950, 17 ],
  /* 3244 */  [ 0.366379530, 17 ],
  /* 3245 */  [ 0.366530125, 17 ],
  /* 3246 */  [ 0.366680736, 17 ],
  /* 3247 */  [ 0.366831362, 17 ],

  /* 3248 */  [ 0.366982004, 17 ],
  /* 3249 */  [ 0.367132661, 17 ],
  /* 3250 */  [ 0.367283334, 17 ],
  /* 3251 */  [ 0.367434022, 17 ],
  /* 3252 */  [ 0.367584725, 17 ],
  /* 3253 */  [ 0.367735444, 17 ],
  /* 3254 */  [ 0.367886179, 17 ],
  /* 3255 */  [ 0.368036929, 17 ],
  /* 3256 */  [ 0.368187694, 17 ],
  /* 3257 */  [ 0.368338475, 17 ],
  /* 3258 */  [ 0.368489271, 17 ],
  /* 3259 */  [ 0.368640082, 17 ],
  /* 3260 */  [ 0.368790909, 17 ],
  /* 3261 */  [ 0.368941752, 17 ],
  /* 3262 */  [ 0.369092610, 17 ],
  /* 3263 */  [ 0.369243483, 17 ],

  /* 3264 */  [ 0.369394372, 17 ],
  /* 3265 */  [ 0.369545276, 17 ],
  /* 3266 */  [ 0.369696195, 17 ],
  /* 3267 */  [ 0.369847130, 17 ],
  /* 3268 */  [ 0.369998080, 17 ],
  /* 3269 */  [ 0.370149046, 17 ],
  /* 3270 */  [ 0.370300027, 17 ],
  /* 3271 */  [ 0.370451024, 17 ],
  /* 3272 */  [ 0.370602036, 17 ],
  /* 3273 */  [ 0.370753063, 17 ],
  /* 3274 */  [ 0.370904105, 17 ],
  /* 3275 */  [ 0.371055163, 17 ],
  /* 3276 */  [ 0.371206237, 17 ],
  /* 3277 */  [ 0.371357326, 17 ],
  /* 3278 */  [ 0.371508430, 17 ],
  /* 3279 */  [ 0.371659549, 17 ],

  /* 3280 */  [ 0.371810684, 17 ],
  /* 3281 */  [ 0.371961834, 17 ],
  /* 3282 */  [ 0.372113000, 17 ],
  /* 3283 */  [ 0.372264181, 17 ],
  /* 3284 */  [ 0.372415377, 17 ],
  /* 3285 */  [ 0.372566589, 17 ],
  /* 3286 */  [ 0.372717816, 17 ],
  /* 3287 */  [ 0.372869058, 17 ],
  /* 3288 */  [ 0.373020316, 17 ],
  /* 3289 */  [ 0.373171589, 17 ],
  /* 3290 */  [ 0.373322877, 17 ],
  /* 3291 */  [ 0.373474181, 17 ],
  /* 3292 */  [ 0.373625500, 17 ],
  /* 3293 */  [ 0.373776834, 17 ],
  /* 3294 */  [ 0.373928184, 17 ],
  /* 3295 */  [ 0.374079549, 17 ],

  /* 3296 */  [ 0.374230929, 17 ],
  /* 3297 */  [ 0.374382325, 17 ],
  /* 3298 */  [ 0.374533735, 17 ],
  /* 3299 */  [ 0.374685162, 17 ],
  /* 3300 */  [ 0.374836603, 17 ],
  /* 3301 */  [ 0.374988060, 17 ],
  /* 3302 */  [ 0.375139532, 17 ],
  /* 3303 */  [ 0.375291019, 17 ],
  /* 3304 */  [ 0.375442522, 17 ],
  /* 3305 */  [ 0.375594040, 17 ],
  /* 3306 */  [ 0.375745573, 17 ],
  /* 3307 */  [ 0.375897122, 17 ],
  /* 3308 */  [ 0.376048685, 17 ],
  /* 3309 */  [ 0.376200265, 17 ],
  /* 3310 */  [ 0.376351859, 17 ],
  /* 3311 */  [ 0.376503468, 17 ],

  /* 3312 */  [ 0.376655093, 17 ],
  /* 3313 */  [ 0.376806733, 17 ],
  /* 3314 */  [ 0.376958389, 17 ],
  /* 3315 */  [ 0.377110059, 17 ],
  /* 3316 */  [ 0.377261745, 17 ],
  /* 3317 */  [ 0.377413446, 17 ],
  /* 3318 */  [ 0.377565163, 17 ],
  /* 3319 */  [ 0.377716894, 17 ],
  /* 3320 */  [ 0.377868641, 17 ],
  /* 3321 */  [ 0.378020403, 17 ],
  /* 3322 */  [ 0.378172181, 17 ],
  /* 3323 */  [ 0.378323973, 17 ],
  /* 3324 */  [ 0.378475781, 17 ],
  /* 3325 */  [ 0.378627604, 17 ],
  /* 3326 */  [ 0.378779442, 17 ],
  /* 3327 */  [ 0.378931296, 17 ],

  /* 3328 */  [ 0.379083164, 17 ],
  /* 3329 */  [ 0.379235048, 17 ],
  /* 3330 */  [ 0.379386947, 17 ],
  /* 3331 */  [ 0.379538862, 17 ],
  /* 3332 */  [ 0.379690791, 17 ],
  /* 3333 */  [ 0.379842736, 17 ],
  /* 3334 */  [ 0.379994696, 17 ],
  /* 3335 */  [ 0.380146671, 17 ],
  /* 3336 */  [ 0.380298661, 17 ],
  /* 3337 */  [ 0.380450666, 17 ],
  /* 3338 */  [ 0.380602687, 17 ],
  /* 3339 */  [ 0.380754723, 17 ],
  /* 3340 */  [ 0.380906774, 17 ],
  /* 3341 */  [ 0.381058840, 17 ],
  /* 3342 */  [ 0.381210921, 17 ],
  /* 3343 */  [ 0.381363018, 17 ],

  /* 3344 */  [ 0.381515130, 17 ],
  /* 3345 */  [ 0.381667257, 17 ],
  /* 3346 */  [ 0.381819399, 17 ],
  /* 3347 */  [ 0.381971556, 17 ],
  /* 3348 */  [ 0.382123728, 17 ],
  /* 3349 */  [ 0.382275916, 17 ],
  /* 3350 */  [ 0.382428118, 17 ],
  /* 3351 */  [ 0.382580336, 17 ],
  /* 3352 */  [ 0.382732569, 17 ],
  /* 3353 */  [ 0.382884817, 17 ],
  /* 3354 */  [ 0.383037080, 17 ],
  /* 3355 */  [ 0.383189358, 17 ],
  /* 3356 */  [ 0.383341652, 17 ],
  /* 3357 */  [ 0.383493960, 17 ],
  /* 3358 */  [ 0.383646284, 17 ],
  /* 3359 */  [ 0.383798623, 17 ],

  /* 3360 */  [ 0.383950977, 17 ],
  /* 3361 */  [ 0.384103346, 17 ],
  /* 3362 */  [ 0.384255730, 17 ],
  /* 3363 */  [ 0.384408129, 17 ],
  /* 3364 */  [ 0.384560544, 17 ],
  /* 3365 */  [ 0.384712973, 17 ],
  /* 3366 */  [ 0.384865418, 17 ],
  /* 3367 */  [ 0.385017878, 17 ],
  /* 3368 */  [ 0.385170352, 17 ],
  /* 3369 */  [ 0.385322842, 17 ],
  /* 3370 */  [ 0.385475347, 17 ],
  /* 3371 */  [ 0.385627867, 17 ],
  /* 3372 */  [ 0.385780402, 17 ],
  /* 3373 */  [ 0.385932953, 17 ],
  /* 3374 */  [ 0.386085518, 17 ],
  /* 3375 */  [ 0.386238098, 17 ],

  /* 3376 */  [ 0.386390694, 17 ],
  /* 3377 */  [ 0.386543304, 17 ],
  /* 3378 */  [ 0.386695930, 17 ],
  /* 3379 */  [ 0.386848570, 17 ],
  /* 3380 */  [ 0.387001226, 17 ],
  /* 3381 */  [ 0.387153897, 17 ],
  /* 3382 */  [ 0.387306582, 17 ],
  /* 3383 */  [ 0.387459283, 17 ],
  /* 3384 */  [ 0.387611999, 17 ],
  /* 3385 */  [ 0.387764730, 17 ],
  /* 3386 */  [ 0.387917476, 17 ],
  /* 3387 */  [ 0.388070237, 17 ],
  /* 3388 */  [ 0.388223013, 17 ],
  /* 3389 */  [ 0.388375804, 17 ],
  /* 3390 */  [ 0.388528610, 17 ],
  /* 3391 */  [ 0.388681431, 17 ],

  /* 3392 */  [ 0.388834268, 17 ],
  /* 3393 */  [ 0.388987119, 17 ],
  /* 3394 */  [ 0.389139985, 17 ],
  /* 3395 */  [ 0.389292866, 17 ],
  /* 3396 */  [ 0.389445762, 17 ],
  /* 3397 */  [ 0.389598674, 17 ],
  /* 3398 */  [ 0.389751600, 17 ],
  /* 3399 */  [ 0.389904541, 17 ],
  /* 3400 */  [ 0.390057497, 17 ],
  /* 3401 */  [ 0.390210468, 17 ],
  /* 3402 */  [ 0.390363455, 17 ],
  /* 3403 */  [ 0.390516456, 17 ],
  /* 3404 */  [ 0.390669472, 17 ],
  /* 3405 */  [ 0.390822503, 17 ],
  /* 3406 */  [ 0.390975549, 17 ],
  /* 3407 */  [ 0.391128611, 17 ],

  /* 3408 */  [ 0.391281687, 17 ],
  /* 3409 */  [ 0.391434778, 17 ],
  /* 3410 */  [ 0.391587884, 17 ],
  /* 3411 */  [ 0.391741005, 17 ],
  /* 3412 */  [ 0.391894141, 17 ],
  /* 3413 */  [ 0.392047292, 17 ],
  /* 3414 */  [ 0.392200458, 17 ],
  /* 3415 */  [ 0.392353638, 17 ],
  /* 3416 */  [ 0.392506834, 17 ],
  /* 3417 */  [ 0.392660045, 17 ],
  /* 3418 */  [ 0.392813271, 17 ],
  /* 3419 */  [ 0.392966511, 17 ],
  /* 3420 */  [ 0.393119767, 17 ],
  /* 3421 */  [ 0.393273038, 17 ],
  /* 3422 */  [ 0.393426323, 17 ],
  /* 3423 */  [ 0.393579623, 17 ],

  /* 3424 */  [ 0.393732939, 17 ],
  /* 3425 */  [ 0.393886269, 17 ],
  /* 3426 */  [ 0.394039614, 17 ],
  /* 3427 */  [ 0.394192974, 17 ],
  /* 3428 */  [ 0.394346349, 17 ],
  /* 3429 */  [ 0.394499739, 17 ],
  /* 3430 */  [ 0.394653144, 17 ],
  /* 3431 */  [ 0.394806564, 17 ],
  /* 3432 */  [ 0.394959999, 17 ],
  /* 3433 */  [ 0.395113448, 17 ],
  /* 3434 */  [ 0.395266913, 17 ],
  /* 3435 */  [ 0.395420392, 17 ],
  /* 3436 */  [ 0.395573886, 17 ],
  /* 3437 */  [ 0.395727395, 17 ],
  /* 3438 */  [ 0.395880919, 17 ],
  /* 3439 */  [ 0.396034458, 17 ],

  /* 3440 */  [ 0.396188012, 17 ],
  /* 3441 */  [ 0.396341581, 17 ],
  /* 3442 */  [ 0.396495164, 17 ],
  /* 3443 */  [ 0.396648763, 17 ],
  /* 3444 */  [ 0.396802376, 17 ],
  /* 3445 */  [ 0.396956004, 17 ],
  /* 3446 */  [ 0.397109647, 17 ],
  /* 3447 */  [ 0.397263305, 17 ],
  /* 3448 */  [ 0.397416978, 17 ],
  /* 3449 */  [ 0.397570666, 17 ],
  /* 3450 */  [ 0.397724368, 17 ],
  /* 3451 */  [ 0.397878085, 17 ],
  /* 3452 */  [ 0.398031818, 17 ],
  /* 3453 */  [ 0.398185565, 17 ],
  /* 3454 */  [ 0.398339326, 17 ],
  /* 3455 */  [ 0.398493103, 17 ],

  /* 3456 */  [ 0.398646895, 17 ],
  /* 3457 */  [ 0.398800701, 17 ],
  /* 3458 */  [ 0.398954522, 17 ],
  /* 3459 */  [ 0.399108358, 17 ],
  /* 3460 */  [ 0.399262209, 17 ],
  /* 3461 */  [ 0.399416075, 17 ],
  /* 3462 */  [ 0.399569955, 17 ],
  /* 3463 */  [ 0.399723851, 17 ],
  /* 3464 */  [ 0.399877761, 17 ],
  /* 3465 */  [ 0.400031686, 17 ],
  /* 3466 */  [ 0.400185625, 17 ],
  /* 3467 */  [ 0.400339580, 17 ],
  /* 3468 */  [ 0.400493549, 17 ],
  /* 3469 */  [ 0.400647534, 17 ],
  /* 3470 */  [ 0.400801533, 17 ],
  /* 3471 */  [ 0.400955546, 17 ],

  /* 3472 */  [ 0.401109575, 17 ],
  /* 3473 */  [ 0.401263618, 17 ],
  /* 3474 */  [ 0.401417676, 17 ],
  /* 3475 */  [ 0.401571749, 17 ],
  /* 3476 */  [ 0.401725837, 17 ],
  /* 3477 */  [ 0.401879939, 17 ],
  /* 3478 */  [ 0.402034056, 17 ],
  /* 3479 */  [ 0.402188188, 17 ],
  /* 3480 */  [ 0.402342335, 17 ],
  /* 3481 */  [ 0.402496497, 17 ],
  /* 3482 */  [ 0.402650673, 17 ],
  /* 3483 */  [ 0.402804864, 17 ],
  /* 3484 */  [ 0.402959070, 17 ],
  /* 3485 */  [ 0.403113291, 17 ],
  /* 3486 */  [ 0.403267526, 17 ],
  /* 3487 */  [ 0.403421776, 17 ],

  /* 3488 */  [ 0.403576041, 17 ],
  /* 3489 */  [ 0.403730320, 17 ],
  /* 3490 */  [ 0.403884615, 17 ],
  /* 3491 */  [ 0.404038924, 17 ],
  /* 3492 */  [ 0.404193247, 17 ],
  /* 3493 */  [ 0.404347586, 17 ],
  /* 3494 */  [ 0.404501939, 17 ],
  /* 3495 */  [ 0.404656307, 17 ],
  /* 3496 */  [ 0.404810690, 17 ],
  /* 3497 */  [ 0.404965087, 17 ],
  /* 3498 */  [ 0.405119499, 17 ],
  /* 3499 */  [ 0.405273926, 17 ],
  /* 3500 */  [ 0.405428368, 17 ],
  /* 3501 */  [ 0.405582824, 17 ],
  /* 3502 */  [ 0.405737295, 17 ],
  /* 3503 */  [ 0.405891781, 17 ],

  /* 3504 */  [ 0.406046281, 17 ],
  /* 3505 */  [ 0.406200796, 17 ],
  /* 3506 */  [ 0.406355326, 17 ],
  /* 3507 */  [ 0.406509870, 17 ],
  /* 3508 */  [ 0.406664429, 17 ],
  /* 3509 */  [ 0.406819003, 17 ],
  /* 3510 */  [ 0.406973592, 17 ],
  /* 3511 */  [ 0.407128195, 17 ],
  /* 3512 */  [ 0.407282813, 17 ],
  /* 3513 */  [ 0.407437445, 17 ],
  /* 3514 */  [ 0.407592093, 17 ],
  /* 3515 */  [ 0.407746754, 17 ],
  /* 3516 */  [ 0.407901431, 17 ],
  /* 3517 */  [ 0.408056122, 17 ],
  /* 3518 */  [ 0.408210828, 17 ],
  /* 3519 */  [ 0.408365549, 17 ],

  /* 3520 */  [ 0.408520284, 17 ],
  /* 3521 */  [ 0.408675034, 17 ],
  /* 3522 */  [ 0.408829798, 17 ],
  /* 3523 */  [ 0.408984577, 17 ],
  /* 3524 */  [ 0.409139371, 17 ],
  /* 3525 */  [ 0.409294180, 17 ],
  /* 3526 */  [ 0.409449003, 17 ],
  /* 3527 */  [ 0.409603840, 17 ],
  /* 3528 */  [ 0.409758693, 17 ],
  /* 3529 */  [ 0.409913560, 17 ],
  /* 3530 */  [ 0.410068441, 17 ],
  /* 3531 */  [ 0.410223338, 17 ],
  /* 3532 */  [ 0.410378249, 17 ],
  /* 3533 */  [ 0.410533174, 17 ],
  /* 3534 */  [ 0.410688114, 17 ],
  /* 3535 */  [ 0.410843069, 17 ],

  /* 3536 */  [ 0.410998038, 17 ],
  /* 3537 */  [ 0.411153022, 17 ],
  /* 3538 */  [ 0.411308021, 17 ],
  /* 3539 */  [ 0.411463034, 17 ],
  /* 3540 */  [ 0.411618062, 17 ],
  /* 3541 */  [ 0.411773104, 17 ],
  /* 3542 */  [ 0.411928161, 17 ],
  /* 3543 */  [ 0.412083232, 17 ],
  /* 3544 */  [ 0.412238319, 17 ],
  /* 3545 */  [ 0.412393419, 17 ],
  /* 3546 */  [ 0.412548535, 17 ],
  /* 3547 */  [ 0.412703664, 17 ],
  /* 3548 */  [ 0.412858809, 17 ],
  /* 3549 */  [ 0.413013968, 17 ],
  /* 3550 */  [ 0.413169142, 17 ],
  /* 3551 */  [ 0.413324330, 17 ],

  /* 3552 */  [ 0.413479532, 17 ],
  /* 3553 */  [ 0.413634750, 17 ],
  /* 3554 */  [ 0.413789982, 17 ],
  /* 3555 */  [ 0.413945228, 17 ],
  /* 3556 */  [ 0.414100489, 17 ],
  /* 3557 */  [ 0.414255765, 17 ],
  /* 3558 */  [ 0.414411055, 17 ],
  /* 3559 */  [ 0.414566359, 17 ],
  /* 3560 */  [ 0.414721679, 17 ],
  /* 3561 */  [ 0.414877012, 17 ],
  /* 3562 */  [ 0.415032361, 17 ],
  /* 3563 */  [ 0.415187723, 17 ],
  /* 3564 */  [ 0.415343101, 17 ],
  /* 3565 */  [ 0.415498493, 17 ],
  /* 3566 */  [ 0.415653899, 17 ],
  /* 3567 */  [ 0.415809320, 17 ],

  /* 3568 */  [ 0.415964756, 17 ],
  /* 3569 */  [ 0.416120206, 17 ],
  /* 3570 */  [ 0.416275670, 17 ],
  /* 3571 */  [ 0.416431149, 17 ],
  /* 3572 */  [ 0.416586643, 17 ],
  /* 3573 */  [ 0.416742151, 17 ],
  /* 3574 */  [ 0.416897673, 17 ],
  /* 3575 */  [ 0.417053210, 17 ],
  /* 3576 */  [ 0.417208762, 17 ],
  /* 3577 */  [ 0.417364328, 17 ],
  /* 3578 */  [ 0.417519909, 17 ],
  /* 3579 */  [ 0.417675504, 17 ],
  /* 3580 */  [ 0.417831113, 17 ],
  /* 3581 */  [ 0.417986737, 17 ],
  /* 3582 */  [ 0.418142376, 17 ],
  /* 3583 */  [ 0.418298029, 17 ],

  /* 3584 */  [ 0.418453696, 17 ],
  /* 3585 */  [ 0.418609378, 17 ],
  /* 3586 */  [ 0.418765075, 17 ],
  /* 3587 */  [ 0.418920786, 17 ],
  /* 3588 */  [ 0.419076511, 17 ],
  /* 3589 */  [ 0.419232251, 17 ],
  /* 3590 */  [ 0.419388005, 17 ],
  /* 3591 */  [ 0.419543774, 17 ],
  /* 3592 */  [ 0.419699557, 17 ],
  /* 3593 */  [ 0.419855355, 17 ],
  /* 3594 */  [ 0.420011167, 17 ],
  /* 3595 */  [ 0.420166994, 17 ],
  /* 3596 */  [ 0.420322835, 17 ],
  /* 3597 */  [ 0.420478690, 17 ],
  /* 3598 */  [ 0.420634560, 17 ],
  /* 3599 */  [ 0.420790445, 17 ],

  /* 3600 */  [ 0.420946343, 17 ],
  /* 3601 */  [ 0.421102257, 17 ],
  /* 3602 */  [ 0.421258184, 17 ],
  /* 3603 */  [ 0.421414127, 17 ],
  /* 3604 */  [ 0.421570083, 17 ],
  /* 3605 */  [ 0.421726054, 17 ],
  /* 3606 */  [ 0.421882040, 17 ],
  /* 3607 */  [ 0.422038039, 17 ],
  /* 3608 */  [ 0.422194054, 17 ],
  /* 3609 */  [ 0.422350082, 17 ],
  /* 3610 */  [ 0.422506125, 17 ],
  /* 3611 */  [ 0.422662183, 17 ],
  /* 3612 */  [ 0.422818255, 17 ],
  /* 3613 */  [ 0.422974341, 17 ],
  /* 3614 */  [ 0.423130442, 17 ],
  /* 3615 */  [ 0.423286557, 17 ],

  /* 3616 */  [ 0.423442686, 17 ],
  /* 3617 */  [ 0.423598830, 17 ],
  /* 3618 */  [ 0.423754988, 17 ],
  /* 3619 */  [ 0.423911161, 17 ],
  /* 3620 */  [ 0.424067348, 17 ],
  /* 3621 */  [ 0.424223550, 17 ],
  /* 3622 */  [ 0.424379765, 17 ],
  /* 3623 */  [ 0.424535996, 17 ],
  /* 3624 */  [ 0.424692240, 17 ],
  /* 3625 */  [ 0.424848499, 17 ],
  /* 3626 */  [ 0.425004772, 17 ],
  /* 3627 */  [ 0.425161060, 17 ],
  /* 3628 */  [ 0.425317362, 17 ],
  /* 3629 */  [ 0.425473678, 17 ],
  /* 3630 */  [ 0.425630009, 17 ],
  /* 3631 */  [ 0.425786354, 17 ],

  /* 3632 */  [ 0.425942714, 17 ],
  /* 3633 */  [ 0.426099088, 17 ],
  /* 3634 */  [ 0.426255476, 17 ],
  /* 3635 */  [ 0.426411878, 17 ],
  /* 3636 */  [ 0.426568295, 17 ],
  /* 3637 */  [ 0.426724726, 17 ],
  /* 3638 */  [ 0.426881172, 17 ],
  /* 3639 */  [ 0.427037632, 17 ],
  /* 3640 */  [ 0.427194106, 17 ],
  /* 3641 */  [ 0.427350594, 17 ],
  /* 3642 */  [ 0.427507097, 17 ],
  /* 3643 */  [ 0.427663614, 17 ],
  /* 3644 */  [ 0.427820146, 17 ],
  /* 3645 */  [ 0.427976692, 17 ],
  /* 3646 */  [ 0.428133252, 17 ],
  /* 3647 */  [ 0.428289826, 17 ],

  /* 3648 */  [ 0.428446415, 17 ],
  /* 3649 */  [ 0.428603018, 17 ],
  /* 3650 */  [ 0.428759635, 17 ],
  /* 3651 */  [ 0.428916267, 17 ],
  /* 3652 */  [ 0.429072913, 17 ],
  /* 3653 */  [ 0.429229573, 17 ],
  /* 3654 */  [ 0.429386248, 17 ],
  /* 3655 */  [ 0.429542937, 17 ],
  /* 3656 */  [ 0.429699640, 17 ],
  /* 3657 */  [ 0.429856357, 17 ],
  /* 3658 */  [ 0.430013089, 17 ],
  /* 3659 */  [ 0.430169835, 17 ],
  /* 3660 */  [ 0.430326595, 17 ],
  /* 3661 */  [ 0.430483370, 17 ],
  /* 3662 */  [ 0.430640159, 17 ],
  /* 3663 */  [ 0.430796962, 17 ],

  /* 3664 */  [ 0.430953779, 17 ],
  /* 3665 */  [ 0.431110611, 17 ],
  /* 3666 */  [ 0.431267457, 17 ],
  /* 3667 */  [ 0.431424317, 17 ],
  /* 3668 */  [ 0.431581192, 17 ],
  /* 3669 */  [ 0.431738080, 17 ],
  /* 3670 */  [ 0.431894983, 17 ],
  /* 3671 */  [ 0.432051900, 17 ],
  /* 3672 */  [ 0.432208832, 17 ],
  /* 3673 */  [ 0.432365778, 17 ],
  /* 3674 */  [ 0.432522737, 17 ],
  /* 3675 */  [ 0.432679712, 17 ],
  /* 3676 */  [ 0.432836700, 17 ],
  /* 3677 */  [ 0.432993703, 17 ],
  /* 3678 */  [ 0.433150720, 17 ],
  /* 3679 */  [ 0.433307751, 17 ],

  /* 3680 */  [ 0.433464796, 17 ],
  /* 3681 */  [ 0.433621856, 17 ],
  /* 3682 */  [ 0.433778929, 17 ],
  /* 3683 */  [ 0.433936017, 17 ],
  /* 3684 */  [ 0.434093120, 17 ],
  /* 3685 */  [ 0.434250236, 17 ],
  /* 3686 */  [ 0.434407367, 17 ],
  /* 3687 */  [ 0.434564512, 17 ],
  /* 3688 */  [ 0.434721671, 17 ],
  /* 3689 */  [ 0.434878844, 17 ],
  /* 3690 */  [ 0.435036032, 17 ],
  /* 3691 */  [ 0.435193233, 17 ],
  /* 3692 */  [ 0.435350449, 17 ],
  /* 3693 */  [ 0.435507679, 17 ],
  /* 3694 */  [ 0.435664924, 17 ],
  /* 3695 */  [ 0.435822182, 17 ],

  /* 3696 */  [ 0.435979455, 17 ],
  /* 3697 */  [ 0.436136741, 17 ],
  /* 3698 */  [ 0.436294042, 17 ],
  /* 3699 */  [ 0.436451358, 17 ],
  /* 3700 */  [ 0.436608687, 17 ],
  /* 3701 */  [ 0.436766031, 17 ],
  /* 3702 */  [ 0.436923388, 17 ],
  /* 3703 */  [ 0.437080760, 17 ],
  /* 3704 */  [ 0.437238146, 17 ],
  /* 3705 */  [ 0.437395547, 17 ],
  /* 3706 */  [ 0.437552961, 17 ],
  /* 3707 */  [ 0.437710389, 17 ],
  /* 3708 */  [ 0.437867832, 17 ],
  /* 3709 */  [ 0.438025289, 17 ],
  /* 3710 */  [ 0.438182760, 17 ],
  /* 3711 */  [ 0.438340245, 17 ],

  /* 3712 */  [ 0.438497744, 17 ],
  /* 3713 */  [ 0.438655258, 17 ],
  /* 3714 */  [ 0.438812785, 17 ],
  /* 3715 */  [ 0.438970327, 17 ],
  /* 3716 */  [ 0.439127883, 17 ],
  /* 3717 */  [ 0.439285453, 17 ],
  /* 3718 */  [ 0.439443037, 17 ],
  /* 3719 */  [ 0.439600635, 17 ],
  /* 3720 */  [ 0.439758248, 17 ],
  /* 3721 */  [ 0.439915874, 17 ],
  /* 3722 */  [ 0.440073515, 17 ],
  /* 3723 */  [ 0.440231170, 17 ],
  /* 3724 */  [ 0.440388839, 17 ],
  /* 3725 */  [ 0.440546522, 17 ],
  /* 3726 */  [ 0.440704219, 17 ],
  /* 3727 */  [ 0.440861930, 17 ],

  /* 3728 */  [ 0.441019655, 17 ],
  /* 3729 */  [ 0.441177395, 17 ],
  /* 3730 */  [ 0.441335148, 17 ],
  /* 3731 */  [ 0.441492916, 17 ],
  /* 3732 */  [ 0.441650697, 17 ],
  /* 3733 */  [ 0.441808493, 17 ],
  /* 3734 */  [ 0.441966303, 17 ],
  /* 3735 */  [ 0.442124127, 17 ],
  /* 3736 */  [ 0.442281965, 17 ],
  /* 3737 */  [ 0.442439817, 17 ],
  /* 3738 */  [ 0.442597683, 17 ],
  /* 3739 */  [ 0.442755564, 17 ],
  /* 3740 */  [ 0.442913458, 17 ],
  /* 3741 */  [ 0.443071366, 17 ],
  /* 3742 */  [ 0.443229289, 17 ],
  /* 3743 */  [ 0.443387226, 17 ],

  /* 3744 */  [ 0.443545176, 17 ],
  /* 3745 */  [ 0.443703141, 17 ],
  /* 3746 */  [ 0.443861120, 17 ],
  /* 3747 */  [ 0.444019113, 17 ],
  /* 3748 */  [ 0.444177119, 17 ],
  /* 3749 */  [ 0.444335140, 17 ],
  /* 3750 */  [ 0.444493175, 17 ],
  /* 3751 */  [ 0.444651224, 17 ],
  /* 3752 */  [ 0.444809288, 17 ],
  /* 3753 */  [ 0.444967365, 17 ],
  /* 3754 */  [ 0.445125456, 17 ],
  /* 3755 */  [ 0.445283561, 17 ],
  /* 3756 */  [ 0.445441680, 17 ],
  /* 3757 */  [ 0.445599814, 17 ],
  /* 3758 */  [ 0.445757961, 17 ],
  /* 3759 */  [ 0.445916122, 17 ],

  /* 3760 */  [ 0.446074298, 17 ],
  /* 3761 */  [ 0.446232487, 17 ],
  /* 3762 */  [ 0.446390690, 17 ],
  /* 3763 */  [ 0.446548908, 17 ],
  /* 3764 */  [ 0.446707139, 17 ],
  /* 3765 */  [ 0.446865385, 17 ],
  /* 3766 */  [ 0.447023644, 17 ],
  /* 3767 */  [ 0.447181918, 17 ],
  /* 3768 */  [ 0.447340205, 17 ],
  /* 3769 */  [ 0.447498507, 17 ],
  /* 3770 */  [ 0.447656822, 17 ],
  /* 3771 */  [ 0.447815152, 17 ],
  /* 3772 */  [ 0.447973495, 17 ],
  /* 3773 */  [ 0.448131853, 17 ],
  /* 3774 */  [ 0.448290224, 17 ],
  /* 3775 */  [ 0.448448609, 17 ],

  /* 3776 */  [ 0.448607009, 17 ],
  /* 3777 */  [ 0.448765422, 17 ],
  /* 3778 */  [ 0.448923850, 17 ],
  /* 3779 */  [ 0.449082291, 17 ],
  /* 3780 */  [ 0.449240746, 17 ],
  /* 3781 */  [ 0.449399216, 17 ],
  /* 3782 */  [ 0.449557699, 17 ],
  /* 3783 */  [ 0.449716196, 17 ],
  /* 3784 */  [ 0.449874708, 17 ],
  /* 3785 */  [ 0.450033233, 17 ],
  /* 3786 */  [ 0.450191772, 17 ],
  /* 3787 */  [ 0.450350325, 17 ],
  /* 3788 */  [ 0.450508892, 17 ],
  /* 3789 */  [ 0.450667473, 17 ],
  /* 3790 */  [ 0.450826068, 17 ],
  /* 3791 */  [ 0.450984677, 17 ],

  /* 3792 */  [ 0.451143300, 17 ],
  /* 3793 */  [ 0.451301937, 17 ],
  /* 3794 */  [ 0.451460588, 17 ],
  /* 3795 */  [ 0.451619252, 17 ],
  /* 3796 */  [ 0.451777931, 17 ],
  /* 3797 */  [ 0.451936623, 17 ],
  /* 3798 */  [ 0.452095330, 17 ],
  /* 3799 */  [ 0.452254050, 17 ],
  /* 3800 */  [ 0.452412785, 17 ],
  /* 3801 */  [ 0.452571533, 17 ],
  /* 3802 */  [ 0.452730295, 17 ],
  /* 3803 */  [ 0.452889071, 17 ],
  /* 3804 */  [ 0.453047861, 17 ],
  /* 3805 */  [ 0.453206665, 17 ],
  /* 3806 */  [ 0.453365483, 17 ],
  /* 3807 */  [ 0.453524315, 17 ],

  /* 3808 */  [ 0.453683161, 17 ],
  /* 3809 */  [ 0.453842020, 17 ],
  /* 3810 */  [ 0.454000894, 17 ],
  /* 3811 */  [ 0.454159781, 17 ],
  /* 3812 */  [ 0.454318683, 17 ],
  /* 3813 */  [ 0.454477598, 17 ],
  /* 3814 */  [ 0.454636527, 17 ],
  /* 3815 */  [ 0.454795470, 17 ],
  /* 3816 */  [ 0.454954427, 17 ],
  /* 3817 */  [ 0.455113397, 17 ],
  /* 3818 */  [ 0.455272382, 17 ],
  /* 3819 */  [ 0.455431381, 17 ],
  /* 3820 */  [ 0.455590393, 17 ],
  /* 3821 */  [ 0.455749419, 17 ],
  /* 3822 */  [ 0.455908459, 17 ],
  /* 3823 */  [ 0.456067513, 17 ],

  /* 3824 */  [ 0.456226581, 17 ],
  /* 3825 */  [ 0.456385663, 17 ],
  /* 3826 */  [ 0.456544759, 17 ],
  /* 3827 */  [ 0.456703868, 17 ],
  /* 3828 */  [ 0.456862992, 17 ],
  /* 3829 */  [ 0.457022129, 17 ],
  /* 3830 */  [ 0.457181280, 17 ],
  /* 3831 */  [ 0.457340445, 17 ],
  /* 3832 */  [ 0.457499623, 17 ],
  /* 3833 */  [ 0.457658816, 17 ],
  /* 3834 */  [ 0.457818022, 17 ],
  /* 3835 */  [ 0.457977243, 17 ],
  /* 3836 */  [ 0.458136477, 17 ],
  /* 3837 */  [ 0.458295725, 17 ],
  /* 3838 */  [ 0.458454987, 17 ],
  /* 3839 */  [ 0.458614262, 17 ],

  /* 3840 */  [ 0.458773552, 17 ],
  /* 3841 */  [ 0.458932855, 17 ],
  /* 3842 */  [ 0.459092172, 17 ],
  /* 3843 */  [ 0.459251503, 17 ],
  /* 3844 */  [ 0.459410848, 17 ],
  /* 3845 */  [ 0.459570206, 17 ],
  /* 3846 */  [ 0.459729579, 17 ],
  /* 3847 */  [ 0.459888965, 17 ],
  /* 3848 */  [ 0.460048365, 17 ],
  /* 3849 */  [ 0.460207779, 17 ],
  /* 3850 */  [ 0.460367206, 17 ],
  /* 3851 */  [ 0.460526648, 17 ],
  /* 3852 */  [ 0.460686103, 17 ],
  /* 3853 */  [ 0.460845572, 17 ],
  /* 3854 */  [ 0.461005055, 17 ],
  /* 3855 */  [ 0.461164552, 17 ],

  /* 3856 */  [ 0.461324062, 17 ],
  /* 3857 */  [ 0.461483586, 17 ],
  /* 3858 */  [ 0.461643124, 17 ],
  /* 3859 */  [ 0.461802676, 17 ],
  /* 3860 */  [ 0.461962242, 17 ],
  /* 3861 */  [ 0.462121821, 17 ],
  /* 3862 */  [ 0.462281414, 17 ],
  /* 3863 */  [ 0.462441021, 17 ],
  /* 3864 */  [ 0.462600642, 17 ],
  /* 3865 */  [ 0.462760276, 17 ],
  /* 3866 */  [ 0.462919924, 17 ],
  /* 3867 */  [ 0.463079586, 17 ],
  /* 3868 */  [ 0.463239262, 17 ],
  /* 3869 */  [ 0.463398951, 17 ],
  /* 3870 */  [ 0.463558655, 17 ],
  /* 3871 */  [ 0.463718372, 17 ],

  /* 3872 */  [ 0.463878102, 17 ],
  /* 3873 */  [ 0.464037847, 17 ],
  /* 3874 */  [ 0.464197605, 17 ],
  /* 3875 */  [ 0.464357377, 17 ],
  /* 3876 */  [ 0.464517163, 17 ],
  /* 3877 */  [ 0.464676962, 17 ],
  /* 3878 */  [ 0.464836776, 17 ],
  /* 3879 */  [ 0.464996603, 17 ],
  /* 3880 */  [ 0.465156443, 17 ],
  /* 3881 */  [ 0.465316298, 17 ],
  /* 3882 */  [ 0.465476166, 17 ],
  /* 3883 */  [ 0.465636048, 17 ],
  /* 3884 */  [ 0.465795943, 17 ],
  /* 3885 */  [ 0.465955853, 17 ],
  /* 3886 */  [ 0.466115776, 17 ],
  /* 3887 */  [ 0.466275713, 17 ],

  /* 3888 */  [ 0.466435663, 17 ],
  /* 3889 */  [ 0.466595627, 17 ],
  /* 3890 */  [ 0.466755605, 17 ],
  /* 3891 */  [ 0.466915597, 17 ],
  /* 3892 */  [ 0.467075602, 17 ],
  /* 3893 */  [ 0.467235621, 17 ],
  /* 3894 */  [ 0.467395654, 17 ],
  /* 3895 */  [ 0.467555701, 17 ],
  /* 3896 */  [ 0.467715761, 17 ],
  /* 3897 */  [ 0.467875835, 17 ],
  /* 3898 */  [ 0.468035922, 17 ],
  /* 3899 */  [ 0.468196023, 17 ],
  /* 3900 */  [ 0.468356138, 17 ],
  /* 3901 */  [ 0.468516267, 17 ],
  /* 3902 */  [ 0.468676409, 17 ],
  /* 3903 */  [ 0.468836565, 17 ],

  /* 3904 */  [ 0.468996735, 17 ],
  /* 3905 */  [ 0.469156918, 17 ],
  /* 3906 */  [ 0.469317115, 17 ],
  /* 3907 */  [ 0.469477326, 17 ],
  /* 3908 */  [ 0.469637550, 17 ],
  /* 3909 */  [ 0.469797788, 17 ],
  /* 3910 */  [ 0.469958040, 17 ],
  /* 3911 */  [ 0.470118305, 17 ],
  /* 3912 */  [ 0.470278584, 17 ],
  /* 3913 */  [ 0.470438877, 17 ],
  /* 3914 */  [ 0.470599183, 17 ],
  /* 3915 */  [ 0.470759503, 17 ],
  /* 3916 */  [ 0.470919836, 17 ],
  /* 3917 */  [ 0.471080184, 17 ],
  /* 3918 */  [ 0.471240545, 17 ],
  /* 3919 */  [ 0.471400919, 17 ],

  /* 3920 */  [ 0.471561307, 17 ],
  /* 3921 */  [ 0.471721709, 17 ],
  /* 3922 */  [ 0.471882125, 17 ],
  /* 3923 */  [ 0.472042554, 17 ],
  /* 3924 */  [ 0.472202996, 17 ],
  /* 3925 */  [ 0.472363453, 17 ],
  /* 3926 */  [ 0.472523923, 17 ],
  /* 3927 */  [ 0.472684406, 17 ],
  /* 3928 */  [ 0.472844904, 17 ],
  /* 3929 */  [ 0.473005414, 17 ],
  /* 3930 */  [ 0.473165939, 17 ],
  /* 3931 */  [ 0.473326477, 17 ],
  /* 3932 */  [ 0.473487029, 17 ],
  /* 3933 */  [ 0.473647594, 17 ],
  /* 3934 */  [ 0.473808173, 17 ],
  /* 3935 */  [ 0.473968765, 17 ],

  /* 3936 */  [ 0.474129372, 17 ],
  /* 3937 */  [ 0.474289991, 17 ],
  /* 3938 */  [ 0.474450625, 17 ],
  /* 3939 */  [ 0.474611272, 17 ],
  /* 3940 */  [ 0.474771932, 17 ],
  /* 3941 */  [ 0.474932606, 17 ],
  /* 3942 */  [ 0.475093294, 17 ],
  /* 3943 */  [ 0.475253995, 17 ],
  /* 3944 */  [ 0.475414710, 17 ],
  /* 3945 */  [ 0.475575439, 17 ],
  /* 3946 */  [ 0.475736181, 17 ],
  /* 3947 */  [ 0.475896936, 17 ],
  /* 3948 */  [ 0.476057705, 17 ],
  /* 3949 */  [ 0.476218488, 17 ],
  /* 3950 */  [ 0.476379285, 17 ],
  /* 3951 */  [ 0.476540095, 17 ],

  /* 3952 */  [ 0.476700918, 17 ],
  /* 3953 */  [ 0.476861755, 17 ],
  /* 3954 */  [ 0.477022606, 17 ],
  /* 3955 */  [ 0.477183470, 17 ],
  /* 3956 */  [ 0.477344348, 17 ],
  /* 3957 */  [ 0.477505239, 17 ],
  /* 3958 */  [ 0.477666144, 17 ],
  /* 3959 */  [ 0.477827062, 17 ],
  /* 3960 */  [ 0.477987994, 17 ],
  /* 3961 */  [ 0.478148940, 17 ],
  /* 3962 */  [ 0.478309899, 17 ],
  /* 3963 */  [ 0.478470871, 17 ],
  /* 3964 */  [ 0.478631857, 17 ],
  /* 3965 */  [ 0.478792857, 17 ],
  /* 3966 */  [ 0.478953870, 17 ],
  /* 3967 */  [ 0.479114897, 17 ],

  /* 3968 */  [ 0.479275937, 17 ],
  /* 3969 */  [ 0.479436991, 17 ],
  /* 3970 */  [ 0.479598058, 17 ],
  /* 3971 */  [ 0.479759139, 17 ],
  /* 3972 */  [ 0.479920233, 17 ],
  /* 3973 */  [ 0.480081341, 17 ],
  /* 3974 */  [ 0.480242463, 17 ],
  /* 3975 */  [ 0.480403598, 17 ],
  /* 3976 */  [ 0.480564746, 17 ],
  /* 3977 */  [ 0.480725908, 17 ],
  /* 3978 */  [ 0.480887083, 17 ],
  /* 3979 */  [ 0.481048272, 17 ],
  /* 3980 */  [ 0.481209475, 17 ],
  /* 3981 */  [ 0.481370691, 17 ],
  /* 3982 */  [ 0.481531920, 17 ],
  /* 3983 */  [ 0.481693163, 17 ],

  /* 3984 */  [ 0.481854420, 17 ],
  /* 3985 */  [ 0.482015690, 17 ],
  /* 3986 */  [ 0.482176973, 17 ],
  /* 3987 */  [ 0.482338270, 17 ],
  /* 3988 */  [ 0.482499580, 17 ],
  /* 3989 */  [ 0.482660904, 17 ],
  /* 3990 */  [ 0.482822242, 17 ],
  /* 3991 */  [ 0.482983592, 17 ],
  /* 3992 */  [ 0.483144957, 17 ],
  /* 3993 */  [ 0.483306335, 17 ],
  /* 3994 */  [ 0.483467726, 17 ],
  /* 3995 */  [ 0.483629131, 17 ],
  /* 3996 */  [ 0.483790549, 17 ],
  /* 3997 */  [ 0.483951980, 17 ],
  /* 3998 */  [ 0.484113426, 17 ],
  /* 3999 */  [ 0.484274884, 17 ],

  /* 4000 */  [ 0.484436356, 17 ],
  /* 4001 */  [ 0.484597842, 17 ],
  /* 4002 */  [ 0.484759341, 17 ],
  /* 4003 */  [ 0.484920853, 17 ],
  /* 4004 */  [ 0.485082379, 17 ],
  /* 4005 */  [ 0.485243918, 17 ],
  /* 4006 */  [ 0.485405471, 17 ],
  /* 4007 */  [ 0.485567037, 17 ],
  /* 4008 */  [ 0.485728617, 17 ],
  /* 4009 */  [ 0.485890210, 17 ],
  /* 4010 */  [ 0.486051817, 17 ],
  /* 4011 */  [ 0.486213436, 17 ],
  /* 4012 */  [ 0.486375070, 17 ],
  /* 4013 */  [ 0.486536717, 17 ],
  /* 4014 */  [ 0.486698377, 17 ],
  /* 4015 */  [ 0.486860051, 17 ],

  /* 4016 */  [ 0.487021738, 17 ],
  /* 4017 */  [ 0.487183438, 17 ],
  /* 4018 */  [ 0.487345152, 17 ],
  /* 4019 */  [ 0.487506879, 17 ],
  /* 4020 */  [ 0.487668620, 17 ],
  /* 4021 */  [ 0.487830374, 17 ],
  /* 4022 */  [ 0.487992142, 17 ],
  /* 4023 */  [ 0.488153923, 17 ],
  /* 4024 */  [ 0.488315717, 17 ],
  /* 4025 */  [ 0.488477525, 17 ],
  /* 4026 */  [ 0.488639346, 17 ],
  /* 4027 */  [ 0.488801181, 17 ],
  /* 4028 */  [ 0.488963029, 17 ],
  /* 4029 */  [ 0.489124890, 17 ],
  /* 4030 */  [ 0.489286765, 17 ],
  /* 4031 */  [ 0.489448653, 17 ],

  /* 4032 */  [ 0.489610555, 17 ],
  /* 4033 */  [ 0.489772470, 17 ],
  /* 4034 */  [ 0.489934398, 17 ],
  /* 4035 */  [ 0.490096340, 17 ],
  /* 4036 */  [ 0.490258295, 17 ],
  /* 4037 */  [ 0.490420263, 17 ],
  /* 4038 */  [ 0.490582245, 17 ],
  /* 4039 */  [ 0.490744240, 17 ],
  /* 4040 */  [ 0.490906249, 17 ],
  /* 4041 */  [ 0.491068271, 17 ],
  /* 4042 */  [ 0.491230306, 17 ],
  /* 4043 */  [ 0.491392355, 17 ],
  /* 4044 */  [ 0.491554417, 17 ],
  /* 4045 */  [ 0.491716492, 17 ],
  /* 4046 */  [ 0.491878581, 17 ],
  /* 4047 */  [ 0.492040683, 17 ],

  /* 4048 */  [ 0.492202799, 17 ],
  /* 4049 */  [ 0.492364928, 17 ],
  /* 4050 */  [ 0.492527070, 17 ],
  /* 4051 */  [ 0.492689225, 17 ],
  /* 4052 */  [ 0.492851394, 17 ],
  /* 4053 */  [ 0.493013576, 17 ],
  /* 4054 */  [ 0.493175772, 17 ],
  /* 4055 */  [ 0.493337981, 17 ],
  /* 4056 */  [ 0.493500203, 17 ],
  /* 4057 */  [ 0.493662438, 17 ],
  /* 4058 */  [ 0.493824687, 17 ],
  /* 4059 */  [ 0.493986949, 17 ],
  /* 4060 */  [ 0.494149225, 17 ],
  /* 4061 */  [ 0.494311514, 17 ],
  /* 4062 */  [ 0.494473816, 17 ],
  /* 4063 */  [ 0.494636131, 17 ],

  /* 4064 */  [ 0.494798460, 17 ],
  /* 4065 */  [ 0.494960802, 17 ],
  /* 4066 */  [ 0.495123158, 17 ],
  /* 4067 */  [ 0.495285526, 17 ],
  /* 4068 */  [ 0.495447908, 17 ],
  /* 4069 */  [ 0.495610304, 17 ],
  /* 4070 */  [ 0.495772712, 17 ],
  /* 4071 */  [ 0.495935134, 17 ],
  /* 4072 */  [ 0.496097570, 17 ],
  /* 4073 */  [ 0.496260018, 17 ],
  /* 4074 */  [ 0.496422480, 17 ],
  /* 4075 */  [ 0.496584955, 17 ],
  /* 4076 */  [ 0.496747444, 17 ],
  /* 4077 */  [ 0.496909945, 17 ],
  /* 4078 */  [ 0.497072460, 17 ],
  /* 4079 */  [ 0.497234989, 17 ],

  /* 4080 */  [ 0.497397530, 17 ],
  /* 4081 */  [ 0.497560085, 17 ],
  /* 4082 */  [ 0.497722653, 17 ],
  /* 4083 */  [ 0.497885235, 17 ],
  /* 4084 */  [ 0.498047829, 17 ],
  /* 4085 */  [ 0.498210437, 17 ],
  /* 4086 */  [ 0.498373058, 17 ],
  /* 4087 */  [ 0.498535693, 17 ],
  /* 4088 */  [ 0.498698341, 17 ],
  /* 4089 */  [ 0.498861002, 17 ],
  /* 4090 */  [ 0.499023676, 17 ],
  /* 4091 */  [ 0.499186364, 17 ],
  /* 4092 */  [ 0.499349064, 17 ],
  /* 4093 */  [ 0.499511778, 17 ],
  /* 4094 */  [ 0.499674506, 17 ],
  /* 4095 */  [ 0.499837246, 17 ],

  /* 4096 */  [ 0.250000000, 18 ],
  /* 4097 */  [ 0.250081384, 18 ],
  /* 4098 */  [ 0.250162774, 18 ],
  /* 4099 */  [ 0.250244170, 18 ],
  /* 4100 */  [ 0.250325574, 18 ],
  /* 4101 */  [ 0.250406984, 18 ],
  /* 4102 */  [ 0.250488400, 18 ],
  /* 4103 */  [ 0.250569824, 18 ],
  /* 4104 */  [ 0.250651254, 18 ],
  /* 4105 */  [ 0.250732690, 18 ],
  /* 4106 */  [ 0.250814133, 18 ],
  /* 4107 */  [ 0.250895583, 18 ],
  /* 4108 */  [ 0.250977039, 18 ],
  /* 4109 */  [ 0.251058502, 18 ],
  /* 4110 */  [ 0.251139971, 18 ],
  /* 4111 */  [ 0.251221448, 18 ],

  /* 4112 */  [ 0.251302930, 18 ],
  /* 4113 */  [ 0.251384420, 18 ],
  /* 4114 */  [ 0.251465916, 18 ],
  /* 4115 */  [ 0.251547418, 18 ],
  /* 4116 */  [ 0.251628927, 18 ],
  /* 4117 */  [ 0.251710443, 18 ],
  /* 4118 */  [ 0.251791965, 18 ],
  /* 4119 */  [ 0.251873494, 18 ],
  /* 4120 */  [ 0.251955030, 18 ],
  /* 4121 */  [ 0.252036572, 18 ],
  /* 4122 */  [ 0.252118121, 18 ],
  /* 4123 */  [ 0.252199676, 18 ],
  /* 4124 */  [ 0.252281238, 18 ],
  /* 4125 */  [ 0.252362807, 18 ],
  /* 4126 */  [ 0.252444382, 18 ],
  /* 4127 */  [ 0.252525963, 18 ],

  /* 4128 */  [ 0.252607552, 18 ],
  /* 4129 */  [ 0.252689147, 18 ],
  /* 4130 */  [ 0.252770748, 18 ],
  /* 4131 */  [ 0.252852356, 18 ],
  /* 4132 */  [ 0.252933971, 18 ],
  /* 4133 */  [ 0.253015592, 18 ],
  /* 4134 */  [ 0.253097220, 18 ],
  /* 4135 */  [ 0.253178854, 18 ],
  /* 4136 */  [ 0.253260495, 18 ],
  /* 4137 */  [ 0.253342143, 18 ],
  /* 4138 */  [ 0.253423797, 18 ],
  /* 4139 */  [ 0.253505457, 18 ],
  /* 4140 */  [ 0.253587125, 18 ],
  /* 4141 */  [ 0.253668799, 18 ],
  /* 4142 */  [ 0.253750479, 18 ],
  /* 4143 */  [ 0.253832166, 18 ],

  /* 4144 */  [ 0.253913860, 18 ],
  /* 4145 */  [ 0.253995560, 18 ],
  /* 4146 */  [ 0.254077266, 18 ],
  /* 4147 */  [ 0.254158980, 18 ],
  /* 4148 */  [ 0.254240700, 18 ],
  /* 4149 */  [ 0.254322426, 18 ],
  /* 4150 */  [ 0.254404159, 18 ],
  /* 4151 */  [ 0.254485899, 18 ],
  /* 4152 */  [ 0.254567645, 18 ],
  /* 4153 */  [ 0.254649397, 18 ],
  /* 4154 */  [ 0.254731157, 18 ],
  /* 4155 */  [ 0.254812922, 18 ],
  /* 4156 */  [ 0.254894695, 18 ],
  /* 4157 */  [ 0.254976474, 18 ],
  /* 4158 */  [ 0.255058259, 18 ],
  /* 4159 */  [ 0.255140051, 18 ],

  /* 4160 */  [ 0.255221850, 18 ],
  /* 4161 */  [ 0.255303655, 18 ],
  /* 4162 */  [ 0.255385467, 18 ],
  /* 4163 */  [ 0.255467285, 18 ],
  /* 4164 */  [ 0.255549110, 18 ],
  /* 4165 */  [ 0.255630941, 18 ],
  /* 4166 */  [ 0.255712779, 18 ],
  /* 4167 */  [ 0.255794624, 18 ],
  /* 4168 */  [ 0.255876475, 18 ],
  /* 4169 */  [ 0.255958332, 18 ],
  /* 4170 */  [ 0.256040196, 18 ],
  /* 4171 */  [ 0.256122067, 18 ],
  /* 4172 */  [ 0.256203944, 18 ],
  /* 4173 */  [ 0.256285828, 18 ],
  /* 4174 */  [ 0.256367718, 18 ],
  /* 4175 */  [ 0.256449615, 18 ],

  /* 4176 */  [ 0.256531518, 18 ],
  /* 4177 */  [ 0.256613428, 18 ],
  /* 4178 */  [ 0.256695344, 18 ],
  /* 4179 */  [ 0.256777267, 18 ],
  /* 4180 */  [ 0.256859197, 18 ],
  /* 4181 */  [ 0.256941133, 18 ],
  /* 4182 */  [ 0.257023076, 18 ],
  /* 4183 */  [ 0.257105025, 18 ],
  /* 4184 */  [ 0.257186980, 18 ],
  /* 4185 */  [ 0.257268942, 18 ],
  /* 4186 */  [ 0.257350911, 18 ],
  /* 4187 */  [ 0.257432886, 18 ],
  /* 4188 */  [ 0.257514868, 18 ],
  /* 4189 */  [ 0.257596856, 18 ],
  /* 4190 */  [ 0.257678851, 18 ],
  /* 4191 */  [ 0.257760852, 18 ],

  /* 4192 */  [ 0.257842860, 18 ],
  /* 4193 */  [ 0.257924875, 18 ],
  /* 4194 */  [ 0.258006895, 18 ],
  /* 4195 */  [ 0.258088923, 18 ],
  /* 4196 */  [ 0.258170957, 18 ],
  /* 4197 */  [ 0.258252997, 18 ],
  /* 4198 */  [ 0.258335044, 18 ],
  /* 4199 */  [ 0.258417097, 18 ],
  /* 4200 */  [ 0.258499157, 18 ],
  /* 4201 */  [ 0.258581224, 18 ],
  /* 4202 */  [ 0.258663297, 18 ],
  /* 4203 */  [ 0.258745376, 18 ],
  /* 4204 */  [ 0.258827462, 18 ],
  /* 4205 */  [ 0.258909555, 18 ],
  /* 4206 */  [ 0.258991654, 18 ],
  /* 4207 */  [ 0.259073760, 18 ],

  /* 4208 */  [ 0.259155872, 18 ],
  /* 4209 */  [ 0.259237990, 18 ],
  /* 4210 */  [ 0.259320115, 18 ],
  /* 4211 */  [ 0.259402247, 18 ],
  /* 4212 */  [ 0.259484385, 18 ],
  /* 4213 */  [ 0.259566529, 18 ],
  /* 4214 */  [ 0.259648680, 18 ],
  /* 4215 */  [ 0.259730838, 18 ],
  /* 4216 */  [ 0.259813002, 18 ],
  /* 4217 */  [ 0.259895173, 18 ],
  /* 4218 */  [ 0.259977350, 18 ],
  /* 4219 */  [ 0.260059533, 18 ],
  /* 4220 */  [ 0.260141723, 18 ],
  /* 4221 */  [ 0.260223920, 18 ],
  /* 4222 */  [ 0.260306123, 18 ],
  /* 4223 */  [ 0.260388332, 18 ],

  /* 4224 */  [ 0.260470548, 18 ],
  /* 4225 */  [ 0.260552771, 18 ],
  /* 4226 */  [ 0.260635000, 18 ],
  /* 4227 */  [ 0.260717235, 18 ],
  /* 4228 */  [ 0.260799477, 18 ],
  /* 4229 */  [ 0.260881725, 18 ],
  /* 4230 */  [ 0.260963980, 18 ],
  /* 4231 */  [ 0.261046242, 18 ],
  /* 4232 */  [ 0.261128510, 18 ],
  /* 4233 */  [ 0.261210784, 18 ],
  /* 4234 */  [ 0.261293065, 18 ],
  /* 4235 */  [ 0.261375352, 18 ],
  /* 4236 */  [ 0.261457646, 18 ],
  /* 4237 */  [ 0.261539946, 18 ],
  /* 4238 */  [ 0.261622253, 18 ],
  /* 4239 */  [ 0.261704566, 18 ],

  /* 4240 */  [ 0.261786886, 18 ],
  /* 4241 */  [ 0.261869212, 18 ],
  /* 4242 */  [ 0.261951545, 18 ],
  /* 4243 */  [ 0.262033884, 18 ],
  /* 4244 */  [ 0.262116229, 18 ],
  /* 4245 */  [ 0.262198581, 18 ],
  /* 4246 */  [ 0.262280940, 18 ],
  /* 4247 */  [ 0.262363305, 18 ],
  /* 4248 */  [ 0.262445676, 18 ],
  /* 4249 */  [ 0.262528054, 18 ],
  /* 4250 */  [ 0.262610438, 18 ],
  /* 4251 */  [ 0.262692829, 18 ],
  /* 4252 */  [ 0.262775227, 18 ],
  /* 4253 */  [ 0.262857630, 18 ],
  /* 4254 */  [ 0.262940040, 18 ],
  /* 4255 */  [ 0.263022457, 18 ],

  /* 4256 */  [ 0.263104880, 18 ],
  /* 4257 */  [ 0.263187310, 18 ],
  /* 4258 */  [ 0.263269746, 18 ],
  /* 4259 */  [ 0.263352188, 18 ],
  /* 4260 */  [ 0.263434637, 18 ],
  /* 4261 */  [ 0.263517093, 18 ],
  /* 4262 */  [ 0.263599554, 18 ],
  /* 4263 */  [ 0.263682023, 18 ],
  /* 4264 */  [ 0.263764497, 18 ],
  /* 4265 */  [ 0.263846979, 18 ],
  /* 4266 */  [ 0.263929466, 18 ],
  /* 4267 */  [ 0.264011960, 18 ],
  /* 4268 */  [ 0.264094461, 18 ],
  /* 4269 */  [ 0.264176968, 18 ],
  /* 4270 */  [ 0.264259481, 18 ],
  /* 4271 */  [ 0.264342001, 18 ],

  /* 4272 */  [ 0.264424527, 18 ],
  /* 4273 */  [ 0.264507060, 18 ],
  /* 4274 */  [ 0.264589599, 18 ],
  /* 4275 */  [ 0.264672145, 18 ],
  /* 4276 */  [ 0.264754697, 18 ],
  /* 4277 */  [ 0.264837255, 18 ],
  /* 4278 */  [ 0.264919820, 18 ],
  /* 4279 */  [ 0.265002392, 18 ],
  /* 4280 */  [ 0.265084969, 18 ],
  /* 4281 */  [ 0.265167554, 18 ],
  /* 4282 */  [ 0.265250144, 18 ],
  /* 4283 */  [ 0.265332741, 18 ],
  /* 4284 */  [ 0.265415345, 18 ],
  /* 4285 */  [ 0.265497955, 18 ],
  /* 4286 */  [ 0.265580571, 18 ],
  /* 4287 */  [ 0.265663194, 18 ],

  /* 4288 */  [ 0.265745823, 18 ],
  /* 4289 */  [ 0.265828459, 18 ],
  /* 4290 */  [ 0.265911101, 18 ],
  /* 4291 */  [ 0.265993749, 18 ],
  /* 4292 */  [ 0.266076404, 18 ],
  /* 4293 */  [ 0.266159065, 18 ],
  /* 4294 */  [ 0.266241733, 18 ],
  /* 4295 */  [ 0.266324407, 18 ],
  /* 4296 */  [ 0.266407088, 18 ],
  /* 4297 */  [ 0.266489775, 18 ],
  /* 4298 */  [ 0.266572468, 18 ],
  /* 4299 */  [ 0.266655168, 18 ],
  /* 4300 */  [ 0.266737874, 18 ],
  /* 4301 */  [ 0.266820587, 18 ],
  /* 4302 */  [ 0.266903306, 18 ],
  /* 4303 */  [ 0.266986031, 18 ],

  /* 4304 */  [ 0.267068763, 18 ],
  /* 4305 */  [ 0.267151501, 18 ],
  /* 4306 */  [ 0.267234246, 18 ],
  /* 4307 */  [ 0.267316997, 18 ],
  /* 4308 */  [ 0.267399755, 18 ],
  /* 4309 */  [ 0.267482518, 18 ],
  /* 4310 */  [ 0.267565289, 18 ],
  /* 4311 */  [ 0.267648065, 18 ],
  /* 4312 */  [ 0.267730848, 18 ],
  /* 4313 */  [ 0.267813638, 18 ],
  /* 4314 */  [ 0.267896434, 18 ],
  /* 4315 */  [ 0.267979236, 18 ],
  /* 4316 */  [ 0.268062045, 18 ],
  /* 4317 */  [ 0.268144860, 18 ],
  /* 4318 */  [ 0.268227681, 18 ],
  /* 4319 */  [ 0.268310509, 18 ],

  /* 4320 */  [ 0.268393343, 18 ],
  /* 4321 */  [ 0.268476184, 18 ],
  /* 4322 */  [ 0.268559031, 18 ],
  /* 4323 */  [ 0.268641885, 18 ],
  /* 4324 */  [ 0.268724744, 18 ],
  /* 4325 */  [ 0.268807611, 18 ],
  /* 4326 */  [ 0.268890483, 18 ],
  /* 4327 */  [ 0.268973362, 18 ],
  /* 4328 */  [ 0.269056248, 18 ],
  /* 4329 */  [ 0.269139139, 18 ],
  /* 4330 */  [ 0.269222037, 18 ],
  /* 4331 */  [ 0.269304942, 18 ],
  /* 4332 */  [ 0.269387853, 18 ],
  /* 4333 */  [ 0.269470770, 18 ],
  /* 4334 */  [ 0.269553694, 18 ],
  /* 4335 */  [ 0.269636624, 18 ],

  /* 4336 */  [ 0.269719560, 18 ],
  /* 4337 */  [ 0.269802503, 18 ],
  /* 4338 */  [ 0.269885452, 18 ],
  /* 4339 */  [ 0.269968408, 18 ],
  /* 4340 */  [ 0.270051370, 18 ],
  /* 4341 */  [ 0.270134338, 18 ],
  /* 4342 */  [ 0.270217312, 18 ],
  /* 4343 */  [ 0.270300293, 18 ],
  /* 4344 */  [ 0.270383281, 18 ],
  /* 4345 */  [ 0.270466275, 18 ],
  /* 4346 */  [ 0.270549275, 18 ],
  /* 4347 */  [ 0.270632281, 18 ],
  /* 4348 */  [ 0.270715294, 18 ],
  /* 4349 */  [ 0.270798313, 18 ],
  /* 4350 */  [ 0.270881339, 18 ],
  /* 4351 */  [ 0.270964371, 18 ],

  /* 4352 */  [ 0.271047409, 18 ],
  /* 4353 */  [ 0.271130454, 18 ],
  /* 4354 */  [ 0.271213505, 18 ],
  /* 4355 */  [ 0.271296562, 18 ],
  /* 4356 */  [ 0.271379626, 18 ],
  /* 4357 */  [ 0.271462696, 18 ],
  /* 4358 */  [ 0.271545772, 18 ],
  /* 4359 */  [ 0.271628855, 18 ],
  /* 4360 */  [ 0.271711944, 18 ],
  /* 4361 */  [ 0.271795040, 18 ],
  /* 4362 */  [ 0.271878142, 18 ],
  /* 4363 */  [ 0.271961250, 18 ],
  /* 4364 */  [ 0.272044365, 18 ],
  /* 4365 */  [ 0.272127486, 18 ],
  /* 4366 */  [ 0.272210613, 18 ],
  /* 4367 */  [ 0.272293746, 18 ],

  /* 4368 */  [ 0.272376886, 18 ],
  /* 4369 */  [ 0.272460033, 18 ],
  /* 4370 */  [ 0.272543185, 18 ],
  /* 4371 */  [ 0.272626344, 18 ],
  /* 4372 */  [ 0.272709510, 18 ],
  /* 4373 */  [ 0.272792681, 18 ],
  /* 4374 */  [ 0.272875859, 18 ],
  /* 4375 */  [ 0.272959044, 18 ],
  /* 4376 */  [ 0.273042234, 18 ],
  /* 4377 */  [ 0.273125431, 18 ],
  /* 4378 */  [ 0.273208635, 18 ],
  /* 4379 */  [ 0.273291844, 18 ],
  /* 4380 */  [ 0.273375060, 18 ],
  /* 4381 */  [ 0.273458283, 18 ],
  /* 4382 */  [ 0.273541511, 18 ],
  /* 4383 */  [ 0.273624747, 18 ],

  /* 4384 */  [ 0.273707988, 18 ],
  /* 4385 */  [ 0.273791236, 18 ],
  /* 4386 */  [ 0.273874490, 18 ],
  /* 4387 */  [ 0.273957750, 18 ],
  /* 4388 */  [ 0.274041017, 18 ],
  /* 4389 */  [ 0.274124290, 18 ],
  /* 4390 */  [ 0.274207569, 18 ],
  /* 4391 */  [ 0.274290855, 18 ],
  /* 4392 */  [ 0.274374147, 18 ],
  /* 4393 */  [ 0.274457445, 18 ],
  /* 4394 */  [ 0.274540749, 18 ],
  /* 4395 */  [ 0.274624060, 18 ],
  /* 4396 */  [ 0.274707378, 18 ],
  /* 4397 */  [ 0.274790701, 18 ],
  /* 4398 */  [ 0.274874031, 18 ],
  /* 4399 */  [ 0.274957367, 18 ],

  /* 4400 */  [ 0.275040710, 18 ],
  /* 4401 */  [ 0.275124059, 18 ],
  /* 4402 */  [ 0.275207414, 18 ],
  /* 4403 */  [ 0.275290775, 18 ],
  /* 4404 */  [ 0.275374143, 18 ],
  /* 4405 */  [ 0.275457517, 18 ],
  /* 4406 */  [ 0.275540897, 18 ],
  /* 4407 */  [ 0.275624284, 18 ],
  /* 4408 */  [ 0.275707677, 18 ],
  /* 4409 */  [ 0.275791076, 18 ],
  /* 4410 */  [ 0.275874482, 18 ],
  /* 4411 */  [ 0.275957894, 18 ],
  /* 4412 */  [ 0.276041312, 18 ],
  /* 4413 */  [ 0.276124737, 18 ],
  /* 4414 */  [ 0.276208167, 18 ],
  /* 4415 */  [ 0.276291605, 18 ],

  /* 4416 */  [ 0.276375048, 18 ],
  /* 4417 */  [ 0.276458498, 18 ],
  /* 4418 */  [ 0.276541954, 18 ],
  /* 4419 */  [ 0.276625416, 18 ],
  /* 4420 */  [ 0.276708885, 18 ],
  /* 4421 */  [ 0.276792360, 18 ],
  /* 4422 */  [ 0.276875841, 18 ],
  /* 4423 */  [ 0.276959328, 18 ],
  /* 4424 */  [ 0.277042822, 18 ],
  /* 4425 */  [ 0.277126322, 18 ],
  /* 4426 */  [ 0.277209829, 18 ],
  /* 4427 */  [ 0.277293341, 18 ],
  /* 4428 */  [ 0.277376860, 18 ],
  /* 4429 */  [ 0.277460385, 18 ],
  /* 4430 */  [ 0.277543917, 18 ],
  /* 4431 */  [ 0.277627455, 18 ],

  /* 4432 */  [ 0.277710999, 18 ],
  /* 4433 */  [ 0.277794549, 18 ],
  /* 4434 */  [ 0.277878106, 18 ],
  /* 4435 */  [ 0.277961669, 18 ],
  /* 4436 */  [ 0.278045238, 18 ],
  /* 4437 */  [ 0.278128813, 18 ],
  /* 4438 */  [ 0.278212395, 18 ],
  /* 4439 */  [ 0.278295983, 18 ],
  /* 4440 */  [ 0.278379578, 18 ],
  /* 4441 */  [ 0.278463178, 18 ],
  /* 4442 */  [ 0.278546785, 18 ],
  /* 4443 */  [ 0.278630398, 18 ],
  /* 4444 */  [ 0.278714018, 18 ],
  /* 4445 */  [ 0.278797643, 18 ],
  /* 4446 */  [ 0.278881275, 18 ],
  /* 4447 */  [ 0.278964914, 18 ],

  /* 4448 */  [ 0.279048558, 18 ],
  /* 4449 */  [ 0.279132209, 18 ],
  /* 4450 */  [ 0.279215866, 18 ],
  /* 4451 */  [ 0.279299529, 18 ],
  /* 4452 */  [ 0.279383199, 18 ],
  /* 4453 */  [ 0.279466875, 18 ],
  /* 4454 */  [ 0.279550557, 18 ],
  /* 4455 */  [ 0.279634245, 18 ],
  /* 4456 */  [ 0.279717940, 18 ],
  /* 4457 */  [ 0.279801641, 18 ],
  /* 4458 */  [ 0.279885348, 18 ],
  /* 4459 */  [ 0.279969061, 18 ],
  /* 4460 */  [ 0.280052781, 18 ],
  /* 4461 */  [ 0.280136507, 18 ],
  /* 4462 */  [ 0.280220239, 18 ],
  /* 4463 */  [ 0.280303978, 18 ],

  /* 4464 */  [ 0.280387722, 18 ],
  /* 4465 */  [ 0.280471473, 18 ],
  /* 4466 */  [ 0.280555230, 18 ],
  /* 4467 */  [ 0.280638994, 18 ],
  /* 4468 */  [ 0.280722764, 18 ],
  /* 4469 */  [ 0.280806540, 18 ],
  /* 4470 */  [ 0.280890322, 18 ],
  /* 4471 */  [ 0.280974110, 18 ],
  /* 4472 */  [ 0.281057905, 18 ],
  /* 4473 */  [ 0.281141706, 18 ],
  /* 4474 */  [ 0.281225513, 18 ],
  /* 4475 */  [ 0.281309326, 18 ],
  /* 4476 */  [ 0.281393146, 18 ],
  /* 4477 */  [ 0.281476972, 18 ],
  /* 4478 */  [ 0.281560804, 18 ],
  /* 4479 */  [ 0.281644643, 18 ],

  /* 4480 */  [ 0.281728487, 18 ],
  /* 4481 */  [ 0.281812338, 18 ],
  /* 4482 */  [ 0.281896195, 18 ],
  /* 4483 */  [ 0.281980059, 18 ],
  /* 4484 */  [ 0.282063928, 18 ],
  /* 4485 */  [ 0.282147804, 18 ],
  /* 4486 */  [ 0.282231686, 18 ],
  /* 4487 */  [ 0.282315574, 18 ],
  /* 4488 */  [ 0.282399469, 18 ],
  /* 4489 */  [ 0.282483370, 18 ],
  /* 4490 */  [ 0.282567277, 18 ],
  /* 4491 */  [ 0.282651190, 18 ],
  /* 4492 */  [ 0.282735109, 18 ],
  /* 4493 */  [ 0.282819035, 18 ],
  /* 4494 */  [ 0.282902967, 18 ],
  /* 4495 */  [ 0.282986905, 18 ],

  /* 4496 */  [ 0.283070849, 18 ],
  /* 4497 */  [ 0.283154800, 18 ],
  /* 4498 */  [ 0.283238757, 18 ],
  /* 4499 */  [ 0.283322720, 18 ],
  /* 4500 */  [ 0.283406689, 18 ],
  /* 4501 */  [ 0.283490665, 18 ],
  /* 4502 */  [ 0.283574646, 18 ],
  /* 4503 */  [ 0.283658634, 18 ],
  /* 4504 */  [ 0.283742628, 18 ],
  /* 4505 */  [ 0.283826629, 18 ],
  /* 4506 */  [ 0.283910635, 18 ],
  /* 4507 */  [ 0.283994648, 18 ],
  /* 4508 */  [ 0.284078667, 18 ],
  /* 4509 */  [ 0.284162692, 18 ],
  /* 4510 */  [ 0.284246723, 18 ],
  /* 4511 */  [ 0.284330761, 18 ],

  /* 4512 */  [ 0.284414805, 18 ],
  /* 4513 */  [ 0.284498855, 18 ],
  /* 4514 */  [ 0.284582911, 18 ],
  /* 4515 */  [ 0.284666974, 18 ],
  /* 4516 */  [ 0.284751042, 18 ],
  /* 4517 */  [ 0.284835117, 18 ],
  /* 4518 */  [ 0.284919198, 18 ],
  /* 4519 */  [ 0.285003285, 18 ],
  /* 4520 */  [ 0.285087379, 18 ],
  /* 4521 */  [ 0.285171479, 18 ],
  /* 4522 */  [ 0.285255584, 18 ],
  /* 4523 */  [ 0.285339697, 18 ],
  /* 4524 */  [ 0.285423815, 18 ],
  /* 4525 */  [ 0.285507939, 18 ],
  /* 4526 */  [ 0.285592070, 18 ],
  /* 4527 */  [ 0.285676207, 18 ],

  /* 4528 */  [ 0.285760350, 18 ],
  /* 4529 */  [ 0.285844499, 18 ],
  /* 4530 */  [ 0.285928655, 18 ],
  /* 4531 */  [ 0.286012816, 18 ],
  /* 4532 */  [ 0.286096984, 18 ],
  /* 4533 */  [ 0.286181158, 18 ],
  /* 4534 */  [ 0.286265338, 18 ],
  /* 4535 */  [ 0.286349525, 18 ],
  /* 4536 */  [ 0.286433717, 18 ],
  /* 4537 */  [ 0.286517916, 18 ],
  /* 4538 */  [ 0.286602121, 18 ],
  /* 4539 */  [ 0.286686332, 18 ],
  /* 4540 */  [ 0.286770550, 18 ],
  /* 4541 */  [ 0.286854773, 18 ],
  /* 4542 */  [ 0.286939003, 18 ],
  /* 4543 */  [ 0.287023239, 18 ],

  /* 4544 */  [ 0.287107481, 18 ],
  /* 4545 */  [ 0.287191729, 18 ],
  /* 4546 */  [ 0.287275983, 18 ],
  /* 4547 */  [ 0.287360244, 18 ],
  /* 4548 */  [ 0.287444511, 18 ],
  /* 4549 */  [ 0.287528784, 18 ],
  /* 4550 */  [ 0.287613063, 18 ],
  /* 4551 */  [ 0.287697348, 18 ],
  /* 4552 */  [ 0.287781640, 18 ],
  /* 4553 */  [ 0.287865937, 18 ],
  /* 4554 */  [ 0.287950241, 18 ],
  /* 4555 */  [ 0.288034551, 18 ],
  /* 4556 */  [ 0.288118867, 18 ],
  /* 4557 */  [ 0.288203190, 18 ],
  /* 4558 */  [ 0.288287518, 18 ],
  /* 4559 */  [ 0.288371853, 18 ],

  /* 4560 */  [ 0.288456194, 18 ],
  /* 4561 */  [ 0.288540541, 18 ],
  /* 4562 */  [ 0.288624894, 18 ],
  /* 4563 */  [ 0.288709253, 18 ],
  /* 4564 */  [ 0.288793619, 18 ],
  /* 4565 */  [ 0.288877990, 18 ],
  /* 4566 */  [ 0.288962368, 18 ],
  /* 4567 */  [ 0.289046752, 18 ],
  /* 4568 */  [ 0.289131142, 18 ],
  /* 4569 */  [ 0.289215538, 18 ],
  /* 4570 */  [ 0.289299941, 18 ],
  /* 4571 */  [ 0.289384349, 18 ],
  /* 4572 */  [ 0.289468764, 18 ],
  /* 4573 */  [ 0.289553185, 18 ],
  /* 4574 */  [ 0.289637612, 18 ],
  /* 4575 */  [ 0.289722045, 18 ],

  /* 4576 */  [ 0.289806485, 18 ],
  /* 4577 */  [ 0.289890930, 18 ],
  /* 4578 */  [ 0.289975382, 18 ],
  /* 4579 */  [ 0.290059840, 18 ],
  /* 4580 */  [ 0.290144304, 18 ],
  /* 4581 */  [ 0.290228774, 18 ],
  /* 4582 */  [ 0.290313250, 18 ],
  /* 4583 */  [ 0.290397733, 18 ],
  /* 4584 */  [ 0.290482221, 18 ],
  /* 4585 */  [ 0.290566716, 18 ],
  /* 4586 */  [ 0.290651217, 18 ],
  /* 4587 */  [ 0.290735724, 18 ],
  /* 4588 */  [ 0.290820237, 18 ],
  /* 4589 */  [ 0.290904756, 18 ],
  /* 4590 */  [ 0.290989281, 18 ],
  /* 4591 */  [ 0.291073813, 18 ],

  /* 4592 */  [ 0.291158351, 18 ],
  /* 4593 */  [ 0.291242894, 18 ],
  /* 4594 */  [ 0.291327444, 18 ],
  /* 4595 */  [ 0.291412001, 18 ],
  /* 4596 */  [ 0.291496563, 18 ],
  /* 4597 */  [ 0.291581131, 18 ],
  /* 4598 */  [ 0.291665706, 18 ],
  /* 4599 */  [ 0.291750286, 18 ],
  /* 4600 */  [ 0.291834873, 18 ],
  /* 4601 */  [ 0.291919466, 18 ],
  /* 4602 */  [ 0.292004065, 18 ],
  /* 4603 */  [ 0.292088670, 18 ],
  /* 4604 */  [ 0.292173281, 18 ],
  /* 4605 */  [ 0.292257899, 18 ],
  /* 4606 */  [ 0.292342522, 18 ],
  /* 4607 */  [ 0.292427152, 18 ],

  /* 4608 */  [ 0.292511788, 18 ],
  /* 4609 */  [ 0.292596430, 18 ],
  /* 4610 */  [ 0.292681078, 18 ],
  /* 4611 */  [ 0.292765732, 18 ],
  /* 4612 */  [ 0.292850392, 18 ],
  /* 4613 */  [ 0.292935058, 18 ],
  /* 4614 */  [ 0.293019731, 18 ],
  /* 4615 */  [ 0.293104409, 18 ],
  /* 4616 */  [ 0.293189094, 18 ],
  /* 4617 */  [ 0.293273785, 18 ],
  /* 4618 */  [ 0.293358482, 18 ],
  /* 4619 */  [ 0.293443185, 18 ],
  /* 4620 */  [ 0.293527894, 18 ],
  /* 4621 */  [ 0.293612609, 18 ],
  /* 4622 */  [ 0.293697331, 18 ],
  /* 4623 */  [ 0.293782058, 18 ],

  /* 4624 */  [ 0.293866792, 18 ],
  /* 4625 */  [ 0.293951532, 18 ],
  /* 4626 */  [ 0.294036278, 18 ],
  /* 4627 */  [ 0.294121029, 18 ],
  /* 4628 */  [ 0.294205788, 18 ],
  /* 4629 */  [ 0.294290552, 18 ],
  /* 4630 */  [ 0.294375322, 18 ],
  /* 4631 */  [ 0.294460098, 18 ],
  /* 4632 */  [ 0.294544881, 18 ],
  /* 4633 */  [ 0.294629669, 18 ],
  /* 4634 */  [ 0.294714464, 18 ],
  /* 4635 */  [ 0.294799265, 18 ],
  /* 4636 */  [ 0.294884072, 18 ],
  /* 4637 */  [ 0.294968885, 18 ],
  /* 4638 */  [ 0.295053704, 18 ],
  /* 4639 */  [ 0.295138529, 18 ],

  /* 4640 */  [ 0.295223360, 18 ],
  /* 4641 */  [ 0.295308197, 18 ],
  /* 4642 */  [ 0.295393041, 18 ],
  /* 4643 */  [ 0.295477890, 18 ],
  /* 4644 */  [ 0.295562746, 18 ],
  /* 4645 */  [ 0.295647608, 18 ],
  /* 4646 */  [ 0.295732476, 18 ],
  /* 4647 */  [ 0.295817349, 18 ],
  /* 4648 */  [ 0.295902229, 18 ],
  /* 4649 */  [ 0.295987115, 18 ],
  /* 4650 */  [ 0.296072008, 18 ],
  /* 4651 */  [ 0.296156906, 18 ],
  /* 4652 */  [ 0.296241810, 18 ],
  /* 4653 */  [ 0.296326721, 18 ],
  /* 4654 */  [ 0.296411637, 18 ],
  /* 4655 */  [ 0.296496560, 18 ],

  /* 4656 */  [ 0.296581488, 18 ],
  /* 4657 */  [ 0.296666423, 18 ],
  /* 4658 */  [ 0.296751364, 18 ],
  /* 4659 */  [ 0.296836311, 18 ],
  /* 4660 */  [ 0.296921264, 18 ],
  /* 4661 */  [ 0.297006223, 18 ],
  /* 4662 */  [ 0.297091188, 18 ],
  /* 4663 */  [ 0.297176159, 18 ],
  /* 4664 */  [ 0.297261136, 18 ],
  /* 4665 */  [ 0.297346120, 18 ],
  /* 4666 */  [ 0.297431109, 18 ],
  /* 4667 */  [ 0.297516105, 18 ],
  /* 4668 */  [ 0.297601106, 18 ],
  /* 4669 */  [ 0.297686114, 18 ],
  /* 4670 */  [ 0.297771128, 18 ],
  /* 4671 */  [ 0.297856147, 18 ],

  /* 4672 */  [ 0.297941173, 18 ],
  /* 4673 */  [ 0.298026205, 18 ],
  /* 4674 */  [ 0.298111243, 18 ],
  /* 4675 */  [ 0.298196287, 18 ],
  /* 4676 */  [ 0.298281337, 18 ],
  /* 4677 */  [ 0.298366393, 18 ],
  /* 4678 */  [ 0.298451456, 18 ],
  /* 4679 */  [ 0.298536524, 18 ],
  /* 4680 */  [ 0.298621598, 18 ],
  /* 4681 */  [ 0.298706679, 18 ],
  /* 4682 */  [ 0.298791765, 18 ],
  /* 4683 */  [ 0.298876858, 18 ],
  /* 4684 */  [ 0.298961956, 18 ],
  /* 4685 */  [ 0.299047061, 18 ],
  /* 4686 */  [ 0.299132172, 18 ],
  /* 4687 */  [ 0.299217288, 18 ],

  /* 4688 */  [ 0.299302411, 18 ],
  /* 4689 */  [ 0.299387540, 18 ],
  /* 4690 */  [ 0.299472675, 18 ],
  /* 4691 */  [ 0.299557816, 18 ],
  /* 4692 */  [ 0.299642963, 18 ],
  /* 4693 */  [ 0.299728116, 18 ],
  /* 4694 */  [ 0.299813275, 18 ],
  /* 4695 */  [ 0.299898440, 18 ],
  /* 4696 */  [ 0.299983611, 18 ],
  /* 4697 */  [ 0.300068789, 18 ],
  /* 4698 */  [ 0.300153972, 18 ],
  /* 4699 */  [ 0.300239161, 18 ],
  /* 4700 */  [ 0.300324357, 18 ],
  /* 4701 */  [ 0.300409558, 18 ],
  /* 4702 */  [ 0.300494765, 18 ],
  /* 4703 */  [ 0.300579979, 18 ],

  /* 4704 */  [ 0.300665198, 18 ],
  /* 4705 */  [ 0.300750424, 18 ],
  /* 4706 */  [ 0.300835656, 18 ],
  /* 4707 */  [ 0.300920893, 18 ],
  /* 4708 */  [ 0.301006137, 18 ],
  /* 4709 */  [ 0.301091387, 18 ],
  /* 4710 */  [ 0.301176643, 18 ],
  /* 4711 */  [ 0.301261904, 18 ],
  /* 4712 */  [ 0.301347172, 18 ],
  /* 4713 */  [ 0.301432446, 18 ],
  /* 4714 */  [ 0.301517726, 18 ],
  /* 4715 */  [ 0.301603012, 18 ],
  /* 4716 */  [ 0.301688304, 18 ],
  /* 4717 */  [ 0.301773602, 18 ],
  /* 4718 */  [ 0.301858906, 18 ],
  /* 4719 */  [ 0.301944216, 18 ],

  /* 4720 */  [ 0.302029532, 18 ],
  /* 4721 */  [ 0.302114854, 18 ],
  /* 4722 */  [ 0.302200182, 18 ],
  /* 4723 */  [ 0.302285516, 18 ],
  /* 4724 */  [ 0.302370856, 18 ],
  /* 4725 */  [ 0.302456203, 18 ],
  /* 4726 */  [ 0.302541555, 18 ],
  /* 4727 */  [ 0.302626913, 18 ],
  /* 4728 */  [ 0.302712277, 18 ],
  /* 4729 */  [ 0.302797648, 18 ],
  /* 4730 */  [ 0.302883024, 18 ],
  /* 4731 */  [ 0.302968406, 18 ],
  /* 4732 */  [ 0.303053794, 18 ],
  /* 4733 */  [ 0.303139189, 18 ],
  /* 4734 */  [ 0.303224589, 18 ],
  /* 4735 */  [ 0.303309995, 18 ],

  /* 4736 */  [ 0.303395408, 18 ],
  /* 4737 */  [ 0.303480826, 18 ],
  /* 4738 */  [ 0.303566251, 18 ],
  /* 4739 */  [ 0.303651681, 18 ],
  /* 4740 */  [ 0.303737117, 18 ],
  /* 4741 */  [ 0.303822560, 18 ],
  /* 4742 */  [ 0.303908008, 18 ],
  /* 4743 */  [ 0.303993463, 18 ],
  /* 4744 */  [ 0.304078923, 18 ],
  /* 4745 */  [ 0.304164390, 18 ],
  /* 4746 */  [ 0.304249862, 18 ],
  /* 4747 */  [ 0.304335340, 18 ],
  /* 4748 */  [ 0.304420825, 18 ],
  /* 4749 */  [ 0.304506315, 18 ],
  /* 4750 */  [ 0.304591812, 18 ],
  /* 4751 */  [ 0.304677314, 18 ],

  /* 4752 */  [ 0.304762823, 18 ],
  /* 4753 */  [ 0.304848337, 18 ],
  /* 4754 */  [ 0.304933858, 18 ],
  /* 4755 */  [ 0.305019384, 18 ],
  /* 4756 */  [ 0.305104917, 18 ],
  /* 4757 */  [ 0.305190455, 18 ],
  /* 4758 */  [ 0.305275999, 18 ],
  /* 4759 */  [ 0.305361550, 18 ],
  /* 4760 */  [ 0.305447106, 18 ],
  /* 4761 */  [ 0.305532669, 18 ],
  /* 4762 */  [ 0.305618237, 18 ],
  /* 4763 */  [ 0.305703811, 18 ],
  /* 4764 */  [ 0.305789392, 18 ],
  /* 4765 */  [ 0.305874978, 18 ],
  /* 4766 */  [ 0.305960571, 18 ],
  /* 4767 */  [ 0.306046169, 18 ],

  /* 4768 */  [ 0.306131773, 18 ],
  /* 4769 */  [ 0.306217383, 18 ],
  /* 4770 */  [ 0.306303000, 18 ],
  /* 4771 */  [ 0.306388622, 18 ],
  /* 4772 */  [ 0.306474250, 18 ],
  /* 4773 */  [ 0.306559885, 18 ],
  /* 4774 */  [ 0.306645525, 18 ],
  /* 4775 */  [ 0.306731171, 18 ],
  /* 4776 */  [ 0.306816823, 18 ],
  /* 4777 */  [ 0.306902481, 18 ],
  /* 4778 */  [ 0.306988145, 18 ],
  /* 4779 */  [ 0.307073816, 18 ],
  /* 4780 */  [ 0.307159492, 18 ],
  /* 4781 */  [ 0.307245174, 18 ],
  /* 4782 */  [ 0.307330862, 18 ],
  /* 4783 */  [ 0.307416556, 18 ],

  /* 4784 */  [ 0.307502256, 18 ],
  /* 4785 */  [ 0.307587962, 18 ],
  /* 4786 */  [ 0.307673674, 18 ],
  /* 4787 */  [ 0.307759392, 18 ],
  /* 4788 */  [ 0.307845115, 18 ],
  /* 4789 */  [ 0.307930845, 18 ],
  /* 4790 */  [ 0.308016581, 18 ],
  /* 4791 */  [ 0.308102323, 18 ],
  /* 4792 */  [ 0.308188071, 18 ],
  /* 4793 */  [ 0.308273824, 18 ],
  /* 4794 */  [ 0.308359584, 18 ],
  /* 4795 */  [ 0.308445350, 18 ],
  /* 4796 */  [ 0.308531121, 18 ],
  /* 4797 */  [ 0.308616899, 18 ],
  /* 4798 */  [ 0.308702682, 18 ],
  /* 4799 */  [ 0.308788472, 18 ],

  /* 4800 */  [ 0.308874267, 18 ],
  /* 4801 */  [ 0.308960068, 18 ],
  /* 4802 */  [ 0.309045876, 18 ],
  /* 4803 */  [ 0.309131689, 18 ],
  /* 4804 */  [ 0.309217508, 18 ],
  /* 4805 */  [ 0.309303334, 18 ],
  /* 4806 */  [ 0.309389165, 18 ],
  /* 4807 */  [ 0.309475002, 18 ],
  /* 4808 */  [ 0.309560845, 18 ],
  /* 4809 */  [ 0.309646694, 18 ],
  /* 4810 */  [ 0.309732549, 18 ],
  /* 4811 */  [ 0.309818410, 18 ],
  /* 4812 */  [ 0.309904277, 18 ],
  /* 4813 */  [ 0.309990150, 18 ],
  /* 4814 */  [ 0.310076028, 18 ],
  /* 4815 */  [ 0.310161913, 18 ],

  /* 4816 */  [ 0.310247804, 18 ],
  /* 4817 */  [ 0.310333700, 18 ],
  /* 4818 */  [ 0.310419603, 18 ],
  /* 4819 */  [ 0.310505511, 18 ],
  /* 4820 */  [ 0.310591426, 18 ],
  /* 4821 */  [ 0.310677346, 18 ],
  /* 4822 */  [ 0.310763272, 18 ],
  /* 4823 */  [ 0.310849205, 18 ],
  /* 4824 */  [ 0.310935143, 18 ],
  /* 4825 */  [ 0.311021087, 18 ],
  /* 4826 */  [ 0.311107037, 18 ],
  /* 4827 */  [ 0.311192993, 18 ],
  /* 4828 */  [ 0.311278955, 18 ],
  /* 4829 */  [ 0.311364923, 18 ],
  /* 4830 */  [ 0.311450897, 18 ],
  /* 4831 */  [ 0.311536877, 18 ],

  /* 4832 */  [ 0.311622862, 18 ],
  /* 4833 */  [ 0.311708854, 18 ],
  /* 4834 */  [ 0.311794851, 18 ],
  /* 4835 */  [ 0.311880855, 18 ],
  /* 4836 */  [ 0.311966864, 18 ],
  /* 4837 */  [ 0.312052880, 18 ],
  /* 4838 */  [ 0.312138901, 18 ],
  /* 4839 */  [ 0.312224928, 18 ],
  /* 4840 */  [ 0.312310961, 18 ],
  /* 4841 */  [ 0.312397000, 18 ],
  /* 4842 */  [ 0.312483045, 18 ],
  /* 4843 */  [ 0.312569096, 18 ],
  /* 4844 */  [ 0.312655153, 18 ],
  /* 4845 */  [ 0.312741216, 18 ],
  /* 4846 */  [ 0.312827284, 18 ],
  /* 4847 */  [ 0.312913359, 18 ],

  /* 4848 */  [ 0.312999439, 18 ],
  /* 4849 */  [ 0.313085526, 18 ],
  /* 4850 */  [ 0.313171618, 18 ],
  /* 4851 */  [ 0.313257716, 18 ],
  /* 4852 */  [ 0.313343820, 18 ],
  /* 4853 */  [ 0.313429931, 18 ],
  /* 4854 */  [ 0.313516047, 18 ],
  /* 4855 */  [ 0.313602168, 18 ],
  /* 4856 */  [ 0.313688296, 18 ],
  /* 4857 */  [ 0.313774430, 18 ],
  /* 4858 */  [ 0.313860570, 18 ],
  /* 4859 */  [ 0.313946715, 18 ],
  /* 4860 */  [ 0.314032867, 18 ],
  /* 4861 */  [ 0.314119024, 18 ],
  /* 4862 */  [ 0.314205187, 18 ],
  /* 4863 */  [ 0.314291357, 18 ],

  /* 4864 */  [ 0.314377532, 18 ],
  /* 4865 */  [ 0.314463713, 18 ],
  /* 4866 */  [ 0.314549900, 18 ],
  /* 4867 */  [ 0.314636092, 18 ],
  /* 4868 */  [ 0.314722291, 18 ],
  /* 4869 */  [ 0.314808496, 18 ],
  /* 4870 */  [ 0.314894706, 18 ],
  /* 4871 */  [ 0.314980923, 18 ],
  /* 4872 */  [ 0.315067145, 18 ],
  /* 4873 */  [ 0.315153373, 18 ],
  /* 4874 */  [ 0.315239607, 18 ],
  /* 4875 */  [ 0.315325847, 18 ],
  /* 4876 */  [ 0.315412093, 18 ],
  /* 4877 */  [ 0.315498345, 18 ],
  /* 4878 */  [ 0.315584603, 18 ],
  /* 4879 */  [ 0.315670866, 18 ],

  /* 4880 */  [ 0.315757136, 18 ],
  /* 4881 */  [ 0.315843411, 18 ],
  /* 4882 */  [ 0.315929693, 18 ],
  /* 4883 */  [ 0.316015980, 18 ],
  /* 4884 */  [ 0.316102273, 18 ],
  /* 4885 */  [ 0.316188572, 18 ],
  /* 4886 */  [ 0.316274877, 18 ],
  /* 4887 */  [ 0.316361187, 18 ],
  /* 4888 */  [ 0.316447504, 18 ],
  /* 4889 */  [ 0.316533826, 18 ],
  /* 4890 */  [ 0.316620155, 18 ],
  /* 4891 */  [ 0.316706489, 18 ],
  /* 4892 */  [ 0.316792829, 18 ],
  /* 4893 */  [ 0.316879175, 18 ],
  /* 4894 */  [ 0.316965527, 18 ],
  /* 4895 */  [ 0.317051885, 18 ],

  /* 4896 */  [ 0.317138249, 18 ],
  /* 4897 */  [ 0.317224618, 18 ],
  /* 4898 */  [ 0.317310994, 18 ],
  /* 4899 */  [ 0.317397375, 18 ],
  /* 4900 */  [ 0.317483762, 18 ],
  /* 4901 */  [ 0.317570155, 18 ],
  /* 4902 */  [ 0.317656554, 18 ],
  /* 4903 */  [ 0.317742959, 18 ],
  /* 4904 */  [ 0.317829370, 18 ],
  /* 4905 */  [ 0.317915786, 18 ],
  /* 4906 */  [ 0.318002209, 18 ],
  /* 4907 */  [ 0.318088637, 18 ],
  /* 4908 */  [ 0.318175071, 18 ],
  /* 4909 */  [ 0.318261511, 18 ],
  /* 4910 */  [ 0.318347957, 18 ],
  /* 4911 */  [ 0.318434409, 18 ],

  /* 4912 */  [ 0.318520867, 18 ],
  /* 4913 */  [ 0.318607330, 18 ],
  /* 4914 */  [ 0.318693800, 18 ],
  /* 4915 */  [ 0.318780275, 18 ],
  /* 4916 */  [ 0.318866756, 18 ],
  /* 4917 */  [ 0.318953243, 18 ],
  /* 4918 */  [ 0.319039736, 18 ],
  /* 4919 */  [ 0.319126235, 18 ],
  /* 4920 */  [ 0.319212739, 18 ],
  /* 4921 */  [ 0.319299250, 18 ],
  /* 4922 */  [ 0.319385766, 18 ],
  /* 4923 */  [ 0.319472288, 18 ],
  /* 4924 */  [ 0.319558816, 18 ],
  /* 4925 */  [ 0.319645350, 18 ],
  /* 4926 */  [ 0.319731890, 18 ],
  /* 4927 */  [ 0.319818435, 18 ],

  /* 4928 */  [ 0.319904987, 18 ],
  /* 4929 */  [ 0.319991544, 18 ],
  /* 4930 */  [ 0.320078107, 18 ],
  /* 4931 */  [ 0.320164676, 18 ],
  /* 4932 */  [ 0.320251251, 18 ],
  /* 4933 */  [ 0.320337832, 18 ],
  /* 4934 */  [ 0.320424419, 18 ],
  /* 4935 */  [ 0.320511011, 18 ],
  /* 4936 */  [ 0.320597609, 18 ],
  /* 4937 */  [ 0.320684213, 18 ],
  /* 4938 */  [ 0.320770823, 18 ],
  /* 4939 */  [ 0.320857439, 18 ],
  /* 4940 */  [ 0.320944061, 18 ],
  /* 4941 */  [ 0.321030688, 18 ],
  /* 4942 */  [ 0.321117322, 18 ],
  /* 4943 */  [ 0.321203961, 18 ],

  /* 4944 */  [ 0.321290606, 18 ],
  /* 4945 */  [ 0.321377257, 18 ],
  /* 4946 */  [ 0.321463913, 18 ],
  /* 4947 */  [ 0.321550576, 18 ],
  /* 4948 */  [ 0.321637244, 18 ],
  /* 4949 */  [ 0.321723919, 18 ],
  /* 4950 */  [ 0.321810599, 18 ],
  /* 4951 */  [ 0.321897285, 18 ],
  /* 4952 */  [ 0.321983976, 18 ],
  /* 4953 */  [ 0.322070674, 18 ],
  /* 4954 */  [ 0.322157377, 18 ],
  /* 4955 */  [ 0.322244087, 18 ],
  /* 4956 */  [ 0.322330802, 18 ],
  /* 4957 */  [ 0.322417523, 18 ],
  /* 4958 */  [ 0.322504249, 18 ],
  /* 4959 */  [ 0.322590982, 18 ],

  /* 4960 */  [ 0.322677720, 18 ],
  /* 4961 */  [ 0.322764465, 18 ],
  /* 4962 */  [ 0.322851215, 18 ],
  /* 4963 */  [ 0.322937971, 18 ],
  /* 4964 */  [ 0.323024732, 18 ],
  /* 4965 */  [ 0.323111500, 18 ],
  /* 4966 */  [ 0.323198273, 18 ],
  /* 4967 */  [ 0.323285052, 18 ],
  /* 4968 */  [ 0.323371837, 18 ],
  /* 4969 */  [ 0.323458628, 18 ],
  /* 4970 */  [ 0.323545425, 18 ],
  /* 4971 */  [ 0.323632227, 18 ],
  /* 4972 */  [ 0.323719036, 18 ],
  /* 4973 */  [ 0.323805850, 18 ],
  /* 4974 */  [ 0.323892670, 18 ],
  /* 4975 */  [ 0.323979496, 18 ],

  /* 4976 */  [ 0.324066327, 18 ],
  /* 4977 */  [ 0.324153165, 18 ],
  /* 4978 */  [ 0.324240008, 18 ],
  /* 4979 */  [ 0.324326857, 18 ],
  /* 4980 */  [ 0.324413712, 18 ],
  /* 4981 */  [ 0.324500572, 18 ],
  /* 4982 */  [ 0.324587439, 18 ],
  /* 4983 */  [ 0.324674311, 18 ],
  /* 4984 */  [ 0.324761189, 18 ],
  /* 4985 */  [ 0.324848073, 18 ],
  /* 4986 */  [ 0.324934963, 18 ],
  /* 4987 */  [ 0.325021858, 18 ],
  /* 4988 */  [ 0.325108760, 18 ],
  /* 4989 */  [ 0.325195667, 18 ],
  /* 4990 */  [ 0.325282580, 18 ],
  /* 4991 */  [ 0.325369498, 18 ],

  /* 4992 */  [ 0.325456423, 18 ],
  /* 4993 */  [ 0.325543353, 18 ],
  /* 4994 */  [ 0.325630290, 18 ],
  /* 4995 */  [ 0.325717232, 18 ],
  /* 4996 */  [ 0.325804179, 18 ],
  /* 4997 */  [ 0.325891133, 18 ],
  /* 4998 */  [ 0.325978092, 18 ],
  /* 4999 */  [ 0.326065057, 18 ],
  /* 5000 */  [ 0.326152028, 18 ],
  /* 5001 */  [ 0.326239005, 18 ],
  /* 5002 */  [ 0.326325988, 18 ],
  /* 5003 */  [ 0.326412976, 18 ],
  /* 5004 */  [ 0.326499970, 18 ],
  /* 5005 */  [ 0.326586970, 18 ],
  /* 5006 */  [ 0.326673976, 18 ],
  /* 5007 */  [ 0.326760988, 18 ],

  /* 5008 */  [ 0.326848005, 18 ],
  /* 5009 */  [ 0.326935028, 18 ],
  /* 5010 */  [ 0.327022057, 18 ],
  /* 5011 */  [ 0.327109092, 18 ],
  /* 5012 */  [ 0.327196132, 18 ],
  /* 5013 */  [ 0.327283178, 18 ],
  /* 5014 */  [ 0.327370231, 18 ],
  /* 5015 */  [ 0.327457288, 18 ],
  /* 5016 */  [ 0.327544352, 18 ],
  /* 5017 */  [ 0.327631421, 18 ],
  /* 5018 */  [ 0.327718497, 18 ],
  /* 5019 */  [ 0.327805578, 18 ],
  /* 5020 */  [ 0.327892665, 18 ],
  /* 5021 */  [ 0.327979757, 18 ],
  /* 5022 */  [ 0.328066855, 18 ],
  /* 5023 */  [ 0.328153960, 18 ],

  /* 5024 */  [ 0.328241070, 18 ],
  /* 5025 */  [ 0.328328185, 18 ],
  /* 5026 */  [ 0.328415307, 18 ],
  /* 5027 */  [ 0.328502434, 18 ],
  /* 5028 */  [ 0.328589567, 18 ],
  /* 5029 */  [ 0.328676706, 18 ],
  /* 5030 */  [ 0.328763850, 18 ],
  /* 5031 */  [ 0.328851001, 18 ],
  /* 5032 */  [ 0.328938157, 18 ],
  /* 5033 */  [ 0.329025319, 18 ],
  /* 5034 */  [ 0.329112486, 18 ],
  /* 5035 */  [ 0.329199660, 18 ],
  /* 5036 */  [ 0.329286839, 18 ],
  /* 5037 */  [ 0.329374024, 18 ],
  /* 5038 */  [ 0.329461215, 18 ],
  /* 5039 */  [ 0.329548411, 18 ],

  /* 5040 */  [ 0.329635614, 18 ],
  /* 5041 */  [ 0.329722822, 18 ],
  /* 5042 */  [ 0.329810036, 18 ],
  /* 5043 */  [ 0.329897255, 18 ],
  /* 5044 */  [ 0.329984481, 18 ],
  /* 5045 */  [ 0.330071712, 18 ],
  /* 5046 */  [ 0.330158949, 18 ],
  /* 5047 */  [ 0.330246191, 18 ],
  /* 5048 */  [ 0.330333440, 18 ],
  /* 5049 */  [ 0.330420694, 18 ],
  /* 5050 */  [ 0.330507954, 18 ],
  /* 5051 */  [ 0.330595220, 18 ],
  /* 5052 */  [ 0.330682491, 18 ],
  /* 5053 */  [ 0.330769768, 18 ],
  /* 5054 */  [ 0.330857051, 18 ],
  /* 5055 */  [ 0.330944340, 18 ],

  /* 5056 */  [ 0.331031635, 18 ],
  /* 5057 */  [ 0.331118935, 18 ],
  /* 5058 */  [ 0.331206241, 18 ],
  /* 5059 */  [ 0.331293553, 18 ],
  /* 5060 */  [ 0.331380870, 18 ],
  /* 5061 */  [ 0.331468193, 18 ],
  /* 5062 */  [ 0.331555522, 18 ],
  /* 5063 */  [ 0.331642857, 18 ],
  /* 5064 */  [ 0.331730198, 18 ],
  /* 5065 */  [ 0.331817544, 18 ],
  /* 5066 */  [ 0.331904896, 18 ],
  /* 5067 */  [ 0.331992254, 18 ],
  /* 5068 */  [ 0.332079617, 18 ],
  /* 5069 */  [ 0.332166986, 18 ],
  /* 5070 */  [ 0.332254361, 18 ],
  /* 5071 */  [ 0.332341742, 18 ],

  /* 5072 */  [ 0.332429129, 18 ],
  /* 5073 */  [ 0.332516521, 18 ],
  /* 5074 */  [ 0.332603919, 18 ],
  /* 5075 */  [ 0.332691323, 18 ],
  /* 5076 */  [ 0.332778732, 18 ],
  /* 5077 */  [ 0.332866147, 18 ],
  /* 5078 */  [ 0.332953568, 18 ],
  /* 5079 */  [ 0.333040995, 18 ],
  /* 5080 */  [ 0.333128427, 18 ],
  /* 5081 */  [ 0.333215865, 18 ],
  /* 5082 */  [ 0.333303309, 18 ],
  /* 5083 */  [ 0.333390759, 18 ],
  /* 5084 */  [ 0.333478214, 18 ],
  /* 5085 */  [ 0.333565675, 18 ],
  /* 5086 */  [ 0.333653142, 18 ],
  /* 5087 */  [ 0.333740615, 18 ],

  /* 5088 */  [ 0.333828093, 18 ],
  /* 5089 */  [ 0.333915577, 18 ],
  /* 5090 */  [ 0.334003067, 18 ],
  /* 5091 */  [ 0.334090562, 18 ],
  /* 5092 */  [ 0.334178063, 18 ],
  /* 5093 */  [ 0.334265570, 18 ],
  /* 5094 */  [ 0.334353083, 18 ],
  /* 5095 */  [ 0.334440601, 18 ],
  /* 5096 */  [ 0.334528126, 18 ],
  /* 5097 */  [ 0.334615655, 18 ],
  /* 5098 */  [ 0.334703191, 18 ],
  /* 5099 */  [ 0.334790732, 18 ],
  /* 5100 */  [ 0.334878279, 18 ],
  /* 5101 */  [ 0.334965832, 18 ],
  /* 5102 */  [ 0.335053391, 18 ],
  /* 5103 */  [ 0.335140955, 18 ],

  /* 5104 */  [ 0.335228525, 18 ],
  /* 5105 */  [ 0.335316100, 18 ],
  /* 5106 */  [ 0.335403682, 18 ],
  /* 5107 */  [ 0.335491269, 18 ],
  /* 5108 */  [ 0.335578861, 18 ],
  /* 5109 */  [ 0.335666460, 18 ],
  /* 5110 */  [ 0.335754064, 18 ],
  /* 5111 */  [ 0.335841674, 18 ],
  /* 5112 */  [ 0.335929290, 18 ],
  /* 5113 */  [ 0.336016911, 18 ],
  /* 5114 */  [ 0.336104538, 18 ],
  /* 5115 */  [ 0.336192171, 18 ],
  /* 5116 */  [ 0.336279809, 18 ],
  /* 5117 */  [ 0.336367453, 18 ],
  /* 5118 */  [ 0.336455103, 18 ],
  /* 5119 */  [ 0.336542759, 18 ],

  /* 5120 */  [ 0.336630420, 18 ],
  /* 5121 */  [ 0.336718087, 18 ],
  /* 5122 */  [ 0.336805760, 18 ],
  /* 5123 */  [ 0.336893439, 18 ],
  /* 5124 */  [ 0.336981123, 18 ],
  /* 5125 */  [ 0.337068813, 18 ],
  /* 5126 */  [ 0.337156508, 18 ],
  /* 5127 */  [ 0.337244209, 18 ],
  /* 5128 */  [ 0.337331916, 18 ],
  /* 5129 */  [ 0.337419629, 18 ],
  /* 5130 */  [ 0.337507347, 18 ],
  /* 5131 */  [ 0.337595071, 18 ],
  /* 5132 */  [ 0.337682801, 18 ],
  /* 5133 */  [ 0.337770537, 18 ],
  /* 5134 */  [ 0.337858278, 18 ],
  /* 5135 */  [ 0.337946025, 18 ],

  /* 5136 */  [ 0.338033777, 18 ],
  /* 5137 */  [ 0.338121535, 18 ],
  /* 5138 */  [ 0.338209299, 18 ],
  /* 5139 */  [ 0.338297069, 18 ],
  /* 5140 */  [ 0.338384844, 18 ],
  /* 5141 */  [ 0.338472625, 18 ],
  /* 5142 */  [ 0.338560412, 18 ],
  /* 5143 */  [ 0.338648204, 18 ],
  /* 5144 */  [ 0.338736002, 18 ],
  /* 5145 */  [ 0.338823806, 18 ],
  /* 5146 */  [ 0.338911616, 18 ],
  /* 5147 */  [ 0.338999431, 18 ],
  /* 5148 */  [ 0.339087252, 18 ],
  /* 5149 */  [ 0.339175078, 18 ],
  /* 5150 */  [ 0.339262910, 18 ],
  /* 5151 */  [ 0.339350748, 18 ],

  /* 5152 */  [ 0.339438592, 18 ],
  /* 5153 */  [ 0.339526441, 18 ],
  /* 5154 */  [ 0.339614296, 18 ],
  /* 5155 */  [ 0.339702157, 18 ],
  /* 5156 */  [ 0.339790023, 18 ],
  /* 5157 */  [ 0.339877895, 18 ],
  /* 5158 */  [ 0.339965773, 18 ],
  /* 5159 */  [ 0.340053656, 18 ],
  /* 5160 */  [ 0.340141545, 18 ],
  /* 5161 */  [ 0.340229440, 18 ],
  /* 5162 */  [ 0.340317340, 18 ],
  /* 5163 */  [ 0.340405246, 18 ],
  /* 5164 */  [ 0.340493158, 18 ],
  /* 5165 */  [ 0.340581075, 18 ],
  /* 5166 */  [ 0.340668999, 18 ],
  /* 5167 */  [ 0.340756927, 18 ],

  /* 5168 */  [ 0.340844862, 18 ],
  /* 5169 */  [ 0.340932802, 18 ],
  /* 5170 */  [ 0.341020748, 18 ],
  /* 5171 */  [ 0.341108699, 18 ],
  /* 5172 */  [ 0.341196656, 18 ],
  /* 5173 */  [ 0.341284619, 18 ],
  /* 5174 */  [ 0.341372587, 18 ],
  /* 5175 */  [ 0.341460562, 18 ],
  /* 5176 */  [ 0.341548541, 18 ],
  /* 5177 */  [ 0.341636527, 18 ],
  /* 5178 */  [ 0.341724518, 18 ],
  /* 5179 */  [ 0.341812515, 18 ],
  /* 5180 */  [ 0.341900517, 18 ],
  /* 5181 */  [ 0.341988525, 18 ],
  /* 5182 */  [ 0.342076539, 18 ],
  /* 5183 */  [ 0.342164558, 18 ],

  /* 5184 */  [ 0.342252584, 18 ],
  /* 5185 */  [ 0.342340614, 18 ],
  /* 5186 */  [ 0.342428651, 18 ],
  /* 5187 */  [ 0.342516693, 18 ],
  /* 5188 */  [ 0.342604741, 18 ],
  /* 5189 */  [ 0.342692794, 18 ],
  /* 5190 */  [ 0.342780853, 18 ],
  /* 5191 */  [ 0.342868918, 18 ],
  /* 5192 */  [ 0.342956988, 18 ],
  /* 5193 */  [ 0.343045064, 18 ],
  /* 5194 */  [ 0.343133146, 18 ],
  /* 5195 */  [ 0.343221233, 18 ],
  /* 5196 */  [ 0.343309326, 18 ],
  /* 5197 */  [ 0.343397425, 18 ],
  /* 5198 */  [ 0.343485529, 18 ],
  /* 5199 */  [ 0.343573639, 18 ],

  /* 5200 */  [ 0.343661754, 18 ],
  /* 5201 */  [ 0.343749876, 18 ],
  /* 5202 */  [ 0.343838003, 18 ],
  /* 5203 */  [ 0.343926135, 18 ],
  /* 5204 */  [ 0.344014273, 18 ],
  /* 5205 */  [ 0.344102417, 18 ],
  /* 5206 */  [ 0.344190566, 18 ],
  /* 5207 */  [ 0.344278722, 18 ],
  /* 5208 */  [ 0.344366882, 18 ],
  /* 5209 */  [ 0.344455049, 18 ],
  /* 5210 */  [ 0.344543221, 18 ],
  /* 5211 */  [ 0.344631398, 18 ],
  /* 5212 */  [ 0.344719582, 18 ],
  /* 5213 */  [ 0.344807771, 18 ],
  /* 5214 */  [ 0.344895965, 18 ],
  /* 5215 */  [ 0.344984165, 18 ],

  /* 5216 */  [ 0.345072371, 18 ],
  /* 5217 */  [ 0.345160583, 18 ],
  /* 5218 */  [ 0.345248800, 18 ],
  /* 5219 */  [ 0.345337023, 18 ],
  /* 5220 */  [ 0.345425251, 18 ],
  /* 5221 */  [ 0.345513485, 18 ],
  /* 5222 */  [ 0.345601725, 18 ],
  /* 5223 */  [ 0.345689970, 18 ],
  /* 5224 */  [ 0.345778221, 18 ],
  /* 5225 */  [ 0.345866478, 18 ],
  /* 5226 */  [ 0.345954740, 18 ],
  /* 5227 */  [ 0.346043008, 18 ],
  /* 5228 */  [ 0.346131281, 18 ],
  /* 5229 */  [ 0.346219560, 18 ],
  /* 5230 */  [ 0.346307845, 18 ],
  /* 5231 */  [ 0.346396135, 18 ],

  /* 5232 */  [ 0.346484431, 18 ],
  /* 5233 */  [ 0.346572733, 18 ],
  /* 5234 */  [ 0.346661040, 18 ],
  /* 5235 */  [ 0.346749353, 18 ],
  /* 5236 */  [ 0.346837671, 18 ],
  /* 5237 */  [ 0.346925996, 18 ],
  /* 5238 */  [ 0.347014325, 18 ],
  /* 5239 */  [ 0.347102661, 18 ],
  /* 5240 */  [ 0.347191002, 18 ],
  /* 5241 */  [ 0.347279348, 18 ],
  /* 5242 */  [ 0.347367700, 18 ],
  /* 5243 */  [ 0.347456058, 18 ],
  /* 5244 */  [ 0.347544422, 18 ],
  /* 5245 */  [ 0.347632791, 18 ],
  /* 5246 */  [ 0.347721165, 18 ],
  /* 5247 */  [ 0.347809546, 18 ],

  /* 5248 */  [ 0.347897931, 18 ],
  /* 5249 */  [ 0.347986323, 18 ],
  /* 5250 */  [ 0.348074720, 18 ],
  /* 5251 */  [ 0.348163123, 18 ],
  /* 5252 */  [ 0.348251531, 18 ],
  /* 5253 */  [ 0.348339945, 18 ],
  /* 5254 */  [ 0.348428365, 18 ],
  /* 5255 */  [ 0.348516790, 18 ],
  /* 5256 */  [ 0.348605221, 18 ],
  /* 5257 */  [ 0.348693657, 18 ],
  /* 5258 */  [ 0.348782099, 18 ],
  /* 5259 */  [ 0.348870547, 18 ],
  /* 5260 */  [ 0.348959000, 18 ],
  /* 5261 */  [ 0.349047459, 18 ],
  /* 5262 */  [ 0.349135923, 18 ],
  /* 5263 */  [ 0.349224393, 18 ],

  /* 5264 */  [ 0.349312869, 18 ],
  /* 5265 */  [ 0.349401350, 18 ],
  /* 5266 */  [ 0.349489837, 18 ],
  /* 5267 */  [ 0.349578329, 18 ],
  /* 5268 */  [ 0.349666827, 18 ],
  /* 5269 */  [ 0.349755331, 18 ],
  /* 5270 */  [ 0.349843840, 18 ],
  /* 5271 */  [ 0.349932355, 18 ],
  /* 5272 */  [ 0.350020876, 18 ],
  /* 5273 */  [ 0.350109402, 18 ],
  /* 5274 */  [ 0.350197933, 18 ],
  /* 5275 */  [ 0.350286470, 18 ],
  /* 5276 */  [ 0.350375013, 18 ],
  /* 5277 */  [ 0.350463562, 18 ],
  /* 5278 */  [ 0.350552116, 18 ],
  /* 5279 */  [ 0.350640675, 18 ],

  /* 5280 */  [ 0.350729240, 18 ],
  /* 5281 */  [ 0.350817811, 18 ],
  /* 5282 */  [ 0.350906388, 18 ],
  /* 5283 */  [ 0.350994970, 18 ],
  /* 5284 */  [ 0.351083557, 18 ],
  /* 5285 */  [ 0.351172150, 18 ],
  /* 5286 */  [ 0.351260749, 18 ],
  /* 5287 */  [ 0.351349353, 18 ],
  /* 5288 */  [ 0.351437963, 18 ],
  /* 5289 */  [ 0.351526579, 18 ],
  /* 5290 */  [ 0.351615200, 18 ],
  /* 5291 */  [ 0.351703827, 18 ],
  /* 5292 */  [ 0.351792459, 18 ],
  /* 5293 */  [ 0.351881097, 18 ],
  /* 5294 */  [ 0.351969740, 18 ],
  /* 5295 */  [ 0.352058389, 18 ],

  /* 5296 */  [ 0.352147044, 18 ],
  /* 5297 */  [ 0.352235704, 18 ],
  /* 5298 */  [ 0.352324369, 18 ],
  /* 5299 */  [ 0.352413041, 18 ],
  /* 5300 */  [ 0.352501718, 18 ],
  /* 5301 */  [ 0.352590400, 18 ],
  /* 5302 */  [ 0.352679088, 18 ],
  /* 5303 */  [ 0.352767782, 18 ],
  /* 5304 */  [ 0.352856481, 18 ],
  /* 5305 */  [ 0.352945186, 18 ],
  /* 5306 */  [ 0.353033896, 18 ],
  /* 5307 */  [ 0.353122612, 18 ],
  /* 5308 */  [ 0.353211333, 18 ],
  /* 5309 */  [ 0.353300061, 18 ],
  /* 5310 */  [ 0.353388793, 18 ],
  /* 5311 */  [ 0.353477531, 18 ],

  /* 5312 */  [ 0.353566275, 18 ],
  /* 5313 */  [ 0.353655024, 18 ],
  /* 5314 */  [ 0.353743779, 18 ],
  /* 5315 */  [ 0.353832540, 18 ],
  /* 5316 */  [ 0.353921306, 18 ],
  /* 5317 */  [ 0.354010077, 18 ],
  /* 5318 */  [ 0.354098855, 18 ],
  /* 5319 */  [ 0.354187637, 18 ],
  /* 5320 */  [ 0.354276426, 18 ],
  /* 5321 */  [ 0.354365220, 18 ],
  /* 5322 */  [ 0.354454019, 18 ],
  /* 5323 */  [ 0.354542824, 18 ],
  /* 5324 */  [ 0.354631635, 18 ],
  /* 5325 */  [ 0.354720451, 18 ],
  /* 5326 */  [ 0.354809272, 18 ],
  /* 5327 */  [ 0.354898100, 18 ],

  /* 5328 */  [ 0.354986932, 18 ],
  /* 5329 */  [ 0.355075771, 18 ],
  /* 5330 */  [ 0.355164615, 18 ],
  /* 5331 */  [ 0.355253464, 18 ],
  /* 5332 */  [ 0.355342319, 18 ],
  /* 5333 */  [ 0.355431180, 18 ],
  /* 5334 */  [ 0.355520046, 18 ],
  /* 5335 */  [ 0.355608917, 18 ],
  /* 5336 */  [ 0.355697795, 18 ],
  /* 5337 */  [ 0.355786677, 18 ],
  /* 5338 */  [ 0.355875566, 18 ],
  /* 5339 */  [ 0.355964460, 18 ],
  /* 5340 */  [ 0.356053359, 18 ],
  /* 5341 */  [ 0.356142264, 18 ],
  /* 5342 */  [ 0.356231175, 18 ],
  /* 5343 */  [ 0.356320091, 18 ],

  /* 5344 */  [ 0.356409012, 18 ],
  /* 5345 */  [ 0.356497940, 18 ],
  /* 5346 */  [ 0.356586872, 18 ],
  /* 5347 */  [ 0.356675811, 18 ],
  /* 5348 */  [ 0.356764754, 18 ],
  /* 5349 */  [ 0.356853704, 18 ],
  /* 5350 */  [ 0.356942659, 18 ],
  /* 5351 */  [ 0.357031619, 18 ],
  /* 5352 */  [ 0.357120585, 18 ],
  /* 5353 */  [ 0.357209557, 18 ],
  /* 5354 */  [ 0.357298534, 18 ],
  /* 5355 */  [ 0.357387516, 18 ],
  /* 5356 */  [ 0.357476504, 18 ],
  /* 5357 */  [ 0.357565498, 18 ],
  /* 5358 */  [ 0.357654497, 18 ],
  /* 5359 */  [ 0.357743502, 18 ],

  /* 5360 */  [ 0.357832512, 18 ],
  /* 5361 */  [ 0.357921528, 18 ],
  /* 5362 */  [ 0.358010550, 18 ],
  /* 5363 */  [ 0.358099576, 18 ],
  /* 5364 */  [ 0.358188609, 18 ],
  /* 5365 */  [ 0.358277647, 18 ],
  /* 5366 */  [ 0.358366690, 18 ],
  /* 5367 */  [ 0.358455739, 18 ],
  /* 5368 */  [ 0.358544794, 18 ],
  /* 5369 */  [ 0.358633854, 18 ],
  /* 5370 */  [ 0.358722920, 18 ],
  /* 5371 */  [ 0.358811991, 18 ],
  /* 5372 */  [ 0.358901067, 18 ],
  /* 5373 */  [ 0.358990150, 18 ],
  /* 5374 */  [ 0.359079237, 18 ],
  /* 5375 */  [ 0.359168331, 18 ],

  /* 5376 */  [ 0.359257429, 18 ],
  /* 5377 */  [ 0.359346534, 18 ],
  /* 5378 */  [ 0.359435644, 18 ],
  /* 5379 */  [ 0.359524759, 18 ],
  /* 5380 */  [ 0.359613880, 18 ],
  /* 5381 */  [ 0.359703006, 18 ],
  /* 5382 */  [ 0.359792138, 18 ],
  /* 5383 */  [ 0.359881276, 18 ],
  /* 5384 */  [ 0.359970419, 18 ],
  /* 5385 */  [ 0.360059567, 18 ],
  /* 5386 */  [ 0.360148721, 18 ],
  /* 5387 */  [ 0.360237881, 18 ],
  /* 5388 */  [ 0.360327046, 18 ],
  /* 5389 */  [ 0.360416216, 18 ],
  /* 5390 */  [ 0.360505392, 18 ],
  /* 5391 */  [ 0.360594574, 18 ],

  /* 5392 */  [ 0.360683761, 18 ],
  /* 5393 */  [ 0.360772953, 18 ],
  /* 5394 */  [ 0.360862152, 18 ],
  /* 5395 */  [ 0.360951355, 18 ],
  /* 5396 */  [ 0.361040564, 18 ],
  /* 5397 */  [ 0.361129779, 18 ],
  /* 5398 */  [ 0.361218999, 18 ],
  /* 5399 */  [ 0.361308225, 18 ],
  /* 5400 */  [ 0.361397456, 18 ],
  /* 5401 */  [ 0.361486693, 18 ],
  /* 5402 */  [ 0.361575935, 18 ],
  /* 5403 */  [ 0.361665183, 18 ],
  /* 5404 */  [ 0.361754436, 18 ],
  /* 5405 */  [ 0.361843695, 18 ],
  /* 5406 */  [ 0.361932959, 18 ],
  /* 5407 */  [ 0.362022229, 18 ],

  /* 5408 */  [ 0.362111504, 18 ],
  /* 5409 */  [ 0.362200785, 18 ],
  /* 5410 */  [ 0.362290071, 18 ],
  /* 5411 */  [ 0.362379362, 18 ],
  /* 5412 */  [ 0.362468660, 18 ],
  /* 5413 */  [ 0.362557962, 18 ],
  /* 5414 */  [ 0.362647271, 18 ],
  /* 5415 */  [ 0.362736584, 18 ],
  /* 5416 */  [ 0.362825904, 18 ],
  /* 5417 */  [ 0.362915228, 18 ],
  /* 5418 */  [ 0.363004559, 18 ],
  /* 5419 */  [ 0.363093894, 18 ],
  /* 5420 */  [ 0.363183236, 18 ],
  /* 5421 */  [ 0.363272582, 18 ],
  /* 5422 */  [ 0.363361935, 18 ],
  /* 5423 */  [ 0.363451292, 18 ],

  /* 5424 */  [ 0.363540655, 18 ],
  /* 5425 */  [ 0.363630024, 18 ],
  /* 5426 */  [ 0.363719398, 18 ],
  /* 5427 */  [ 0.363808778, 18 ],
  /* 5428 */  [ 0.363898163, 18 ],
  /* 5429 */  [ 0.363987554, 18 ],
  /* 5430 */  [ 0.364076950, 18 ],
  /* 5431 */  [ 0.364166352, 18 ],
  /* 5432 */  [ 0.364255759, 18 ],
  /* 5433 */  [ 0.364345171, 18 ],
  /* 5434 */  [ 0.364434589, 18 ],
  /* 5435 */  [ 0.364524013, 18 ],
  /* 5436 */  [ 0.364613442, 18 ],
  /* 5437 */  [ 0.364702877, 18 ],
  /* 5438 */  [ 0.364792317, 18 ],
  /* 5439 */  [ 0.364881762, 18 ],

  /* 5440 */  [ 0.364971213, 18 ],
  /* 5441 */  [ 0.365060669, 18 ],
  /* 5442 */  [ 0.365150131, 18 ],
  /* 5443 */  [ 0.365239599, 18 ],
  /* 5444 */  [ 0.365329072, 18 ],
  /* 5445 */  [ 0.365418550, 18 ],
  /* 5446 */  [ 0.365508034, 18 ],
  /* 5447 */  [ 0.365597523, 18 ],
  /* 5448 */  [ 0.365687018, 18 ],
  /* 5449 */  [ 0.365776518, 18 ],
  /* 5450 */  [ 0.365866024, 18 ],
  /* 5451 */  [ 0.365955536, 18 ],
  /* 5452 */  [ 0.366045052, 18 ],
  /* 5453 */  [ 0.366134574, 18 ],
  /* 5454 */  [ 0.366224102, 18 ],
  /* 5455 */  [ 0.366313635, 18 ],

  /* 5456 */  [ 0.366403174, 18 ],
  /* 5457 */  [ 0.366492718, 18 ],
  /* 5458 */  [ 0.366582267, 18 ],
  /* 5459 */  [ 0.366671822, 18 ],
  /* 5460 */  [ 0.366761383, 18 ],
  /* 5461 */  [ 0.366850949, 18 ],
  /* 5462 */  [ 0.366940520, 18 ],
  /* 5463 */  [ 0.367030097, 18 ],
  /* 5464 */  [ 0.367119680, 18 ],
  /* 5465 */  [ 0.367209267, 18 ],
  /* 5466 */  [ 0.367298861, 18 ],
  /* 5467 */  [ 0.367388459, 18 ],
  /* 5468 */  [ 0.367478064, 18 ],
  /* 5469 */  [ 0.367567673, 18 ],
  /* 5470 */  [ 0.367657288, 18 ],
  /* 5471 */  [ 0.367746909, 18 ],

  /* 5472 */  [ 0.367836535, 18 ],
  /* 5473 */  [ 0.367926167, 18 ],
  /* 5474 */  [ 0.368015804, 18 ],
  /* 5475 */  [ 0.368105446, 18 ],
  /* 5476 */  [ 0.368195094, 18 ],
  /* 5477 */  [ 0.368284747, 18 ],
  /* 5478 */  [ 0.368374406, 18 ],
  /* 5479 */  [ 0.368464070, 18 ],
  /* 5480 */  [ 0.368553740, 18 ],
  /* 5481 */  [ 0.368643415, 18 ],
  /* 5482 */  [ 0.368733096, 18 ],
  /* 5483 */  [ 0.368822782, 18 ],
  /* 5484 */  [ 0.368912473, 18 ],
  /* 5485 */  [ 0.369002170, 18 ],
  /* 5486 */  [ 0.369091873, 18 ],
  /* 5487 */  [ 0.369181581, 18 ],

  /* 5488 */  [ 0.369271294, 18 ],
  /* 5489 */  [ 0.369361013, 18 ],
  /* 5490 */  [ 0.369450737, 18 ],
  /* 5491 */  [ 0.369540467, 18 ],
  /* 5492 */  [ 0.369630202, 18 ],
  /* 5493 */  [ 0.369719942, 18 ],
  /* 5494 */  [ 0.369809688, 18 ],
  /* 5495 */  [ 0.369899440, 18 ],
  /* 5496 */  [ 0.369989197, 18 ],
  /* 5497 */  [ 0.370078959, 18 ],
  /* 5498 */  [ 0.370168727, 18 ],
  /* 5499 */  [ 0.370258500, 18 ],
  /* 5500 */  [ 0.370348279, 18 ],
  /* 5501 */  [ 0.370438063, 18 ],
  /* 5502 */  [ 0.370527853, 18 ],
  /* 5503 */  [ 0.370617648, 18 ],

  /* 5504 */  [ 0.370707448, 18 ],
  /* 5505 */  [ 0.370797254, 18 ],
  /* 5506 */  [ 0.370887065, 18 ],
  /* 5507 */  [ 0.370976882, 18 ],
  /* 5508 */  [ 0.371066704, 18 ],
  /* 5509 */  [ 0.371156532, 18 ],
  /* 5510 */  [ 0.371246365, 18 ],
  /* 5511 */  [ 0.371336203, 18 ],
  /* 5512 */  [ 0.371426047, 18 ],
  /* 5513 */  [ 0.371515897, 18 ],
  /* 5514 */  [ 0.371605751, 18 ],
  /* 5515 */  [ 0.371695612, 18 ],
  /* 5516 */  [ 0.371785477, 18 ],
  /* 5517 */  [ 0.371875348, 18 ],
  /* 5518 */  [ 0.371965225, 18 ],
  /* 5519 */  [ 0.372055107, 18 ],

  /* 5520 */  [ 0.372144994, 18 ],
  /* 5521 */  [ 0.372234887, 18 ],
  /* 5522 */  [ 0.372324785, 18 ],
  /* 5523 */  [ 0.372414689, 18 ],
  /* 5524 */  [ 0.372504598, 18 ],
  /* 5525 */  [ 0.372594513, 18 ],
  /* 5526 */  [ 0.372684433, 18 ],
  /* 5527 */  [ 0.372774358, 18 ],
  /* 5528 */  [ 0.372864289, 18 ],
  /* 5529 */  [ 0.372954225, 18 ],
  /* 5530 */  [ 0.373044167, 18 ],
  /* 5531 */  [ 0.373134114, 18 ],
  /* 5532 */  [ 0.373224066, 18 ],
  /* 5533 */  [ 0.373314024, 18 ],
  /* 5534 */  [ 0.373403987, 18 ],
  /* 5535 */  [ 0.373493956, 18 ],

  /* 5536 */  [ 0.373583930, 18 ],
  /* 5537 */  [ 0.373673910, 18 ],
  /* 5538 */  [ 0.373763895, 18 ],
  /* 5539 */  [ 0.373853885, 18 ],
  /* 5540 */  [ 0.373943881, 18 ],
  /* 5541 */  [ 0.374033882, 18 ],
  /* 5542 */  [ 0.374123889, 18 ],
  /* 5543 */  [ 0.374213901, 18 ],
  /* 5544 */  [ 0.374303918, 18 ],
  /* 5545 */  [ 0.374393941, 18 ],
  /* 5546 */  [ 0.374483970, 18 ],
  /* 5547 */  [ 0.374574003, 18 ],
  /* 5548 */  [ 0.374664042, 18 ],
  /* 5549 */  [ 0.374754087, 18 ],
  /* 5550 */  [ 0.374844137, 18 ],
  /* 5551 */  [ 0.374934192, 18 ],

  /* 5552 */  [ 0.375024253, 18 ],
  /* 5553 */  [ 0.375114319, 18 ],
  /* 5554 */  [ 0.375204391, 18 ],
  /* 5555 */  [ 0.375294468, 18 ],
  /* 5556 */  [ 0.375384550, 18 ],
  /* 5557 */  [ 0.375474638, 18 ],
  /* 5558 */  [ 0.375564731, 18 ],
  /* 5559 */  [ 0.375654830, 18 ],
  /* 5560 */  [ 0.375744934, 18 ],
  /* 5561 */  [ 0.375835043, 18 ],
  /* 5562 */  [ 0.375925158, 18 ],
  /* 5563 */  [ 0.376015278, 18 ],
  /* 5564 */  [ 0.376105404, 18 ],
  /* 5565 */  [ 0.376195535, 18 ],
  /* 5566 */  [ 0.376285671, 18 ],
  /* 5567 */  [ 0.376375813, 18 ],

  /* 5568 */  [ 0.376465960, 18 ],
  /* 5569 */  [ 0.376556113, 18 ],
  /* 5570 */  [ 0.376646271, 18 ],
  /* 5571 */  [ 0.376736434, 18 ],
  /* 5572 */  [ 0.376826603, 18 ],
  /* 5573 */  [ 0.376916777, 18 ],
  /* 5574 */  [ 0.377006957, 18 ],
  /* 5575 */  [ 0.377097141, 18 ],
  /* 5576 */  [ 0.377187332, 18 ],
  /* 5577 */  [ 0.377277528, 18 ],
  /* 5578 */  [ 0.377367729, 18 ],
  /* 5579 */  [ 0.377457935, 18 ],
  /* 5580 */  [ 0.377548147, 18 ],
  /* 5581 */  [ 0.377638364, 18 ],
  /* 5582 */  [ 0.377728587, 18 ],
  /* 5583 */  [ 0.377818815, 18 ],

  /* 5584 */  [ 0.377909049, 18 ],
  /* 5585 */  [ 0.377999288, 18 ],
  /* 5586 */  [ 0.378089532, 18 ],
  /* 5587 */  [ 0.378179781, 18 ],
  /* 5588 */  [ 0.378270036, 18 ],
  /* 5589 */  [ 0.378360297, 18 ],
  /* 5590 */  [ 0.378450563, 18 ],
  /* 5591 */  [ 0.378540834, 18 ],
  /* 5592 */  [ 0.378631110, 18 ],
  /* 5593 */  [ 0.378721392, 18 ],
  /* 5594 */  [ 0.378811680, 18 ],
  /* 5595 */  [ 0.378901972, 18 ],
  /* 5596 */  [ 0.378992270, 18 ],
  /* 5597 */  [ 0.379082574, 18 ],
  /* 5598 */  [ 0.379172883, 18 ],
  /* 5599 */  [ 0.379263197, 18 ],

  /* 5600 */  [ 0.379353516, 18 ],
  /* 5601 */  [ 0.379443841, 18 ],
  /* 5602 */  [ 0.379534172, 18 ],
  /* 5603 */  [ 0.379624507, 18 ],
  /* 5604 */  [ 0.379714848, 18 ],
  /* 5605 */  [ 0.379805195, 18 ],
  /* 5606 */  [ 0.379895547, 18 ],
  /* 5607 */  [ 0.379985904, 18 ],
  /* 5608 */  [ 0.380076266, 18 ],
  /* 5609 */  [ 0.380166634, 18 ],
  /* 5610 */  [ 0.380257008, 18 ],
  /* 5611 */  [ 0.380347386, 18 ],
  /* 5612 */  [ 0.380437770, 18 ],
  /* 5613 */  [ 0.380528160, 18 ],
  /* 5614 */  [ 0.380618555, 18 ],
  /* 5615 */  [ 0.380708955, 18 ],

  /* 5616 */  [ 0.380799360, 18 ],
  /* 5617 */  [ 0.380889771, 18 ],
  /* 5618 */  [ 0.380980187, 18 ],
  /* 5619 */  [ 0.381070609, 18 ],
  /* 5620 */  [ 0.381161036, 18 ],
  /* 5621 */  [ 0.381251468, 18 ],
  /* 5622 */  [ 0.381341906, 18 ],
  /* 5623 */  [ 0.381432349, 18 ],
  /* 5624 */  [ 0.381522798, 18 ],
  /* 5625 */  [ 0.381613251, 18 ],
  /* 5626 */  [ 0.381703711, 18 ],
  /* 5627 */  [ 0.381794175, 18 ],
  /* 5628 */  [ 0.381884645, 18 ],
  /* 5629 */  [ 0.381975120, 18 ],
  /* 5630 */  [ 0.382065601, 18 ],
  /* 5631 */  [ 0.382156087, 18 ],

  /* 5632 */  [ 0.382246578, 18 ],
  /* 5633 */  [ 0.382337075, 18 ],
  /* 5634 */  [ 0.382427577, 18 ],
  /* 5635 */  [ 0.382518084, 18 ],
  /* 5636 */  [ 0.382608597, 18 ],
  /* 5637 */  [ 0.382699115, 18 ],
  /* 5638 */  [ 0.382789638, 18 ],
  /* 5639 */  [ 0.382880167, 18 ],
  /* 5640 */  [ 0.382970701, 18 ],
  /* 5641 */  [ 0.383061241, 18 ],
  /* 5642 */  [ 0.383151786, 18 ],
  /* 5643 */  [ 0.383242336, 18 ],
  /* 5644 */  [ 0.383332891, 18 ],
  /* 5645 */  [ 0.383423452, 18 ],
  /* 5646 */  [ 0.383514018, 18 ],
  /* 5647 */  [ 0.383604590, 18 ],

  /* 5648 */  [ 0.383695167, 18 ],
  /* 5649 */  [ 0.383785749, 18 ],
  /* 5650 */  [ 0.383876337, 18 ],
  /* 5651 */  [ 0.383966930, 18 ],
  /* 5652 */  [ 0.384057528, 18 ],
  /* 5653 */  [ 0.384148132, 18 ],
  /* 5654 */  [ 0.384238741, 18 ],
  /* 5655 */  [ 0.384329355, 18 ],
  /* 5656 */  [ 0.384419975, 18 ],
  /* 5657 */  [ 0.384510600, 18 ],
  /* 5658 */  [ 0.384601230, 18 ],
  /* 5659 */  [ 0.384691866, 18 ],
  /* 5660 */  [ 0.384782507, 18 ],
  /* 5661 */  [ 0.384873153, 18 ],
  /* 5662 */  [ 0.384963805, 18 ],
  /* 5663 */  [ 0.385054462, 18 ],

  /* 5664 */  [ 0.385145124, 18 ],
  /* 5665 */  [ 0.385235792, 18 ],
  /* 5666 */  [ 0.385326465, 18 ],
  /* 5667 */  [ 0.385417143, 18 ],
  /* 5668 */  [ 0.385507827, 18 ],
  /* 5669 */  [ 0.385598516, 18 ],
  /* 5670 */  [ 0.385689211, 18 ],
  /* 5671 */  [ 0.385779910, 18 ],
  /* 5672 */  [ 0.385870615, 18 ],
  /* 5673 */  [ 0.385961326, 18 ],
  /* 5674 */  [ 0.386052041, 18 ],
  /* 5675 */  [ 0.386142762, 18 ],
  /* 5676 */  [ 0.386233489, 18 ],
  /* 5677 */  [ 0.386324221, 18 ],
  /* 5678 */  [ 0.386414958, 18 ],
  /* 5679 */  [ 0.386505700, 18 ],

  /* 5680 */  [ 0.386596448, 18 ],
  /* 5681 */  [ 0.386687201, 18 ],
  /* 5682 */  [ 0.386777959, 18 ],
  /* 5683 */  [ 0.386868723, 18 ],
  /* 5684 */  [ 0.386959492, 18 ],
  /* 5685 */  [ 0.387050266, 18 ],
  /* 5686 */  [ 0.387141045, 18 ],
  /* 5687 */  [ 0.387231830, 18 ],
  /* 5688 */  [ 0.387322621, 18 ],
  /* 5689 */  [ 0.387413416, 18 ],
  /* 5690 */  [ 0.387504217, 18 ],
  /* 5691 */  [ 0.387595023, 18 ],
  /* 5692 */  [ 0.387685835, 18 ],
  /* 5693 */  [ 0.387776652, 18 ],
  /* 5694 */  [ 0.387867474, 18 ],
  /* 5695 */  [ 0.387958301, 18 ],

  /* 5696 */  [ 0.388049134, 18 ],
  /* 5697 */  [ 0.388139972, 18 ],
  /* 5698 */  [ 0.388230816, 18 ],
  /* 5699 */  [ 0.388321665, 18 ],
  /* 5700 */  [ 0.388412519, 18 ],
  /* 5701 */  [ 0.388503378, 18 ],
  /* 5702 */  [ 0.388594243, 18 ],
  /* 5703 */  [ 0.388685113, 18 ],
  /* 5704 */  [ 0.388775988, 18 ],
  /* 5705 */  [ 0.388866869, 18 ],
  /* 5706 */  [ 0.388957755, 18 ],
  /* 5707 */  [ 0.389048646, 18 ],
  /* 5708 */  [ 0.389139542, 18 ],
  /* 5709 */  [ 0.389230444, 18 ],
  /* 5710 */  [ 0.389321352, 18 ],
  /* 5711 */  [ 0.389412264, 18 ],

  /* 5712 */  [ 0.389503182, 18 ],
  /* 5713 */  [ 0.389594105, 18 ],
  /* 5714 */  [ 0.389685033, 18 ],
  /* 5715 */  [ 0.389775967, 18 ],
  /* 5716 */  [ 0.389866906, 18 ],
  /* 5717 */  [ 0.389957850, 18 ],
  /* 5718 */  [ 0.390048800, 18 ],
  /* 5719 */  [ 0.390139755, 18 ],
  /* 5720 */  [ 0.390230715, 18 ],
  /* 5721 */  [ 0.390321681, 18 ],
  /* 5722 */  [ 0.390412651, 18 ],
  /* 5723 */  [ 0.390503628, 18 ],
  /* 5724 */  [ 0.390594609, 18 ],
  /* 5725 */  [ 0.390685596, 18 ],
  /* 5726 */  [ 0.390776588, 18 ],
  /* 5727 */  [ 0.390867585, 18 ],

  /* 5728 */  [ 0.390958588, 18 ],
  /* 5729 */  [ 0.391049596, 18 ],
  /* 5730 */  [ 0.391140609, 18 ],
  /* 5731 */  [ 0.391231627, 18 ],
  /* 5732 */  [ 0.391322651, 18 ],
  /* 5733 */  [ 0.391413680, 18 ],
  /* 5734 */  [ 0.391504714, 18 ],
  /* 5735 */  [ 0.391595754, 18 ],
  /* 5736 */  [ 0.391686799, 18 ],
  /* 5737 */  [ 0.391777849, 18 ],
  /* 5738 */  [ 0.391868905, 18 ],
  /* 5739 */  [ 0.391959966, 18 ],
  /* 5740 */  [ 0.392051032, 18 ],
  /* 5741 */  [ 0.392142103, 18 ],
  /* 5742 */  [ 0.392233180, 18 ],
  /* 5743 */  [ 0.392324262, 18 ],

  /* 5744 */  [ 0.392415349, 18 ],
  /* 5745 */  [ 0.392506442, 18 ],
  /* 5746 */  [ 0.392597540, 18 ],
  /* 5747 */  [ 0.392688643, 18 ],
  /* 5748 */  [ 0.392779751, 18 ],
  /* 5749 */  [ 0.392870865, 18 ],
  /* 5750 */  [ 0.392961984, 18 ],
  /* 5751 */  [ 0.393053108, 18 ],
  /* 5752 */  [ 0.393144238, 18 ],
  /* 5753 */  [ 0.393235372, 18 ],
  /* 5754 */  [ 0.393326513, 18 ],
  /* 5755 */  [ 0.393417658, 18 ],
  /* 5756 */  [ 0.393508809, 18 ],
  /* 5757 */  [ 0.393599965, 18 ],
  /* 5758 */  [ 0.393691126, 18 ],
  /* 5759 */  [ 0.393782292, 18 ],

  /* 5760 */  [ 0.393873464, 18 ],
  /* 5761 */  [ 0.393964641, 18 ],
  /* 5762 */  [ 0.394055823, 18 ],
  /* 5763 */  [ 0.394147011, 18 ],
  /* 5764 */  [ 0.394238204, 18 ],
  /* 5765 */  [ 0.394329402, 18 ],
  /* 5766 */  [ 0.394420605, 18 ],
  /* 5767 */  [ 0.394511814, 18 ],
  /* 5768 */  [ 0.394603028, 18 ],
  /* 5769 */  [ 0.394694247, 18 ],
  /* 5770 */  [ 0.394785472, 18 ],
  /* 5771 */  [ 0.394876702, 18 ],
  /* 5772 */  [ 0.394967937, 18 ],
  /* 5773 */  [ 0.395059177, 18 ],
  /* 5774 */  [ 0.395150423, 18 ],
  /* 5775 */  [ 0.395241673, 18 ],

  /* 5776 */  [ 0.395332930, 18 ],
  /* 5777 */  [ 0.395424191, 18 ],
  /* 5778 */  [ 0.395515458, 18 ],
  /* 5779 */  [ 0.395606730, 18 ],
  /* 5780 */  [ 0.395698007, 18 ],
  /* 5781 */  [ 0.395789289, 18 ],
  /* 5782 */  [ 0.395880577, 18 ],
  /* 5783 */  [ 0.395971870, 18 ],
  /* 5784 */  [ 0.396063168, 18 ],
  /* 5785 */  [ 0.396154472, 18 ],
  /* 5786 */  [ 0.396245780, 18 ],
  /* 5787 */  [ 0.396337094, 18 ],
  /* 5788 */  [ 0.396428414, 18 ],
  /* 5789 */  [ 0.396519738, 18 ],
  /* 5790 */  [ 0.396611068, 18 ],
  /* 5791 */  [ 0.396702403, 18 ],

  /* 5792 */  [ 0.396793743, 18 ],
  /* 5793 */  [ 0.396885089, 18 ],
  /* 5794 */  [ 0.396976440, 18 ],
  /* 5795 */  [ 0.397067796, 18 ],
  /* 5796 */  [ 0.397159157, 18 ],
  /* 5797 */  [ 0.397250524, 18 ],
  /* 5798 */  [ 0.397341896, 18 ],
  /* 5799 */  [ 0.397433273, 18 ],
  /* 5800 */  [ 0.397524655, 18 ],
  /* 5801 */  [ 0.397616043, 18 ],
  /* 5802 */  [ 0.397707436, 18 ],
  /* 5803 */  [ 0.397798834, 18 ],
  /* 5804 */  [ 0.397890237, 18 ],
  /* 5805 */  [ 0.397981646, 18 ],
  /* 5806 */  [ 0.398073059, 18 ],
  /* 5807 */  [ 0.398164479, 18 ],

  /* 5808 */  [ 0.398255903, 18 ],
  /* 5809 */  [ 0.398347333, 18 ],
  /* 5810 */  [ 0.398438767, 18 ],
  /* 5811 */  [ 0.398530207, 18 ],
  /* 5812 */  [ 0.398621653, 18 ],
  /* 5813 */  [ 0.398713103, 18 ],
  /* 5814 */  [ 0.398804559, 18 ],
  /* 5815 */  [ 0.398896020, 18 ],
  /* 5816 */  [ 0.398987487, 18 ],
  /* 5817 */  [ 0.399078958, 18 ],
  /* 5818 */  [ 0.399170435, 18 ],
  /* 5819 */  [ 0.399261917, 18 ],
  /* 5820 */  [ 0.399353404, 18 ],
  /* 5821 */  [ 0.399444897, 18 ],
  /* 5822 */  [ 0.399536395, 18 ],
  /* 5823 */  [ 0.399627898, 18 ],

  /* 5824 */  [ 0.399719406, 18 ],
  /* 5825 */  [ 0.399810919, 18 ],
  /* 5826 */  [ 0.399902438, 18 ],
  /* 5827 */  [ 0.399993962, 18 ],
  /* 5828 */  [ 0.400085491, 18 ],
  /* 5829 */  [ 0.400177026, 18 ],
  /* 5830 */  [ 0.400268565, 18 ],
  /* 5831 */  [ 0.400360110, 18 ],
  /* 5832 */  [ 0.400451660, 18 ],
  /* 5833 */  [ 0.400543216, 18 ],
  /* 5834 */  [ 0.400634776, 18 ],
  /* 5835 */  [ 0.400726342, 18 ],
  /* 5836 */  [ 0.400817913, 18 ],
  /* 5837 */  [ 0.400909489, 18 ],
  /* 5838 */  [ 0.401001071, 18 ],
  /* 5839 */  [ 0.401092657, 18 ],

  /* 5840 */  [ 0.401184249, 18 ],
  /* 5841 */  [ 0.401275847, 18 ],
  /* 5842 */  [ 0.401367449, 18 ],
  /* 5843 */  [ 0.401459057, 18 ],
  /* 5844 */  [ 0.401550670, 18 ],
  /* 5845 */  [ 0.401642288, 18 ],
  /* 5846 */  [ 0.401733911, 18 ],
  /* 5847 */  [ 0.401825540, 18 ],
  /* 5848 */  [ 0.401917173, 18 ],
  /* 5849 */  [ 0.402008812, 18 ],
  /* 5850 */  [ 0.402100457, 18 ],
  /* 5851 */  [ 0.402192106, 18 ],
  /* 5852 */  [ 0.402283761, 18 ],
  /* 5853 */  [ 0.402375420, 18 ],
  /* 5854 */  [ 0.402467086, 18 ],
  /* 5855 */  [ 0.402558756, 18 ],

  /* 5856 */  [ 0.402650431, 18 ],
  /* 5857 */  [ 0.402742112, 18 ],
  /* 5858 */  [ 0.402833798, 18 ],
  /* 5859 */  [ 0.402925489, 18 ],
  /* 5860 */  [ 0.403017186, 18 ],
  /* 5861 */  [ 0.403108887, 18 ],
  /* 5862 */  [ 0.403200594, 18 ],
  /* 5863 */  [ 0.403292306, 18 ],
  /* 5864 */  [ 0.403384024, 18 ],
  /* 5865 */  [ 0.403475746, 18 ],
  /* 5866 */  [ 0.403567474, 18 ],
  /* 5867 */  [ 0.403659207, 18 ],
  /* 5868 */  [ 0.403750945, 18 ],
  /* 5869 */  [ 0.403842688, 18 ],
  /* 5870 */  [ 0.403934437, 18 ],
  /* 5871 */  [ 0.404026190, 18 ],

  /* 5872 */  [ 0.404117949, 18 ],
  /* 5873 */  [ 0.404209714, 18 ],
  /* 5874 */  [ 0.404301483, 18 ],
  /* 5875 */  [ 0.404393258, 18 ],
  /* 5876 */  [ 0.404485037, 18 ],
  /* 5877 */  [ 0.404576822, 18 ],
  /* 5878 */  [ 0.404668613, 18 ],
  /* 5879 */  [ 0.404760408, 18 ],
  /* 5880 */  [ 0.404852209, 18 ],
  /* 5881 */  [ 0.404944014, 18 ],
  /* 5882 */  [ 0.405035825, 18 ],
  /* 5883 */  [ 0.405127642, 18 ],
  /* 5884 */  [ 0.405219463, 18 ],
  /* 5885 */  [ 0.405311290, 18 ],
  /* 5886 */  [ 0.405403122, 18 ],
  /* 5887 */  [ 0.405494959, 18 ],

  /* 5888 */  [ 0.405586801, 18 ],
  /* 5889 */  [ 0.405678648, 18 ],
  /* 5890 */  [ 0.405770501, 18 ],
  /* 5891 */  [ 0.405862359, 18 ],
  /* 5892 */  [ 0.405954222, 18 ],
  /* 5893 */  [ 0.406046090, 18 ],
  /* 5894 */  [ 0.406137963, 18 ],
  /* 5895 */  [ 0.406229842, 18 ],
  /* 5896 */  [ 0.406321726, 18 ],
  /* 5897 */  [ 0.406413615, 18 ],
  /* 5898 */  [ 0.406505509, 18 ],
  /* 5899 */  [ 0.406597408, 18 ],
  /* 5900 */  [ 0.406689313, 18 ],
  /* 5901 */  [ 0.406781223, 18 ],
  /* 5902 */  [ 0.406873138, 18 ],
  /* 5903 */  [ 0.406965058, 18 ],

  /* 5904 */  [ 0.407056983, 18 ],
  /* 5905 */  [ 0.407148914, 18 ],
  /* 5906 */  [ 0.407240850, 18 ],
  /* 5907 */  [ 0.407332791, 18 ],
  /* 5908 */  [ 0.407424737, 18 ],
  /* 5909 */  [ 0.407516688, 18 ],
  /* 5910 */  [ 0.407608645, 18 ],
  /* 5911 */  [ 0.407700606, 18 ],
  /* 5912 */  [ 0.407792573, 18 ],
  /* 5913 */  [ 0.407884545, 18 ],
  /* 5914 */  [ 0.407976522, 18 ],
  /* 5915 */  [ 0.408068505, 18 ],
  /* 5916 */  [ 0.408160492, 18 ],
  /* 5917 */  [ 0.408252485, 18 ],
  /* 5918 */  [ 0.408344483, 18 ],
  /* 5919 */  [ 0.408436486, 18 ],

  /* 5920 */  [ 0.408528495, 18 ],
  /* 5921 */  [ 0.408620508, 18 ],
  /* 5922 */  [ 0.408712527, 18 ],
  /* 5923 */  [ 0.408804551, 18 ],
  /* 5924 */  [ 0.408896580, 18 ],
  /* 5925 */  [ 0.408988614, 18 ],
  /* 5926 */  [ 0.409080653, 18 ],
  /* 5927 */  [ 0.409172698, 18 ],
  /* 5928 */  [ 0.409264748, 18 ],
  /* 5929 */  [ 0.409356803, 18 ],
  /* 5930 */  [ 0.409448863, 18 ],
  /* 5931 */  [ 0.409540928, 18 ],
  /* 5932 */  [ 0.409632999, 18 ],
  /* 5933 */  [ 0.409725074, 18 ],
  /* 5934 */  [ 0.409817155, 18 ],
  /* 5935 */  [ 0.409909241, 18 ],

  /* 5936 */  [ 0.410001332, 18 ],
  /* 5937 */  [ 0.410093428, 18 ],
  /* 5938 */  [ 0.410185530, 18 ],
  /* 5939 */  [ 0.410277637, 18 ],
  /* 5940 */  [ 0.410369748, 18 ],
  /* 5941 */  [ 0.410461865, 18 ],
  /* 5942 */  [ 0.410553988, 18 ],
  /* 5943 */  [ 0.410646115, 18 ],
  /* 5944 */  [ 0.410738247, 18 ],
  /* 5945 */  [ 0.410830385, 18 ],
  /* 5946 */  [ 0.410922528, 18 ],
  /* 5947 */  [ 0.411014676, 18 ],
  /* 5948 */  [ 0.411106829, 18 ],
  /* 5949 */  [ 0.411198987, 18 ],
  /* 5950 */  [ 0.411291151, 18 ],
  /* 5951 */  [ 0.411383320, 18 ],

  /* 5952 */  [ 0.411475493, 18 ],
  /* 5953 */  [ 0.411567672, 18 ],
  /* 5954 */  [ 0.411659857, 18 ],
  /* 5955 */  [ 0.411752046, 18 ],
  /* 5956 */  [ 0.411844240, 18 ],
  /* 5957 */  [ 0.411936440, 18 ],
  /* 5958 */  [ 0.412028645, 18 ],
  /* 5959 */  [ 0.412120855, 18 ],
  /* 5960 */  [ 0.412213070, 18 ],
  /* 5961 */  [ 0.412305290, 18 ],
  /* 5962 */  [ 0.412397516, 18 ],
  /* 5963 */  [ 0.412489746, 18 ],
  /* 5964 */  [ 0.412581982, 18 ],
  /* 5965 */  [ 0.412674223, 18 ],
  /* 5966 */  [ 0.412766469, 18 ],
  /* 5967 */  [ 0.412858720, 18 ],

  /* 5968 */  [ 0.412950976, 18 ],
  /* 5969 */  [ 0.413043238, 18 ],
  /* 5970 */  [ 0.413135505, 18 ],
  /* 5971 */  [ 0.413227776, 18 ],
  /* 5972 */  [ 0.413320053, 18 ],
  /* 5973 */  [ 0.413412335, 18 ],
  /* 5974 */  [ 0.413504623, 18 ],
  /* 5975 */  [ 0.413596915, 18 ],
  /* 5976 */  [ 0.413689213, 18 ],
  /* 5977 */  [ 0.413781515, 18 ],
  /* 5978 */  [ 0.413873823, 18 ],
  /* 5979 */  [ 0.413966136, 18 ],
  /* 5980 */  [ 0.414058454, 18 ],
  /* 5981 */  [ 0.414150778, 18 ],
  /* 5982 */  [ 0.414243106, 18 ],
  /* 5983 */  [ 0.414335440, 18 ],

  /* 5984 */  [ 0.414427779, 18 ],
  /* 5985 */  [ 0.414520122, 18 ],
  /* 5986 */  [ 0.414612471, 18 ],
  /* 5987 */  [ 0.414704826, 18 ],
  /* 5988 */  [ 0.414797185, 18 ],
  /* 5989 */  [ 0.414889549, 18 ],
  /* 5990 */  [ 0.414981919, 18 ],
  /* 5991 */  [ 0.415074294, 18 ],
  /* 5992 */  [ 0.415166674, 18 ],
  /* 5993 */  [ 0.415259059, 18 ],
  /* 5994 */  [ 0.415351449, 18 ],
  /* 5995 */  [ 0.415443844, 18 ],
  /* 5996 */  [ 0.415536244, 18 ],
  /* 5997 */  [ 0.415628650, 18 ],
  /* 5998 */  [ 0.415721061, 18 ],
  /* 5999 */  [ 0.415813476, 18 ],

  /* 6000 */  [ 0.415905897, 18 ],
  /* 6001 */  [ 0.415998324, 18 ],
  /* 6002 */  [ 0.416090755, 18 ],
  /* 6003 */  [ 0.416183191, 18 ],
  /* 6004 */  [ 0.416275633, 18 ],
  /* 6005 */  [ 0.416368079, 18 ],
  /* 6006 */  [ 0.416460531, 18 ],
  /* 6007 */  [ 0.416552988, 18 ],
  /* 6008 */  [ 0.416645450, 18 ],
  /* 6009 */  [ 0.416737917, 18 ],
  /* 6010 */  [ 0.416830389, 18 ],
  /* 6011 */  [ 0.416922867, 18 ],
  /* 6012 */  [ 0.417015349, 18 ],
  /* 6013 */  [ 0.417107837, 18 ],
  /* 6014 */  [ 0.417200330, 18 ],
  /* 6015 */  [ 0.417292828, 18 ],

  /* 6016 */  [ 0.417385331, 18 ],
  /* 6017 */  [ 0.417477839, 18 ],
  /* 6018 */  [ 0.417570352, 18 ],
  /* 6019 */  [ 0.417662871, 18 ],
  /* 6020 */  [ 0.417755394, 18 ],
  /* 6021 */  [ 0.417847923, 18 ],
  /* 6022 */  [ 0.417940457, 18 ],
  /* 6023 */  [ 0.418032996, 18 ],
  /* 6024 */  [ 0.418125540, 18 ],
  /* 6025 */  [ 0.418218089, 18 ],
  /* 6026 */  [ 0.418310643, 18 ],
  /* 6027 */  [ 0.418403203, 18 ],
  /* 6028 */  [ 0.418495767, 18 ],
  /* 6029 */  [ 0.418588337, 18 ],
  /* 6030 */  [ 0.418680911, 18 ],
  /* 6031 */  [ 0.418773491, 18 ],

  /* 6032 */  [ 0.418866076, 18 ],
  /* 6033 */  [ 0.418958666, 18 ],
  /* 6034 */  [ 0.419051262, 18 ],
  /* 6035 */  [ 0.419143862, 18 ],
  /* 6036 */  [ 0.419236467, 18 ],
  /* 6037 */  [ 0.419329078, 18 ],
  /* 6038 */  [ 0.419421694, 18 ],
  /* 6039 */  [ 0.419514314, 18 ],
  /* 6040 */  [ 0.419606940, 18 ],
  /* 6041 */  [ 0.419699571, 18 ],
  /* 6042 */  [ 0.419792208, 18 ],
  /* 6043 */  [ 0.419884849, 18 ],
  /* 6044 */  [ 0.419977495, 18 ],
  /* 6045 */  [ 0.420070147, 18 ],
  /* 6046 */  [ 0.420162803, 18 ],
  /* 6047 */  [ 0.420255465, 18 ],

  /* 6048 */  [ 0.420348132, 18 ],
  /* 6049 */  [ 0.420440803, 18 ],
  /* 6050 */  [ 0.420533481, 18 ],
  /* 6051 */  [ 0.420626163, 18 ],
  /* 6052 */  [ 0.420718850, 18 ],
  /* 6053 */  [ 0.420811542, 18 ],
  /* 6054 */  [ 0.420904240, 18 ],
  /* 6055 */  [ 0.420996942, 18 ],
  /* 6056 */  [ 0.421089650, 18 ],
  /* 6057 */  [ 0.421182362, 18 ],
  /* 6058 */  [ 0.421275080, 18 ],
  /* 6059 */  [ 0.421367803, 18 ],
  /* 6060 */  [ 0.421460531, 18 ],
  /* 6061 */  [ 0.421553264, 18 ],
  /* 6062 */  [ 0.421646003, 18 ],
  /* 6063 */  [ 0.421738746, 18 ],

  /* 6064 */  [ 0.421831494, 18 ],
  /* 6065 */  [ 0.421924248, 18 ],
  /* 6066 */  [ 0.422017007, 18 ],
  /* 6067 */  [ 0.422109770, 18 ],
  /* 6068 */  [ 0.422202539, 18 ],
  /* 6069 */  [ 0.422295313, 18 ],
  /* 6070 */  [ 0.422388092, 18 ],
  /* 6071 */  [ 0.422480876, 18 ],
  /* 6072 */  [ 0.422573665, 18 ],
  /* 6073 */  [ 0.422666460, 18 ],
  /* 6074 */  [ 0.422759259, 18 ],
  /* 6075 */  [ 0.422852064, 18 ],
  /* 6076 */  [ 0.422944873, 18 ],
  /* 6077 */  [ 0.423037688, 18 ],
  /* 6078 */  [ 0.423130508, 18 ],
  /* 6079 */  [ 0.423223333, 18 ],

  /* 6080 */  [ 0.423316162, 18 ],
  /* 6081 */  [ 0.423408997, 18 ],
  /* 6082 */  [ 0.423501838, 18 ],
  /* 6083 */  [ 0.423594683, 18 ],
  /* 6084 */  [ 0.423687533, 18 ],
  /* 6085 */  [ 0.423780389, 18 ],
  /* 6086 */  [ 0.423873249, 18 ],
  /* 6087 */  [ 0.423966115, 18 ],
  /* 6088 */  [ 0.424058985, 18 ],
  /* 6089 */  [ 0.424151861, 18 ],
  /* 6090 */  [ 0.424244742, 18 ],
  /* 6091 */  [ 0.424337628, 18 ],
  /* 6092 */  [ 0.424430519, 18 ],
  /* 6093 */  [ 0.424523415, 18 ],
  /* 6094 */  [ 0.424616316, 18 ],
  /* 6095 */  [ 0.424709222, 18 ],

  /* 6096 */  [ 0.424802133, 18 ],
  /* 6097 */  [ 0.424895050, 18 ],
  /* 6098 */  [ 0.424987971, 18 ],
  /* 6099 */  [ 0.425080898, 18 ],
  /* 6100 */  [ 0.425173829, 18 ],
  /* 6101 */  [ 0.425266766, 18 ],
  /* 6102 */  [ 0.425359708, 18 ],
  /* 6103 */  [ 0.425452655, 18 ],
  /* 6104 */  [ 0.425545607, 18 ],
  /* 6105 */  [ 0.425638564, 18 ],
  /* 6106 */  [ 0.425731526, 18 ],
  /* 6107 */  [ 0.425824493, 18 ],
  /* 6108 */  [ 0.425917465, 18 ],
  /* 6109 */  [ 0.426010443, 18 ],
  /* 6110 */  [ 0.426103425, 18 ],
  /* 6111 */  [ 0.426196412, 18 ],

  /* 6112 */  [ 0.426289405, 18 ],
  /* 6113 */  [ 0.426382403, 18 ],
  /* 6114 */  [ 0.426475405, 18 ],
  /* 6115 */  [ 0.426568413, 18 ],
  /* 6116 */  [ 0.426661426, 18 ],
  /* 6117 */  [ 0.426754444, 18 ],
  /* 6118 */  [ 0.426847467, 18 ],
  /* 6119 */  [ 0.426940495, 18 ],
  /* 6120 */  [ 0.427033528, 18 ],
  /* 6121 */  [ 0.427126566, 18 ],
  /* 6122 */  [ 0.427219609, 18 ],
  /* 6123 */  [ 0.427312657, 18 ],
  /* 6124 */  [ 0.427405711, 18 ],
  /* 6125 */  [ 0.427498769, 18 ],
  /* 6126 */  [ 0.427591833, 18 ],
  /* 6127 */  [ 0.427684901, 18 ],

  /* 6128 */  [ 0.427777975, 18 ],
  /* 6129 */  [ 0.427871054, 18 ],
  /* 6130 */  [ 0.427964137, 18 ],
  /* 6131 */  [ 0.428057226, 18 ],
  /* 6132 */  [ 0.428150320, 18 ],
  /* 6133 */  [ 0.428243419, 18 ],
  /* 6134 */  [ 0.428336523, 18 ],
  /* 6135 */  [ 0.428429632, 18 ],
  /* 6136 */  [ 0.428522746, 18 ],
  /* 6137 */  [ 0.428615865, 18 ],
  /* 6138 */  [ 0.428708989, 18 ],
  /* 6139 */  [ 0.428802119, 18 ],
  /* 6140 */  [ 0.428895253, 18 ],
  /* 6141 */  [ 0.428988392, 18 ],
  /* 6142 */  [ 0.429081537, 18 ],
  /* 6143 */  [ 0.429174686, 18 ],

  /* 6144 */  [ 0.429267841, 18 ],
  /* 6145 */  [ 0.429361001, 18 ],
  /* 6146 */  [ 0.429454165, 18 ],
  /* 6147 */  [ 0.429547335, 18 ],
  /* 6148 */  [ 0.429640510, 18 ],
  /* 6149 */  [ 0.429733690, 18 ],
  /* 6150 */  [ 0.429826874, 18 ],
  /* 6151 */  [ 0.429920064, 18 ],
  /* 6152 */  [ 0.430013259, 18 ],
  /* 6153 */  [ 0.430106459, 18 ],
  /* 6154 */  [ 0.430199664, 18 ],
  /* 6155 */  [ 0.430292875, 18 ],
  /* 6156 */  [ 0.430386090, 18 ],
  /* 6157 */  [ 0.430479310, 18 ],
  /* 6158 */  [ 0.430572535, 18 ],
  /* 6159 */  [ 0.430665765, 18 ],

  /* 6160 */  [ 0.430759001, 18 ],
  /* 6161 */  [ 0.430852241, 18 ],
  /* 6162 */  [ 0.430945487, 18 ],
  /* 6163 */  [ 0.431038737, 18 ],
  /* 6164 */  [ 0.431131993, 18 ],
  /* 6165 */  [ 0.431225253, 18 ],
  /* 6166 */  [ 0.431318519, 18 ],
  /* 6167 */  [ 0.431411790, 18 ],
  /* 6168 */  [ 0.431505065, 18 ],
  /* 6169 */  [ 0.431598346, 18 ],
  /* 6170 */  [ 0.431691632, 18 ],
  /* 6171 */  [ 0.431784923, 18 ],
  /* 6172 */  [ 0.431878218, 18 ],
  /* 6173 */  [ 0.431971519, 18 ],
  /* 6174 */  [ 0.432064825, 18 ],
  /* 6175 */  [ 0.432158136, 18 ],

  /* 6176 */  [ 0.432251452, 18 ],
  /* 6177 */  [ 0.432344773, 18 ],
  /* 6178 */  [ 0.432438099, 18 ],
  /* 6179 */  [ 0.432531431, 18 ],
  /* 6180 */  [ 0.432624767, 18 ],
  /* 6181 */  [ 0.432718108, 18 ],
  /* 6182 */  [ 0.432811454, 18 ],
  /* 6183 */  [ 0.432904805, 18 ],
  /* 6184 */  [ 0.432998162, 18 ],
  /* 6185 */  [ 0.433091523, 18 ],
  /* 6186 */  [ 0.433184889, 18 ],
  /* 6187 */  [ 0.433278261, 18 ],
  /* 6188 */  [ 0.433371637, 18 ],
  /* 6189 */  [ 0.433465019, 18 ],
  /* 6190 */  [ 0.433558405, 18 ],
  /* 6191 */  [ 0.433651797, 18 ],

  /* 6192 */  [ 0.433745193, 18 ],
  /* 6193 */  [ 0.433838595, 18 ],
  /* 6194 */  [ 0.433932001, 18 ],
  /* 6195 */  [ 0.434025413, 18 ],
  /* 6196 */  [ 0.434118830, 18 ],
  /* 6197 */  [ 0.434212251, 18 ],
  /* 6198 */  [ 0.434305678, 18 ],
  /* 6199 */  [ 0.434399110, 18 ],
  /* 6200 */  [ 0.434492546, 18 ],
  /* 6201 */  [ 0.434585988, 18 ],
  /* 6202 */  [ 0.434679435, 18 ],
  /* 6203 */  [ 0.434772887, 18 ],
  /* 6204 */  [ 0.434866344, 18 ],
  /* 6205 */  [ 0.434959806, 18 ],
  /* 6206 */  [ 0.435053272, 18 ],
  /* 6207 */  [ 0.435146744, 18 ],

  /* 6208 */  [ 0.435240221, 18 ],
  /* 6209 */  [ 0.435333703, 18 ],
  /* 6210 */  [ 0.435427190, 18 ],
  /* 6211 */  [ 0.435520682, 18 ],
  /* 6212 */  [ 0.435614179, 18 ],
  /* 6213 */  [ 0.435707681, 18 ],
  /* 6214 */  [ 0.435801188, 18 ],
  /* 6215 */  [ 0.435894700, 18 ],
  /* 6216 */  [ 0.435988217, 18 ],
  /* 6217 */  [ 0.436081739, 18 ],
  /* 6218 */  [ 0.436175266, 18 ],
  /* 6219 */  [ 0.436268799, 18 ],
  /* 6220 */  [ 0.436362336, 18 ],
  /* 6221 */  [ 0.436455878, 18 ],
  /* 6222 */  [ 0.436549425, 18 ],
  /* 6223 */  [ 0.436642977, 18 ],

  /* 6224 */  [ 0.436736534, 18 ],
  /* 6225 */  [ 0.436830096, 18 ],
  /* 6226 */  [ 0.436923664, 18 ],
  /* 6227 */  [ 0.437017236, 18 ],
  /* 6228 */  [ 0.437110813, 18 ],
  /* 6229 */  [ 0.437204395, 18 ],
  /* 6230 */  [ 0.437297982, 18 ],
  /* 6231 */  [ 0.437391575, 18 ],
  /* 6232 */  [ 0.437485172, 18 ],
  /* 6233 */  [ 0.437578774, 18 ],
  /* 6234 */  [ 0.437672381, 18 ],
  /* 6235 */  [ 0.437765994, 18 ],
  /* 6236 */  [ 0.437859611, 18 ],
  /* 6237 */  [ 0.437953233, 18 ],
  /* 6238 */  [ 0.438046860, 18 ],
  /* 6239 */  [ 0.438140493, 18 ],

  /* 6240 */  [ 0.438234130, 18 ],
  /* 6241 */  [ 0.438327772, 18 ],
  /* 6242 */  [ 0.438421419, 18 ],
  /* 6243 */  [ 0.438515072, 18 ],
  /* 6244 */  [ 0.438608729, 18 ],
  /* 6245 */  [ 0.438702391, 18 ],
  /* 6246 */  [ 0.438796059, 18 ],
  /* 6247 */  [ 0.438889731, 18 ],
  /* 6248 */  [ 0.438983408, 18 ],
  /* 6249 */  [ 0.439077090, 18 ],
  /* 6250 */  [ 0.439170778, 18 ],
  /* 6251 */  [ 0.439264470, 18 ],
  /* 6252 */  [ 0.439358167, 18 ],
  /* 6253 */  [ 0.439451869, 18 ],
  /* 6254 */  [ 0.439545577, 18 ],
  /* 6255 */  [ 0.439639289, 18 ],

  /* 6256 */  [ 0.439733006, 18 ],
  /* 6257 */  [ 0.439826728, 18 ],
  /* 6258 */  [ 0.439920456, 18 ],
  /* 6259 */  [ 0.440014188, 18 ],
  /* 6260 */  [ 0.440107925, 18 ],
  /* 6261 */  [ 0.440201667, 18 ],
  /* 6262 */  [ 0.440295414, 18 ],
  /* 6263 */  [ 0.440389167, 18 ],
  /* 6264 */  [ 0.440482924, 18 ],
  /* 6265 */  [ 0.440576686, 18 ],
  /* 6266 */  [ 0.440670453, 18 ],
  /* 6267 */  [ 0.440764225, 18 ],
  /* 6268 */  [ 0.440858002, 18 ],
  /* 6269 */  [ 0.440951784, 18 ],
  /* 6270 */  [ 0.441045572, 18 ],
  /* 6271 */  [ 0.441139364, 18 ],

  /* 6272 */  [ 0.441233161, 18 ],
  /* 6273 */  [ 0.441326963, 18 ],
  /* 6274 */  [ 0.441420770, 18 ],
  /* 6275 */  [ 0.441514582, 18 ],
  /* 6276 */  [ 0.441608399, 18 ],
  /* 6277 */  [ 0.441702221, 18 ],
  /* 6278 */  [ 0.441796048, 18 ],
  /* 6279 */  [ 0.441889880, 18 ],
  /* 6280 */  [ 0.441983717, 18 ],
  /* 6281 */  [ 0.442077559, 18 ],
  /* 6282 */  [ 0.442171406, 18 ],
  /* 6283 */  [ 0.442265257, 18 ],
  /* 6284 */  [ 0.442359114, 18 ],
  /* 6285 */  [ 0.442452976, 18 ],
  /* 6286 */  [ 0.442546843, 18 ],
  /* 6287 */  [ 0.442640715, 18 ],

  /* 6288 */  [ 0.442734592, 18 ],
  /* 6289 */  [ 0.442828473, 18 ],
  /* 6290 */  [ 0.442922360, 18 ],
  /* 6291 */  [ 0.443016252, 18 ],
  /* 6292 */  [ 0.443110148, 18 ],
  /* 6293 */  [ 0.443204050, 18 ],
  /* 6294 */  [ 0.443297957, 18 ],
  /* 6295 */  [ 0.443391868, 18 ],
  /* 6296 */  [ 0.443485785, 18 ],
  /* 6297 */  [ 0.443579706, 18 ],
  /* 6298 */  [ 0.443673633, 18 ],
  /* 6299 */  [ 0.443767564, 18 ],
  /* 6300 */  [ 0.443861501, 18 ],
  /* 6301 */  [ 0.443955442, 18 ],
  /* 6302 */  [ 0.444049389, 18 ],
  /* 6303 */  [ 0.444143340, 18 ],

  /* 6304 */  [ 0.444237296, 18 ],
  /* 6305 */  [ 0.444331258, 18 ],
  /* 6306 */  [ 0.444425224, 18 ],
  /* 6307 */  [ 0.444519195, 18 ],
  /* 6308 */  [ 0.444613171, 18 ],
  /* 6309 */  [ 0.444707153, 18 ],
  /* 6310 */  [ 0.444801139, 18 ],
  /* 6311 */  [ 0.444895130, 18 ],
  /* 6312 */  [ 0.444989126, 18 ],
  /* 6313 */  [ 0.445083127, 18 ],
  /* 6314 */  [ 0.445177133, 18 ],
  /* 6315 */  [ 0.445271144, 18 ],
  /* 6316 */  [ 0.445365160, 18 ],
  /* 6317 */  [ 0.445459181, 18 ],
  /* 6318 */  [ 0.445553206, 18 ],
  /* 6319 */  [ 0.445647237, 18 ],

  /* 6320 */  [ 0.445741273, 18 ],
  /* 6321 */  [ 0.445835314, 18 ],
  /* 6322 */  [ 0.445929359, 18 ],
  /* 6323 */  [ 0.446023410, 18 ],
  /* 6324 */  [ 0.446117466, 18 ],
  /* 6325 */  [ 0.446211526, 18 ],
  /* 6326 */  [ 0.446305592, 18 ],
  /* 6327 */  [ 0.446399662, 18 ],
  /* 6328 */  [ 0.446493738, 18 ],
  /* 6329 */  [ 0.446587818, 18 ],
  /* 6330 */  [ 0.446681903, 18 ],
  /* 6331 */  [ 0.446775994, 18 ],
  /* 6332 */  [ 0.446870089, 18 ],
  /* 6333 */  [ 0.446964189, 18 ],
  /* 6334 */  [ 0.447058294, 18 ],
  /* 6335 */  [ 0.447152404, 18 ],

  /* 6336 */  [ 0.447246519, 18 ],
  /* 6337 */  [ 0.447340639, 18 ],
  /* 6338 */  [ 0.447434764, 18 ],
  /* 6339 */  [ 0.447528894, 18 ],
  /* 6340 */  [ 0.447623029, 18 ],
  /* 6341 */  [ 0.447717169, 18 ],
  /* 6342 */  [ 0.447811314, 18 ],
  /* 6343 */  [ 0.447905463, 18 ],
  /* 6344 */  [ 0.447999618, 18 ],
  /* 6345 */  [ 0.448093778, 18 ],
  /* 6346 */  [ 0.448187942, 18 ],
  /* 6347 */  [ 0.448282112, 18 ],
  /* 6348 */  [ 0.448376286, 18 ],
  /* 6349 */  [ 0.448470466, 18 ],
  /* 6350 */  [ 0.448564650, 18 ],
  /* 6351 */  [ 0.448658839, 18 ],

  /* 6352 */  [ 0.448753033, 18 ],
  /* 6353 */  [ 0.448847233, 18 ],
  /* 6354 */  [ 0.448941437, 18 ],
  /* 6355 */  [ 0.449035646, 18 ],
  /* 6356 */  [ 0.449129860, 18 ],
  /* 6357 */  [ 0.449224079, 18 ],
  /* 6358 */  [ 0.449318303, 18 ],
  /* 6359 */  [ 0.449412531, 18 ],
  /* 6360 */  [ 0.449506765, 18 ],
  /* 6361 */  [ 0.449601004, 18 ],
  /* 6362 */  [ 0.449695247, 18 ],
  /* 6363 */  [ 0.449789496, 18 ],
  /* 6364 */  [ 0.449883749, 18 ],
  /* 6365 */  [ 0.449978008, 18 ],
  /* 6366 */  [ 0.450072271, 18 ],
  /* 6367 */  [ 0.450166540, 18 ],

  /* 6368 */  [ 0.450260813, 18 ],
  /* 6369 */  [ 0.450355091, 18 ],
  /* 6370 */  [ 0.450449374, 18 ],
  /* 6371 */  [ 0.450543662, 18 ],
  /* 6372 */  [ 0.450637955, 18 ],
  /* 6373 */  [ 0.450732253, 18 ],
  /* 6374 */  [ 0.450826556, 18 ],
  /* 6375 */  [ 0.450920864, 18 ],
  /* 6376 */  [ 0.451015176, 18 ],
  /* 6377 */  [ 0.451109494, 18 ],
  /* 6378 */  [ 0.451203817, 18 ],
  /* 6379 */  [ 0.451298144, 18 ],
  /* 6380 */  [ 0.451392477, 18 ],
  /* 6381 */  [ 0.451486814, 18 ],
  /* 6382 */  [ 0.451581156, 18 ],
  /* 6383 */  [ 0.451675503, 18 ],

  /* 6384 */  [ 0.451769856, 18 ],
  /* 6385 */  [ 0.451864213, 18 ],
  /* 6386 */  [ 0.451958575, 18 ],
  /* 6387 */  [ 0.452052942, 18 ],
  /* 6388 */  [ 0.452147313, 18 ],
  /* 6389 */  [ 0.452241690, 18 ],
  /* 6390 */  [ 0.452336072, 18 ],
  /* 6391 */  [ 0.452430458, 18 ],
  /* 6392 */  [ 0.452524850, 18 ],
  /* 6393 */  [ 0.452619246, 18 ],
  /* 6394 */  [ 0.452713648, 18 ],
  /* 6395 */  [ 0.452808054, 18 ],
  /* 6396 */  [ 0.452902465, 18 ],
  /* 6397 */  [ 0.452996882, 18 ],
  /* 6398 */  [ 0.453091303, 18 ],
  /* 6399 */  [ 0.453185729, 18 ],

  /* 6400 */  [ 0.453280160, 18 ],
  /* 6401 */  [ 0.453374595, 18 ],
  /* 6402 */  [ 0.453469036, 18 ],
  /* 6403 */  [ 0.453563482, 18 ],
  /* 6404 */  [ 0.453657932, 18 ],
  /* 6405 */  [ 0.453752388, 18 ],
  /* 6406 */  [ 0.453846848, 18 ],
  /* 6407 */  [ 0.453941314, 18 ],
  /* 6408 */  [ 0.454035784, 18 ],
  /* 6409 */  [ 0.454130259, 18 ],
  /* 6410 */  [ 0.454224739, 18 ],
  /* 6411 */  [ 0.454319224, 18 ],
  /* 6412 */  [ 0.454413714, 18 ],
  /* 6413 */  [ 0.454508209, 18 ],
  /* 6414 */  [ 0.454602708, 18 ],
  /* 6415 */  [ 0.454697213, 18 ],

  /* 6416 */  [ 0.454791723, 18 ],
  /* 6417 */  [ 0.454886237, 18 ],
  /* 6418 */  [ 0.454980756, 18 ],
  /* 6419 */  [ 0.455075281, 18 ],
  /* 6420 */  [ 0.455169810, 18 ],
  /* 6421 */  [ 0.455264344, 18 ],
  /* 6422 */  [ 0.455358883, 18 ],
  /* 6423 */  [ 0.455453427, 18 ],
  /* 6424 */  [ 0.455547976, 18 ],
  /* 6425 */  [ 0.455642529, 18 ],
  /* 6426 */  [ 0.455737088, 18 ],
  /* 6427 */  [ 0.455831652, 18 ],
  /* 6428 */  [ 0.455926220, 18 ],
  /* 6429 */  [ 0.456020793, 18 ],
  /* 6430 */  [ 0.456115372, 18 ],
  /* 6431 */  [ 0.456209955, 18 ],

  /* 6432 */  [ 0.456304543, 18 ],
  /* 6433 */  [ 0.456399136, 18 ],
  /* 6434 */  [ 0.456493733, 18 ],
  /* 6435 */  [ 0.456588336, 18 ],
  /* 6436 */  [ 0.456682944, 18 ],
  /* 6437 */  [ 0.456777556, 18 ],
  /* 6438 */  [ 0.456872174, 18 ],
  /* 6439 */  [ 0.456966796, 18 ],
  /* 6440 */  [ 0.457061423, 18 ],
  /* 6441 */  [ 0.457156056, 18 ],
  /* 6442 */  [ 0.457250693, 18 ],
  /* 6443 */  [ 0.457345335, 18 ],
  /* 6444 */  [ 0.457439981, 18 ],
  /* 6445 */  [ 0.457534633, 18 ],
  /* 6446 */  [ 0.457629290, 18 ],
  /* 6447 */  [ 0.457723951, 18 ],

  /* 6448 */  [ 0.457818618, 18 ],
  /* 6449 */  [ 0.457913289, 18 ],
  /* 6450 */  [ 0.458007965, 18 ],
  /* 6451 */  [ 0.458102646, 18 ],
  /* 6452 */  [ 0.458197332, 18 ],
  /* 6453 */  [ 0.458292023, 18 ],
  /* 6454 */  [ 0.458386719, 18 ],
  /* 6455 */  [ 0.458481420, 18 ],
  /* 6456 */  [ 0.458576125, 18 ],
  /* 6457 */  [ 0.458670836, 18 ],
  /* 6458 */  [ 0.458765551, 18 ],
  /* 6459 */  [ 0.458860271, 18 ],
  /* 6460 */  [ 0.458954996, 18 ],
  /* 6461 */  [ 0.459049726, 18 ],
  /* 6462 */  [ 0.459144461, 18 ],
  /* 6463 */  [ 0.459239201, 18 ],

  /* 6464 */  [ 0.459333946, 18 ],
  /* 6465 */  [ 0.459428695, 18 ],
  /* 6466 */  [ 0.459523450, 18 ],
  /* 6467 */  [ 0.459618209, 18 ],
  /* 6468 */  [ 0.459712973, 18 ],
  /* 6469 */  [ 0.459807742, 18 ],
  /* 6470 */  [ 0.459902516, 18 ],
  /* 6471 */  [ 0.459997295, 18 ],
  /* 6472 */  [ 0.460092079, 18 ],
  /* 6473 */  [ 0.460186867, 18 ],
  /* 6474 */  [ 0.460281661, 18 ],
  /* 6475 */  [ 0.460376459, 18 ],
  /* 6476 */  [ 0.460471262, 18 ],
  /* 6477 */  [ 0.460566071, 18 ],
  /* 6478 */  [ 0.460660884, 18 ],
  /* 6479 */  [ 0.460755701, 18 ],

  /* 6480 */  [ 0.460850524, 18 ],
  /* 6481 */  [ 0.460945352, 18 ],
  /* 6482 */  [ 0.461040184, 18 ],
  /* 6483 */  [ 0.461135022, 18 ],
  /* 6484 */  [ 0.461229864, 18 ],
  /* 6485 */  [ 0.461324711, 18 ],
  /* 6486 */  [ 0.461419563, 18 ],
  /* 6487 */  [ 0.461514420, 18 ],
  /* 6488 */  [ 0.461609282, 18 ],
  /* 6489 */  [ 0.461704149, 18 ],
  /* 6490 */  [ 0.461799020, 18 ],
  /* 6491 */  [ 0.461893897, 18 ],
  /* 6492 */  [ 0.461988778, 18 ],
  /* 6493 */  [ 0.462083664, 18 ],
  /* 6494 */  [ 0.462178555, 18 ],
  /* 6495 */  [ 0.462273451, 18 ],

  /* 6496 */  [ 0.462368352, 18 ],
  /* 6497 */  [ 0.462463257, 18 ],
  /* 6498 */  [ 0.462558168, 18 ],
  /* 6499 */  [ 0.462653083, 18 ],
  /* 6500 */  [ 0.462748003, 18 ],
  /* 6501 */  [ 0.462842928, 18 ],
  /* 6502 */  [ 0.462937858, 18 ],
  /* 6503 */  [ 0.463032793, 18 ],
  /* 6504 */  [ 0.463127733, 18 ],
  /* 6505 */  [ 0.463222678, 18 ],
  /* 6506 */  [ 0.463317627, 18 ],
  /* 6507 */  [ 0.463412581, 18 ],
  /* 6508 */  [ 0.463507540, 18 ],
  /* 6509 */  [ 0.463602504, 18 ],
  /* 6510 */  [ 0.463697473, 18 ],
  /* 6511 */  [ 0.463792447, 18 ],

  /* 6512 */  [ 0.463887426, 18 ],
  /* 6513 */  [ 0.463982409, 18 ],
  /* 6514 */  [ 0.464077398, 18 ],
  /* 6515 */  [ 0.464172391, 18 ],
  /* 6516 */  [ 0.464267389, 18 ],
  /* 6517 */  [ 0.464362392, 18 ],
  /* 6518 */  [ 0.464457399, 18 ],
  /* 6519 */  [ 0.464552412, 18 ],
  /* 6520 */  [ 0.464647430, 18 ],
  /* 6521 */  [ 0.464742452, 18 ],
  /* 6522 */  [ 0.464837479, 18 ],
  /* 6523 */  [ 0.464932511, 18 ],
  /* 6524 */  [ 0.465027548, 18 ],
  /* 6525 */  [ 0.465122590, 18 ],
  /* 6526 */  [ 0.465217637, 18 ],
  /* 6527 */  [ 0.465312688, 18 ],

  /* 6528 */  [ 0.465407744, 18 ],
  /* 6529 */  [ 0.465502806, 18 ],
  /* 6530 */  [ 0.465597872, 18 ],
  /* 6531 */  [ 0.465692943, 18 ],
  /* 6532 */  [ 0.465788018, 18 ],
  /* 6533 */  [ 0.465883099, 18 ],
  /* 6534 */  [ 0.465978184, 18 ],
  /* 6535 */  [ 0.466073275, 18 ],
  /* 6536 */  [ 0.466168370, 18 ],
  /* 6537 */  [ 0.466263470, 18 ],
  /* 6538 */  [ 0.466358575, 18 ],
  /* 6539 */  [ 0.466453684, 18 ],
  /* 6540 */  [ 0.466548799, 18 ],
  /* 6541 */  [ 0.466643918, 18 ],
  /* 6542 */  [ 0.466739043, 18 ],
  /* 6543 */  [ 0.466834172, 18 ],

  /* 6544 */  [ 0.466929306, 18 ],
  /* 6545 */  [ 0.467024445, 18 ],
  /* 6546 */  [ 0.467119588, 18 ],
  /* 6547 */  [ 0.467214737, 18 ],
  /* 6548 */  [ 0.467309890, 18 ],
  /* 6549 */  [ 0.467405048, 18 ],
  /* 6550 */  [ 0.467500211, 18 ],
  /* 6551 */  [ 0.467595379, 18 ],
  /* 6552 */  [ 0.467690552, 18 ],
  /* 6553 */  [ 0.467785729, 18 ],
  /* 6554 */  [ 0.467880912, 18 ],
  /* 6555 */  [ 0.467976099, 18 ],
  /* 6556 */  [ 0.468071291, 18 ],
  /* 6557 */  [ 0.468166488, 18 ],
  /* 6558 */  [ 0.468261690, 18 ],
  /* 6559 */  [ 0.468356896, 18 ],

  /* 6560 */  [ 0.468452108, 18 ],
  /* 6561 */  [ 0.468547324, 18 ],
  /* 6562 */  [ 0.468642545, 18 ],
  /* 6563 */  [ 0.468737771, 18 ],
  /* 6564 */  [ 0.468833002, 18 ],
  /* 6565 */  [ 0.468928237, 18 ],
  /* 6566 */  [ 0.469023478, 18 ],
  /* 6567 */  [ 0.469118723, 18 ],
  /* 6568 */  [ 0.469213973, 18 ],
  /* 6569 */  [ 0.469309228, 18 ],
  /* 6570 */  [ 0.469404488, 18 ],
  /* 6571 */  [ 0.469499752, 18 ],
  /* 6572 */  [ 0.469595022, 18 ],
  /* 6573 */  [ 0.469690296, 18 ],
  /* 6574 */  [ 0.469785575, 18 ],
  /* 6575 */  [ 0.469880859, 18 ],

  /* 6576 */  [ 0.469976148, 18 ],
  /* 6577 */  [ 0.470071442, 18 ],
  /* 6578 */  [ 0.470166740, 18 ],
  /* 6579 */  [ 0.470262043, 18 ],
  /* 6580 */  [ 0.470357351, 18 ],
  /* 6581 */  [ 0.470452664, 18 ],
  /* 6582 */  [ 0.470547982, 18 ],
  /* 6583 */  [ 0.470643305, 18 ],
  /* 6584 */  [ 0.470738632, 18 ],
  /* 6585 */  [ 0.470833964, 18 ],
  /* 6586 */  [ 0.470929301, 18 ],
  /* 6587 */  [ 0.471024643, 18 ],
  /* 6588 */  [ 0.471119990, 18 ],
  /* 6589 */  [ 0.471215341, 18 ],
  /* 6590 */  [ 0.471310698, 18 ],
  /* 6591 */  [ 0.471406059, 18 ],

  /* 6592 */  [ 0.471501425, 18 ],
  /* 6593 */  [ 0.471596796, 18 ],
  /* 6594 */  [ 0.471692171, 18 ],
  /* 6595 */  [ 0.471787552, 18 ],
  /* 6596 */  [ 0.471882937, 18 ],
  /* 6597 */  [ 0.471978327, 18 ],
  /* 6598 */  [ 0.472073722, 18 ],
  /* 6599 */  [ 0.472169122, 18 ],
  /* 6600 */  [ 0.472264527, 18 ],
  /* 6601 */  [ 0.472359936, 18 ],
  /* 6602 */  [ 0.472455350, 18 ],
  /* 6603 */  [ 0.472550769, 18 ],
  /* 6604 */  [ 0.472646193, 18 ],
  /* 6605 */  [ 0.472741622, 18 ],
  /* 6606 */  [ 0.472837055, 18 ],
  /* 6607 */  [ 0.472932493, 18 ],

  /* 6608 */  [ 0.473027937, 18 ],
  /* 6609 */  [ 0.473123384, 18 ],
  /* 6610 */  [ 0.473218837, 18 ],
  /* 6611 */  [ 0.473314295, 18 ],
  /* 6612 */  [ 0.473409757, 18 ],
  /* 6613 */  [ 0.473505224, 18 ],
  /* 6614 */  [ 0.473600696, 18 ],
  /* 6615 */  [ 0.473696173, 18 ],
  /* 6616 */  [ 0.473791655, 18 ],
  /* 6617 */  [ 0.473887141, 18 ],
  /* 6618 */  [ 0.473982632, 18 ],
  /* 6619 */  [ 0.474078128, 18 ],
  /* 6620 */  [ 0.474173629, 18 ],
  /* 6621 */  [ 0.474269135, 18 ],
  /* 6622 */  [ 0.474364645, 18 ],
  /* 6623 */  [ 0.474460161, 18 ],

  /* 6624 */  [ 0.474555681, 18 ],
  /* 6625 */  [ 0.474651205, 18 ],
  /* 6626 */  [ 0.474746735, 18 ],
  /* 6627 */  [ 0.474842270, 18 ],
  /* 6628 */  [ 0.474937809, 18 ],
  /* 6629 */  [ 0.475033353, 18 ],
  /* 6630 */  [ 0.475128902, 18 ],
  /* 6631 */  [ 0.475224456, 18 ],
  /* 6632 */  [ 0.475320014, 18 ],
  /* 6633 */  [ 0.475415578, 18 ],
  /* 6634 */  [ 0.475511146, 18 ],
  /* 6635 */  [ 0.475606719, 18 ],
  /* 6636 */  [ 0.475702296, 18 ],
  /* 6637 */  [ 0.475797879, 18 ],
  /* 6638 */  [ 0.475893466, 18 ],
  /* 6639 */  [ 0.475989058, 18 ],

  /* 6640 */  [ 0.476084655, 18 ],
  /* 6641 */  [ 0.476180257, 18 ],
  /* 6642 */  [ 0.476275863, 18 ],
  /* 6643 */  [ 0.476371475, 18 ],
  /* 6644 */  [ 0.476467091, 18 ],
  /* 6645 */  [ 0.476562712, 18 ],
  /* 6646 */  [ 0.476658338, 18 ],
  /* 6647 */  [ 0.476753968, 18 ],
  /* 6648 */  [ 0.476849603, 18 ],
  /* 6649 */  [ 0.476945243, 18 ],
  /* 6650 */  [ 0.477040888, 18 ],
  /* 6651 */  [ 0.477136538, 18 ],
  /* 6652 */  [ 0.477232193, 18 ],
  /* 6653 */  [ 0.477327852, 18 ],
  /* 6654 */  [ 0.477423516, 18 ],
  /* 6655 */  [ 0.477519185, 18 ],

  /* 6656 */  [ 0.477614858, 18 ],
  /* 6657 */  [ 0.477710537, 18 ],
  /* 6658 */  [ 0.477806220, 18 ],
  /* 6659 */  [ 0.477901908, 18 ],
  /* 6660 */  [ 0.477997601, 18 ],
  /* 6661 */  [ 0.478093299, 18 ],
  /* 6662 */  [ 0.478189001, 18 ],
  /* 6663 */  [ 0.478284708, 18 ],
  /* 6664 */  [ 0.478380420, 18 ],
  /* 6665 */  [ 0.478476137, 18 ],
  /* 6666 */  [ 0.478571858, 18 ],
  /* 6667 */  [ 0.478667585, 18 ],
  /* 6668 */  [ 0.478763316, 18 ],
  /* 6669 */  [ 0.478859052, 18 ],
  /* 6670 */  [ 0.478954793, 18 ],
  /* 6671 */  [ 0.479050538, 18 ],

  /* 6672 */  [ 0.479146288, 18 ],
  /* 6673 */  [ 0.479242043, 18 ],
  /* 6674 */  [ 0.479337803, 18 ],
  /* 6675 */  [ 0.479433568, 18 ],
  /* 6676 */  [ 0.479529337, 18 ],
  /* 6677 */  [ 0.479625111, 18 ],
  /* 6678 */  [ 0.479720890, 18 ],
  /* 6679 */  [ 0.479816674, 18 ],
  /* 6680 */  [ 0.479912463, 18 ],
  /* 6681 */  [ 0.480008256, 18 ],
  /* 6682 */  [ 0.480104054, 18 ],
  /* 6683 */  [ 0.480199857, 18 ],
  /* 6684 */  [ 0.480295664, 18 ],
  /* 6685 */  [ 0.480391477, 18 ],
  /* 6686 */  [ 0.480487294, 18 ],
  /* 6687 */  [ 0.480583116, 18 ],

  /* 6688 */  [ 0.480678943, 18 ],
  /* 6689 */  [ 0.480774774, 18 ],
  /* 6690 */  [ 0.480870611, 18 ],
  /* 6691 */  [ 0.480966452, 18 ],
  /* 6692 */  [ 0.481062298, 18 ],
  /* 6693 */  [ 0.481158148, 18 ],
  /* 6694 */  [ 0.481254004, 18 ],
  /* 6695 */  [ 0.481349864, 18 ],
  /* 6696 */  [ 0.481445729, 18 ],
  /* 6697 */  [ 0.481541598, 18 ],
  /* 6698 */  [ 0.481637473, 18 ],
  /* 6699 */  [ 0.481733352, 18 ],
  /* 6700 */  [ 0.481829236, 18 ],
  /* 6701 */  [ 0.481925125, 18 ],
  /* 6702 */  [ 0.482021019, 18 ],
  /* 6703 */  [ 0.482116917, 18 ],

  /* 6704 */  [ 0.482212820, 18 ],
  /* 6705 */  [ 0.482308728, 18 ],
  /* 6706 */  [ 0.482404640, 18 ],
  /* 6707 */  [ 0.482500558, 18 ],
  /* 6708 */  [ 0.482596480, 18 ],
  /* 6709 */  [ 0.482692407, 18 ],
  /* 6710 */  [ 0.482788339, 18 ],
  /* 6711 */  [ 0.482884275, 18 ],
  /* 6712 */  [ 0.482980216, 18 ],
  /* 6713 */  [ 0.483076162, 18 ],
  /* 6714 */  [ 0.483172113, 18 ],
  /* 6715 */  [ 0.483268069, 18 ],
  /* 6716 */  [ 0.483364029, 18 ],
  /* 6717 */  [ 0.483459994, 18 ],
  /* 6718 */  [ 0.483555964, 18 ],
  /* 6719 */  [ 0.483651939, 18 ],

  /* 6720 */  [ 0.483747918, 18 ],
  /* 6721 */  [ 0.483843902, 18 ],
  /* 6722 */  [ 0.483939891, 18 ],
  /* 6723 */  [ 0.484035885, 18 ],
  /* 6724 */  [ 0.484131883, 18 ],
  /* 6725 */  [ 0.484227886, 18 ],
  /* 6726 */  [ 0.484323894, 18 ],
  /* 6727 */  [ 0.484419907, 18 ],
  /* 6728 */  [ 0.484515924, 18 ],
  /* 6729 */  [ 0.484611946, 18 ],
  /* 6730 */  [ 0.484707973, 18 ],
  /* 6731 */  [ 0.484804005, 18 ],
  /* 6732 */  [ 0.484900041, 18 ],
  /* 6733 */  [ 0.484996083, 18 ],
  /* 6734 */  [ 0.485092128, 18 ],
  /* 6735 */  [ 0.485188179, 18 ],

  /* 6736 */  [ 0.485284235, 18 ],
  /* 6737 */  [ 0.485380295, 18 ],
  /* 6738 */  [ 0.485476360, 18 ],
  /* 6739 */  [ 0.485572430, 18 ],
  /* 6740 */  [ 0.485668504, 18 ],
  /* 6741 */  [ 0.485764583, 18 ],
  /* 6742 */  [ 0.485860667, 18 ],
  /* 6743 */  [ 0.485956756, 18 ],
  /* 6744 */  [ 0.486052849, 18 ],
  /* 6745 */  [ 0.486148948, 18 ],
  /* 6746 */  [ 0.486245051, 18 ],
  /* 6747 */  [ 0.486341158, 18 ],
  /* 6748 */  [ 0.486437271, 18 ],
  /* 6749 */  [ 0.486533388, 18 ],
  /* 6750 */  [ 0.486629510, 18 ],
  /* 6751 */  [ 0.486725637, 18 ],

  /* 6752 */  [ 0.486821768, 18 ],
  /* 6753 */  [ 0.486917905, 18 ],
  /* 6754 */  [ 0.487014045, 18 ],
  /* 6755 */  [ 0.487110191, 18 ],
  /* 6756 */  [ 0.487206342, 18 ],
  /* 6757 */  [ 0.487302497, 18 ],
  /* 6758 */  [ 0.487398657, 18 ],
  /* 6759 */  [ 0.487494821, 18 ],
  /* 6760 */  [ 0.487590991, 18 ],
  /* 6761 */  [ 0.487687165, 18 ],
  /* 6762 */  [ 0.487783344, 18 ],
  /* 6763 */  [ 0.487879528, 18 ],
  /* 6764 */  [ 0.487975716, 18 ],
  /* 6765 */  [ 0.488071909, 18 ],
  /* 6766 */  [ 0.488168107, 18 ],
  /* 6767 */  [ 0.488264310, 18 ],

  /* 6768 */  [ 0.488360517, 18 ],
  /* 6769 */  [ 0.488456729, 18 ],
  /* 6770 */  [ 0.488552946, 18 ],
  /* 6771 */  [ 0.488649167, 18 ],
  /* 6772 */  [ 0.488745394, 18 ],
  /* 6773 */  [ 0.488841625, 18 ],
  /* 6774 */  [ 0.488937860, 18 ],
  /* 6775 */  [ 0.489034101, 18 ],
  /* 6776 */  [ 0.489130346, 18 ],
  /* 6777 */  [ 0.489226596, 18 ],
  /* 6778 */  [ 0.489322851, 18 ],
  /* 6779 */  [ 0.489419110, 18 ],
  /* 6780 */  [ 0.489515375, 18 ],
  /* 6781 */  [ 0.489611643, 18 ],
  /* 6782 */  [ 0.489707917, 18 ],
  /* 6783 */  [ 0.489804195, 18 ],

  /* 6784 */  [ 0.489900479, 18 ],
  /* 6785 */  [ 0.489996766, 18 ],
  /* 6786 */  [ 0.490093059, 18 ],
  /* 6787 */  [ 0.490189356, 18 ],
  /* 6788 */  [ 0.490285658, 18 ],
  /* 6789 */  [ 0.490381965, 18 ],
  /* 6790 */  [ 0.490478277, 18 ],
  /* 6791 */  [ 0.490574593, 18 ],
  /* 6792 */  [ 0.490670914, 18 ],
  /* 6793 */  [ 0.490767239, 18 ],
  /* 6794 */  [ 0.490863570, 18 ],
  /* 6795 */  [ 0.490959905, 18 ],
  /* 6796 */  [ 0.491056245, 18 ],
  /* 6797 */  [ 0.491152589, 18 ],
  /* 6798 */  [ 0.491248939, 18 ],
  /* 6799 */  [ 0.491345293, 18 ],

  /* 6800 */  [ 0.491441651, 18 ],
  /* 6801 */  [ 0.491538015, 18 ],
  /* 6802 */  [ 0.491634383, 18 ],
  /* 6803 */  [ 0.491730756, 18 ],
  /* 6804 */  [ 0.491827134, 18 ],
  /* 6805 */  [ 0.491923516, 18 ],
  /* 6806 */  [ 0.492019903, 18 ],
  /* 6807 */  [ 0.492116295, 18 ],
  /* 6808 */  [ 0.492212691, 18 ],
  /* 6809 */  [ 0.492309093, 18 ],
  /* 6810 */  [ 0.492405499, 18 ],
  /* 6811 */  [ 0.492501909, 18 ],
  /* 6812 */  [ 0.492598325, 18 ],
  /* 6813 */  [ 0.492694745, 18 ],
  /* 6814 */  [ 0.492791170, 18 ],
  /* 6815 */  [ 0.492887599, 18 ],

  /* 6816 */  [ 0.492984033, 18 ],
  /* 6817 */  [ 0.493080472, 18 ],
  /* 6818 */  [ 0.493176916, 18 ],
  /* 6819 */  [ 0.493273365, 18 ],
  /* 6820 */  [ 0.493369818, 18 ],
  /* 6821 */  [ 0.493466275, 18 ],
  /* 6822 */  [ 0.493562738, 18 ],
  /* 6823 */  [ 0.493659205, 18 ],
  /* 6824 */  [ 0.493755677, 18 ],
  /* 6825 */  [ 0.493852154, 18 ],
  /* 6826 */  [ 0.493948635, 18 ],
  /* 6827 */  [ 0.494045122, 18 ],
  /* 6828 */  [ 0.494141612, 18 ],
  /* 6829 */  [ 0.494238108, 18 ],
  /* 6830 */  [ 0.494334608, 18 ],
  /* 6831 */  [ 0.494431113, 18 ],

  /* 6832 */  [ 0.494527623, 18 ],
  /* 6833 */  [ 0.494624137, 18 ],
  /* 6834 */  [ 0.494720656, 18 ],
  /* 6835 */  [ 0.494817180, 18 ],
  /* 6836 */  [ 0.494913709, 18 ],
  /* 6837 */  [ 0.495010242, 18 ],
  /* 6838 */  [ 0.495106780, 18 ],
  /* 6839 */  [ 0.495203322, 18 ],
  /* 6840 */  [ 0.495299870, 18 ],
  /* 6841 */  [ 0.495396422, 18 ],
  /* 6842 */  [ 0.495492978, 18 ],
  /* 6843 */  [ 0.495589540, 18 ],
  /* 6844 */  [ 0.495686106, 18 ],
  /* 6845 */  [ 0.495782677, 18 ],
  /* 6846 */  [ 0.495879252, 18 ],
  /* 6847 */  [ 0.495975833, 18 ],

  /* 6848 */  [ 0.496072418, 18 ],
  /* 6849 */  [ 0.496169007, 18 ],
  /* 6850 */  [ 0.496265602, 18 ],
  /* 6851 */  [ 0.496362201, 18 ],
  /* 6852 */  [ 0.496458804, 18 ],
  /* 6853 */  [ 0.496555413, 18 ],
  /* 6854 */  [ 0.496652026, 18 ],
  /* 6855 */  [ 0.496748644, 18 ],
  /* 6856 */  [ 0.496845266, 18 ],
  /* 6857 */  [ 0.496941894, 18 ],
  /* 6858 */  [ 0.497038526, 18 ],
  /* 6859 */  [ 0.497135162, 18 ],
  /* 6860 */  [ 0.497231804, 18 ],
  /* 6861 */  [ 0.497328450, 18 ],
  /* 6862 */  [ 0.497425100, 18 ],
  /* 6863 */  [ 0.497521756, 18 ],

  /* 6864 */  [ 0.497618416, 18 ],
  /* 6865 */  [ 0.497715081, 18 ],
  /* 6866 */  [ 0.497811750, 18 ],
  /* 6867 */  [ 0.497908425, 18 ],
  /* 6868 */  [ 0.498005103, 18 ],
  /* 6869 */  [ 0.498101787, 18 ],
  /* 6870 */  [ 0.498198475, 18 ],
  /* 6871 */  [ 0.498295168, 18 ],
  /* 6872 */  [ 0.498391866, 18 ],
  /* 6873 */  [ 0.498488568, 18 ],
  /* 6874 */  [ 0.498585275, 18 ],
  /* 6875 */  [ 0.498681987, 18 ],
  /* 6876 */  [ 0.498778704, 18 ],
  /* 6877 */  [ 0.498875425, 18 ],
  /* 6878 */  [ 0.498972150, 18 ],
  /* 6879 */  [ 0.499068881, 18 ],

  /* 6880 */  [ 0.499165616, 18 ],
  /* 6881 */  [ 0.499262356, 18 ],
  /* 6882 */  [ 0.499359101, 18 ],
  /* 6883 */  [ 0.499455850, 18 ],
  /* 6884 */  [ 0.499552604, 18 ],
  /* 6885 */  [ 0.499649362, 18 ],
  /* 6886 */  [ 0.499746126, 18 ],
  /* 6887 */  [ 0.499842894, 18 ],
  /* 6888 */  [ 0.499939666, 18 ],
  /* 6889 */  [ 0.250018222, 19 ],
  /* 6890 */  [ 0.250066613, 19 ],
  /* 6891 */  [ 0.250115006, 19 ],
  /* 6892 */  [ 0.250163402, 19 ],
  /* 6893 */  [ 0.250211800, 19 ],
  /* 6894 */  [ 0.250260200, 19 ],
  /* 6895 */  [ 0.250308603, 19 ],

  /* 6896 */  [ 0.250357008, 19 ],
  /* 6897 */  [ 0.250405415, 19 ],
  /* 6898 */  [ 0.250453825, 19 ],
  /* 6899 */  [ 0.250502237, 19 ],
  /* 6900 */  [ 0.250550652, 19 ],
  /* 6901 */  [ 0.250599068, 19 ],
  /* 6902 */  [ 0.250647488, 19 ],
  /* 6903 */  [ 0.250695909, 19 ],
  /* 6904 */  [ 0.250744333, 19 ],
  /* 6905 */  [ 0.250792759, 19 ],
  /* 6906 */  [ 0.250841187, 19 ],
  /* 6907 */  [ 0.250889618, 19 ],
  /* 6908 */  [ 0.250938051, 19 ],
  /* 6909 */  [ 0.250986487, 19 ],
  /* 6910 */  [ 0.251034924, 19 ],
  /* 6911 */  [ 0.251083365, 19 ],

  /* 6912 */  [ 0.251131807, 19 ],
  /* 6913 */  [ 0.251180252, 19 ],
  /* 6914 */  [ 0.251228699, 19 ],
  /* 6915 */  [ 0.251277148, 19 ],
  /* 6916 */  [ 0.251325600, 19 ],
  /* 6917 */  [ 0.251374054, 19 ],
  /* 6918 */  [ 0.251422511, 19 ],
  /* 6919 */  [ 0.251470970, 19 ],
  /* 6920 */  [ 0.251519431, 19 ],
  /* 6921 */  [ 0.251567894, 19 ],
  /* 6922 */  [ 0.251616360, 19 ],
  /* 6923 */  [ 0.251664828, 19 ],
  /* 6924 */  [ 0.251713299, 19 ],
  /* 6925 */  [ 0.251761772, 19 ],
  /* 6926 */  [ 0.251810247, 19 ],
  /* 6927 */  [ 0.251858724, 19 ],

  /* 6928 */  [ 0.251907204, 19 ],
  /* 6929 */  [ 0.251955686, 19 ],
  /* 6930 */  [ 0.252004171, 19 ],
  /* 6931 */  [ 0.252052658, 19 ],
  /* 6932 */  [ 0.252101147, 19 ],
  /* 6933 */  [ 0.252149638, 19 ],
  /* 6934 */  [ 0.252198132, 19 ],
  /* 6935 */  [ 0.252246628, 19 ],
  /* 6936 */  [ 0.252295127, 19 ],
  /* 6937 */  [ 0.252343627, 19 ],
  /* 6938 */  [ 0.252392131, 19 ],
  /* 6939 */  [ 0.252440636, 19 ],
  /* 6940 */  [ 0.252489144, 19 ],
  /* 6941 */  [ 0.252537654, 19 ],
  /* 6942 */  [ 0.252586166, 19 ],
  /* 6943 */  [ 0.252634681, 19 ],

  /* 6944 */  [ 0.252683198, 19 ],
  /* 6945 */  [ 0.252731718, 19 ],
  /* 6946 */  [ 0.252780240, 19 ],
  /* 6947 */  [ 0.252828764, 19 ],
  /* 6948 */  [ 0.252877290, 19 ],
  /* 6949 */  [ 0.252925819, 19 ],
  /* 6950 */  [ 0.252974350, 19 ],
  /* 6951 */  [ 0.253022883, 19 ],
  /* 6952 */  [ 0.253071419, 19 ],
  /* 6953 */  [ 0.253119957, 19 ],
  /* 6954 */  [ 0.253168498, 19 ],
  /* 6955 */  [ 0.253217040, 19 ],
  /* 6956 */  [ 0.253265585, 19 ],
  /* 6957 */  [ 0.253314133, 19 ],
  /* 6958 */  [ 0.253362682, 19 ],
  /* 6959 */  [ 0.253411234, 19 ],

  /* 6960 */  [ 0.253459789, 19 ],
  /* 6961 */  [ 0.253508345, 19 ],
  /* 6962 */  [ 0.253556904, 19 ],
  /* 6963 */  [ 0.253605466, 19 ],
  /* 6964 */  [ 0.253654029, 19 ],
  /* 6965 */  [ 0.253702595, 19 ],
  /* 6966 */  [ 0.253751164, 19 ],
  /* 6967 */  [ 0.253799734, 19 ],
  /* 6968 */  [ 0.253848307, 19 ],
  /* 6969 */  [ 0.253896883, 19 ],
  /* 6970 */  [ 0.253945460, 19 ],
  /* 6971 */  [ 0.253994040, 19 ],
  /* 6972 */  [ 0.254042622, 19 ],
  /* 6973 */  [ 0.254091207, 19 ],
  /* 6974 */  [ 0.254139794, 19 ],
  /* 6975 */  [ 0.254188383, 19 ],

  /* 6976 */  [ 0.254236974, 19 ],
  /* 6977 */  [ 0.254285568, 19 ],
  /* 6978 */  [ 0.254334165, 19 ],
  /* 6979 */  [ 0.254382763, 19 ],
  /* 6980 */  [ 0.254431364, 19 ],
  /* 6981 */  [ 0.254479967, 19 ],
  /* 6982 */  [ 0.254528572, 19 ],
  /* 6983 */  [ 0.254577180, 19 ],
  /* 6984 */  [ 0.254625790, 19 ],
  /* 6985 */  [ 0.254674403, 19 ],
  /* 6986 */  [ 0.254723017, 19 ],
  /* 6987 */  [ 0.254771635, 19 ],
  /* 6988 */  [ 0.254820254, 19 ],
  /* 6989 */  [ 0.254868876, 19 ],
  /* 6990 */  [ 0.254917500, 19 ],
  /* 6991 */  [ 0.254966126, 19 ],

  /* 6992 */  [ 0.255014755, 19 ],
  /* 6993 */  [ 0.255063386, 19 ],
  /* 6994 */  [ 0.255112019, 19 ],
  /* 6995 */  [ 0.255160655, 19 ],
  /* 6996 */  [ 0.255209292, 19 ],
  /* 6997 */  [ 0.255257933, 19 ],
  /* 6998 */  [ 0.255306575, 19 ],
  /* 6999 */  [ 0.255355220, 19 ],
  /* 7000 */  [ 0.255403867, 19 ],
  /* 7001 */  [ 0.255452517, 19 ],
  /* 7002 */  [ 0.255501169, 19 ],
  /* 7003 */  [ 0.255549823, 19 ],
  /* 7004 */  [ 0.255598479, 19 ],
  /* 7005 */  [ 0.255647138, 19 ],
  /* 7006 */  [ 0.255695799, 19 ],
  /* 7007 */  [ 0.255744463, 19 ],

  /* 7008 */  [ 0.255793128, 19 ],
  /* 7009 */  [ 0.255841796, 19 ],
  /* 7010 */  [ 0.255890467, 19 ],
  /* 7011 */  [ 0.255939139, 19 ],
  /* 7012 */  [ 0.255987814, 19 ],
  /* 7013 */  [ 0.256036492, 19 ],
  /* 7014 */  [ 0.256085171, 19 ],
  /* 7015 */  [ 0.256133853, 19 ],
  /* 7016 */  [ 0.256182537, 19 ],
  /* 7017 */  [ 0.256231224, 19 ],
  /* 7018 */  [ 0.256279913, 19 ],
  /* 7019 */  [ 0.256328604, 19 ],
  /* 7020 */  [ 0.256377297, 19 ],
  /* 7021 */  [ 0.256425993, 19 ],
  /* 7022 */  [ 0.256474691, 19 ],
  /* 7023 */  [ 0.256523392, 19 ],

  /* 7024 */  [ 0.256572095, 19 ],
  /* 7025 */  [ 0.256620800, 19 ],
  /* 7026 */  [ 0.256669507, 19 ],
  /* 7027 */  [ 0.256718217, 19 ],
  /* 7028 */  [ 0.256766929, 19 ],
  /* 7029 */  [ 0.256815643, 19 ],
  /* 7030 */  [ 0.256864359, 19 ],
  /* 7031 */  [ 0.256913078, 19 ],
  /* 7032 */  [ 0.256961800, 19 ],
  /* 7033 */  [ 0.257010523, 19 ],
  /* 7034 */  [ 0.257059249, 19 ],
  /* 7035 */  [ 0.257107977, 19 ],
  /* 7036 */  [ 0.257156708, 19 ],
  /* 7037 */  [ 0.257205440, 19 ],
  /* 7038 */  [ 0.257254175, 19 ],
  /* 7039 */  [ 0.257302913, 19 ],

  /* 7040 */  [ 0.257351652, 19 ],
  /* 7041 */  [ 0.257400394, 19 ],
  /* 7042 */  [ 0.257449139, 19 ],
  /* 7043 */  [ 0.257497885, 19 ],
  /* 7044 */  [ 0.257546634, 19 ],
  /* 7045 */  [ 0.257595386, 19 ],
  /* 7046 */  [ 0.257644139, 19 ],
  /* 7047 */  [ 0.257692895, 19 ],
  /* 7048 */  [ 0.257741653, 19 ],
  /* 7049 */  [ 0.257790414, 19 ],
  /* 7050 */  [ 0.257839176, 19 ],
  /* 7051 */  [ 0.257887941, 19 ],
  /* 7052 */  [ 0.257936709, 19 ],
  /* 7053 */  [ 0.257985478, 19 ],
  /* 7054 */  [ 0.258034250, 19 ],
  /* 7055 */  [ 0.258083025, 19 ],

  /* 7056 */  [ 0.258131801, 19 ],
  /* 7057 */  [ 0.258180580, 19 ],
  /* 7058 */  [ 0.258229361, 19 ],
  /* 7059 */  [ 0.258278145, 19 ],
  /* 7060 */  [ 0.258326931, 19 ],
  /* 7061 */  [ 0.258375719, 19 ],
  /* 7062 */  [ 0.258424509, 19 ],
  /* 7063 */  [ 0.258473302, 19 ],
  /* 7064 */  [ 0.258522097, 19 ],
  /* 7065 */  [ 0.258570894, 19 ],
  /* 7066 */  [ 0.258619694, 19 ],
  /* 7067 */  [ 0.258668496, 19 ],
  /* 7068 */  [ 0.258717300, 19 ],
  /* 7069 */  [ 0.258766106, 19 ],
  /* 7070 */  [ 0.258814915, 19 ],
  /* 7071 */  [ 0.258863726, 19 ],

  /* 7072 */  [ 0.258912540, 19 ],
  /* 7073 */  [ 0.258961356, 19 ],
  /* 7074 */  [ 0.259010174, 19 ],
  /* 7075 */  [ 0.259058994, 19 ],
  /* 7076 */  [ 0.259107817, 19 ],
  /* 7077 */  [ 0.259156642, 19 ],
  /* 7078 */  [ 0.259205469, 19 ],
  /* 7079 */  [ 0.259254298, 19 ],
  /* 7080 */  [ 0.259303130, 19 ],
  /* 7081 */  [ 0.259351964, 19 ],
  /* 7082 */  [ 0.259400801, 19 ],
  /* 7083 */  [ 0.259449639, 19 ],
  /* 7084 */  [ 0.259498480, 19 ],
  /* 7085 */  [ 0.259547324, 19 ],
  /* 7086 */  [ 0.259596169, 19 ],
  /* 7087 */  [ 0.259645017, 19 ],

  /* 7088 */  [ 0.259693868, 19 ],
  /* 7089 */  [ 0.259742720, 19 ],
  /* 7090 */  [ 0.259791575, 19 ],
  /* 7091 */  [ 0.259840432, 19 ],
  /* 7092 */  [ 0.259889291, 19 ],
  /* 7093 */  [ 0.259938153, 19 ],
  /* 7094 */  [ 0.259987017, 19 ],
  /* 7095 */  [ 0.260035883, 19 ],
  /* 7096 */  [ 0.260084752, 19 ],
  /* 7097 */  [ 0.260133623, 19 ],
  /* 7098 */  [ 0.260182496, 19 ],
  /* 7099 */  [ 0.260231372, 19 ],
  /* 7100 */  [ 0.260280249, 19 ],
  /* 7101 */  [ 0.260329129, 19 ],
  /* 7102 */  [ 0.260378012, 19 ],
  /* 7103 */  [ 0.260426896, 19 ],

  /* 7104 */  [ 0.260475783, 19 ],
  /* 7105 */  [ 0.260524673, 19 ],
  /* 7106 */  [ 0.260573564, 19 ],
  /* 7107 */  [ 0.260622458, 19 ],
  /* 7108 */  [ 0.260671354, 19 ],
  /* 7109 */  [ 0.260720252, 19 ],
  /* 7110 */  [ 0.260769153, 19 ],
  /* 7111 */  [ 0.260818056, 19 ],
  /* 7112 */  [ 0.260866961, 19 ],
  /* 7113 */  [ 0.260915869, 19 ],
  /* 7114 */  [ 0.260964779, 19 ],
  /* 7115 */  [ 0.261013691, 19 ],
  /* 7116 */  [ 0.261062606, 19 ],
  /* 7117 */  [ 0.261111522, 19 ],
  /* 7118 */  [ 0.261160441, 19 ],
  /* 7119 */  [ 0.261209363, 19 ],

  /* 7120 */  [ 0.261258286, 19 ],
  /* 7121 */  [ 0.261307212, 19 ],
  /* 7122 */  [ 0.261356140, 19 ],
  /* 7123 */  [ 0.261405071, 19 ],
  /* 7124 */  [ 0.261454004, 19 ],
  /* 7125 */  [ 0.261502939, 19 ],
  /* 7126 */  [ 0.261551876, 19 ],
  /* 7127 */  [ 0.261600816, 19 ],
  /* 7128 */  [ 0.261649758, 19 ],
  /* 7129 */  [ 0.261698702, 19 ],
  /* 7130 */  [ 0.261747649, 19 ],
  /* 7131 */  [ 0.261796597, 19 ],
  /* 7132 */  [ 0.261845548, 19 ],
  /* 7133 */  [ 0.261894502, 19 ],
  /* 7134 */  [ 0.261943458, 19 ],
  /* 7135 */  [ 0.261992416, 19 ],

  /* 7136 */  [ 0.262041376, 19 ],
  /* 7137 */  [ 0.262090338, 19 ],
  /* 7138 */  [ 0.262139303, 19 ],
  /* 7139 */  [ 0.262188270, 19 ],
  /* 7140 */  [ 0.262237240, 19 ],
  /* 7141 */  [ 0.262286211, 19 ],
  /* 7142 */  [ 0.262335185, 19 ],
  /* 7143 */  [ 0.262384162, 19 ],
  /* 7144 */  [ 0.262433140, 19 ],
  /* 7145 */  [ 0.262482121, 19 ],
  /* 7146 */  [ 0.262531104, 19 ],
  /* 7147 */  [ 0.262580089, 19 ],
  /* 7148 */  [ 0.262629077, 19 ],
  /* 7149 */  [ 0.262678067, 19 ],
  /* 7150 */  [ 0.262727059, 19 ],
  /* 7151 */  [ 0.262776054, 19 ],

  /* 7152 */  [ 0.262825051, 19 ],
  /* 7153 */  [ 0.262874050, 19 ],
  /* 7154 */  [ 0.262923051, 19 ],
  /* 7155 */  [ 0.262972055, 19 ],
  /* 7156 */  [ 0.263021061, 19 ],
  /* 7157 */  [ 0.263070069, 19 ],
  /* 7158 */  [ 0.263119079, 19 ],
  /* 7159 */  [ 0.263168092, 19 ],
  /* 7160 */  [ 0.263217107, 19 ],
  /* 7161 */  [ 0.263266125, 19 ],
  /* 7162 */  [ 0.263315144, 19 ],
  /* 7163 */  [ 0.263364166, 19 ],
  /* 7164 */  [ 0.263413191, 19 ],
  /* 7165 */  [ 0.263462217, 19 ],
  /* 7166 */  [ 0.263511246, 19 ],
  /* 7167 */  [ 0.263560277, 19 ],

  /* 7168 */  [ 0.263609310, 19 ],
  /* 7169 */  [ 0.263658346, 19 ],
  /* 7170 */  [ 0.263707384, 19 ],
  /* 7171 */  [ 0.263756424, 19 ],
  /* 7172 */  [ 0.263805466, 19 ],
  /* 7173 */  [ 0.263854511, 19 ],
  /* 7174 */  [ 0.263903558, 19 ],
  /* 7175 */  [ 0.263952607, 19 ],
  /* 7176 */  [ 0.264001659, 19 ],
  /* 7177 */  [ 0.264050713, 19 ],
  /* 7178 */  [ 0.264099769, 19 ],
  /* 7179 */  [ 0.264148827, 19 ],
  /* 7180 */  [ 0.264197888, 19 ],
  /* 7181 */  [ 0.264246951, 19 ],
  /* 7182 */  [ 0.264296016, 19 ],
  /* 7183 */  [ 0.264345084, 19 ],

  /* 7184 */  [ 0.264394153, 19 ],
  /* 7185 */  [ 0.264443225, 19 ],
  /* 7186 */  [ 0.264492300, 19 ],
  /* 7187 */  [ 0.264541376, 19 ],
  /* 7188 */  [ 0.264590455, 19 ],
  /* 7189 */  [ 0.264639536, 19 ],
  /* 7190 */  [ 0.264688620, 19 ],
  /* 7191 */  [ 0.264737706, 19 ],
  /* 7192 */  [ 0.264786794, 19 ],
  /* 7193 */  [ 0.264835884, 19 ],
  /* 7194 */  [ 0.264884976, 19 ],
  /* 7195 */  [ 0.264934071, 19 ],
  /* 7196 */  [ 0.264983168, 19 ],
  /* 7197 */  [ 0.265032268, 19 ],
  /* 7198 */  [ 0.265081369, 19 ],
  /* 7199 */  [ 0.265130473, 19 ],

  /* 7200 */  [ 0.265179580, 19 ],
  /* 7201 */  [ 0.265228688, 19 ],
  /* 7202 */  [ 0.265277799, 19 ],
  /* 7203 */  [ 0.265326912, 19 ],
  /* 7204 */  [ 0.265376027, 19 ],
  /* 7205 */  [ 0.265425145, 19 ],
  /* 7206 */  [ 0.265474264, 19 ],
  /* 7207 */  [ 0.265523387, 19 ],
  /* 7208 */  [ 0.265572511, 19 ],
  /* 7209 */  [ 0.265621638, 19 ],
  /* 7210 */  [ 0.265670766, 19 ],
  /* 7211 */  [ 0.265719898, 19 ],
  /* 7212 */  [ 0.265769031, 19 ],
  /* 7213 */  [ 0.265818167, 19 ],
  /* 7214 */  [ 0.265867305, 19 ],
  /* 7215 */  [ 0.265916445, 19 ],

  /* 7216 */  [ 0.265965588, 19 ],
  /* 7217 */  [ 0.266014732, 19 ],
  /* 7218 */  [ 0.266063880, 19 ],
  /* 7219 */  [ 0.266113029, 19 ],
  /* 7220 */  [ 0.266162181, 19 ],
  /* 7221 */  [ 0.266211334, 19 ],
  /* 7222 */  [ 0.266260491, 19 ],
  /* 7223 */  [ 0.266309649, 19 ],
  /* 7224 */  [ 0.266358810, 19 ],
  /* 7225 */  [ 0.266407973, 19 ],
  /* 7226 */  [ 0.266457138, 19 ],
  /* 7227 */  [ 0.266506305, 19 ],
  /* 7228 */  [ 0.266555475, 19 ],
  /* 7229 */  [ 0.266604647, 19 ],
  /* 7230 */  [ 0.266653822, 19 ],
  /* 7231 */  [ 0.266702998, 19 ],

  /* 7232 */  [ 0.266752177, 19 ],
  /* 7233 */  [ 0.266801358, 19 ],
  /* 7234 */  [ 0.266850541, 19 ],
  /* 7235 */  [ 0.266899727, 19 ],
  /* 7236 */  [ 0.266948915, 19 ],
  /* 7237 */  [ 0.266998105, 19 ],
  /* 7238 */  [ 0.267047298, 19 ],
  /* 7239 */  [ 0.267096492, 19 ],
  /* 7240 */  [ 0.267145689, 19 ],
  /* 7241 */  [ 0.267194888, 19 ],
  /* 7242 */  [ 0.267244090, 19 ],
  /* 7243 */  [ 0.267293294, 19 ],
  /* 7244 */  [ 0.267342500, 19 ],
  /* 7245 */  [ 0.267391708, 19 ],
  /* 7246 */  [ 0.267440919, 19 ],
  /* 7247 */  [ 0.267490131, 19 ],

  /* 7248 */  [ 0.267539347, 19 ],
  /* 7249 */  [ 0.267588564, 19 ],
  /* 7250 */  [ 0.267637783, 19 ],
  /* 7251 */  [ 0.267687005, 19 ],
  /* 7252 */  [ 0.267736229, 19 ],
  /* 7253 */  [ 0.267785456, 19 ],
  /* 7254 */  [ 0.267834685, 19 ],
  /* 7255 */  [ 0.267883915, 19 ],
  /* 7256 */  [ 0.267933149, 19 ],
  /* 7257 */  [ 0.267982384, 19 ],
  /* 7258 */  [ 0.268031622, 19 ],
  /* 7259 */  [ 0.268080862, 19 ],
  /* 7260 */  [ 0.268130104, 19 ],
  /* 7261 */  [ 0.268179349, 19 ],
  /* 7262 */  [ 0.268228595, 19 ],
  /* 7263 */  [ 0.268277844, 19 ],

  /* 7264 */  [ 0.268327096, 19 ],
  /* 7265 */  [ 0.268376349, 19 ],
  /* 7266 */  [ 0.268425605, 19 ],
  /* 7267 */  [ 0.268474863, 19 ],
  /* 7268 */  [ 0.268524123, 19 ],
  /* 7269 */  [ 0.268573386, 19 ],
  /* 7270 */  [ 0.268622651, 19 ],
  /* 7271 */  [ 0.268671918, 19 ],
  /* 7272 */  [ 0.268721187, 19 ],
  /* 7273 */  [ 0.268770459, 19 ],
  /* 7274 */  [ 0.268819733, 19 ],
  /* 7275 */  [ 0.268869009, 19 ],
  /* 7276 */  [ 0.268918287, 19 ],
  /* 7277 */  [ 0.268967568, 19 ],
  /* 7278 */  [ 0.269016851, 19 ],
  /* 7279 */  [ 0.269066136, 19 ],

  /* 7280 */  [ 0.269115423, 19 ],
  /* 7281 */  [ 0.269164713, 19 ],
  /* 7282 */  [ 0.269214005, 19 ],
  /* 7283 */  [ 0.269263299, 19 ],
  /* 7284 */  [ 0.269312595, 19 ],
  /* 7285 */  [ 0.269361894, 19 ],
  /* 7286 */  [ 0.269411195, 19 ],
  /* 7287 */  [ 0.269460498, 19 ],
  /* 7288 */  [ 0.269509804, 19 ],
  /* 7289 */  [ 0.269559111, 19 ],
  /* 7290 */  [ 0.269608421, 19 ],
  /* 7291 */  [ 0.269657734, 19 ],
  /* 7292 */  [ 0.269707048, 19 ],
  /* 7293 */  [ 0.269756365, 19 ],
  /* 7294 */  [ 0.269805684, 19 ],
  /* 7295 */  [ 0.269855005, 19 ],

  /* 7296 */  [ 0.269904329, 19 ],
  /* 7297 */  [ 0.269953654, 19 ],
  /* 7298 */  [ 0.270002982, 19 ],
  /* 7299 */  [ 0.270052313, 19 ],
  /* 7300 */  [ 0.270101645, 19 ],
  /* 7301 */  [ 0.270150980, 19 ],
  /* 7302 */  [ 0.270200317, 19 ],
  /* 7303 */  [ 0.270249656, 19 ],
  /* 7304 */  [ 0.270298998, 19 ],
  /* 7305 */  [ 0.270348341, 19 ],
  /* 7306 */  [ 0.270397687, 19 ],
  /* 7307 */  [ 0.270447036, 19 ],
  /* 7308 */  [ 0.270496386, 19 ],
  /* 7309 */  [ 0.270545739, 19 ],
  /* 7310 */  [ 0.270595094, 19 ],
  /* 7311 */  [ 0.270644451, 19 ],

  /* 7312 */  [ 0.270693811, 19 ],
  /* 7313 */  [ 0.270743173, 19 ],
  /* 7314 */  [ 0.270792537, 19 ],
  /* 7315 */  [ 0.270841903, 19 ],
  /* 7316 */  [ 0.270891271, 19 ],
  /* 7317 */  [ 0.270940642, 19 ],
  /* 7318 */  [ 0.270990015, 19 ],
  /* 7319 */  [ 0.271039390, 19 ],
  /* 7320 */  [ 0.271088768, 19 ],
  /* 7321 */  [ 0.271138148, 19 ],
  /* 7322 */  [ 0.271187530, 19 ],
  /* 7323 */  [ 0.271236914, 19 ],
  /* 7324 */  [ 0.271286301, 19 ],
  /* 7325 */  [ 0.271335689, 19 ],
  /* 7326 */  [ 0.271385080, 19 ],
  /* 7327 */  [ 0.271434474, 19 ],

  /* 7328 */  [ 0.271483869, 19 ],
  /* 7329 */  [ 0.271533267, 19 ],
  /* 7330 */  [ 0.271582667, 19 ],
  /* 7331 */  [ 0.271632069, 19 ],
  /* 7332 */  [ 0.271681474, 19 ],
  /* 7333 */  [ 0.271730880, 19 ],
  /* 7334 */  [ 0.271780289, 19 ],
  /* 7335 */  [ 0.271829701, 19 ],
  /* 7336 */  [ 0.271879114, 19 ],
  /* 7337 */  [ 0.271928530, 19 ],
  /* 7338 */  [ 0.271977948, 19 ],
  /* 7339 */  [ 0.272027368, 19 ],
  /* 7340 */  [ 0.272076790, 19 ],
  /* 7341 */  [ 0.272126215, 19 ],
  /* 7342 */  [ 0.272175642, 19 ],
  /* 7343 */  [ 0.272225071, 19 ],

  /* 7344 */  [ 0.272274503, 19 ],
  /* 7345 */  [ 0.272323936, 19 ],
  /* 7346 */  [ 0.272373372, 19 ],
  /* 7347 */  [ 0.272422810, 19 ],
  /* 7348 */  [ 0.272472251, 19 ],
  /* 7349 */  [ 0.272521693, 19 ],
  /* 7350 */  [ 0.272571138, 19 ],
  /* 7351 */  [ 0.272620585, 19 ],
  /* 7352 */  [ 0.272670035, 19 ],
  /* 7353 */  [ 0.272719486, 19 ],
  /* 7354 */  [ 0.272768940, 19 ],
  /* 7355 */  [ 0.272818396, 19 ],
  /* 7356 */  [ 0.272867855, 19 ],
  /* 7357 */  [ 0.272917315, 19 ],
  /* 7358 */  [ 0.272966778, 19 ],
  /* 7359 */  [ 0.273016243, 19 ],

  /* 7360 */  [ 0.273065710, 19 ],
  /* 7361 */  [ 0.273115180, 19 ],
  /* 7362 */  [ 0.273164652, 19 ],
  /* 7363 */  [ 0.273214126, 19 ],
  /* 7364 */  [ 0.273263602, 19 ],
  /* 7365 */  [ 0.273313081, 19 ],
  /* 7366 */  [ 0.273362561, 19 ],
  /* 7367 */  [ 0.273412044, 19 ],
  /* 7368 */  [ 0.273461530, 19 ],
  /* 7369 */  [ 0.273511017, 19 ],
  /* 7370 */  [ 0.273560507, 19 ],
  /* 7371 */  [ 0.273609999, 19 ],
  /* 7372 */  [ 0.273659493, 19 ],
  /* 7373 */  [ 0.273708989, 19 ],
  /* 7374 */  [ 0.273758488, 19 ],
  /* 7375 */  [ 0.273807989, 19 ],

  /* 7376 */  [ 0.273857492, 19 ],
  /* 7377 */  [ 0.273906997, 19 ],
  /* 7378 */  [ 0.273956505, 19 ],
  /* 7379 */  [ 0.274006015, 19 ],
  /* 7380 */  [ 0.274055527, 19 ],
  /* 7381 */  [ 0.274105041, 19 ],
  /* 7382 */  [ 0.274154558, 19 ],
  /* 7383 */  [ 0.274204076, 19 ],
  /* 7384 */  [ 0.274253597, 19 ],
  /* 7385 */  [ 0.274303121, 19 ],
  /* 7386 */  [ 0.274352646, 19 ],
  /* 7387 */  [ 0.274402174, 19 ],
  /* 7388 */  [ 0.274451704, 19 ],
  /* 7389 */  [ 0.274501236, 19 ],
  /* 7390 */  [ 0.274550771, 19 ],
  /* 7391 */  [ 0.274600307, 19 ],

  /* 7392 */  [ 0.274649846, 19 ],
  /* 7393 */  [ 0.274699387, 19 ],
  /* 7394 */  [ 0.274748931, 19 ],
  /* 7395 */  [ 0.274798476, 19 ],
  /* 7396 */  [ 0.274848024, 19 ],
  /* 7397 */  [ 0.274897574, 19 ],
  /* 7398 */  [ 0.274947126, 19 ],
  /* 7399 */  [ 0.274996681, 19 ],
  /* 7400 */  [ 0.275046238, 19 ],
  /* 7401 */  [ 0.275095797, 19 ],
  /* 7402 */  [ 0.275145358, 19 ],
  /* 7403 */  [ 0.275194921, 19 ],
  /* 7404 */  [ 0.275244487, 19 ],
  /* 7405 */  [ 0.275294055, 19 ],
  /* 7406 */  [ 0.275343625, 19 ],
  /* 7407 */  [ 0.275393198, 19 ],

  /* 7408 */  [ 0.275442772, 19 ],
  /* 7409 */  [ 0.275492349, 19 ],
  /* 7410 */  [ 0.275541928, 19 ],
  /* 7411 */  [ 0.275591509, 19 ],
  /* 7412 */  [ 0.275641093, 19 ],
  /* 7413 */  [ 0.275690679, 19 ],
  /* 7414 */  [ 0.275740267, 19 ],
  /* 7415 */  [ 0.275789857, 19 ],
  /* 7416 */  [ 0.275839449, 19 ],
  /* 7417 */  [ 0.275889044, 19 ],
  /* 7418 */  [ 0.275938641, 19 ],
  /* 7419 */  [ 0.275988240, 19 ],
  /* 7420 */  [ 0.276037842, 19 ],
  /* 7421 */  [ 0.276087445, 19 ],
  /* 7422 */  [ 0.276137051, 19 ],
  /* 7423 */  [ 0.276186659, 19 ],

  /* 7424 */  [ 0.276236269, 19 ],
  /* 7425 */  [ 0.276285882, 19 ],
  /* 7426 */  [ 0.276335497, 19 ],
  /* 7427 */  [ 0.276385113, 19 ],
  /* 7428 */  [ 0.276434733, 19 ],
  /* 7429 */  [ 0.276484354, 19 ],
  /* 7430 */  [ 0.276533978, 19 ],
  /* 7431 */  [ 0.276583604, 19 ],
  /* 7432 */  [ 0.276633232, 19 ],
  /* 7433 */  [ 0.276682862, 19 ],
  /* 7434 */  [ 0.276732495, 19 ],
  /* 7435 */  [ 0.276782129, 19 ],
  /* 7436 */  [ 0.276831766, 19 ],
  /* 7437 */  [ 0.276881406, 19 ],
  /* 7438 */  [ 0.276931047, 19 ],
  /* 7439 */  [ 0.276980691, 19 ],

  /* 7440 */  [ 0.277030337, 19 ],
  /* 7441 */  [ 0.277079985, 19 ],
  /* 7442 */  [ 0.277129635, 19 ],
  /* 7443 */  [ 0.277179288, 19 ],
  /* 7444 */  [ 0.277228942, 19 ],
  /* 7445 */  [ 0.277278600, 19 ],
  /* 7446 */  [ 0.277328259, 19 ],
  /* 7447 */  [ 0.277377920, 19 ],
  /* 7448 */  [ 0.277427584, 19 ],
  /* 7449 */  [ 0.277477250, 19 ],
  /* 7450 */  [ 0.277526918, 19 ],
  /* 7451 */  [ 0.277576588, 19 ],
  /* 7452 */  [ 0.277626261, 19 ],
  /* 7453 */  [ 0.277675936, 19 ],
  /* 7454 */  [ 0.277725613, 19 ],
  /* 7455 */  [ 0.277775292, 19 ],

  /* 7456 */  [ 0.277824973, 19 ],
  /* 7457 */  [ 0.277874657, 19 ],
  /* 7458 */  [ 0.277924343, 19 ],
  /* 7459 */  [ 0.277974031, 19 ],
  /* 7460 */  [ 0.278023722, 19 ],
  /* 7461 */  [ 0.278073414, 19 ],
  /* 7462 */  [ 0.278123109, 19 ],
  /* 7463 */  [ 0.278172806, 19 ],
  /* 7464 */  [ 0.278222505, 19 ],
  /* 7465 */  [ 0.278272207, 19 ],
  /* 7466 */  [ 0.278321910, 19 ],
  /* 7467 */  [ 0.278371616, 19 ],
  /* 7468 */  [ 0.278421324, 19 ],
  /* 7469 */  [ 0.278471035, 19 ],
  /* 7470 */  [ 0.278520747, 19 ],
  /* 7471 */  [ 0.278570462, 19 ],

  /* 7472 */  [ 0.278620179, 19 ],
  /* 7473 */  [ 0.278669898, 19 ],
  /* 7474 */  [ 0.278719619, 19 ],
  /* 7475 */  [ 0.278769343, 19 ],
  /* 7476 */  [ 0.278819069, 19 ],
  /* 7477 */  [ 0.278868797, 19 ],
  /* 7478 */  [ 0.278918527, 19 ],
  /* 7479 */  [ 0.278968260, 19 ],
  /* 7480 */  [ 0.279017995, 19 ],
  /* 7481 */  [ 0.279067731, 19 ],
  /* 7482 */  [ 0.279117471, 19 ],
  /* 7483 */  [ 0.279167212, 19 ],
  /* 7484 */  [ 0.279216956, 19 ],
  /* 7485 */  [ 0.279266701, 19 ],
  /* 7486 */  [ 0.279316449, 19 ],
  /* 7487 */  [ 0.279366200, 19 ],

  /* 7488 */  [ 0.279415952, 19 ],
  /* 7489 */  [ 0.279465707, 19 ],
  /* 7490 */  [ 0.279515464, 19 ],
  /* 7491 */  [ 0.279565223, 19 ],
  /* 7492 */  [ 0.279614984, 19 ],
  /* 7493 */  [ 0.279664748, 19 ],
  /* 7494 */  [ 0.279714513, 19 ],
  /* 7495 */  [ 0.279764281, 19 ],
  /* 7496 */  [ 0.279814051, 19 ],
  /* 7497 */  [ 0.279863824, 19 ],
  /* 7498 */  [ 0.279913598, 19 ],
  /* 7499 */  [ 0.279963375, 19 ],
  /* 7500 */  [ 0.280013154, 19 ],
  /* 7501 */  [ 0.280062935, 19 ],
  /* 7502 */  [ 0.280112719, 19 ],
  /* 7503 */  [ 0.280162504, 19 ],

  /* 7504 */  [ 0.280212292, 19 ],
  /* 7505 */  [ 0.280262082, 19 ],
  /* 7506 */  [ 0.280311875, 19 ],
  /* 7507 */  [ 0.280361669, 19 ],
  /* 7508 */  [ 0.280411466, 19 ],
  /* 7509 */  [ 0.280461265, 19 ],
  /* 7510 */  [ 0.280511066, 19 ],
  /* 7511 */  [ 0.280560869, 19 ],
  /* 7512 */  [ 0.280610675, 19 ],
  /* 7513 */  [ 0.280660483, 19 ],
  /* 7514 */  [ 0.280710292, 19 ],
  /* 7515 */  [ 0.280760105, 19 ],
  /* 7516 */  [ 0.280809919, 19 ],
  /* 7517 */  [ 0.280859736, 19 ],
  /* 7518 */  [ 0.280909554, 19 ],
  /* 7519 */  [ 0.280959375, 19 ],

  /* 7520 */  [ 0.281009199, 19 ],
  /* 7521 */  [ 0.281059024, 19 ],
  /* 7522 */  [ 0.281108852, 19 ],
  /* 7523 */  [ 0.281158682, 19 ],
  /* 7524 */  [ 0.281208514, 19 ],
  /* 7525 */  [ 0.281258348, 19 ],
  /* 7526 */  [ 0.281308184, 19 ],
  /* 7527 */  [ 0.281358023, 19 ],
  /* 7528 */  [ 0.281407864, 19 ],
  /* 7529 */  [ 0.281457707, 19 ],
  /* 7530 */  [ 0.281507552, 19 ],
  /* 7531 */  [ 0.281557400, 19 ],
  /* 7532 */  [ 0.281607250, 19 ],
  /* 7533 */  [ 0.281657101, 19 ],
  /* 7534 */  [ 0.281706956, 19 ],
  /* 7535 */  [ 0.281756812, 19 ],

  /* 7536 */  [ 0.281806670, 19 ],
  /* 7537 */  [ 0.281856531, 19 ],
  /* 7538 */  [ 0.281906394, 19 ],
  /* 7539 */  [ 0.281956259, 19 ],
  /* 7540 */  [ 0.282006127, 19 ],
  /* 7541 */  [ 0.282055996, 19 ],
  /* 7542 */  [ 0.282105868, 19 ],
  /* 7543 */  [ 0.282155742, 19 ],
  /* 7544 */  [ 0.282205618, 19 ],
  /* 7545 */  [ 0.282255496, 19 ],
  /* 7546 */  [ 0.282305377, 19 ],
  /* 7547 */  [ 0.282355260, 19 ],
  /* 7548 */  [ 0.282405145, 19 ],
  /* 7549 */  [ 0.282455032, 19 ],
  /* 7550 */  [ 0.282504921, 19 ],
  /* 7551 */  [ 0.282554813, 19 ],

  /* 7552 */  [ 0.282604707, 19 ],
  /* 7553 */  [ 0.282654603, 19 ],
  /* 7554 */  [ 0.282704501, 19 ],
  /* 7555 */  [ 0.282754401, 19 ],
  /* 7556 */  [ 0.282804304, 19 ],
  /* 7557 */  [ 0.282854209, 19 ],
  /* 7558 */  [ 0.282904116, 19 ],
  /* 7559 */  [ 0.282954025, 19 ],
  /* 7560 */  [ 0.283003936, 19 ],
  /* 7561 */  [ 0.283053850, 19 ],
  /* 7562 */  [ 0.283103766, 19 ],
  /* 7563 */  [ 0.283153684, 19 ],
  /* 7564 */  [ 0.283203604, 19 ],
  /* 7565 */  [ 0.283253527, 19 ],
  /* 7566 */  [ 0.283303451, 19 ],
  /* 7567 */  [ 0.283353378, 19 ],

  /* 7568 */  [ 0.283403307, 19 ],
  /* 7569 */  [ 0.283453238, 19 ],
  /* 7570 */  [ 0.283503172, 19 ],
  /* 7571 */  [ 0.283553107, 19 ],
  /* 7572 */  [ 0.283603045, 19 ],
  /* 7573 */  [ 0.283652985, 19 ],
  /* 7574 */  [ 0.283702927, 19 ],
  /* 7575 */  [ 0.283752872, 19 ],
  /* 7576 */  [ 0.283802818, 19 ],
  /* 7577 */  [ 0.283852767, 19 ],
  /* 7578 */  [ 0.283902718, 19 ],
  /* 7579 */  [ 0.283952671, 19 ],
  /* 7580 */  [ 0.284002627, 19 ],
  /* 7581 */  [ 0.284052584, 19 ],
  /* 7582 */  [ 0.284102544, 19 ],
  /* 7583 */  [ 0.284152506, 19 ],

  /* 7584 */  [ 0.284202470, 19 ],
  /* 7585 */  [ 0.284252436, 19 ],
  /* 7586 */  [ 0.284302405, 19 ],
  /* 7587 */  [ 0.284352376, 19 ],
  /* 7588 */  [ 0.284402349, 19 ],
  /* 7589 */  [ 0.284452324, 19 ],
  /* 7590 */  [ 0.284502301, 19 ],
  /* 7591 */  [ 0.284552281, 19 ],
  /* 7592 */  [ 0.284602263, 19 ],
  /* 7593 */  [ 0.284652246, 19 ],
  /* 7594 */  [ 0.284702233, 19 ],
  /* 7595 */  [ 0.284752221, 19 ],
  /* 7596 */  [ 0.284802211, 19 ],
  /* 7597 */  [ 0.284852204, 19 ],
  /* 7598 */  [ 0.284902199, 19 ],
  /* 7599 */  [ 0.284952196, 19 ],

  /* 7600 */  [ 0.285002195, 19 ],
  /* 7601 */  [ 0.285052197, 19 ],
  /* 7602 */  [ 0.285102201, 19 ],
  /* 7603 */  [ 0.285152206, 19 ],
  /* 7604 */  [ 0.285202214, 19 ],
  /* 7605 */  [ 0.285252225, 19 ],
  /* 7606 */  [ 0.285302237, 19 ],
  /* 7607 */  [ 0.285352252, 19 ],
  /* 7608 */  [ 0.285402269, 19 ],
  /* 7609 */  [ 0.285452288, 19 ],
  /* 7610 */  [ 0.285502309, 19 ],
  /* 7611 */  [ 0.285552332, 19 ],
  /* 7612 */  [ 0.285602358, 19 ],
  /* 7613 */  [ 0.285652386, 19 ],
  /* 7614 */  [ 0.285702416, 19 ],
  /* 7615 */  [ 0.285752448, 19 ],

  /* 7616 */  [ 0.285802482, 19 ],
  /* 7617 */  [ 0.285852519, 19 ],
  /* 7618 */  [ 0.285902557, 19 ],
  /* 7619 */  [ 0.285952598, 19 ],
  /* 7620 */  [ 0.286002641, 19 ],
  /* 7621 */  [ 0.286052687, 19 ],
  /* 7622 */  [ 0.286102734, 19 ],
  /* 7623 */  [ 0.286152784, 19 ],
  /* 7624 */  [ 0.286202836, 19 ],
  /* 7625 */  [ 0.286252890, 19 ],
  /* 7626 */  [ 0.286302946, 19 ],
  /* 7627 */  [ 0.286353005, 19 ],
  /* 7628 */  [ 0.286403065, 19 ],
  /* 7629 */  [ 0.286453128, 19 ],
  /* 7630 */  [ 0.286503193, 19 ],
  /* 7631 */  [ 0.286553260, 19 ],

  /* 7632 */  [ 0.286603329, 19 ],
  /* 7633 */  [ 0.286653401, 19 ],
  /* 7634 */  [ 0.286703475, 19 ],
  /* 7635 */  [ 0.286753551, 19 ],
  /* 7636 */  [ 0.286803629, 19 ],
  /* 7637 */  [ 0.286853709, 19 ],
  /* 7638 */  [ 0.286903792, 19 ],
  /* 7639 */  [ 0.286953876, 19 ],
  /* 7640 */  [ 0.287003963, 19 ],
  /* 7641 */  [ 0.287054052, 19 ],
  /* 7642 */  [ 0.287104143, 19 ],
  /* 7643 */  [ 0.287154237, 19 ],
  /* 7644 */  [ 0.287204332, 19 ],
  /* 7645 */  [ 0.287254430, 19 ],
  /* 7646 */  [ 0.287304530, 19 ],
  /* 7647 */  [ 0.287354632, 19 ],

  /* 7648 */  [ 0.287404737, 19 ],
  /* 7649 */  [ 0.287454843, 19 ],
  /* 7650 */  [ 0.287504952, 19 ],
  /* 7651 */  [ 0.287555063, 19 ],
  /* 7652 */  [ 0.287605176, 19 ],
  /* 7653 */  [ 0.287655291, 19 ],
  /* 7654 */  [ 0.287705409, 19 ],
  /* 7655 */  [ 0.287755528, 19 ],
  /* 7656 */  [ 0.287805650, 19 ],
  /* 7657 */  [ 0.287855774, 19 ],
  /* 7658 */  [ 0.287905900, 19 ],
  /* 7659 */  [ 0.287956028, 19 ],
  /* 7660 */  [ 0.288006159, 19 ],
  /* 7661 */  [ 0.288056292, 19 ],
  /* 7662 */  [ 0.288106427, 19 ],
  /* 7663 */  [ 0.288156564, 19 ],

  /* 7664 */  [ 0.288206703, 19 ],
  /* 7665 */  [ 0.288256844, 19 ],
  /* 7666 */  [ 0.288306988, 19 ],
  /* 7667 */  [ 0.288357134, 19 ],
  /* 7668 */  [ 0.288407282, 19 ],
  /* 7669 */  [ 0.288457432, 19 ],
  /* 7670 */  [ 0.288507584, 19 ],
  /* 7671 */  [ 0.288557739, 19 ],
  /* 7672 */  [ 0.288607895, 19 ],
  /* 7673 */  [ 0.288658054, 19 ],
  /* 7674 */  [ 0.288708215, 19 ],
  /* 7675 */  [ 0.288758379, 19 ],
  /* 7676 */  [ 0.288808544, 19 ],
  /* 7677 */  [ 0.288858712, 19 ],
  /* 7678 */  [ 0.288908881, 19 ],
  /* 7679 */  [ 0.288959053, 19 ],

  /* 7680 */  [ 0.289009227, 19 ],
  /* 7681 */  [ 0.289059404, 19 ],
  /* 7682 */  [ 0.289109582, 19 ],
  /* 7683 */  [ 0.289159763, 19 ],
  /* 7684 */  [ 0.289209946, 19 ],
  /* 7685 */  [ 0.289260131, 19 ],
  /* 7686 */  [ 0.289310318, 19 ],
  /* 7687 */  [ 0.289360507, 19 ],
  /* 7688 */  [ 0.289410699, 19 ],
  /* 7689 */  [ 0.289460893, 19 ],
  /* 7690 */  [ 0.289511088, 19 ],
  /* 7691 */  [ 0.289561287, 19 ],
  /* 7692 */  [ 0.289611487, 19 ],
  /* 7693 */  [ 0.289661689, 19 ],
  /* 7694 */  [ 0.289711894, 19 ],
  /* 7695 */  [ 0.289762101, 19 ],

  /* 7696 */  [ 0.289812309, 19 ],
  /* 7697 */  [ 0.289862521, 19 ],
  /* 7698 */  [ 0.289912734, 19 ],
  /* 7699 */  [ 0.289962949, 19 ],
  /* 7700 */  [ 0.290013167, 19 ],
  /* 7701 */  [ 0.290063387, 19 ],
  /* 7702 */  [ 0.290113609, 19 ],
  /* 7703 */  [ 0.290163833, 19 ],
  /* 7704 */  [ 0.290214059, 19 ],
  /* 7705 */  [ 0.290264288, 19 ],
  /* 7706 */  [ 0.290314519, 19 ],
  /* 7707 */  [ 0.290364751, 19 ],
  /* 7708 */  [ 0.290414986, 19 ],
  /* 7709 */  [ 0.290465224, 19 ],
  /* 7710 */  [ 0.290515463, 19 ],
  /* 7711 */  [ 0.290565705, 19 ],

  /* 7712 */  [ 0.290615948, 19 ],
  /* 7713 */  [ 0.290666194, 19 ],
  /* 7714 */  [ 0.290716442, 19 ],
  /* 7715 */  [ 0.290766692, 19 ],
  /* 7716 */  [ 0.290816945, 19 ],
  /* 7717 */  [ 0.290867199, 19 ],
  /* 7718 */  [ 0.290917456, 19 ],
  /* 7719 */  [ 0.290967715, 19 ],
  /* 7720 */  [ 0.291017976, 19 ],
  /* 7721 */  [ 0.291068239, 19 ],
  /* 7722 */  [ 0.291118505, 19 ],
  /* 7723 */  [ 0.291168772, 19 ],
  /* 7724 */  [ 0.291219042, 19 ],
  /* 7725 */  [ 0.291269314, 19 ],
  /* 7726 */  [ 0.291319588, 19 ],
  /* 7727 */  [ 0.291369865, 19 ],

  /* 7728 */  [ 0.291420143, 19 ],
  /* 7729 */  [ 0.291470424, 19 ],
  /* 7730 */  [ 0.291520706, 19 ],
  /* 7731 */  [ 0.291570991, 19 ],
  /* 7732 */  [ 0.291621278, 19 ],
  /* 7733 */  [ 0.291671568, 19 ],
  /* 7734 */  [ 0.291721859, 19 ],
  /* 7735 */  [ 0.291772153, 19 ],
  /* 7736 */  [ 0.291822449, 19 ],
  /* 7737 */  [ 0.291872747, 19 ],
  /* 7738 */  [ 0.291923047, 19 ],
  /* 7739 */  [ 0.291973349, 19 ],
  /* 7740 */  [ 0.292023653, 19 ],
  /* 7741 */  [ 0.292073960, 19 ],
  /* 7742 */  [ 0.292124269, 19 ],
  /* 7743 */  [ 0.292174580, 19 ],

  /* 7744 */  [ 0.292224893, 19 ],
  /* 7745 */  [ 0.292275208, 19 ],
  /* 7746 */  [ 0.292325526, 19 ],
  /* 7747 */  [ 0.292375845, 19 ],
  /* 7748 */  [ 0.292426167, 19 ],
  /* 7749 */  [ 0.292476491, 19 ],
  /* 7750 */  [ 0.292526817, 19 ],
  /* 7751 */  [ 0.292577145, 19 ],
  /* 7752 */  [ 0.292627476, 19 ],
  /* 7753 */  [ 0.292677808, 19 ],
  /* 7754 */  [ 0.292728143, 19 ],
  /* 7755 */  [ 0.292778480, 19 ],
  /* 7756 */  [ 0.292828819, 19 ],
  /* 7757 */  [ 0.292879160, 19 ],
  /* 7758 */  [ 0.292929504, 19 ],
  /* 7759 */  [ 0.292979849, 19 ],

  /* 7760 */  [ 0.293030197, 19 ],
  /* 7761 */  [ 0.293080547, 19 ],
  /* 7762 */  [ 0.293130899, 19 ],
  /* 7763 */  [ 0.293181253, 19 ],
  /* 7764 */  [ 0.293231610, 19 ],
  /* 7765 */  [ 0.293281968, 19 ],
  /* 7766 */  [ 0.293332329, 19 ],
  /* 7767 */  [ 0.293382692, 19 ],
  /* 7768 */  [ 0.293433057, 19 ],
  /* 7769 */  [ 0.293483424, 19 ],
  /* 7770 */  [ 0.293533794, 19 ],
  /* 7771 */  [ 0.293584165, 19 ],
  /* 7772 */  [ 0.293634539, 19 ],
  /* 7773 */  [ 0.293684915, 19 ],
  /* 7774 */  [ 0.293735293, 19 ],
  /* 7775 */  [ 0.293785673, 19 ],

  /* 7776 */  [ 0.293836055, 19 ],
  /* 7777 */  [ 0.293886440, 19 ],
  /* 7778 */  [ 0.293936826, 19 ],
  /* 7779 */  [ 0.293987215, 19 ],
  /* 7780 */  [ 0.294037606, 19 ],
  /* 7781 */  [ 0.294087999, 19 ],
  /* 7782 */  [ 0.294138395, 19 ],
  /* 7783 */  [ 0.294188792, 19 ],
  /* 7784 */  [ 0.294239192, 19 ],
  /* 7785 */  [ 0.294289593, 19 ],
  /* 7786 */  [ 0.294339997, 19 ],
  /* 7787 */  [ 0.294390403, 19 ],
  /* 7788 */  [ 0.294440812, 19 ],
  /* 7789 */  [ 0.294491222, 19 ],
  /* 7790 */  [ 0.294541635, 19 ],
  /* 7791 */  [ 0.294592049, 19 ],

  /* 7792 */  [ 0.294642466, 19 ],
  /* 7793 */  [ 0.294692885, 19 ],
  /* 7794 */  [ 0.294743306, 19 ],
  /* 7795 */  [ 0.294793730, 19 ],
  /* 7796 */  [ 0.294844155, 19 ],
  /* 7797 */  [ 0.294894583, 19 ],
  /* 7798 */  [ 0.294945013, 19 ],
  /* 7799 */  [ 0.294995445, 19 ],
  /* 7800 */  [ 0.295045879, 19 ],
  /* 7801 */  [ 0.295096315, 19 ],
  /* 7802 */  [ 0.295146753, 19 ],
  /* 7803 */  [ 0.295197194, 19 ],
  /* 7804 */  [ 0.295247637, 19 ],
  /* 7805 */  [ 0.295298082, 19 ],
  /* 7806 */  [ 0.295348529, 19 ],
  /* 7807 */  [ 0.295398978, 19 ],

  /* 7808 */  [ 0.295449429, 19 ],
  /* 7809 */  [ 0.295499883, 19 ],
  /* 7810 */  [ 0.295550338, 19 ],
  /* 7811 */  [ 0.295600796, 19 ],
  /* 7812 */  [ 0.295651256, 19 ],
  /* 7813 */  [ 0.295701718, 19 ],
  /* 7814 */  [ 0.295752183, 19 ],
  /* 7815 */  [ 0.295802649, 19 ],
  /* 7816 */  [ 0.295853118, 19 ],
  /* 7817 */  [ 0.295903588, 19 ],
  /* 7818 */  [ 0.295954061, 19 ],
  /* 7819 */  [ 0.296004536, 19 ],
  /* 7820 */  [ 0.296055013, 19 ],
  /* 7821 */  [ 0.296105493, 19 ],
  /* 7822 */  [ 0.296155974, 19 ],
  /* 7823 */  [ 0.296206458, 19 ],

  /* 7824 */  [ 0.296256944, 19 ],
  /* 7825 */  [ 0.296307432, 19 ],
  /* 7826 */  [ 0.296357922, 19 ],
  /* 7827 */  [ 0.296408414, 19 ],
  /* 7828 */  [ 0.296458908, 19 ],
  /* 7829 */  [ 0.296509405, 19 ],
  /* 7830 */  [ 0.296559904, 19 ],
  /* 7831 */  [ 0.296610404, 19 ],
  /* 7832 */  [ 0.296660907, 19 ],
  /* 7833 */  [ 0.296711413, 19 ],
  /* 7834 */  [ 0.296761920, 19 ],
  /* 7835 */  [ 0.296812429, 19 ],
  /* 7836 */  [ 0.296862941, 19 ],
  /* 7837 */  [ 0.296913455, 19 ],
  /* 7838 */  [ 0.296963971, 19 ],
  /* 7839 */  [ 0.297014489, 19 ],

  /* 7840 */  [ 0.297065009, 19 ],
  /* 7841 */  [ 0.297115531, 19 ],
  /* 7842 */  [ 0.297166056, 19 ],
  /* 7843 */  [ 0.297216582, 19 ],
  /* 7844 */  [ 0.297267111, 19 ],
  /* 7845 */  [ 0.297317642, 19 ],
  /* 7846 */  [ 0.297368175, 19 ],
  /* 7847 */  [ 0.297418710, 19 ],
  /* 7848 */  [ 0.297469248, 19 ],
  /* 7849 */  [ 0.297519787, 19 ],
  /* 7850 */  [ 0.297570329, 19 ],
  /* 7851 */  [ 0.297620873, 19 ],
  /* 7852 */  [ 0.297671418, 19 ],
  /* 7853 */  [ 0.297721967, 19 ],
  /* 7854 */  [ 0.297772517, 19 ],
  /* 7855 */  [ 0.297823069, 19 ],

  /* 7856 */  [ 0.297873624, 19 ],
  /* 7857 */  [ 0.297924180, 19 ],
  /* 7858 */  [ 0.297974739, 19 ],
  /* 7859 */  [ 0.298025300, 19 ],
  /* 7860 */  [ 0.298075863, 19 ],
  /* 7861 */  [ 0.298126429, 19 ],
  /* 7862 */  [ 0.298176996, 19 ],
  /* 7863 */  [ 0.298227565, 19 ],
  /* 7864 */  [ 0.298278137, 19 ],
  /* 7865 */  [ 0.298328711, 19 ],
  /* 7866 */  [ 0.298379287, 19 ],
  /* 7867 */  [ 0.298429865, 19 ],
  /* 7868 */  [ 0.298480445, 19 ],
  /* 7869 */  [ 0.298531028, 19 ],
  /* 7870 */  [ 0.298581612, 19 ],
  /* 7871 */  [ 0.298632199, 19 ],

  /* 7872 */  [ 0.298682788, 19 ],
  /* 7873 */  [ 0.298733379, 19 ],
  /* 7874 */  [ 0.298783972, 19 ],
  /* 7875 */  [ 0.298834567, 19 ],
  /* 7876 */  [ 0.298885165, 19 ],
  /* 7877 */  [ 0.298935764, 19 ],
  /* 7878 */  [ 0.298986366, 19 ],
  /* 7879 */  [ 0.299036970, 19 ],
  /* 7880 */  [ 0.299087576, 19 ],
  /* 7881 */  [ 0.299138184, 19 ],
  /* 7882 */  [ 0.299188794, 19 ],
  /* 7883 */  [ 0.299239406, 19 ],
  /* 7884 */  [ 0.299290021, 19 ],
  /* 7885 */  [ 0.299340638, 19 ],
  /* 7886 */  [ 0.299391256, 19 ],
  /* 7887 */  [ 0.299441877, 19 ],

  /* 7888 */  [ 0.299492500, 19 ],
  /* 7889 */  [ 0.299543126, 19 ],
  /* 7890 */  [ 0.299593753, 19 ],
  /* 7891 */  [ 0.299644382, 19 ],
  /* 7892 */  [ 0.299695014, 19 ],
  /* 7893 */  [ 0.299745648, 19 ],
  /* 7894 */  [ 0.299796284, 19 ],
  /* 7895 */  [ 0.299846922, 19 ],
  /* 7896 */  [ 0.299897562, 19 ],
  /* 7897 */  [ 0.299948204, 19 ],
  /* 7898 */  [ 0.299998849, 19 ],
  /* 7899 */  [ 0.300049495, 19 ],
  /* 7900 */  [ 0.300100144, 19 ],
  /* 7901 */  [ 0.300150795, 19 ],
  /* 7902 */  [ 0.300201448, 19 ],
  /* 7903 */  [ 0.300252103, 19 ],

  /* 7904 */  [ 0.300302761, 19 ],
  /* 7905 */  [ 0.300353420, 19 ],
  /* 7906 */  [ 0.300404082, 19 ],
  /* 7907 */  [ 0.300454745, 19 ],
  /* 7908 */  [ 0.300505411, 19 ],
  /* 7909 */  [ 0.300556079, 19 ],
  /* 7910 */  [ 0.300606749, 19 ],
  /* 7911 */  [ 0.300657421, 19 ],
  /* 7912 */  [ 0.300708096, 19 ],
  /* 7913 */  [ 0.300758772, 19 ],
  /* 7914 */  [ 0.300809451, 19 ],
  /* 7915 */  [ 0.300860132, 19 ],
  /* 7916 */  [ 0.300910815, 19 ],
  /* 7917 */  [ 0.300961500, 19 ],
  /* 7918 */  [ 0.301012187, 19 ],
  /* 7919 */  [ 0.301062876, 19 ],

  /* 7920 */  [ 0.301113568, 19 ],
  /* 7921 */  [ 0.301164261, 19 ],
  /* 7922 */  [ 0.301214957, 19 ],
  /* 7923 */  [ 0.301265655, 19 ],
  /* 7924 */  [ 0.301316355, 19 ],
  /* 7925 */  [ 0.301367057, 19 ],
  /* 7926 */  [ 0.301417761, 19 ],
  /* 7927 */  [ 0.301468468, 19 ],
  /* 7928 */  [ 0.301519176, 19 ],
  /* 7929 */  [ 0.301569887, 19 ],
  /* 7930 */  [ 0.301620599, 19 ],
  /* 7931 */  [ 0.301671314, 19 ],
  /* 7932 */  [ 0.301722031, 19 ],
  /* 7933 */  [ 0.301772751, 19 ],
  /* 7934 */  [ 0.301823472, 19 ],
  /* 7935 */  [ 0.301874195, 19 ],

  /* 7936 */  [ 0.301924921, 19 ],
  /* 7937 */  [ 0.301975649, 19 ],
  /* 7938 */  [ 0.302026378, 19 ],
  /* 7939 */  [ 0.302077110, 19 ],
  /* 7940 */  [ 0.302127845, 19 ],
  /* 7941 */  [ 0.302178581, 19 ],
  /* 7942 */  [ 0.302229319, 19 ],
  /* 7943 */  [ 0.302280060, 19 ],
  /* 7944 */  [ 0.302330802, 19 ],
  /* 7945 */  [ 0.302381547, 19 ],
  /* 7946 */  [ 0.302432294, 19 ],
  /* 7947 */  [ 0.302483043, 19 ],
  /* 7948 */  [ 0.302533794, 19 ],
  /* 7949 */  [ 0.302584547, 19 ],
  /* 7950 */  [ 0.302635303, 19 ],
  /* 7951 */  [ 0.302686060, 19 ],

  /* 7952 */  [ 0.302736820, 19 ],
  /* 7953 */  [ 0.302787581, 19 ],
  /* 7954 */  [ 0.302838345, 19 ],
  /* 7955 */  [ 0.302889111, 19 ],
  /* 7956 */  [ 0.302939879, 19 ],
  /* 7957 */  [ 0.302990650, 19 ],
  /* 7958 */  [ 0.303041422, 19 ],
  /* 7959 */  [ 0.303092197, 19 ],
  /* 7960 */  [ 0.303142973, 19 ],
  /* 7961 */  [ 0.303193752, 19 ],
  /* 7962 */  [ 0.303244533, 19 ],
  /* 7963 */  [ 0.303295316, 19 ],
  /* 7964 */  [ 0.303346101, 19 ],
  /* 7965 */  [ 0.303396889, 19 ],
  /* 7966 */  [ 0.303447678, 19 ],
  /* 7967 */  [ 0.303498469, 19 ],

  /* 7968 */  [ 0.303549263, 19 ],
  /* 7969 */  [ 0.303600059, 19 ],
  /* 7970 */  [ 0.303650857, 19 ],
  /* 7971 */  [ 0.303701657, 19 ],
  /* 7972 */  [ 0.303752459, 19 ],
  /* 7973 */  [ 0.303803263, 19 ],
  /* 7974 */  [ 0.303854070, 19 ],
  /* 7975 */  [ 0.303904878, 19 ],
  /* 7976 */  [ 0.303955689, 19 ],
  /* 7977 */  [ 0.304006502, 19 ],
  /* 7978 */  [ 0.304057317, 19 ],
  /* 7979 */  [ 0.304108134, 19 ],
  /* 7980 */  [ 0.304158953, 19 ],
  /* 7981 */  [ 0.304209774, 19 ],
  /* 7982 */  [ 0.304260597, 19 ],
  /* 7983 */  [ 0.304311423, 19 ],

  /* 7984 */  [ 0.304362251, 19 ],
  /* 7985 */  [ 0.304413080, 19 ],
  /* 7986 */  [ 0.304463912, 19 ],
  /* 7987 */  [ 0.304514746, 19 ],
  /* 7988 */  [ 0.304565582, 19 ],
  /* 7989 */  [ 0.304616421, 19 ],
  /* 7990 */  [ 0.304667261, 19 ],
  /* 7991 */  [ 0.304718103, 19 ],
  /* 7992 */  [ 0.304768948, 19 ],
  /* 7993 */  [ 0.304819795, 19 ],
  /* 7994 */  [ 0.304870644, 19 ],
  /* 7995 */  [ 0.304921495, 19 ],
  /* 7996 */  [ 0.304972348, 19 ],
  /* 7997 */  [ 0.305023203, 19 ],
  /* 7998 */  [ 0.305074060, 19 ],
  /* 7999 */  [ 0.305124920, 19 ],

  /* 8000 */  [ 0.305175781, 19 ],
  /* 8001 */  [ 0.305226645, 19 ],
  /* 8002 */  [ 0.305277511, 19 ],
  /* 8003 */  [ 0.305328379, 19 ],
  /* 8004 */  [ 0.305379249, 19 ],
  /* 8005 */  [ 0.305430121, 19 ],
  /* 8006 */  [ 0.305480995, 19 ],
  /* 8007 */  [ 0.305531872, 19 ],
  /* 8008 */  [ 0.305582750, 19 ],
  /* 8009 */  [ 0.305633631, 19 ],
  /* 8010 */  [ 0.305684513, 19 ],
  /* 8011 */  [ 0.305735398, 19 ],
  /* 8012 */  [ 0.305786285, 19 ],
  /* 8013 */  [ 0.305837174, 19 ],
  /* 8014 */  [ 0.305888066, 19 ],
  /* 8015 */  [ 0.305938959, 19 ],

  /* 8016 */  [ 0.305989854, 19 ],
  /* 8017 */  [ 0.306040752, 19 ],
  /* 8018 */  [ 0.306091652, 19 ],
  /* 8019 */  [ 0.306142554, 19 ],
  /* 8020 */  [ 0.306193457, 19 ],
  /* 8021 */  [ 0.306244364, 19 ],
  /* 8022 */  [ 0.306295272, 19 ],
  /* 8023 */  [ 0.306346182, 19 ],
  /* 8024 */  [ 0.306397094, 19 ],
  /* 8025 */  [ 0.306448009, 19 ],
  /* 8026 */  [ 0.306498925, 19 ],
  /* 8027 */  [ 0.306549844, 19 ],
  /* 8028 */  [ 0.306600765, 19 ],
  /* 8029 */  [ 0.306651688, 19 ],
  /* 8030 */  [ 0.306702613, 19 ],
  /* 8031 */  [ 0.306753540, 19 ],

  /* 8032 */  [ 0.306804470, 19 ],
  /* 8033 */  [ 0.306855401, 19 ],
  /* 8034 */  [ 0.306906334, 19 ],
  /* 8035 */  [ 0.306957270, 19 ],
  /* 8036 */  [ 0.307008208, 19 ],
  /* 8037 */  [ 0.307059148, 19 ],
  /* 8038 */  [ 0.307110090, 19 ],
  /* 8039 */  [ 0.307161034, 19 ],
  /* 8040 */  [ 0.307211980, 19 ],
  /* 8041 */  [ 0.307262928, 19 ],
  /* 8042 */  [ 0.307313879, 19 ],
  /* 8043 */  [ 0.307364831, 19 ],
  /* 8044 */  [ 0.307415786, 19 ],
  /* 8045 */  [ 0.307466743, 19 ],
  /* 8046 */  [ 0.307517702, 19 ],
  /* 8047 */  [ 0.307568663, 19 ],

  /* 8048 */  [ 0.307619626, 19 ],
  /* 8049 */  [ 0.307670591, 19 ],
  /* 8050 */  [ 0.307721558, 19 ],
  /* 8051 */  [ 0.307772528, 19 ],
  /* 8052 */  [ 0.307823499, 19 ],
  /* 8053 */  [ 0.307874473, 19 ],
  /* 8054 */  [ 0.307925449, 19 ],
  /* 8055 */  [ 0.307976426, 19 ],
  /* 8056 */  [ 0.308027406, 19 ],
  /* 8057 */  [ 0.308078389, 19 ],
  /* 8058 */  [ 0.308129373, 19 ],
  /* 8059 */  [ 0.308180359, 19 ],
  /* 8060 */  [ 0.308231347, 19 ],
  /* 8061 */  [ 0.308282338, 19 ],
  /* 8062 */  [ 0.308333331, 19 ],
  /* 8063 */  [ 0.308384325, 19 ],

  /* 8064 */  [ 0.308435322, 19 ],
  /* 8065 */  [ 0.308486321, 19 ],
  /* 8066 */  [ 0.308537322, 19 ],
  /* 8067 */  [ 0.308588325, 19 ],
  /* 8068 */  [ 0.308639331, 19 ],
  /* 8069 */  [ 0.308690338, 19 ],
  /* 8070 */  [ 0.308741348, 19 ],
  /* 8071 */  [ 0.308792359, 19 ],
  /* 8072 */  [ 0.308843373, 19 ],
  /* 8073 */  [ 0.308894389, 19 ],
  /* 8074 */  [ 0.308945407, 19 ],
  /* 8075 */  [ 0.308996427, 19 ],
  /* 8076 */  [ 0.309047449, 19 ],
  /* 8077 */  [ 0.309098473, 19 ],
  /* 8078 */  [ 0.309149499, 19 ],
  /* 8079 */  [ 0.309200528, 19 ],

  /* 8080 */  [ 0.309251558, 19 ],
  /* 8081 */  [ 0.309302591, 19 ],
  /* 8082 */  [ 0.309353626, 19 ],
  /* 8083 */  [ 0.309404663, 19 ],
  /* 8084 */  [ 0.309455702, 19 ],
  /* 8085 */  [ 0.309506743, 19 ],
  /* 8086 */  [ 0.309557786, 19 ],
  /* 8087 */  [ 0.309608831, 19 ],
  /* 8088 */  [ 0.309659879, 19 ],
  /* 8089 */  [ 0.309710928, 19 ],
  /* 8090 */  [ 0.309761980, 19 ],
  /* 8091 */  [ 0.309813033, 19 ],
  /* 8092 */  [ 0.309864089, 19 ],
  /* 8093 */  [ 0.309915147, 19 ],
  /* 8094 */  [ 0.309966207, 19 ],
  /* 8095 */  [ 0.310017269, 19 ],

  /* 8096 */  [ 0.310068333, 19 ],
  /* 8097 */  [ 0.310119400, 19 ],
  /* 8098 */  [ 0.310170468, 19 ],
  /* 8099 */  [ 0.310221539, 19 ],
  /* 8100 */  [ 0.310272611, 19 ],
  /* 8101 */  [ 0.310323686, 19 ],
  /* 8102 */  [ 0.310374763, 19 ],
  /* 8103 */  [ 0.310425842, 19 ],
  /* 8104 */  [ 0.310476923, 19 ],
  /* 8105 */  [ 0.310528006, 19 ],
  /* 8106 */  [ 0.310579091, 19 ],
  /* 8107 */  [ 0.310630179, 19 ],
  /* 8108 */  [ 0.310681268, 19 ],
  /* 8109 */  [ 0.310732360, 19 ],
  /* 8110 */  [ 0.310783453, 19 ],
  /* 8111 */  [ 0.310834549, 19 ],

  /* 8112 */  [ 0.310885647, 19 ],
  /* 8113 */  [ 0.310936747, 19 ],
  /* 8114 */  [ 0.310987849, 19 ],
  /* 8115 */  [ 0.311038953, 19 ],
  /* 8116 */  [ 0.311090059, 19 ],
  /* 8117 */  [ 0.311141168, 19 ],
  /* 8118 */  [ 0.311192278, 19 ],
  /* 8119 */  [ 0.311243390, 19 ],
  /* 8120 */  [ 0.311294505, 19 ],
  /* 8121 */  [ 0.311345622, 19 ],
  /* 8122 */  [ 0.311396741, 19 ],
  /* 8123 */  [ 0.311447862, 19 ],
  /* 8124 */  [ 0.311498985, 19 ],
  /* 8125 */  [ 0.311550110, 19 ],
  /* 8126 */  [ 0.311601237, 19 ],
  /* 8127 */  [ 0.311652366, 19 ],

  /* 8128 */  [ 0.311703498, 19 ],
  /* 8129 */  [ 0.311754631, 19 ],
  /* 8130 */  [ 0.311805767, 19 ],
  /* 8131 */  [ 0.311856905, 19 ],
  /* 8132 */  [ 0.311908044, 19 ],
  /* 8133 */  [ 0.311959186, 19 ],
  /* 8134 */  [ 0.312010330, 19 ],
  /* 8135 */  [ 0.312061476, 19 ],
  /* 8136 */  [ 0.312112625, 19 ],
  /* 8137 */  [ 0.312163775, 19 ],
  /* 8138 */  [ 0.312214927, 19 ],
  /* 8139 */  [ 0.312266082, 19 ],
  /* 8140 */  [ 0.312317238, 19 ],
  /* 8141 */  [ 0.312368397, 19 ],
  /* 8142 */  [ 0.312419558, 19 ],
  /* 8143 */  [ 0.312470720, 19 ],

  /* 8144 */  [ 0.312521885, 19 ],
  /* 8145 */  [ 0.312573052, 19 ],
  /* 8146 */  [ 0.312624222, 19 ],
  /* 8147 */  [ 0.312675393, 19 ],
  /* 8148 */  [ 0.312726566, 19 ],
  /* 8149 */  [ 0.312777742, 19 ],
  /* 8150 */  [ 0.312828919, 19 ],
  /* 8151 */  [ 0.312880099, 19 ],
  /* 8152 */  [ 0.312931280, 19 ],
  /* 8153 */  [ 0.312982464, 19 ],
  /* 8154 */  [ 0.313033650, 19 ],
  /* 8155 */  [ 0.313084838, 19 ],
  /* 8156 */  [ 0.313136028, 19 ],
  /* 8157 */  [ 0.313187220, 19 ],
  /* 8158 */  [ 0.313238414, 19 ],
  /* 8159 */  [ 0.313289611, 19 ],

  /* 8160 */  [ 0.313340809, 19 ],
  /* 8161 */  [ 0.313392010, 19 ],
  /* 8162 */  [ 0.313443212, 19 ],
  /* 8163 */  [ 0.313494417, 19 ],
  /* 8164 */  [ 0.313545624, 19 ],
  /* 8165 */  [ 0.313596833, 19 ],
  /* 8166 */  [ 0.313648044, 19 ],
  /* 8167 */  [ 0.313699257, 19 ],
  /* 8168 */  [ 0.313750472, 19 ],
  /* 8169 */  [ 0.313801689, 19 ],
  /* 8170 */  [ 0.313852909, 19 ],
  /* 8171 */  [ 0.313904130, 19 ],
  /* 8172 */  [ 0.313955354, 19 ],
  /* 8173 */  [ 0.314006579, 19 ],
  /* 8174 */  [ 0.314057807, 19 ],
  /* 8175 */  [ 0.314109037, 19 ],

  /* 8176 */  [ 0.314160269, 19 ],
  /* 8177 */  [ 0.314211502, 19 ],
  /* 8178 */  [ 0.314262739, 19 ],
  /* 8179 */  [ 0.314313977, 19 ],
  /* 8180 */  [ 0.314365217, 19 ],
  /* 8181 */  [ 0.314416459, 19 ],
  /* 8182 */  [ 0.314467704, 19 ],
  /* 8183 */  [ 0.314518950, 19 ],
  /* 8184 */  [ 0.314570199, 19 ],
  /* 8185 */  [ 0.314621449, 19 ],
  /* 8186 */  [ 0.314672702, 19 ],
  /* 8187 */  [ 0.314723957, 19 ],
  /* 8188 */  [ 0.314775214, 19 ],
  /* 8189 */  [ 0.314826473, 19 ],
  /* 8190 */  [ 0.314877734, 19 ],
  /* 8191 */  [ 0.314928997, 19 ],

  /* 8192 */  [ 0.314980262, 19 ],
  /* 8193 */  [ 0.315031530, 19 ],
  /* 8194 */  [ 0.315082799, 19 ],
  /* 8195 */  [ 0.315134071, 19 ],
  /* 8196 */  [ 0.315185344, 19 ],
  /* 8197 */  [ 0.315236620, 19 ],
  /* 8198 */  [ 0.315287898, 19 ],
  /* 8199 */  [ 0.315339178, 19 ],
  /* 8200 */  [ 0.315390460, 19 ],
  /* 8201 */  [ 0.315441744, 19 ],
  /* 8202 */  [ 0.315493030, 19 ],
  /* 8203 */  [ 0.315544318, 19 ],
  /* 8204 */  [ 0.315595608, 19 ],
  /* 8205 */  [ 0.315646901, 19 ],
  /* 8206 */  [ 0.315698195, 19 ]
];
